# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectorSourceArgs',
    'ConnectorSourceArgsDict',
    'ConnectorSourceCursorArgs',
    'ConnectorSourceCursorArgsDict',
    'ConnectorSourceLogSourceArgs',
    'ConnectorSourceLogSourceArgsDict',
    'ConnectorSourceMonitoringSourceArgs',
    'ConnectorSourceMonitoringSourceArgsDict',
    'ConnectorSourceMonitoringSourceNamespaceDetailsArgs',
    'ConnectorSourceMonitoringSourceNamespaceDetailsArgsDict',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgsDict',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgsDict',
    'ConnectorTargetArgs',
    'ConnectorTargetArgsDict',
    'ConnectorTargetDimensionArgs',
    'ConnectorTargetDimensionArgsDict',
    'ConnectorTargetDimensionDimensionValueArgs',
    'ConnectorTargetDimensionDimensionValueArgsDict',
    'ConnectorTaskArgs',
    'ConnectorTaskArgsDict',
    'GetConnectorPluginsFilterArgs',
    'GetConnectorPluginsFilterArgsDict',
    'GetServiceConnectorsFilterArgs',
    'GetServiceConnectorsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectorSourceArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type discriminator.
        """
        config_map: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        """
        cursor: NotRequired[pulumi.Input['ConnectorSourceCursorArgsDict']]
        """
        (Updatable) The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        """
        log_sources: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceLogSourceArgsDict']]]]
        """
        (Updatable) The logs for this Logging source.
        """
        monitoring_sources: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceArgsDict']]]]
        """
        (Updatable) One or more compartment-specific lists of metric namespaces to retrieve data from.
        """
        plugin_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        """
        stream_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
elif False:
    ConnectorSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 config_map: Optional[pulumi.Input[str]] = None,
                 cursor: Optional[pulumi.Input['ConnectorSourceCursorArgs']] = None,
                 log_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceLogSourceArgs']]]] = None,
                 monitoring_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceArgs']]]] = None,
                 plugin_name: Optional[pulumi.Input[str]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) The type discriminator.
        :param pulumi.Input[str] config_map: (Updatable) The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        :param pulumi.Input['ConnectorSourceCursorArgs'] cursor: (Updatable) The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorSourceLogSourceArgs']]] log_sources: (Updatable) The logs for this Logging source.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceArgs']]] monitoring_sources: (Updatable) One or more compartment-specific lists of metric namespaces to retrieve data from.
        :param pulumi.Input[str] plugin_name: (Updatable) The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        :param pulumi.Input[str] stream_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        pulumi.set(__self__, "kind", kind)
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)
        if cursor is not None:
            pulumi.set(__self__, "cursor", cursor)
        if log_sources is not None:
            pulumi.set(__self__, "log_sources", log_sources)
        if monitoring_sources is not None:
            pulumi.set(__self__, "monitoring_sources", monitoring_sources)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        """
        return pulumi.get(self, "config_map")

    @config_map.setter
    def config_map(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_map", value)

    @property
    @pulumi.getter
    def cursor(self) -> Optional[pulumi.Input['ConnectorSourceCursorArgs']]:
        """
        (Updatable) The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        """
        return pulumi.get(self, "cursor")

    @cursor.setter
    def cursor(self, value: Optional[pulumi.Input['ConnectorSourceCursorArgs']]):
        pulumi.set(self, "cursor", value)

    @property
    @pulumi.getter(name="logSources")
    def log_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceLogSourceArgs']]]]:
        """
        (Updatable) The logs for this Logging source.
        """
        return pulumi.get(self, "log_sources")

    @log_sources.setter
    def log_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceLogSourceArgs']]]]):
        pulumi.set(self, "log_sources", value)

    @property
    @pulumi.getter(name="monitoringSources")
    def monitoring_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceArgs']]]]:
        """
        (Updatable) One or more compartment-specific lists of metric namespaces to retrieve data from.
        """
        return pulumi.get(self, "monitoring_sources")

    @monitoring_sources.setter
    def monitoring_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceArgs']]]]):
        pulumi.set(self, "monitoring_sources", value)

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)


if not MYPY:
    class ConnectorSourceCursorArgsDict(TypedDict):
        kind: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The type discriminator.
        """
elif False:
    ConnectorSourceCursorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceCursorArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) The type discriminator.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


if not MYPY:
    class ConnectorSourceLogSourceArgsDict(TypedDict):
        compartment_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the log source.
        """
        log_group_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Identifier of the log group. Either `_Audit` or the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log group. Note: For the Notifications target, only `_Audit` is allowed.
        """
        log_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
elif False:
    ConnectorSourceLogSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceLogSourceArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the log source.
        :param pulumi.Input[str] log_group_id: (Updatable) Identifier of the log group. Either `_Audit` or the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log group. Note: For the Notifications target, only `_Audit` is allowed.
        :param pulumi.Input[str] log_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_id is not None:
            pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the log source.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identifier of the log group. Either `_Audit` or the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log group. Note: For the Notifications target, only `_Audit` is allowed.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        return pulumi.get(self, "log_id")

    @log_id.setter
    def log_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_id", value)


if not MYPY:
    class ConnectorSourceMonitoringSourceArgsDict(TypedDict):
        compartment_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a compartment containing metric namespaces you want to use for the Monitoring source.
        """
        namespace_details: NotRequired[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsArgsDict']]
        """
        (Updatable) Discriminator for namespaces in the compartment-specific list.
        """
elif False:
    ConnectorSourceMonitoringSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceMonitoringSourceArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 namespace_details: Optional[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsArgs']] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a compartment containing metric namespaces you want to use for the Monitoring source.
        :param pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsArgs'] namespace_details: (Updatable) Discriminator for namespaces in the compartment-specific list.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if namespace_details is not None:
            pulumi.set(__self__, "namespace_details", namespace_details)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a compartment containing metric namespaces you want to use for the Monitoring source.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="namespaceDetails")
    def namespace_details(self) -> Optional[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsArgs']]:
        """
        (Updatable) Discriminator for namespaces in the compartment-specific list.
        """
        return pulumi.get(self, "namespace_details")

    @namespace_details.setter
    def namespace_details(self, value: Optional[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsArgs']]):
        pulumi.set(self, "namespace_details", value)


if not MYPY:
    class ConnectorSourceMonitoringSourceNamespaceDetailsArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type discriminator.
        """
        namespaces: pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgsDict']]]
        """
        (Updatable) The namespaces for the compartment-specific list.
        """
elif False:
    ConnectorSourceMonitoringSourceNamespaceDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceMonitoringSourceNamespaceDetailsArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 namespaces: pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs']]]):
        """
        :param pulumi.Input[str] kind: (Updatable) The type discriminator.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs']]] namespaces: (Updatable) The namespaces for the compartment-specific list.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs']]]:
        """
        (Updatable) The namespaces for the compartment-specific list.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs']]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgsDict(TypedDict):
        metrics: pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgsDict']
        """
        (Updatable) The metrics to query for the specified metric namespace.
        """
        namespace: pulumi.Input[str]
        """
        (Updatable) The source service or application to use when querying for metric data points. Must begin with `oci_`.  Example: `oci_computeagent`
        """
elif False:
    ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs:
    def __init__(__self__, *,
                 metrics: pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs'],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs'] metrics: (Updatable) The metrics to query for the specified metric namespace.
        :param pulumi.Input[str] namespace: (Updatable) The source service or application to use when querying for metric data points. Must begin with `oci_`.  Example: `oci_computeagent`
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs']:
        """
        (Updatable) The metrics to query for the specified metric namespace.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: pulumi.Input['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs']):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) The source service or application to use when querying for metric data points. Must begin with `oci_`.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type discriminator.
        """
elif False:
    ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kind: (Updatable) The type discriminator.
        """
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)


if not MYPY:
    class ConnectorTargetArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type discriminator.
        """
        batch_rollover_size_in_mbs: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The batch rollover size in megabytes.
        """
        batch_rollover_time_in_ms: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The batch rollover time in milliseconds.
        """
        batch_size_in_kbs: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The batch rollover size in kilobytes. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        batch_size_in_num: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        batch_time_in_sec: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The batch rollover time in seconds.
        """
        bucket: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        """
        compartment_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectorTargetDimensionArgsDict']]]]
        """
        (Updatable) List of dimension names and values.
        """
        enable_formatted_messaging: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        """
        function_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        """
        log_group_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        log_source_identifier: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        """
        metric: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The name of the metric. Example: `CpuUtilization`
        """
        metric_namespace: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The namespace of the metric. Example: `oci_computeagent`
        """
        namespace: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The namespace.
        """
        object_name_prefix: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The prefix of the objects. Avoid entering confidential information.
        """
        stream_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        topic_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
elif False:
    ConnectorTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorTargetArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 batch_rollover_size_in_mbs: Optional[pulumi.Input[int]] = None,
                 batch_rollover_time_in_ms: Optional[pulumi.Input[int]] = None,
                 batch_size_in_kbs: Optional[pulumi.Input[int]] = None,
                 batch_size_in_num: Optional[pulumi.Input[int]] = None,
                 batch_time_in_sec: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorTargetDimensionArgs']]]] = None,
                 enable_formatted_messaging: Optional[pulumi.Input[bool]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_source_identifier: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object_name_prefix: Optional[pulumi.Input[str]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) The type discriminator.
        :param pulumi.Input[int] batch_rollover_size_in_mbs: (Updatable) The batch rollover size in megabytes.
        :param pulumi.Input[int] batch_rollover_time_in_ms: (Updatable) The batch rollover time in milliseconds.
        :param pulumi.Input[int] batch_size_in_kbs: (Updatable) The batch rollover size in kilobytes. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param pulumi.Input[int] batch_size_in_num: (Updatable) The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param pulumi.Input[int] batch_time_in_sec: (Updatable) The batch rollover time in seconds.
        :param pulumi.Input[str] bucket: (Updatable) The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorTargetDimensionArgs']]] dimensions: (Updatable) List of dimension names and values.
        :param pulumi.Input[bool] enable_formatted_messaging: (Updatable) Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        :param pulumi.Input[str] function_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        :param pulumi.Input[str] log_group_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param pulumi.Input[str] log_source_identifier: (Updatable) Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        :param pulumi.Input[str] metric: (Updatable) The name of the metric. Example: `CpuUtilization`
        :param pulumi.Input[str] metric_namespace: (Updatable) The namespace of the metric. Example: `oci_computeagent`
        :param pulumi.Input[str] namespace: (Updatable) The namespace.
        :param pulumi.Input[str] object_name_prefix: (Updatable) The prefix of the objects. Avoid entering confidential information.
        :param pulumi.Input[str] stream_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        :param pulumi.Input[str] topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        pulumi.set(__self__, "kind", kind)
        if batch_rollover_size_in_mbs is not None:
            pulumi.set(__self__, "batch_rollover_size_in_mbs", batch_rollover_size_in_mbs)
        if batch_rollover_time_in_ms is not None:
            pulumi.set(__self__, "batch_rollover_time_in_ms", batch_rollover_time_in_ms)
        if batch_size_in_kbs is not None:
            pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        if batch_size_in_num is not None:
            pulumi.set(__self__, "batch_size_in_num", batch_size_in_num)
        if batch_time_in_sec is not None:
            pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if enable_formatted_messaging is not None:
            pulumi.set(__self__, "enable_formatted_messaging", enable_formatted_messaging)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_source_identifier is not None:
            pulumi.set(__self__, "log_source_identifier", log_source_identifier)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object_name_prefix is not None:
            pulumi.set(__self__, "object_name_prefix", object_name_prefix)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="batchRolloverSizeInMbs")
    def batch_rollover_size_in_mbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The batch rollover size in megabytes.
        """
        return pulumi.get(self, "batch_rollover_size_in_mbs")

    @batch_rollover_size_in_mbs.setter
    def batch_rollover_size_in_mbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_rollover_size_in_mbs", value)

    @property
    @pulumi.getter(name="batchRolloverTimeInMs")
    def batch_rollover_time_in_ms(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The batch rollover time in milliseconds.
        """
        return pulumi.get(self, "batch_rollover_time_in_ms")

    @batch_rollover_time_in_ms.setter
    def batch_rollover_time_in_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_rollover_time_in_ms", value)

    @property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The batch rollover size in kilobytes. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @batch_size_in_kbs.setter
    def batch_size_in_kbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size_in_kbs", value)

    @property
    @pulumi.getter(name="batchSizeInNum")
    def batch_size_in_num(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_num")

    @batch_size_in_num.setter
    def batch_size_in_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size_in_num", value)

    @property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The batch rollover time in seconds.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @batch_time_in_sec.setter
    def batch_time_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_time_in_sec", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorTargetDimensionArgs']]]]:
        """
        (Updatable) List of dimension names and values.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorTargetDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="enableFormattedMessaging")
    def enable_formatted_messaging(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        """
        return pulumi.get(self, "enable_formatted_messaging")

    @enable_formatted_messaging.setter
    def enable_formatted_messaging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_formatted_messaging", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logSourceIdentifier")
    def log_source_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        """
        return pulumi.get(self, "log_source_identifier")

    @log_source_identifier.setter
    def log_source_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_source_identifier", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the metric. Example: `CpuUtilization`
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The namespace of the metric. Example: `oci_computeagent`
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="objectNamePrefix")
    def object_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The prefix of the objects. Avoid entering confidential information.
        """
        return pulumi.get(self, "object_name_prefix")

    @object_name_prefix.setter
    def object_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_name_prefix", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_id", value)


if not MYPY:
    class ConnectorTargetDimensionArgsDict(TypedDict):
        dimension_value: NotRequired[pulumi.Input['ConnectorTargetDimensionDimensionValueArgsDict']]
        """
        (Updatable) Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        """
        name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
elif False:
    ConnectorTargetDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorTargetDimensionArgs:
    def __init__(__self__, *,
                 dimension_value: Optional[pulumi.Input['ConnectorTargetDimensionDimensionValueArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ConnectorTargetDimensionDimensionValueArgs'] dimension_value: (Updatable) Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        :param pulumi.Input[str] name: (Updatable) Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        if dimension_value is not None:
            pulumi.set(__self__, "dimension_value", dimension_value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Optional[pulumi.Input['ConnectorTargetDimensionDimensionValueArgs']]:
        """
        (Updatable) Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        """
        return pulumi.get(self, "dimension_value")

    @dimension_value.setter
    def dimension_value(self, value: Optional[pulumi.Input['ConnectorTargetDimensionDimensionValueArgs']]):
        pulumi.set(self, "dimension_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ConnectorTargetDimensionDimensionValueArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type of dimension value: static or evaluated.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
elif False:
    ConnectorTargetDimensionDimensionValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorTargetDimensionDimensionValueArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) The type of dimension value: static or evaluated.
        :param pulumi.Input[str] path: (Updatable) The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        :param pulumi.Input[str] value: (Updatable) The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        pulumi.set(__self__, "kind", kind)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ConnectorTaskArgsDict(TypedDict):
        kind: pulumi.Input[str]
        """
        (Updatable) The type descriminator.
        """
        batch_size_in_kbs: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Size limit (kilobytes) for batch sent to invoke the function.
        """
        batch_time_in_sec: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Time limit (seconds) for batch sent to invoke the function.
        """
        condition: NotRequired[pulumi.Input[str]]
        """
        (Updatable) A filter or mask to limit the source used in the flow defined by the connector.
        """
        function_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
elif False:
    ConnectorTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorTaskArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 batch_size_in_kbs: Optional[pulumi.Input[int]] = None,
                 batch_time_in_sec: Optional[pulumi.Input[int]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) The type descriminator.
        :param pulumi.Input[int] batch_size_in_kbs: (Updatable) Size limit (kilobytes) for batch sent to invoke the function.
        :param pulumi.Input[int] batch_time_in_sec: (Updatable) Time limit (seconds) for batch sent to invoke the function.
        :param pulumi.Input[str] condition: (Updatable) A filter or mask to limit the source used in the flow defined by the connector.
        :param pulumi.Input[str] function_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        pulumi.set(__self__, "kind", kind)
        if batch_size_in_kbs is not None:
            pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        if batch_time_in_sec is not None:
            pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) The type descriminator.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @batch_size_in_kbs.setter
    def batch_size_in_kbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size_in_kbs", value)

    @property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @batch_time_in_sec.setter
    def batch_time_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_time_in_sec", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A filter or mask to limit the source used in the flow defined by the connector.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)


if not MYPY:
    class GetConnectorPluginsFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetConnectorPluginsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetConnectorPluginsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetServiceConnectorsFilterArgsDict(TypedDict):
        name: str
        """
        Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetServiceConnectorsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServiceConnectorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


