# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitoredResourcesResult',
    'AwaitableGetMonitoredResourcesResult',
    'get_monitored_resources',
    'get_monitored_resources_output',
]

@pulumi.output_type
class GetMonitoredResourcesResult:
    """
    A collection of values returned by getMonitoredResources.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, monitored_resource_collections=None, name=None, work_request_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitored_resource_collections and not isinstance(monitored_resource_collections, list):
            raise TypeError("Expected argument 'monitored_resource_collections' to be a list")
        pulumi.set(__self__, "monitored_resource_collections", monitored_resource_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitoredResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitoredResourceCollections")
    def monitored_resource_collections(self) -> Sequence['outputs.GetMonitoredResourcesMonitoredResourceCollectionResult']:
        """
        The list of monitored_resource_collection.
        """
        return pulumi.get(self, "monitored_resource_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[str]:
        return pulumi.get(self, "work_request_id")


class AwaitableGetMonitoredResourcesResult(GetMonitoredResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredResourcesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            monitored_resource_collections=self.monitored_resource_collections,
            name=self.name,
            work_request_id=self.work_request_id)


def get_monitored_resources(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetMonitoredResourcesFilterArgs']]] = None,
                            name: Optional[str] = None,
                            work_request_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredResourcesResult:
    """
    This data source provides the list of Monitored Resources in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of monitored resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resources = oci.StackMonitoring.get_monitored_resources(compartment_id=var["compartment_id"],
        name=var["monitored_resource_name"],
        work_request_id=oci_containerengine_work_request["test_work_request"]["id"])
    ```


    :param str compartment_id: The ID of the compartment in which data is listed.
    :param str name: A filter to return resources that match exact resource name.
    :param str work_request_id: A filter to return resources which were impacted as part of this work request identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoredResources:getMonitoredResources', __args__, opts=opts, typ=GetMonitoredResourcesResult).value

    return AwaitableGetMonitoredResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        monitored_resource_collections=pulumi.get(__ret__, 'monitored_resource_collections'),
        name=pulumi.get(__ret__, 'name'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))


@_utilities.lift_output_func(get_monitored_resources)
def get_monitored_resources_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMonitoredResourcesFilterArgs']]]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   work_request_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitoredResourcesResult]:
    """
    This data source provides the list of Monitored Resources in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of monitored resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resources = oci.StackMonitoring.get_monitored_resources(compartment_id=var["compartment_id"],
        name=var["monitored_resource_name"],
        work_request_id=oci_containerengine_work_request["test_work_request"]["id"])
    ```


    :param str compartment_id: The ID of the compartment in which data is listed.
    :param str name: A filter to return resources that match exact resource name.
    :param str work_request_id: A filter to return resources which were impacted as part of this work request identifier.
    """
    ...
