/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeDatabasesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optionally includes dropped databases that have not yet been purged The output also includes an additional `dropped_on` column
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#history DataSnowflakeDatabases#history}
    */
    readonly history?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#id DataSnowflakeDatabases#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optionally filters the databases by a pattern
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#pattern DataSnowflakeDatabases#pattern}
    */
    readonly pattern?: string;
    /**
    * Optionally filters the databases by a pattern
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#starts_with DataSnowflakeDatabases#starts_with}
    */
    readonly startsWith?: string;
    /**
    * Optionally returns only the columns `created_on` and `name` in the results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#terse DataSnowflakeDatabases#terse}
    */
    readonly terse?: boolean | cdktf.IResolvable;
}
export interface DataSnowflakeDatabasesDatabasesReplicationConfiguration {
}
export declare function dataSnowflakeDatabasesDatabasesReplicationConfigurationToTerraform(struct?: DataSnowflakeDatabasesDatabasesReplicationConfiguration): any;
export declare function dataSnowflakeDatabasesDatabasesReplicationConfigurationToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesReplicationConfiguration): any;
export declare class DataSnowflakeDatabasesDatabasesReplicationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesReplicationConfiguration | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesReplicationConfiguration | undefined);
    get accounts(): string[];
    get ignoreEditionCheck(): cdktf.IResolvable;
}
export declare class DataSnowflakeDatabasesDatabasesReplicationConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesReplicationConfigurationOutputReference;
}
export interface DataSnowflakeDatabasesDatabases {
}
export declare function dataSnowflakeDatabasesDatabasesToTerraform(struct?: DataSnowflakeDatabasesDatabases): any;
export declare function dataSnowflakeDatabasesDatabasesToHclTerraform(struct?: DataSnowflakeDatabasesDatabases): any;
export declare class DataSnowflakeDatabasesDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabases | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabases | undefined);
    get comment(): string;
    get createdOn(): string;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get name(): string;
    get options(): string;
    get origin(): string;
    get owner(): string;
    private _replicationConfiguration;
    get replicationConfiguration(): DataSnowflakeDatabasesDatabasesReplicationConfigurationList;
    get retentionTime(): number;
}
export declare class DataSnowflakeDatabasesDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases snowflake_databases}
*/
export declare class DataSnowflakeDatabases extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_databases";
    /**
    * Generates CDKTF code for importing a DataSnowflakeDatabases resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeDatabases to import
    * @param importFromId The id of the existing DataSnowflakeDatabases that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeDatabases to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/data-sources/databases snowflake_databases} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeDatabasesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeDatabasesConfig);
    private _databases;
    get databases(): DataSnowflakeDatabasesDatabasesList;
    private _history?;
    get history(): boolean | cdktf.IResolvable;
    set history(value: boolean | cdktf.IResolvable);
    resetHistory(): void;
    get historyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _terse?;
    get terse(): boolean | cdktf.IResolvable;
    set terse(value: boolean | cdktf.IResolvable);
    resetTerse(): void;
    get terseInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
