"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GrantPrivilegesToDatabaseRole = exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform = exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform = exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform = exports.grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform = exports.GrantPrivilegesToDatabaseRoleOnSchemaOutputReference = exports.grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform = exports.grantPrivilegesToDatabaseRoleOnSchemaToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function grantPrivilegesToDatabaseRoleOnSchemaToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        all_schemas_in_database: cdktf.stringToTerraform(struct.allSchemasInDatabase),
        future_schemas_in_database: cdktf.stringToTerraform(struct.futureSchemasInDatabase),
        schema_name: cdktf.stringToTerraform(struct.schemaName),
    };
}
exports.grantPrivilegesToDatabaseRoleOnSchemaToTerraform = grantPrivilegesToDatabaseRoleOnSchemaToTerraform;
function grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        all_schemas_in_database: {
            value: cdktf.stringToHclTerraform(struct.allSchemasInDatabase),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        future_schemas_in_database: {
            value: cdktf.stringToHclTerraform(struct.futureSchemasInDatabase),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        schema_name: {
            value: cdktf.stringToHclTerraform(struct.schemaName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform = grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform;
class GrantPrivilegesToDatabaseRoleOnSchemaOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allSchemasInDatabase !== undefined) {
            hasAnyValues = true;
            internalValueResult.allSchemasInDatabase = this._allSchemasInDatabase;
        }
        if (this._futureSchemasInDatabase !== undefined) {
            hasAnyValues = true;
            internalValueResult.futureSchemasInDatabase = this._futureSchemasInDatabase;
        }
        if (this._schemaName !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaName = this._schemaName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allSchemasInDatabase = undefined;
            this._futureSchemasInDatabase = undefined;
            this._schemaName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allSchemasInDatabase = value.allSchemasInDatabase;
            this._futureSchemasInDatabase = value.futureSchemasInDatabase;
            this._schemaName = value.schemaName;
        }
    }
    get allSchemasInDatabase() {
        return this.getStringAttribute('all_schemas_in_database');
    }
    set allSchemasInDatabase(value) {
        this._allSchemasInDatabase = value;
    }
    resetAllSchemasInDatabase() {
        this._allSchemasInDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allSchemasInDatabaseInput() {
        return this._allSchemasInDatabase;
    }
    get futureSchemasInDatabase() {
        return this.getStringAttribute('future_schemas_in_database');
    }
    set futureSchemasInDatabase(value) {
        this._futureSchemasInDatabase = value;
    }
    resetFutureSchemasInDatabase() {
        this._futureSchemasInDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get futureSchemasInDatabaseInput() {
        return this._futureSchemasInDatabase;
    }
    get schemaName() {
        return this.getStringAttribute('schema_name');
    }
    set schemaName(value) {
        this._schemaName = value;
    }
    resetSchemaName() {
        this._schemaName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaNameInput() {
        return this._schemaName;
    }
}
exports.GrantPrivilegesToDatabaseRoleOnSchemaOutputReference = GrantPrivilegesToDatabaseRoleOnSchemaOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GrantPrivilegesToDatabaseRoleOnSchemaOutputReference[_a] = { fqn: "@cdktf/provider-snowflake.grantPrivilegesToDatabaseRole.GrantPrivilegesToDatabaseRoleOnSchemaOutputReference", version: "11.2.0" };
function grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        in_database: cdktf.stringToTerraform(struct.inDatabase),
        in_schema: cdktf.stringToTerraform(struct.inSchema),
        object_type_plural: cdktf.stringToTerraform(struct.objectTypePlural),
    };
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform;
function grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        in_database: {
            value: cdktf.stringToHclTerraform(struct.inDatabase),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        in_schema: {
            value: cdktf.stringToHclTerraform(struct.inSchema),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        object_type_plural: {
            value: cdktf.stringToHclTerraform(struct.objectTypePlural),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform;
class GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._inDatabase !== undefined) {
            hasAnyValues = true;
            internalValueResult.inDatabase = this._inDatabase;
        }
        if (this._inSchema !== undefined) {
            hasAnyValues = true;
            internalValueResult.inSchema = this._inSchema;
        }
        if (this._objectTypePlural !== undefined) {
            hasAnyValues = true;
            internalValueResult.objectTypePlural = this._objectTypePlural;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._inDatabase = undefined;
            this._inSchema = undefined;
            this._objectTypePlural = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._inDatabase = value.inDatabase;
            this._inSchema = value.inSchema;
            this._objectTypePlural = value.objectTypePlural;
        }
    }
    get inDatabase() {
        return this.getStringAttribute('in_database');
    }
    set inDatabase(value) {
        this._inDatabase = value;
    }
    resetInDatabase() {
        this._inDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inDatabaseInput() {
        return this._inDatabase;
    }
    get inSchema() {
        return this.getStringAttribute('in_schema');
    }
    set inSchema(value) {
        this._inSchema = value;
    }
    resetInSchema() {
        this._inSchema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inSchemaInput() {
        return this._inSchema;
    }
    get objectTypePlural() {
        return this.getStringAttribute('object_type_plural');
    }
    set objectTypePlural(value) {
        this._objectTypePlural = value;
    }
    // Temporarily expose input value. Use with caution.
    get objectTypePluralInput() {
        return this._objectTypePlural;
    }
}
exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference = GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference;
_b = JSII_RTTI_SYMBOL_1;
GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference[_b] = { fqn: "@cdktf/provider-snowflake.grantPrivilegesToDatabaseRole.GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference", version: "11.2.0" };
function grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        in_database: cdktf.stringToTerraform(struct.inDatabase),
        in_schema: cdktf.stringToTerraform(struct.inSchema),
        object_type_plural: cdktf.stringToTerraform(struct.objectTypePlural),
    };
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform;
function grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        in_database: {
            value: cdktf.stringToHclTerraform(struct.inDatabase),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        in_schema: {
            value: cdktf.stringToHclTerraform(struct.inSchema),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        object_type_plural: {
            value: cdktf.stringToHclTerraform(struct.objectTypePlural),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform;
class GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._inDatabase !== undefined) {
            hasAnyValues = true;
            internalValueResult.inDatabase = this._inDatabase;
        }
        if (this._inSchema !== undefined) {
            hasAnyValues = true;
            internalValueResult.inSchema = this._inSchema;
        }
        if (this._objectTypePlural !== undefined) {
            hasAnyValues = true;
            internalValueResult.objectTypePlural = this._objectTypePlural;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._inDatabase = undefined;
            this._inSchema = undefined;
            this._objectTypePlural = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._inDatabase = value.inDatabase;
            this._inSchema = value.inSchema;
            this._objectTypePlural = value.objectTypePlural;
        }
    }
    get inDatabase() {
        return this.getStringAttribute('in_database');
    }
    set inDatabase(value) {
        this._inDatabase = value;
    }
    resetInDatabase() {
        this._inDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inDatabaseInput() {
        return this._inDatabase;
    }
    get inSchema() {
        return this.getStringAttribute('in_schema');
    }
    set inSchema(value) {
        this._inSchema = value;
    }
    resetInSchema() {
        this._inSchema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inSchemaInput() {
        return this._inSchema;
    }
    get objectTypePlural() {
        return this.getStringAttribute('object_type_plural');
    }
    set objectTypePlural(value) {
        this._objectTypePlural = value;
    }
    // Temporarily expose input value. Use with caution.
    get objectTypePluralInput() {
        return this._objectTypePlural;
    }
}
exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference = GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference;
_c = JSII_RTTI_SYMBOL_1;
GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference[_c] = { fqn: "@cdktf/provider-snowflake.grantPrivilegesToDatabaseRole.GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference", version: "11.2.0" };
function grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        object_name: cdktf.stringToTerraform(struct.objectName),
        object_type: cdktf.stringToTerraform(struct.objectType),
        all: grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform(struct.all),
        future: grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform(struct.future),
    };
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform;
function grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        object_name: {
            value: cdktf.stringToHclTerraform(struct.objectName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        object_type: {
            value: cdktf.stringToHclTerraform(struct.objectType),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        all: {
            value: grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform(struct.all),
            isBlock: true,
            type: "list",
            storageClassType: "GrantPrivilegesToDatabaseRoleOnSchemaObjectAllList",
        },
        future: {
            value: grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform(struct.future),
            isBlock: true,
            type: "list",
            storageClassType: "GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform = grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform;
class GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // all - computed: false, optional: true, required: false
        this._all = new GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference(this, "all");
        // future - computed: false, optional: true, required: false
        this._future = new GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference(this, "future");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._objectName !== undefined) {
            hasAnyValues = true;
            internalValueResult.objectName = this._objectName;
        }
        if (this._objectType !== undefined) {
            hasAnyValues = true;
            internalValueResult.objectType = this._objectType;
        }
        if (this._all?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.all = this._all?.internalValue;
        }
        if (this._future?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.future = this._future?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._objectName = undefined;
            this._objectType = undefined;
            this._all.internalValue = undefined;
            this._future.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._objectName = value.objectName;
            this._objectType = value.objectType;
            this._all.internalValue = value.all;
            this._future.internalValue = value.future;
        }
    }
    get objectName() {
        return this.getStringAttribute('object_name');
    }
    set objectName(value) {
        this._objectName = value;
    }
    resetObjectName() {
        this._objectName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get objectNameInput() {
        return this._objectName;
    }
    get objectType() {
        return this.getStringAttribute('object_type');
    }
    set objectType(value) {
        this._objectType = value;
    }
    resetObjectType() {
        this._objectType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get objectTypeInput() {
        return this._objectType;
    }
    get all() {
        return this._all;
    }
    putAll(value) {
        this._all.internalValue = value;
    }
    resetAll() {
        this._all.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allInput() {
        return this._all.internalValue;
    }
    get future() {
        return this._future;
    }
    putFuture(value) {
        this._future.internalValue = value;
    }
    resetFuture() {
        this._future.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get futureInput() {
        return this._future.internalValue;
    }
}
exports.GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference = GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference;
_d = JSII_RTTI_SYMBOL_1;
GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference[_d] = { fqn: "@cdktf/provider-snowflake.grantPrivilegesToDatabaseRole.GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference", version: "11.2.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/grant_privileges_to_database_role snowflake_grant_privileges_to_database_role}
*/
class GrantPrivilegesToDatabaseRole extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a GrantPrivilegesToDatabaseRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantPrivilegesToDatabaseRole to import
    * @param importFromId The id of the existing GrantPrivilegesToDatabaseRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/grant_privileges_to_database_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantPrivilegesToDatabaseRole to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_grant_privileges_to_database_role", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/grant_privileges_to_database_role snowflake_grant_privileges_to_database_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantPrivilegesToDatabaseRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_grant_privileges_to_database_role',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.86.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // on_schema - computed: false, optional: true, required: false
        this._onSchema = new GrantPrivilegesToDatabaseRoleOnSchemaOutputReference(this, "on_schema");
        // on_schema_object - computed: false, optional: true, required: false
        this._onSchemaObject = new GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference(this, "on_schema_object");
        this._allPrivileges = config.allPrivileges;
        this._alwaysApply = config.alwaysApply;
        this._alwaysApplyTrigger = config.alwaysApplyTrigger;
        this._databaseRoleName = config.databaseRoleName;
        this._id = config.id;
        this._onDatabase = config.onDatabase;
        this._privileges = config.privileges;
        this._withGrantOption = config.withGrantOption;
        this._onSchema.internalValue = config.onSchema;
        this._onSchemaObject.internalValue = config.onSchemaObject;
    }
    get allPrivileges() {
        return this.getBooleanAttribute('all_privileges');
    }
    set allPrivileges(value) {
        this._allPrivileges = value;
    }
    resetAllPrivileges() {
        this._allPrivileges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allPrivilegesInput() {
        return this._allPrivileges;
    }
    get alwaysApply() {
        return this.getBooleanAttribute('always_apply');
    }
    set alwaysApply(value) {
        this._alwaysApply = value;
    }
    resetAlwaysApply() {
        this._alwaysApply = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alwaysApplyInput() {
        return this._alwaysApply;
    }
    get alwaysApplyTrigger() {
        return this.getStringAttribute('always_apply_trigger');
    }
    set alwaysApplyTrigger(value) {
        this._alwaysApplyTrigger = value;
    }
    resetAlwaysApplyTrigger() {
        this._alwaysApplyTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alwaysApplyTriggerInput() {
        return this._alwaysApplyTrigger;
    }
    get databaseRoleName() {
        return this.getStringAttribute('database_role_name');
    }
    set databaseRoleName(value) {
        this._databaseRoleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseRoleNameInput() {
        return this._databaseRoleName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get onDatabase() {
        return this.getStringAttribute('on_database');
    }
    set onDatabase(value) {
        this._onDatabase = value;
    }
    resetOnDatabase() {
        this._onDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onDatabaseInput() {
        return this._onDatabase;
    }
    get privileges() {
        return cdktf.Fn.tolist(this.getListAttribute('privileges'));
    }
    set privileges(value) {
        this._privileges = value;
    }
    resetPrivileges() {
        this._privileges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privilegesInput() {
        return this._privileges;
    }
    get withGrantOption() {
        return this.getBooleanAttribute('with_grant_option');
    }
    set withGrantOption(value) {
        this._withGrantOption = value;
    }
    resetWithGrantOption() {
        this._withGrantOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get withGrantOptionInput() {
        return this._withGrantOption;
    }
    get onSchema() {
        return this._onSchema;
    }
    putOnSchema(value) {
        this._onSchema.internalValue = value;
    }
    resetOnSchema() {
        this._onSchema.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onSchemaInput() {
        return this._onSchema.internalValue;
    }
    get onSchemaObject() {
        return this._onSchemaObject;
    }
    putOnSchemaObject(value) {
        this._onSchemaObject.internalValue = value;
    }
    resetOnSchemaObject() {
        this._onSchemaObject.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onSchemaObjectInput() {
        return this._onSchemaObject.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            all_privileges: cdktf.booleanToTerraform(this._allPrivileges),
            always_apply: cdktf.booleanToTerraform(this._alwaysApply),
            always_apply_trigger: cdktf.stringToTerraform(this._alwaysApplyTrigger),
            database_role_name: cdktf.stringToTerraform(this._databaseRoleName),
            id: cdktf.stringToTerraform(this._id),
            on_database: cdktf.stringToTerraform(this._onDatabase),
            privileges: cdktf.listMapper(cdktf.stringToTerraform, false)(this._privileges),
            with_grant_option: cdktf.booleanToTerraform(this._withGrantOption),
            on_schema: grantPrivilegesToDatabaseRoleOnSchemaToTerraform(this._onSchema.internalValue),
            on_schema_object: grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform(this._onSchemaObject.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            all_privileges: {
                value: cdktf.booleanToHclTerraform(this._allPrivileges),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            always_apply: {
                value: cdktf.booleanToHclTerraform(this._alwaysApply),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            always_apply_trigger: {
                value: cdktf.stringToHclTerraform(this._alwaysApplyTrigger),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            database_role_name: {
                value: cdktf.stringToHclTerraform(this._databaseRoleName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            on_database: {
                value: cdktf.stringToHclTerraform(this._onDatabase),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            privileges: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._privileges),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            with_grant_option: {
                value: cdktf.booleanToHclTerraform(this._withGrantOption),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            on_schema: {
                value: grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform(this._onSchema.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GrantPrivilegesToDatabaseRoleOnSchemaList",
            },
            on_schema_object: {
                value: grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform(this._onSchemaObject.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GrantPrivilegesToDatabaseRoleOnSchemaObjectList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.GrantPrivilegesToDatabaseRole = GrantPrivilegesToDatabaseRole;
_e = JSII_RTTI_SYMBOL_1;
GrantPrivilegesToDatabaseRole[_e] = { fqn: "@cdktf/provider-snowflake.grantPrivilegesToDatabaseRole.GrantPrivilegesToDatabaseRole", version: "11.2.0" };
// =================
// STATIC PROPERTIES
// =================
GrantPrivilegesToDatabaseRole.tfResourceType = "snowflake_grant_privileges_to_database_role";
//# sourceMappingURL=data:application/json;base64,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