/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RowAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the row access policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#comment RowAccessPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the row access policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#database RowAccessPolicy#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#id RowAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the row access policy; must be unique for the database and schema in which the row access policy is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#name RowAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Specifies the SQL expression. The expression can be any boolean-valued SQL expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#row_access_expression RowAccessPolicy#row_access_expression}
    */
    readonly rowAccessExpression: string;
    /**
    * The schema in which to create the row access policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#schema RowAccessPolicy#schema}
    */
    readonly schema: string;
    /**
    * Specifies signature (arguments) for the row access policy (uppercase and sorted to avoid recreation of resource). A signature specifies a set of attributes that must be considered to determine whether the row is accessible. The attribute values come from the database object (e.g. table or view) to be protected by the row access policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#signature RowAccessPolicy#signature}
    */
    readonly signature: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy snowflake_row_access_policy}
*/
export declare class RowAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_row_access_policy";
    /**
    * Generates CDKTF code for importing a RowAccessPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RowAccessPolicy to import
    * @param importFromId The id of the existing RowAccessPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RowAccessPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.86.0/docs/resources/row_access_policy snowflake_row_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RowAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: RowAccessPolicyConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rowAccessExpression?;
    get rowAccessExpression(): string;
    set rowAccessExpression(value: string);
    get rowAccessExpressionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _signature?;
    get signature(): {
        [key: string]: string;
    };
    set signature(value: {
        [key: string]: string;
    });
    get signatureInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
