/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.Analysis;
import fpp.compiler.analysis.Component;
import fpp.compiler.analysis.Connection$;
import fpp.compiler.analysis.Connection$Endpoint$;
import fpp.compiler.analysis.PortInstance;
import fpp.compiler.analysis.PortInstance$Direction$;
import fpp.compiler.analysis.PortInstance$Direction$Input$;
import fpp.compiler.analysis.PortInstance$Direction$Output$;
import fpp.compiler.analysis.PortInstance$Type$;
import fpp.compiler.analysis.PortInstance$Type$DefPort$;
import fpp.compiler.analysis.PortInstance$Type$Serial$;
import fpp.compiler.analysis.PortInstanceIdentifier;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.Symbol$Port$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import fpp.compiler.ast.Locations$;
import fpp.compiler.util.Error;
import fpp.compiler.util.Location;
import fpp.compiler.util.SemanticError$InvalidConnection$;
import fpp.compiler.util.SemanticError$InvalidPortNumber$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public class Connection
implements Ordered<Connection>,
Product,
Serializable {
    private final Endpoint from;
    private final Endpoint to;
    private final boolean isUnmatched;

    public static Connection apply(Endpoint endpoint, Endpoint endpoint2, boolean bl) {
        return Connection$.MODULE$.apply(endpoint, endpoint2, bl);
    }

    public static Either<Error, Connection> fromAst(Analysis analysis, Ast.SpecConnectionGraph.Connection connection) {
        return Connection$.MODULE$.fromAst(analysis, connection);
    }

    public static Connection fromProduct(Product product) {
        return Connection$.MODULE$.fromProduct(product);
    }

    public static Connection unapply(Connection connection) {
        return Connection$.MODULE$.unapply(connection);
    }

    public static boolean $lessinit$greater$default$3() {
        return Connection$.MODULE$.$lessinit$greater$default$3();
    }

    public Connection(Endpoint from, Endpoint to, boolean isUnmatched) {
        this.from = from;
        this.to = to;
        this.isUnmatched = isUnmatched;
        Ordered.$init$(this);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.anyHash(this.from()));
        n = Statics.mix(n, Statics.anyHash(this.to()));
        n = Statics.mix(n, this.isUnmatched() ? 1231 : 1237);
        return Statics.finalizeHash(n, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Connection)) return false;
        Connection connection = (Connection)object;
        if (this.isUnmatched() != connection.isUnmatched()) return false;
        Endpoint endpoint = this.from();
        Endpoint endpoint2 = connection.from();
        if (endpoint == null) {
            if (endpoint2 != null) {
                return false;
            }
        } else if (!((Object)endpoint).equals(endpoint2)) return false;
        Endpoint endpoint3 = this.to();
        Endpoint endpoint4 = connection.to();
        if (endpoint3 == null) {
            if (endpoint4 != null) {
                return false;
            }
        } else if (!((Object)endpoint3).equals(endpoint4)) return false;
        if (!connection.canEqual(this)) return false;
        return true;
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Connection;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "Connection";
    }

    @Override
    public Object productElement(int n) {
        Comparable<Endpoint> comparable;
        int n2 = n;
        switch (n2) {
            case 0: {
                comparable = this._1();
                break;
            }
            case 1: {
                comparable = this._2();
                break;
            }
            case 2: {
                comparable = BoxesRunTime.boxToBoolean(this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
        }
        return comparable;
    }

    @Override
    public String productElementName(int n) {
        String string2;
        int n2 = n;
        switch (n2) {
            case 0: {
                string2 = "from";
                break;
            }
            case 1: {
                string2 = "to";
                break;
            }
            case 2: {
                string2 = "isUnmatched";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
        }
        return string2;
    }

    public Endpoint from() {
        return this.from;
    }

    public Endpoint to() {
        return this.to;
    }

    public boolean isUnmatched() {
        return this.isUnmatched;
    }

    public String toString() {
        return new StringBuilder(4).append(this.from().toString()).append(" -> ").append(this.to().toString()).toString();
    }

    public Either<Error, BoxedUnit> checkTypes() {
        Either either;
        PortInstance toInstance;
        Option<PortInstance.Type> toType;
        PortInstance fromInstance = this.from().port().portInstance();
        Option<PortInstance.Type> fromType = fromInstance.getType();
        if (PortInstance$Type$.MODULE$.areCompatible(fromType, toType = (toInstance = this.to().port().portInstance()).getType())) {
            either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        } else {
            String fromTypeString = PortInstance$Type$.MODULE$.show(fromType);
            String toTypeString = PortInstance$Type$.MODULE$.show(toType);
            String msg = new StringBuilder(31).append("cannot connect port types ").append(fromTypeString).append(" and ").append(toTypeString).toString();
            Location fromLoc = fromInstance.getLoc();
            Location toLoc = toInstance.getLoc();
            either = package$.MODULE$.Left().apply(SemanticError$InvalidConnection$.MODULE$.apply(this.getLoc(), msg, fromLoc, toLoc, SemanticError$InvalidConnection$.MODULE$.$lessinit$greater$default$5(), SemanticError$InvalidConnection$.MODULE$.$lessinit$greater$default$6()));
        }
        return either;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Either<Error, BoxedUnit> checkSerialWithTypedInput() {
        Either either;
        PortInstance toInstance;
        Option<PortInstance.Type> toType;
        PortInstance fromInstance = this.from().port().portInstance();
        Option<PortInstance.Type> fromType = fromInstance.getType();
        Tuple2<Option<PortInstance.Type>, Option<PortInstance.Type>> tuple2 = Tuple2$.MODULE$.apply(fromType, toType = (toInstance = this.to().port().portInstance()).getType());
        if (tuple2 != null) {
            Option<PortInstance.Type> option = tuple2._1();
            Option<PortInstance.Type> option2 = tuple2._2();
            if (option instanceof Some) {
                PortInstance.Type.DefPort defPort;
                Symbol.Port port;
                PortInstance.Type.DefPort defPort2;
                Symbol.Port port2;
                PortInstance.Type type;
                PortInstance.Type type2 = (PortInstance.Type)((Some)option).value();
                if (PortInstance$Type$Serial$.MODULE$.equals(type2) && option2 instanceof Some && (type = (PortInstance.Type)((Some)option2).value()) instanceof PortInstance.Type.DefPort && (port2 = (defPort2 = PortInstance$Type$DefPort$.MODULE$.unapply((PortInstance.Type.DefPort)type))._1()) != null) {
                    Symbol.Port port3 = Symbol$Port$.MODULE$.unapply(port2);
                    Tuple3<List<String>, AstNode<Ast.DefPort>, List<String>> tuple3 = port3._1();
                    Tuple3<List<String>, AstNode<Ast.DefPort>, List<String>> aNode = tuple3;
                    Option<AstNode<Ast.TypeName>> option3 = aNode._2().data().returnType();
                    if (option3 instanceof Some) {
                        String toTypeString = PortInstance$Type$.MODULE$.show(toType);
                        String msg = new StringBuilder(79).append("cannot connect serial output port to input port of type ").append(toTypeString).append(", which returns a value").toString();
                        Location fromLoc = fromInstance.getLoc();
                        Location toLoc = toInstance.getLoc();
                        either = package$.MODULE$.Left().apply(SemanticError$InvalidConnection$.MODULE$.apply(this.getLoc(), msg, fromLoc, toLoc, None$.MODULE$, Some$.MODULE$.apply(Locations$.MODULE$.get(aNode._2().id()))));
                        return either;
                    }
                    either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
                    return either;
                }
                if (type2 instanceof PortInstance.Type.DefPort && (port = (defPort = PortInstance$Type$DefPort$.MODULE$.unapply((PortInstance.Type.DefPort)type2))._1()) != null) {
                    Tuple3<List<String>, AstNode<Ast.DefPort>, List<String>> tuple3;
                    Symbol.Port port4 = Symbol$Port$.MODULE$.unapply(port);
                    Tuple3<List<String>, AstNode<Ast.DefPort>, List<String>> aNode = tuple3 = port4._1();
                    if (option2 instanceof Some && PortInstance$Type$Serial$.MODULE$.equals(((Some)option2).value())) {
                        Option<AstNode<Ast.TypeName>> option4 = aNode._2().data().returnType();
                        if (option4 instanceof Some) {
                            String fromTypeString = PortInstance$Type$.MODULE$.show(fromType);
                            String msg = new StringBuilder(80).append("cannot connect output port of type ").append(fromTypeString).append(", which returns a value, to serial input port").toString();
                            Location fromLoc = fromInstance.getLoc();
                            Location toLoc = toInstance.getLoc();
                            either = package$.MODULE$.Left().apply(SemanticError$InvalidConnection$.MODULE$.apply(this.getLoc(), msg, fromLoc, toLoc, Some$.MODULE$.apply(Locations$.MODULE$.get(aNode._2().id())), None$.MODULE$));
                            return either;
                        }
                        either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
                        return either;
                    }
                }
            }
        }
        either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        return either;
    }

    public Either<Error, BoxedUnit> checkDirections() {
        Either either;
        PortInstance fromInstance = this.from().port().portInstance();
        Option<PortInstance.Direction> fromDirection = fromInstance.getDirection();
        PortInstance toInstance = this.to().port().portInstance();
        Option<PortInstance.Direction> toDirection = toInstance.getDirection();
        Option<PortInstance.Direction> option = Predef$.MODULE$.ArrowAssoc(fromDirection);
        if (PortInstance$Direction$.MODULE$.areCompatible(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(option, toDirection))) {
            either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        } else {
            String fromDirString = PortInstance$Direction$.MODULE$.show(fromDirection);
            String toDirString = PortInstance$Direction$.MODULE$.show(toDirection);
            String msg = new StringBuilder(51).append("invalid directions ").append(fromDirString).append(" -> ").append(toDirString).append(" (should be output -> input)").toString();
            Location fromLoc = fromInstance.getLoc();
            Location toLoc = toInstance.getLoc();
            either = package$.MODULE$.Left().apply(SemanticError$InvalidConnection$.MODULE$.apply(this.getLoc(), msg, fromLoc, toLoc, SemanticError$InvalidConnection$.MODULE$.$lessinit$greater$default$5(), SemanticError$InvalidConnection$.MODULE$.$lessinit$greater$default$6()));
        }
        return either;
    }

    public boolean isMatchConstrained() {
        PortInstance fromPi = this.from().port().portInstance();
        PortInstance toPi = this.to().port().portInstance();
        List<Component.PortMatching> fromPml = this.from().port().componentInstance().component().portMatchingList();
        List<Component.PortMatching> toPml = this.to().port().componentInstance().component().portMatchingList();
        return Connection.portMatchingExists$1(fromPml, fromPi) || Connection.portMatchingExists$1(toPml, toPi);
    }

    @Override
    public int compare(Connection that) {
        int fromCompare = this.from().compare(that.from());
        return fromCompare != 0 ? fromCompare : this.to().compare(that.to());
    }

    public Location getLoc() {
        return this.from().loc();
    }

    public Endpoint getThisEndpoint(PortInstance pi) {
        Endpoint endpoint;
        PortInstance.Direction direction = pi.getDirection().get();
        if (PortInstance$Direction$Input$.MODULE$.equals(direction)) {
            endpoint = this.to();
        } else if (PortInstance$Direction$Output$.MODULE$.equals(direction)) {
            endpoint = this.from();
        } else {
            throw new MatchError(direction);
        }
        return endpoint;
    }

    public Endpoint getOtherEndpoint(PortInstance pi) {
        Endpoint endpoint;
        PortInstance.Direction direction = pi.getDirection().get();
        if (PortInstance$Direction$Input$.MODULE$.equals(direction)) {
            endpoint = this.from();
        } else if (PortInstance$Direction$Output$.MODULE$.equals(direction)) {
            endpoint = this.to();
        } else {
            throw new MatchError(direction);
        }
        return endpoint;
    }

    public Connection copy(Endpoint from, Endpoint to, boolean isUnmatched) {
        return new Connection(from, to, isUnmatched);
    }

    public Endpoint copy$default$1() {
        return this.from();
    }

    public Endpoint copy$default$2() {
        return this.to();
    }

    public boolean copy$default$3() {
        return this.isUnmatched();
    }

    public Endpoint _1() {
        return this.from();
    }

    public Endpoint _2() {
        return this.to();
    }

    public boolean _3() {
        return this.isUnmatched();
    }

    private static final boolean portMatchingExists$1(List pml, PortInstance pi) {
        return pml.exists((Function1<Component.PortMatching, boolean> & Serializable)pm -> pi.equals(pm.instance1()) || pi.equals(pm.instance2()));
    }

    public static class Endpoint
    implements Ordered<Endpoint>,
    Product,
    Serializable {
        private final Location loc;
        private final PortInstanceIdentifier port;
        private final Option portNumber;

        public static Endpoint apply(Location location, PortInstanceIdentifier portInstanceIdentifier, Option<Object> option) {
            return Connection$Endpoint$.MODULE$.apply(location, portInstanceIdentifier, option);
        }

        public static Either<Error, Endpoint> fromAst(Analysis analysis, AstNode<Ast.PortInstanceIdentifier> astNode, Option<AstNode<Ast.Expr>> option) {
            return Connection$Endpoint$.MODULE$.fromAst(analysis, astNode, option);
        }

        public static Endpoint fromProduct(Product product) {
            return Connection$Endpoint$.MODULE$.fromProduct(product);
        }

        public static Endpoint unapply(Endpoint endpoint) {
            return Connection$Endpoint$.MODULE$.unapply(endpoint);
        }

        public static Option<Object> $lessinit$greater$default$3() {
            return Connection$Endpoint$.MODULE$.$lessinit$greater$default$3();
        }

        public Endpoint(Location loc, PortInstanceIdentifier port, Option<Object> portNumber) {
            this.loc = loc;
            this.port = port;
            this.portNumber = portNumber;
            Ordered.$init$(this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Endpoint)) return false;
            Endpoint endpoint = (Endpoint)object;
            Location location = this.loc();
            Location location2 = endpoint.loc();
            if (location == null) {
                if (location2 != null) {
                    return false;
                }
            } else if (!((Object)location).equals(location2)) return false;
            PortInstanceIdentifier portInstanceIdentifier = this.port();
            PortInstanceIdentifier portInstanceIdentifier2 = endpoint.port();
            if (portInstanceIdentifier == null) {
                if (portInstanceIdentifier2 != null) {
                    return false;
                }
            } else if (!((Object)portInstanceIdentifier).equals(portInstanceIdentifier2)) return false;
            Option<Object> option = this.portNumber();
            Option<Object> option2 = endpoint.portNumber();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!endpoint.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Endpoint;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Endpoint";
        }

        @Override
        public Object productElement(int n) {
            Product product;
            int n2 = n;
            switch (n2) {
                case 0: {
                    product = this._1();
                    break;
                }
                case 1: {
                    product = this._2();
                    break;
                }
                case 2: {
                    product = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
                }
            }
            return product;
        }

        @Override
        public String productElementName(int n) {
            String string2;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string2 = "loc";
                    break;
                }
                case 1: {
                    string2 = "port";
                    break;
                }
                case 2: {
                    string2 = "portNumber";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
                }
            }
            return string2;
        }

        public Location loc() {
            return this.loc;
        }

        public PortInstanceIdentifier port() {
            return this.port;
        }

        public Option<Object> portNumber() {
            return this.portNumber;
        }

        public String toString() {
            String string2;
            Option<Object> option = this.portNumber();
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt(((Some)option).value());
                string2 = new StringBuilder(2).append(this.port().toString()).append("[").append(BoxesRunTime.boxToInteger(n).toString()).append("]").toString();
            } else if (None$.MODULE$.equals(option)) {
                string2 = this.port().toString();
            } else {
                throw new MatchError(option);
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Endpoint that) {
            int n;
            String name1 = this.port().getQualifiedName().toString();
            String name2 = that.port().getQualifiedName().toString();
            int nameCompare = StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(name1), name2);
            if (nameCompare != 0) {
                n = nameCompare;
                return n;
            } else {
                Tuple2<Option<Object>, Option<Object>> tuple2 = Tuple2$.MODULE$.apply(this.portNumber(), that.portNumber());
                if (tuple2 == null) return 0;
                Option<Object> option = tuple2._1();
                Option<Object> option2 = tuple2._2();
                if (!(option instanceof Some)) return 0;
                int n1 = BoxesRunTime.unboxToInt(((Some)option).value());
                if (!(option2 instanceof Some)) return 0;
                int n2 = BoxesRunTime.unboxToInt(((Some)option2).value());
                n = n1 - n2;
            }
            return n;
        }

        public Either<Error, BoxedUnit> checkPortNumber(Location loc) {
            Either either;
            Option<Object> option = this.portNumber();
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt(((Some)option).value());
                int size = this.port().portInstance().getArraySize();
                Location specLoc = this.port().portInstance().getLoc();
                String name = this.port().getQualifiedName().toString();
                either = n < size ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(SemanticError$InvalidPortNumber$.MODULE$.apply(loc, n, name, size, specLoc));
            } else if (None$.MODULE$.equals(option)) {
                either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            return either;
        }

        public Endpoint copy(Location loc, PortInstanceIdentifier port, Option<Object> portNumber) {
            return new Endpoint(loc, port, portNumber);
        }

        public Location copy$default$1() {
            return this.loc();
        }

        public PortInstanceIdentifier copy$default$2() {
            return this.port();
        }

        public Option<Object> copy$default$3() {
            return this.portNumber();
        }

        public Location _1() {
            return this.loc();
        }

        public PortInstanceIdentifier _2() {
            return this.port();
        }

        public Option<Object> _3() {
            return this.portNumber();
        }
    }
}

