/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Format;
import fpp.compiler.analysis.Format$Field$Default$;
import fpp.compiler.analysis.Format$Field$Integer$;
import fpp.compiler.analysis.Format$Field$Integer$Character$;
import fpp.compiler.analysis.Format$Field$Integer$Decimal$;
import fpp.compiler.analysis.Format$Field$Integer$Hexadecimal$;
import fpp.compiler.analysis.Format$Field$Integer$Octal$;
import fpp.compiler.analysis.Format$Field$Rational$;
import fpp.compiler.analysis.Format$Field$Rational$Exponent$;
import fpp.compiler.analysis.Format$Field$Rational$Fixed$;
import fpp.compiler.analysis.Format$Field$Rational$General$;
import fpp.compiler.analysis.Type;
import fpp.compiler.analysis.Type$Boolean$;
import fpp.compiler.analysis.Type$PrimitiveInt$Signed$;
import fpp.compiler.analysis.Type$PrimitiveInt$Unsigned$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$TypeNameFloat$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.CppWriterState;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FormatCppWriter$
implements Serializable {
    public static final FormatCppWriter$ MODULE$ = new FormatCppWriter$();

    private FormatCppWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FormatCppWriter$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDecimalFormat(Type.PrimitiveInt pit) {
        String string2;
        Tuple2<Type.PrimitiveInt.Signedness, Integer> tuple2 = Tuple2$.MODULE$.apply(pit.signedness(), BoxesRunTime.boxToInteger(pit.bitWidth()));
        if (tuple2 == null) throw new MatchError(tuple2);
        Type.PrimitiveInt.Signedness signedness = tuple2._1();
        int n = BoxesRunTime.unboxToInt(tuple2._2());
        if (Type$PrimitiveInt$Unsigned$.MODULE$.equals(signedness)) {
            int w = n;
            string2 = new StringBuilder(9).append("%\" PRIu").append(BoxesRunTime.boxToInteger(w).toString()).append(" \"").toString();
            return string2;
        } else {
            if (!Type$PrimitiveInt$Signed$.MODULE$.equals(signedness)) throw new MatchError(tuple2);
            int w = n;
            string2 = new StringBuilder(9).append("%\" PRIi").append(BoxesRunTime.boxToInteger(w).toString()).append(" \"").toString();
        }
        return string2;
    }

    public String writeField(CppWriterState s, Format.Field f, AstNode<Ast.TypeName> tn) {
        String string2;
        Format.Field field2 = f;
        if (Format$Field$Default$.MODULE$.equals(field2)) {
            string2 = this.default$1(s, tn);
        } else if (field2 instanceof Format.Field.Integer) {
            Format.Field.Integer.Type type;
            Format.Field.Integer integer = Format$Field$Integer$.MODULE$.unapply((Format.Field.Integer)field2);
            Format.Field.Integer.Type it = type = integer._1();
            string2 = this.integer$1(s, tn, it);
        } else if (field2 instanceof Format.Field.Rational) {
            Format.Field.Rational rational = Format$Field$Rational$.MODULE$.unapply((Format.Field.Rational)field2);
            Option<BigInt> option = rational._1();
            Format.Field.Rational.Type type = rational._2();
            Option<BigInt> precision = option;
            Format.Field.Rational.Type rt = type;
            string2 = this.rational$1(s, tn, precision, rt);
        } else {
            throw new MatchError(field2);
        }
        return string2;
    }

    public String write(CppWriterState s, Format f, AstNode<Ast.TypeName> tn) {
        return f.fields().foldLeft(this.escapePercent(f.prefix()), (Function2<String, Tuple2, String> & Serializable)(x$1, x$2) -> {
            String a;
            Tuple2 tuple2;
            block3: {
                Tuple2<String, Tuple2> tuple22;
                block2: {
                    tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 == null) break block2;
                    tuple2 = tuple22._2();
                    a = tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple22);
            }
            Format.Field field2 = (Format.Field)tuple2._1();
            String suffix = (String)tuple2._2();
            return new StringBuilder(0).append(a).append(this.writeField(s, field2, tn)).append(this.escapePercent(suffix)).toString();
        });
    }

    public String escapePercent(String s) {
        return s.replaceAll("%", "%%");
    }

    private final String default$1(CppWriterState s$1, AstNode tn$1) {
        String string2;
        Type type = ((Type)s$1.a().typeMap().apply(BoxesRunTime.boxToInteger(tn$1.id()))).getUnderlyingType();
        if (type instanceof Type.Float) {
            string2 = "%f";
        } else if (type instanceof Type.PrimitiveInt) {
            Type.PrimitiveInt pit = (Type.PrimitiveInt)type;
            string2 = this.getDecimalFormat(pit);
        } else {
            string2 = Type$Boolean$.MODULE$.equals(type) ? "%d" : "%s";
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String integer$1(CppWriterState s$2, AstNode tn$2, Format.Field.Integer.Type it) {
        String string2;
        Type type = ((Type)s$2.a().typeMap().apply(BoxesRunTime.boxToInteger(tn$2.id()))).getUnderlyingType();
        if (type instanceof Type.PrimitiveInt) {
            Type.PrimitiveInt pit = (Type.PrimitiveInt)type;
            Format.Field.Integer.Type type2 = it;
            if (Format$Field$Integer$Character$.MODULE$.equals(type2)) {
                return "%c";
            }
            if (Format$Field$Integer$Decimal$.MODULE$.equals(type2)) {
                string2 = this.getDecimalFormat(pit);
                return string2;
            } else if (Format$Field$Integer$Hexadecimal$.MODULE$.equals(type2)) {
                string2 = new StringBuilder(9).append("%\" PRIx").append(BoxesRunTime.boxToInteger(pit.bitWidth()).toString()).append(" \"").toString();
                return string2;
            } else {
                if (!Format$Field$Integer$Octal$.MODULE$.equals(type2)) throw new MatchError(type2);
                string2 = new StringBuilder(9).append("%\" PRIo").append(BoxesRunTime.boxToInteger(pit.bitWidth()).toString()).append(" \"").toString();
            }
            return string2;
        } else {
            string2 = this.default$1(s$2, tn$2);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String rational$1(CppWriterState s$3, AstNode tn$3, Option precision, Format.Field.Rational.Type rt) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$3.data();
        if (typeName instanceof Ast.TypeNameFloat) {
            String string3;
            Ast.TypeNameFloat typeNameFloat = Ast$TypeNameFloat$.MODULE$.unapply((Ast.TypeNameFloat)typeName);
            Ast.TypeFloat typeFloat = typeNameFloat._1();
            Option option = precision;
            if (option instanceof Some) {
                BigInt p = (BigInt)((Some)option).value();
                string3 = new StringBuilder(1).append(".").append(p.toString()).toString();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string3 = "";
            }
            String precisionStr = string3;
            Format.Field.Rational.Type type = rt;
            if (Format$Field$Rational$Exponent$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("e").toString();
                return string2;
            } else if (Format$Field$Rational$Fixed$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("f").toString();
                return string2;
            } else {
                if (!Format$Field$Rational$General$.MODULE$.equals(type)) throw new MatchError(type);
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("g").toString();
            }
            return string2;
        } else {
            string2 = this.default$1(s$3, tn$3);
        }
        return string2;
    }
}

