/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Dictionary;
import fpp.compiler.analysis.Name;
import fpp.compiler.analysis.Name$Qualified$;
import fpp.compiler.analysis.Symbol$Topology$;
import fpp.compiler.analysis.TlmPacket;
import fpp.compiler.analysis.TlmPacketSet;
import fpp.compiler.analysis.Topology;
import fpp.compiler.analysis.Type;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.ComputeCppFiles$FileNames$;
import fpp.compiler.codegen.CppDoc;
import fpp.compiler.codegen.CppDoc$Lines$Cpp$;
import fpp.compiler.codegen.CppDocWriter$;
import fpp.compiler.codegen.CppWriter$;
import fpp.compiler.codegen.CppWriterState;
import fpp.compiler.codegen.CppWriterState$;
import fpp.compiler.codegen.CppWriterUtils;
import fpp.compiler.codegen.Line;
import fpp.compiler.codegen.Line$;
import fpp.compiler.codegen.LineUtils;
import fpp.compiler.codegen.TlmPacketSetCppWriter$;
import fpp.compiler.codegen.TypeCppWriter$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class TlmPacketSetCppWriter
implements LineUtils,
CppWriterUtils,
Product,
Serializable {
    private String q;
    private int indentIncrement;
    private Function1 addBlankPrefix;
    private Function1 addBlankPostfix;
    private Function1 flattenWithBlankPrefix;
    private List standardSystemHppHeaders;
    private List standardUserHppHeaders;
    private List standardSystemCppHeaders;
    private List standardUserCppHeaders;
    private final CppWriterState s;
    private final Tuple3 aNode;
    private final String name;
    private final Topology t;
    private final Dictionary d;
    private final TlmPacketSet tps;
    private final List<Tuple2<BigInt, TlmPacket>> packetsWithId;
    private final List<TlmPacket> packets;
    private final String namespaceName;
    private final String fileName;
    private final List<Dictionary.TlmChannelEntry> channelEntries;

    public static TlmPacketSetCppWriter apply(CppWriterState cppWriterState, Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> tuple3) {
        return TlmPacketSetCppWriter$.MODULE$.apply(cppWriterState, tuple3);
    }

    public static TlmPacketSetCppWriter fromProduct(Product product) {
        return TlmPacketSetCppWriter$.MODULE$.fromProduct(product);
    }

    public static TlmPacketSetCppWriter unapply(TlmPacketSetCppWriter tlmPacketSetCppWriter) {
        return TlmPacketSetCppWriter$.MODULE$.unapply(tlmPacketSetCppWriter);
    }

    public TlmPacketSetCppWriter(CppWriterState s, Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> aNode) {
        this.s = s;
        this.aNode = aNode;
        LineUtils.$init$(this);
        CppWriterUtils.$init$(this);
        AstNode<Ast.SpecTlmPacketSet> node = aNode._2();
        Ast.SpecTlmPacketSet data = node.data();
        this.name = data.name();
        Option<Topology> option = s.a().topology();
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Topology t = (Topology)((Some)option).value();
        this.t = t;
        this.d = (Dictionary)s.a().dictionaryMap().apply(Symbol$Topology$.MODULE$.apply(this.t.aNode()));
        this.tps = (TlmPacketSet)this.d.tlmPacketSetMap().apply(this.name);
        this.packetsWithId = (List)this.tps.packetMap().toList().sortBy((Function1<Tuple2, String> & Serializable)_$1 -> ((TlmPacket)_$1._2()).getName(), (Ordering)Ordering$String$.MODULE$);
        this.packets = this.packetsWithId.map((Function1<Tuple2, TlmPacket> & Serializable)_$2 -> (TlmPacket)_$2._2());
        String topQualifiedName = new StringBuilder(1).append(this.t.getName()).append("_").append(this.name).toString();
        this.namespaceName = new StringBuilder(10).append(topQualifiedName).append("TlmPackets").toString();
        this.fileName = ComputeCppFiles$FileNames$.MODULE$.getTlmPacketSet(topQualifiedName);
        this.channelEntries = (List)this.d.tlmChannelEntryMap().values().toList().sortBy((Function1<Dictionary.TlmChannelEntry, String> & Serializable)_$3 -> _$3.tlmChannel().getName(), (Ordering)Ordering$String$.MODULE$);
        Statics.releaseFence();
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public int indentIncrement() {
        return this.indentIncrement;
    }

    public Function1 addBlankPrefix() {
        return this.addBlankPrefix;
    }

    public Function1 addBlankPostfix() {
        return this.addBlankPostfix;
    }

    public Function1 flattenWithBlankPrefix() {
        return this.flattenWithBlankPrefix;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$q_$eq(String x$0) {
        this.q = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$indentIncrement_$eq(int x$0) {
        this.indentIncrement = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$addBlankPrefix_$eq(Function1 x$0) {
        this.addBlankPrefix = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$addBlankPostfix_$eq(Function1 x$0) {
        this.addBlankPostfix = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$flattenWithBlankPrefix_$eq(Function1 x$0) {
        this.flattenWithBlankPrefix = x$0;
    }

    public List standardSystemHppHeaders() {
        return this.standardSystemHppHeaders;
    }

    public List standardUserHppHeaders() {
        return this.standardUserHppHeaders;
    }

    public List standardSystemCppHeaders() {
        return this.standardSystemCppHeaders;
    }

    public List standardUserCppHeaders() {
        return this.standardUserCppHeaders;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardSystemHppHeaders_$eq(List x$0) {
        this.standardSystemHppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardUserHppHeaders_$eq(List x$0) {
        this.standardUserHppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardSystemCppHeaders_$eq(List x$0) {
        this.standardSystemCppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardUserCppHeaders_$eq(List x$0) {
        this.standardUserCppHeaders = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TlmPacketSetCppWriter)) return false;
        TlmPacketSetCppWriter tlmPacketSetCppWriter = (TlmPacketSetCppWriter)object;
        CppWriterState cppWriterState = this.s();
        CppWriterState cppWriterState2 = tlmPacketSetCppWriter.s();
        if (cppWriterState == null) {
            if (cppWriterState2 != null) {
                return false;
            }
        } else if (!((Object)cppWriterState).equals(cppWriterState2)) return false;
        Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> tuple3 = this.aNode();
        Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> tuple32 = tlmPacketSetCppWriter.aNode();
        if (tuple3 == null) {
            if (tuple32 != null) {
                return false;
            }
        } else if (!((Object)tuple3).equals(tuple32)) return false;
        if (!tlmPacketSetCppWriter.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof TlmPacketSetCppWriter;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "TlmPacketSetCppWriter";
    }

    @Override
    public Object productElement(int n) {
        Product product;
        int n2 = n;
        if (0 == n2) {
            product = this._1();
        } else if (1 == n2) {
            product = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return product;
    }

    @Override
    public String productElementName(int n) {
        String string2;
        int n2 = n;
        if (0 == n2) {
            string2 = "s";
        } else if (1 == n2) {
            string2 = "aNode";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return string2;
    }

    public CppWriterState s() {
        return this.s;
    }

    public Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> aNode() {
        return this.aNode;
    }

    public CppDoc write() {
        return CppWriter$.MODULE$.createCppDoc(new StringBuilder(18).append(this.name).append(" telemetry packets").toString(), this.fileName, this.getIncludeGuard(), this.getMembers(), this.s().toolName(), CppWriter$.MODULE$.createCppDoc$default$6(), CppWriter$.MODULE$.createCppDoc$default$7());
    }

    private CppDoc.Member getCppIncludesMember() {
        Object standardHeaders = ((List)((StrictOptimizedSeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Fw/Types/Assert.hpp", "Fw/Types/StringBase.hpp", "Fw/Time/Time.hpp", new StringBuilder(4).append(this.s().getRelativePath(this.fileName).toString()).append(".hpp").toString()}))).sorted(Ordering$String$.MODULE$)).map(CppWriter$.MODULE$.headerString());
        List<String> usedSymbolHeaders = this.s().writeIncludeDirectives(this.d.usedSymbolSet());
        List headers = (List)((AbstractIterable)standardHeaders).$plus$plus(usedSymbolHeaders);
        return this.linesMember((List)this.addBlankPrefix().apply(((List)headers.sorted((Ordering)Ordering$String$.MODULE$)).map((Function1<String, Line> & Serializable)s -> this.line((String)s))), (CppDoc.Lines.Output)CppDoc$Lines$Cpp$.MODULE$, this.linesMember$default$3());
    }

    private List<CppDoc.Member> getCppMembers() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Member[]{this.getDataStructuresMember(), this.getCppVarsMember()}));
    }

    private CppDoc.Member getCppVarsMember() {
        return this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{CppDocWriter$.MODULE$.writeBannerComment("Extern variables"), this.writePacketList(), this.writeOmittedChannels()})), (CppDoc.Lines.Output)CppDoc$Lines$Cpp$.MODULE$, this.linesMember$default$3());
    }

    private CppDoc.Member getDataStructuresMember() {
        return this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{CppDocWriter$.MODULE$.writeBannerComment("File-local constants and variables"), (Iterable)this.addBlankPrefix().apply(this.wrapInAnonymousNamespace((List)this.addBlankPostfix().apply(package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{this.writeSizeBounds(), this.writeChannelIds(), this.writeChannelSizes(), this.writePacketIds(), this.writePacketGroups(), this.writePacketDataSizes(), this.writePacketEntryArraySizes(), this.writePacketEntryArrays(), this.writePackets(), this.writeOmittedArraySize(), this.writeOmittedEntryArray()})))))})), (CppDoc.Lines.Output)CppDoc$Lines$Cpp$.MODULE$, this.linesMember$default$3());
    }

    private CppDoc.Member getHppIncludesMember() {
        Object headers = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Svc/TlmPacketizer/TlmPacketizerTypes.hpp"}))).map(CppWriter$.MODULE$.headerString());
        return this.linesMember((List)this.addBlankPrefix().apply(((List)((List)headers).sorted((Ordering)Ordering$String$.MODULE$)).map((Function1<String, Line> & Serializable)s -> this.line((String)s))), this.linesMember$default$2(), this.linesMember$default$3());
    }

    private List<CppDoc.Member> getHppMembers() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Member[]{this.getHppVarMember()}));
    }

    private CppDoc.Member getHppVarMember() {
        return this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{CppDocWriter$.MODULE$.writeBannerComment("Extern variables"), this.lines("|\n              |//! The list of packets\n              |extern const Svc::TlmPacketizerPacketList packetList;\n              |\n              |//! The omitted channels\n              |extern const Svc::TlmPacketizerPacket omittedChannels;")})), this.linesMember$default$2(), this.linesMember$default$3());
    }

    private String getIncludeGuard() {
        String string2;
        List<String> list = this.s().a().getEnclosingNames(Symbol$Topology$.MODULE$.apply(this.t.aNode()));
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
            string2 = this.namespaceName;
        } else {
            List<String> names = list;
            String qualifier = CppWriterState$.MODULE$.identFromQualifiedName(Name$Qualified$.MODULE$.fromIdentList(names));
            string2 = new StringBuilder(1).append(qualifier).append("_").append(this.namespaceName).toString();
        }
        String guard = string2;
        return new StringBuilder(4).append(guard).append("_HPP").toString();
    }

    private List<CppDoc.Member> getMembers() {
        List nsil = (List)this.s().getNamespaceIdentList(Symbol$Topology$.MODULE$.apply(this.t.aNode())).$colon$plus(this.namespaceName);
        List members = (List)this.getHppMembers().$plus$plus(this.getCppMembers());
        CppDoc.Member member = this.getHppIncludesMember();
        CppDoc.Member member2 = this.getCppIncludesMember();
        return this.wrapInNamespaces(nsil, members).$colon$colon(member2).$colon$colon(member);
    }

    private List<Line> writeChannelEntry(Dictionary.TlmChannelEntry entry) {
        Name.Qualified name = entry.getQualifiedName();
        String nameStr = CppWriter$.MODULE$.identFromQualifiedName().apply(name);
        return this.lines(new StringBuilder(33).append("{ ChannelIds::").append(nameStr).append(", ChannelSizes::").append(nameStr).append(" },").toString());
    }

    private List<Line> writeChannelEntryForId(BigInt id) {
        Dictionary.TlmChannelEntry entry = (Dictionary.TlmChannelEntry)this.d.tlmChannelEntryMap().apply(id);
        return this.writeChannelEntry(entry);
    }

    private List<Line> writeChannelIds() {
        return this.writeStruct("ChannelIds", (List<Line>)this.channelEntries.flatMap((Function1<Dictionary.TlmChannelEntry, IterableOnce> & Serializable)entry -> this.writeChannelId$1((Dictionary.TlmChannelEntry)entry)));
    }

    private List<Line> writeChannelSizes() {
        return this.writeStruct("ChannelSizes", (List<Line>)this.channelEntries.flatMap((Function1<Dictionary.TlmChannelEntry, IterableOnce> & Serializable)entry -> this.writeChannelSize$1((Dictionary.TlmChannelEntry)entry)));
    }

    private List<Line> writeEntryArraySizeForPacket(TlmPacket tp) {
        String name = tp.getName();
        int size = tp.memberIdList().size();
        return this.lines(new StringBuilder(93).append("|\n          |// The entry array size for packet ").append(name).append("\n          |static constexpr FwIndexType ").append(name).append(" = ").append(size).append(";").toString());
    }

    private List<Line> writeNamespace(String name, List<Line> lines) {
        return (List)this.addBlankPrefix().apply(this.wrapInNamespace(name, (List)this.addBlankPostfix().apply(lines)));
    }

    private List<Line> writeNumPackets() {
        int n = this.packets.size();
        return this.lines(new StringBuilder(268).append("|\n          |// The number of packets\n          |constexpr FwIndexType numPackets = ").append(n).append(";\n          |\n          |static_assert(\n          |  numPackets <= Svc::MAX_PACKETIZER_PACKETS,\n          |  \"number of packets must be less than or equal to the maximum\"\n          |);").toString());
    }

    private List<Line> writeOmittedArraySize() {
        int size = this.tps.omittedIdSet().size();
        return this.lines(new StringBuilder(111).append("|\n          |// The size of the array of omitted channels\n          |constexpr FwIndexType omittedArraySize = ").append(size).append(";").toString());
    }

    private List<Line> writeOmittedChannels() {
        int n = this.tps.omittedIdSet().size();
        String omittedArray = 0 == n ? "nullptr" : "omittedArray";
        return this.lines(new StringBuilder(170).append("|\n          |\n          |constexpr Svc::TlmPacketizerPacket omittedChannels = {\n          |  ").append(omittedArray).append(",\n          |  0,\n          |  0,\n          |  omittedArraySize\n          |};").toString());
    }

    private List<Line> writeOmittedEntryArray() {
        return (List)this.addBlankPrefix().apply(Line$.MODULE$.addPrefixLine(this.line("// The omitted channel entries"), this.wrapInScope("constexpr Svc::TlmPacketizerChannelEntry omittedArray[omittedArraySize] = {", (List)((List)((IterableOnceOps)this.tps.omittedIdSet().map((Function1<BigInt, Dictionary.TlmChannelEntry> & Serializable)_$4 -> (Dictionary.TlmChannelEntry)this.d.tlmChannelEntryMap().apply((BigInt)_$4))).toList().sortBy((Function1<Dictionary.TlmChannelEntry, String> & Serializable)_$5 -> _$5.tlmChannel().getName(), (Ordering)Ordering$String$.MODULE$)).flatMap((Function1<Dictionary.TlmChannelEntry, IterableOnce> & Serializable)entry -> this.writeChannelEntry((Dictionary.TlmChannelEntry)entry)), "};")));
    }

    private List<Line> writePacket(TlmPacket tp) {
        String name = tp.getName();
        int n = tp.memberIdList().size();
        String entryArray = 0 == n ? "nullptr" : new StringBuilder(19).append("PacketEntryArrays::").append(name).toString();
        return this.lines(new StringBuilder(195).append("|\n          |// Packet ").append(name).append("\n          |constexpr Svc::TlmPacketizerPacket ").append(name).append(" = {\n          |  ").append(entryArray).append(",\n          |  PacketIds::").append(name).append(",\n          |  PacketGroups::").append(name).append(",\n          |  PacketEntryArraySizes::").append(name).append("\n          |};").toString());
    }

    private List<Line> writePacketDataSizes() {
        return this.writeStruct("PacketDataSizes", (List<Line>)this.packets.flatMap((Function1<TlmPacket, IterableOnce> & Serializable)tp -> this.writePacketDataSize$1((TlmPacket)tp)));
    }

    private List<Line> writePacketEntryArray(TlmPacket tp) {
        String name = tp.getName();
        return (List)this.addBlankPrefix().apply(Line$.MODULE$.addPrefixLine(this.line(new StringBuilder(34).append("// The channel entries for packet ").append(name).toString()), this.wrapInScope(new StringBuilder(70).append("constexpr Svc::TlmPacketizerChannelEntry ").append(name).append("[PacketEntryArraySizes::").append(name).append("] = {").toString(), (List)tp.memberIdList().flatMap((Function1<BigInt, IterableOnce> & Serializable)id -> this.writeChannelEntryForId((BigInt)id)), "};")));
    }

    private List<Line> writePacketEntryArraySizes() {
        return this.writeStruct("PacketEntryArraySizes", (List<Line>)this.packets.flatMap((Function1<TlmPacket, IterableOnce> & Serializable)tp -> this.writeEntryArraySizeForPacket((TlmPacket)tp)));
    }

    private List<Line> writePacketEntryArrays() {
        return this.writeNamespace("PacketEntryArrays", (List<Line>)this.packets.flatMap((Function1<TlmPacket, IterableOnce> & Serializable)tp -> this.writePacketEntryArray((TlmPacket)tp)));
    }

    private List<Line> writePacketGroups() {
        return this.writeStruct("PacketGroups", (List<Line>)this.packets.flatMap((Function1<TlmPacket, IterableOnce> & Serializable)tp -> this.writePacketGroup$1((TlmPacket)tp)));
    }

    private List<Line> writePacketIds() {
        return this.writeStruct("PacketIds", (List<Line>)this.packetsWithId.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> this.writePacketId$1(TlmPacketSetCppWriter.id$1(x$1), TlmPacketSetCppWriter.tp$1(x$1))));
    }

    private List<Line> writePacketList() {
        Object arrayBody = this.packets.map((Function1<TlmPacket, Line> & Serializable)p -> this.line(new StringBuilder(11).append("&Packets::").append(p.getName()).append(",").toString()));
        List array = this.packets.size() == 0 ? this.lines("{},") : this.wrapInScope("{", (List)arrayBody, "},");
        List body = (List)array.$colon$plus(this.line("Packets::numPackets"));
        return (List)this.addBlankPrefix().apply(this.wrapInScope("constexpr Svc::TlmPacketizerPacketList packetList = {", body, "};"));
    }

    private List<Line> writePackets() {
        return this.writeNamespace("Packets", (List)this.writeNumPackets().$plus$plus((IterableOnce)this.packets.flatMap((Function1<TlmPacket, IterableOnce> & Serializable)tp -> this.writePacket((TlmPacket)tp))));
    }

    private List<Line> writeSizeBounds() {
        return (List)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.packets.size() > 0))).apply(this::writeSizeBounds$$anonfun$1);
    }

    private List<Line> writeStruct(String name, List<Line> lines) {
        return (List)this.addBlankPrefix().apply(this.wrapInNamedStruct(name, (List)this.addBlankPostfix().apply(lines)));
    }

    public TlmPacketSetCppWriter copy(CppWriterState s, Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> aNode) {
        return new TlmPacketSetCppWriter(s, aNode);
    }

    public CppWriterState copy$default$1() {
        return this.s();
    }

    public Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> copy$default$2() {
        return this.aNode();
    }

    public CppWriterState _1() {
        return this.s();
    }

    public Tuple3<List<String>, AstNode<Ast.SpecTlmPacketSet>, List<String>> _2() {
        return this.aNode();
    }

    private final List writeChannelId$1(Dictionary.TlmChannelEntry entry) {
        Name.Qualified name = entry.getQualifiedName();
        String nameStr = CppWriter$.MODULE$.identFromQualifiedName().apply(name);
        BigInt id = (BigInt)this.d.reverseTlmChannelEntryMap().apply(entry);
        String idStr = CppWriter$.MODULE$.writeId(id);
        return this.lines(new StringBuilder(94).append("|\n            |//! The identifier for channel ").append(name).append("\n            |static constexpr FwChanIdType ").append(nameStr).append(" = ").append(idStr).append(";").toString());
    }

    private final List writeChannelSize$1(Dictionary.TlmChannelEntry entry) {
        Name.Qualified name = entry.getQualifiedName();
        String nameStr = CppWriter$.MODULE$.identFromQualifiedName().apply(name);
        Type t = entry.tlmChannel().channelType();
        String tn = TypeCppWriter$.MODULE$.getName(this.s(), t, TypeCppWriter$.MODULE$.getName$default$3());
        String sizeStr = this.writeSerializedSizeExpr(this.s(), t, tn);
        return this.lines(new StringBuilder(96).append("|\n            |//! The serialized size of channel ").append(name).append("\n            |static constexpr FwSizeType ").append(nameStr).append(" = ").append(sizeStr).append(";").toString());
    }

    private final String writeChannelSizeExpr$1(BigInt id) {
        Dictionary.TlmChannelEntry entry = (Dictionary.TlmChannelEntry)this.d.tlmChannelEntryMap().apply(id);
        Name.Qualified name = entry.getQualifiedName();
        String nameStr = CppWriter$.MODULE$.identFromQualifiedName().apply(name);
        return new StringBuilder(14).append("ChannelSizes::").append(nameStr).toString();
    }

    private final List writePacketDataSize$1(TlmPacket tp) {
        List<BigInt> idList;
        String name = tp.getName();
        List<BigInt> list = idList = tp.memberIdList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<BigInt> list2 = list;
        String dataSize = !(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null) ? "0" : ((AbstractIterable)idList.map((Function1<BigInt, String> & Serializable)id -> this.writeChannelSizeExpr$1((BigInt)id))).mkString("\n  + ");
        return this.lines(new StringBuilder(253).append("|\n            |//! The data size for packet ").append(name).append("\n            |static constexpr FwSizeType ").append(name).append(" = ").append(dataSize).append(";\n            |\n            |static_assert(\n            |  ").append(name).append(" <= SizeBounds::packetMaxDataSize,\n            |  \"packet data must fit in max data size\"\n            |);").toString());
    }

    private final List writePacketGroup$1(TlmPacket tp) {
        String name = tp.getName();
        int group = tp.group();
        return this.lines(new StringBuilder(87).append("|\n            |//! The group for packet ").append(name).append("\n            |static constexpr FwIndexType ").append(name).append(" = ").append(group).append(";").toString());
    }

    private final List writePacketId$1(BigInt id, TlmPacket tp) {
        String name = tp.getName();
        String idStr = CppWriter$.MODULE$.writeId(id);
        return this.lines(new StringBuilder(101).append("|\n            |//! The identifier for packet ").append(name).append("\n            |static constexpr FwTlmPacketizeIdType ").append(name).append(" = ").append(idStr).append(";").toString());
    }

    private static final BigInt id$1(Tuple2 x$1$1) {
        return (BigInt)x$1$1._1();
    }

    private static final TlmPacket tp$1(Tuple2 x$1$2) {
        return (TlmPacket)x$1$2._2();
    }

    private final List writeSizeBounds$$anonfun$1() {
        return this.writeStruct("SizeBounds", this.lines("|\n             |// The size of a packet header\n             |static constexpr FwSizeType packetHeaderSize = Fw::Time::SERIALIZED_SIZE +\n             |  sizeof(FwTlmPacketizeIdType) + sizeof(FwPacketDescriptorType);\n             |\n             |// A packet header must fit in a com buffer\n             |static_assert(\n             |  packetHeaderSize <= FW_COM_BUFFER_MAX_SIZE,\n             |  \"packet header must fit in com buffer\"\n             |);\n             |\n             |// The max data size in a com buffer\n             |static constexpr FwSizeType packetMaxDataSize = FW_COM_BUFFER_MAX_SIZE - packetHeaderSize;"));
    }
}

