# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaintenanceRunArgs', 'MaintenanceRun']

@pulumi.input_type
class MaintenanceRunArgs:
    def __init__(__self__, *,
                 patch_type: pulumi.Input[str],
                 target_resource_id: pulumi.Input[str],
                 time_scheduled: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_dst_file_update_enabled: Optional[pulumi.Input[bool]] = None,
                 patching_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MaintenanceRun resource.
        :param pulumi.Input[str] patch_type: Patch type, either "QUARTERLY" or "TIMEZONE".
        :param pulumi.Input[str] target_resource_id: The ID of the target resource for which the maintenance run should be created.
        :param pulumi.Input[str] time_scheduled: (Updatable) The date and time that update should be scheduled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        :param pulumi.Input[bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[str] patching_mode: (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
               
               *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        """
        pulumi.set(__self__, "patch_type", patch_type)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_dst_file_update_enabled is not None:
            pulumi.set(__self__, "is_dst_file_update_enabled", is_dst_file_update_enabled)
        if patching_mode is not None:
            pulumi.set(__self__, "patching_mode", patching_mode)

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Input[str]:
        """
        Patch type, either "QUARTERLY" or "TIMEZONE".
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "patch_type", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[str]:
        """
        The ID of the target resource for which the maintenance run should be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Input[str]:
        """
        (Updatable) The date and time that update should be scheduled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_scheduled", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @is_dst_file_update_enabled.setter
    def is_dst_file_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dst_file_update_enabled", value)

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.

        *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        """
        return pulumi.get(self, "patching_mode")

    @patching_mode.setter
    def patching_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patching_mode", value)


@pulumi.input_type
class _MaintenanceRunState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 current_custom_action_timeout_in_mins: Optional[pulumi.Input[int]] = None,
                 current_patching_component: Optional[pulumi.Input[str]] = None,
                 custom_action_timeout_in_mins: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_component_patching_start_time: Optional[pulumi.Input[str]] = None,
                 estimated_patching_times: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceRunEstimatedPatchingTimeArgs']]]] = None,
                 is_custom_action_timeout_enabled: Optional[pulumi.Input[bool]] = None,
                 is_dst_file_update_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_subtype: Optional[pulumi.Input[str]] = None,
                 maintenance_type: Optional[pulumi.Input[str]] = None,
                 patch_failure_count: Optional[pulumi.Input[int]] = None,
                 patch_id: Optional[pulumi.Input[str]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 patching_end_time: Optional[pulumi.Input[str]] = None,
                 patching_mode: Optional[pulumi.Input[str]] = None,
                 patching_start_time: Optional[pulumi.Input[str]] = None,
                 patching_status: Optional[pulumi.Input[str]] = None,
                 peer_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_db_server_version: Optional[pulumi.Input[str]] = None,
                 target_resource_id: Optional[pulumi.Input[str]] = None,
                 target_resource_type: Optional[pulumi.Input[str]] = None,
                 target_storage_server_version: Optional[pulumi.Input[str]] = None,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceRun resources.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        :param pulumi.Input[int] current_custom_action_timeout_in_mins: Extend current custom action timeout between the current database servers during waiting state, from 0 (zero) to 30 minutes.
        :param pulumi.Input[str] current_patching_component: The name of the current infrastruture component that is getting patched.
        :param pulumi.Input[int] custom_action_timeout_in_mins: Determines the amount of time the system will wait before the start of each database server patching operation. Specify a number of minutes, from 15 to 120.
        :param pulumi.Input[str] description: Description of the maintenance run.
        :param pulumi.Input[str] display_name: The user-friendly name for the maintenance run.
        :param pulumi.Input[str] estimated_component_patching_start_time: The estimated start time of the next infrastruture component patching operation.
        :param pulumi.Input[Sequence[pulumi.Input['MaintenanceRunEstimatedPatchingTimeArgs']]] estimated_patching_times: The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching).
        :param pulumi.Input[bool] is_custom_action_timeout_enabled: If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        :param pulumi.Input[bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_subtype: Maintenance sub-type.
        :param pulumi.Input[str] maintenance_type: Maintenance type.
        :param pulumi.Input[int] patch_failure_count: Contain the patch failure count.
        :param pulumi.Input[str] patch_id: The unique identifier of the patch. The identifier string includes the patch type, the Oracle Database version, and the patch creation date (using the format YYMMDD). For example, the identifier `ru_patch_19.9.0.0_201030` is used for an RU patch for Oracle Database 19.9.0.0 that was released October 30, 2020.
        :param pulumi.Input[str] patch_type: Patch type, either "QUARTERLY" or "TIMEZONE".
        :param pulumi.Input[str] patching_end_time: The time when the patching operation ended.
        :param pulumi.Input[str] patching_mode: (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
               
               *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        :param pulumi.Input[str] patching_start_time: The time when the patching operation started.
        :param pulumi.Input[str] patching_status: The status of the patching operation.
        :param pulumi.Input[str] peer_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance run for the Autonomous Data Guard association's peer container database.
        :param pulumi.Input[str] state: The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        :param pulumi.Input[str] target_db_server_version: The target software version for the database server patching operation.
        :param pulumi.Input[str] target_resource_id: The ID of the target resource for which the maintenance run should be created.
        :param pulumi.Input[str] target_resource_type: The type of the target resource on which the maintenance run occurs.
        :param pulumi.Input[str] target_storage_server_version: The target Cell version that is to be patched to.
        :param pulumi.Input[str] time_ended: The date and time the maintenance run was completed.
        :param pulumi.Input[str] time_scheduled: (Updatable) The date and time that update should be scheduled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_started: The date and time the maintenance run starts.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if current_custom_action_timeout_in_mins is not None:
            pulumi.set(__self__, "current_custom_action_timeout_in_mins", current_custom_action_timeout_in_mins)
        if current_patching_component is not None:
            pulumi.set(__self__, "current_patching_component", current_patching_component)
        if custom_action_timeout_in_mins is not None:
            pulumi.set(__self__, "custom_action_timeout_in_mins", custom_action_timeout_in_mins)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_component_patching_start_time is not None:
            pulumi.set(__self__, "estimated_component_patching_start_time", estimated_component_patching_start_time)
        if estimated_patching_times is not None:
            pulumi.set(__self__, "estimated_patching_times", estimated_patching_times)
        if is_custom_action_timeout_enabled is not None:
            pulumi.set(__self__, "is_custom_action_timeout_enabled", is_custom_action_timeout_enabled)
        if is_dst_file_update_enabled is not None:
            pulumi.set(__self__, "is_dst_file_update_enabled", is_dst_file_update_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_subtype is not None:
            pulumi.set(__self__, "maintenance_subtype", maintenance_subtype)
        if maintenance_type is not None:
            pulumi.set(__self__, "maintenance_type", maintenance_type)
        if patch_failure_count is not None:
            pulumi.set(__self__, "patch_failure_count", patch_failure_count)
        if patch_id is not None:
            pulumi.set(__self__, "patch_id", patch_id)
        if patch_type is not None:
            pulumi.set(__self__, "patch_type", patch_type)
        if patching_end_time is not None:
            pulumi.set(__self__, "patching_end_time", patching_end_time)
        if patching_mode is not None:
            pulumi.set(__self__, "patching_mode", patching_mode)
        if patching_start_time is not None:
            pulumi.set(__self__, "patching_start_time", patching_start_time)
        if patching_status is not None:
            pulumi.set(__self__, "patching_status", patching_status)
        if peer_maintenance_run_id is not None:
            pulumi.set(__self__, "peer_maintenance_run_id", peer_maintenance_run_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_db_server_version is not None:
            pulumi.set(__self__, "target_db_server_version", target_db_server_version)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if target_storage_server_version is not None:
            pulumi.set(__self__, "target_storage_server_version", target_storage_server_version)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_scheduled is not None:
            pulumi.set(__self__, "time_scheduled", time_scheduled)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="currentCustomActionTimeoutInMins")
    def current_custom_action_timeout_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Extend current custom action timeout between the current database servers during waiting state, from 0 (zero) to 30 minutes.
        """
        return pulumi.get(self, "current_custom_action_timeout_in_mins")

    @current_custom_action_timeout_in_mins.setter
    def current_custom_action_timeout_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_custom_action_timeout_in_mins", value)

    @property
    @pulumi.getter(name="currentPatchingComponent")
    def current_patching_component(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the current infrastruture component that is getting patched.
        """
        return pulumi.get(self, "current_patching_component")

    @current_patching_component.setter
    def current_patching_component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_patching_component", value)

    @property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Determines the amount of time the system will wait before the start of each database server patching operation. Specify a number of minutes, from 15 to 120.
        """
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @custom_action_timeout_in_mins.setter
    def custom_action_timeout_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "custom_action_timeout_in_mins", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the maintenance run.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the maintenance run.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedComponentPatchingStartTime")
    def estimated_component_patching_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The estimated start time of the next infrastruture component patching operation.
        """
        return pulumi.get(self, "estimated_component_patching_start_time")

    @estimated_component_patching_start_time.setter
    def estimated_component_patching_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimated_component_patching_start_time", value)

    @property
    @pulumi.getter(name="estimatedPatchingTimes")
    def estimated_patching_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceRunEstimatedPatchingTimeArgs']]]]:
        """
        The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching).
        """
        return pulumi.get(self, "estimated_patching_times")

    @estimated_patching_times.setter
    def estimated_patching_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceRunEstimatedPatchingTimeArgs']]]]):
        pulumi.set(self, "estimated_patching_times", value)

    @property
    @pulumi.getter(name="isCustomActionTimeoutEnabled")
    def is_custom_action_timeout_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        """
        return pulumi.get(self, "is_custom_action_timeout_enabled")

    @is_custom_action_timeout_enabled.setter
    def is_custom_action_timeout_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_custom_action_timeout_enabled", value)

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @is_dst_file_update_enabled.setter
    def is_dst_file_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dst_file_update_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceSubtype")
    def maintenance_subtype(self) -> Optional[pulumi.Input[str]]:
        """
        Maintenance sub-type.
        """
        return pulumi.get(self, "maintenance_subtype")

    @maintenance_subtype.setter
    def maintenance_subtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_subtype", value)

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Maintenance type.
        """
        return pulumi.get(self, "maintenance_type")

    @maintenance_type.setter
    def maintenance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_type", value)

    @property
    @pulumi.getter(name="patchFailureCount")
    def patch_failure_count(self) -> Optional[pulumi.Input[int]]:
        """
        Contain the patch failure count.
        """
        return pulumi.get(self, "patch_failure_count")

    @patch_failure_count.setter
    def patch_failure_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "patch_failure_count", value)

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the patch. The identifier string includes the patch type, the Oracle Database version, and the patch creation date (using the format YYMMDD). For example, the identifier `ru_patch_19.9.0.0_201030` is used for an RU patch for Oracle Database 19.9.0.0 that was released October 30, 2020.
        """
        return pulumi.get(self, "patch_id")

    @patch_id.setter
    def patch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_id", value)

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> Optional[pulumi.Input[str]]:
        """
        Patch type, either "QUARTERLY" or "TIMEZONE".
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_type", value)

    @property
    @pulumi.getter(name="patchingEndTime")
    def patching_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the patching operation ended.
        """
        return pulumi.get(self, "patching_end_time")

    @patching_end_time.setter
    def patching_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patching_end_time", value)

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.

        *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        """
        return pulumi.get(self, "patching_mode")

    @patching_mode.setter
    def patching_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patching_mode", value)

    @property
    @pulumi.getter(name="patchingStartTime")
    def patching_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the patching operation started.
        """
        return pulumi.get(self, "patching_start_time")

    @patching_start_time.setter
    def patching_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patching_start_time", value)

    @property
    @pulumi.getter(name="patchingStatus")
    def patching_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the patching operation.
        """
        return pulumi.get(self, "patching_status")

    @patching_status.setter
    def patching_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patching_status", value)

    @property
    @pulumi.getter(name="peerMaintenanceRunId")
    def peer_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance run for the Autonomous Data Guard association's peer container database.
        """
        return pulumi.get(self, "peer_maintenance_run_id")

    @peer_maintenance_run_id.setter
    def peer_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_maintenance_run_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetDbServerVersion")
    def target_db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The target software version for the database server patching operation.
        """
        return pulumi.get(self, "target_db_server_version")

    @target_db_server_version.setter
    def target_db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_db_server_version", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target resource for which the maintenance run should be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_resource_type", value)

    @property
    @pulumi.getter(name="targetStorageServerVersion")
    def target_storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The target Cell version that is to be patched to.
        """
        return pulumi.get(self, "target_storage_server_version")

    @target_storage_server_version.setter
    def target_storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_storage_server_version", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the maintenance run was completed.
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date and time that update should be scheduled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_scheduled", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the maintenance run starts.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)


class MaintenanceRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_dst_file_update_enabled: Optional[pulumi.Input[bool]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 patching_mode: Optional[pulumi.Input[str]] = None,
                 target_resource_id: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Maintenance Run resource in Oracle Cloud Infrastructure Database service.

        Creates a maintenance run with one of the following:
        The latest available release update patch (RUP) for the Autonomous Container Database.
        The latest available RUP and DST time zone (TZ) file updates for the Autonomous Container Database.
        Creates a maintenance run to update the DST TZ file for the Autonomous Container Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_maintenance_run = oci.database.MaintenanceRun("test_maintenance_run",
            patch_type=maintenance_run_patch_type,
            target_resource_id=test_resource["id"],
            time_scheduled=maintenance_run_time_scheduled,
            compartment_id=compartment_id,
            is_dst_file_update_enabled=maintenance_run_is_dst_file_update_enabled,
            patching_mode=maintenance_run_patching_mode)
        ```

        ## Import

        MaintenanceRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/maintenanceRun:MaintenanceRun test_maintenance_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        :param pulumi.Input[bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[str] patch_type: Patch type, either "QUARTERLY" or "TIMEZONE".
        :param pulumi.Input[str] patching_mode: (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
               
               *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        :param pulumi.Input[str] target_resource_id: The ID of the target resource for which the maintenance run should be created.
        :param pulumi.Input[str] time_scheduled: (Updatable) The date and time that update should be scheduled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Maintenance Run resource in Oracle Cloud Infrastructure Database service.

        Creates a maintenance run with one of the following:
        The latest available release update patch (RUP) for the Autonomous Container Database.
        The latest available RUP and DST time zone (TZ) file updates for the Autonomous Container Database.
        Creates a maintenance run to update the DST TZ file for the Autonomous Container Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_maintenance_run = oci.database.MaintenanceRun("test_maintenance_run",
            patch_type=maintenance_run_patch_type,
            target_resource_id=test_resource["id"],
            time_scheduled=maintenance_run_time_scheduled,
            compartment_id=compartment_id,
            is_dst_file_update_enabled=maintenance_run_is_dst_file_update_enabled,
            patching_mode=maintenance_run_patching_mode)
        ```

        ## Import

        MaintenanceRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/maintenanceRun:MaintenanceRun test_maintenance_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param MaintenanceRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_dst_file_update_enabled: Optional[pulumi.Input[bool]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 patching_mode: Optional[pulumi.Input[str]] = None,
                 target_resource_id: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceRunArgs.__new__(MaintenanceRunArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["is_dst_file_update_enabled"] = is_dst_file_update_enabled
            if patch_type is None and not opts.urn:
                raise TypeError("Missing required property 'patch_type'")
            __props__.__dict__["patch_type"] = patch_type
            __props__.__dict__["patching_mode"] = patching_mode
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            if time_scheduled is None and not opts.urn:
                raise TypeError("Missing required property 'time_scheduled'")
            __props__.__dict__["time_scheduled"] = time_scheduled
            __props__.__dict__["current_custom_action_timeout_in_mins"] = None
            __props__.__dict__["current_patching_component"] = None
            __props__.__dict__["custom_action_timeout_in_mins"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_component_patching_start_time"] = None
            __props__.__dict__["estimated_patching_times"] = None
            __props__.__dict__["is_custom_action_timeout_enabled"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_subtype"] = None
            __props__.__dict__["maintenance_type"] = None
            __props__.__dict__["patch_failure_count"] = None
            __props__.__dict__["patch_id"] = None
            __props__.__dict__["patching_end_time"] = None
            __props__.__dict__["patching_start_time"] = None
            __props__.__dict__["patching_status"] = None
            __props__.__dict__["peer_maintenance_run_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["target_db_server_version"] = None
            __props__.__dict__["target_resource_type"] = None
            __props__.__dict__["target_storage_server_version"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
        super(MaintenanceRun, __self__).__init__(
            'oci:Database/maintenanceRun:MaintenanceRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            current_custom_action_timeout_in_mins: Optional[pulumi.Input[int]] = None,
            current_patching_component: Optional[pulumi.Input[str]] = None,
            custom_action_timeout_in_mins: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            estimated_component_patching_start_time: Optional[pulumi.Input[str]] = None,
            estimated_patching_times: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceRunEstimatedPatchingTimeArgs']]]]] = None,
            is_custom_action_timeout_enabled: Optional[pulumi.Input[bool]] = None,
            is_dst_file_update_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_subtype: Optional[pulumi.Input[str]] = None,
            maintenance_type: Optional[pulumi.Input[str]] = None,
            patch_failure_count: Optional[pulumi.Input[int]] = None,
            patch_id: Optional[pulumi.Input[str]] = None,
            patch_type: Optional[pulumi.Input[str]] = None,
            patching_end_time: Optional[pulumi.Input[str]] = None,
            patching_mode: Optional[pulumi.Input[str]] = None,
            patching_start_time: Optional[pulumi.Input[str]] = None,
            patching_status: Optional[pulumi.Input[str]] = None,
            peer_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            target_db_server_version: Optional[pulumi.Input[str]] = None,
            target_resource_id: Optional[pulumi.Input[str]] = None,
            target_resource_type: Optional[pulumi.Input[str]] = None,
            target_storage_server_version: Optional[pulumi.Input[str]] = None,
            time_ended: Optional[pulumi.Input[str]] = None,
            time_scheduled: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None) -> 'MaintenanceRun':
        """
        Get an existing MaintenanceRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        :param pulumi.Input[int] current_custom_action_timeout_in_mins: Extend current custom action timeout between the current database servers during waiting state, from 0 (zero) to 30 minutes.
        :param pulumi.Input[str] current_patching_component: The name of the current infrastruture component that is getting patched.
        :param pulumi.Input[int] custom_action_timeout_in_mins: Determines the amount of time the system will wait before the start of each database server patching operation. Specify a number of minutes, from 15 to 120.
        :param pulumi.Input[str] description: Description of the maintenance run.
        :param pulumi.Input[str] display_name: The user-friendly name for the maintenance run.
        :param pulumi.Input[str] estimated_component_patching_start_time: The estimated start time of the next infrastruture component patching operation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceRunEstimatedPatchingTimeArgs']]]] estimated_patching_times: The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching).
        :param pulumi.Input[bool] is_custom_action_timeout_enabled: If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        :param pulumi.Input[bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_subtype: Maintenance sub-type.
        :param pulumi.Input[str] maintenance_type: Maintenance type.
        :param pulumi.Input[int] patch_failure_count: Contain the patch failure count.
        :param pulumi.Input[str] patch_id: The unique identifier of the patch. The identifier string includes the patch type, the Oracle Database version, and the patch creation date (using the format YYMMDD). For example, the identifier `ru_patch_19.9.0.0_201030` is used for an RU patch for Oracle Database 19.9.0.0 that was released October 30, 2020.
        :param pulumi.Input[str] patch_type: Patch type, either "QUARTERLY" or "TIMEZONE".
        :param pulumi.Input[str] patching_end_time: The time when the patching operation ended.
        :param pulumi.Input[str] patching_mode: (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
               
               *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        :param pulumi.Input[str] patching_start_time: The time when the patching operation started.
        :param pulumi.Input[str] patching_status: The status of the patching operation.
        :param pulumi.Input[str] peer_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance run for the Autonomous Data Guard association's peer container database.
        :param pulumi.Input[str] state: The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        :param pulumi.Input[str] target_db_server_version: The target software version for the database server patching operation.
        :param pulumi.Input[str] target_resource_id: The ID of the target resource for which the maintenance run should be created.
        :param pulumi.Input[str] target_resource_type: The type of the target resource on which the maintenance run occurs.
        :param pulumi.Input[str] target_storage_server_version: The target Cell version that is to be patched to.
        :param pulumi.Input[str] time_ended: The date and time the maintenance run was completed.
        :param pulumi.Input[str] time_scheduled: (Updatable) The date and time that update should be scheduled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_started: The date and time the maintenance run starts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceRunState.__new__(_MaintenanceRunState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["current_custom_action_timeout_in_mins"] = current_custom_action_timeout_in_mins
        __props__.__dict__["current_patching_component"] = current_patching_component
        __props__.__dict__["custom_action_timeout_in_mins"] = custom_action_timeout_in_mins
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_component_patching_start_time"] = estimated_component_patching_start_time
        __props__.__dict__["estimated_patching_times"] = estimated_patching_times
        __props__.__dict__["is_custom_action_timeout_enabled"] = is_custom_action_timeout_enabled
        __props__.__dict__["is_dst_file_update_enabled"] = is_dst_file_update_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_subtype"] = maintenance_subtype
        __props__.__dict__["maintenance_type"] = maintenance_type
        __props__.__dict__["patch_failure_count"] = patch_failure_count
        __props__.__dict__["patch_id"] = patch_id
        __props__.__dict__["patch_type"] = patch_type
        __props__.__dict__["patching_end_time"] = patching_end_time
        __props__.__dict__["patching_mode"] = patching_mode
        __props__.__dict__["patching_start_time"] = patching_start_time
        __props__.__dict__["patching_status"] = patching_status
        __props__.__dict__["peer_maintenance_run_id"] = peer_maintenance_run_id
        __props__.__dict__["state"] = state
        __props__.__dict__["target_db_server_version"] = target_db_server_version
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["target_resource_type"] = target_resource_type
        __props__.__dict__["target_storage_server_version"] = target_storage_server_version
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_scheduled"] = time_scheduled
        __props__.__dict__["time_started"] = time_started
        return MaintenanceRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Maintenance Run.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentCustomActionTimeoutInMins")
    def current_custom_action_timeout_in_mins(self) -> pulumi.Output[int]:
        """
        Extend current custom action timeout between the current database servers during waiting state, from 0 (zero) to 30 minutes.
        """
        return pulumi.get(self, "current_custom_action_timeout_in_mins")

    @property
    @pulumi.getter(name="currentPatchingComponent")
    def current_patching_component(self) -> pulumi.Output[str]:
        """
        The name of the current infrastruture component that is getting patched.
        """
        return pulumi.get(self, "current_patching_component")

    @property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> pulumi.Output[int]:
        """
        Determines the amount of time the system will wait before the start of each database server patching operation. Specify a number of minutes, from 15 to 120.
        """
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the maintenance run.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the maintenance run.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedComponentPatchingStartTime")
    def estimated_component_patching_start_time(self) -> pulumi.Output[str]:
        """
        The estimated start time of the next infrastruture component patching operation.
        """
        return pulumi.get(self, "estimated_component_patching_start_time")

    @property
    @pulumi.getter(name="estimatedPatchingTimes")
    def estimated_patching_times(self) -> pulumi.Output[Sequence['outputs.MaintenanceRunEstimatedPatchingTime']]:
        """
        The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching).
        """
        return pulumi.get(self, "estimated_patching_times")

    @property
    @pulumi.getter(name="isCustomActionTimeoutEnabled")
    def is_custom_action_timeout_enabled(self) -> pulumi.Output[bool]:
        """
        If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        """
        return pulumi.get(self, "is_custom_action_timeout_enabled")

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceSubtype")
    def maintenance_subtype(self) -> pulumi.Output[str]:
        """
        Maintenance sub-type.
        """
        return pulumi.get(self, "maintenance_subtype")

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> pulumi.Output[str]:
        """
        Maintenance type.
        """
        return pulumi.get(self, "maintenance_type")

    @property
    @pulumi.getter(name="patchFailureCount")
    def patch_failure_count(self) -> pulumi.Output[int]:
        """
        Contain the patch failure count.
        """
        return pulumi.get(self, "patch_failure_count")

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the patch. The identifier string includes the patch type, the Oracle Database version, and the patch creation date (using the format YYMMDD). For example, the identifier `ru_patch_19.9.0.0_201030` is used for an RU patch for Oracle Database 19.9.0.0 that was released October 30, 2020.
        """
        return pulumi.get(self, "patch_id")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Output[str]:
        """
        Patch type, either "QUARTERLY" or "TIMEZONE".
        """
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="patchingEndTime")
    def patching_end_time(self) -> pulumi.Output[str]:
        """
        The time when the patching operation ended.
        """
        return pulumi.get(self, "patching_end_time")

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.

        *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See [Oracle-Managed Infrastructure Maintenance Updates](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle) for more information.
        """
        return pulumi.get(self, "patching_mode")

    @property
    @pulumi.getter(name="patchingStartTime")
    def patching_start_time(self) -> pulumi.Output[str]:
        """
        The time when the patching operation started.
        """
        return pulumi.get(self, "patching_start_time")

    @property
    @pulumi.getter(name="patchingStatus")
    def patching_status(self) -> pulumi.Output[str]:
        """
        The status of the patching operation.
        """
        return pulumi.get(self, "patching_status")

    @property
    @pulumi.getter(name="peerMaintenanceRunId")
    def peer_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance run for the Autonomous Data Guard association's peer container database.
        """
        return pulumi.get(self, "peer_maintenance_run_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetDbServerVersion")
    def target_db_server_version(self) -> pulumi.Output[str]:
        """
        The target software version for the database server patching operation.
        """
        return pulumi.get(self, "target_db_server_version")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[str]:
        """
        The ID of the target resource for which the maintenance run should be created.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output[str]:
        """
        The type of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_type")

    @property
    @pulumi.getter(name="targetStorageServerVersion")
    def target_storage_server_version(self) -> pulumi.Output[str]:
        """
        The target Cell version that is to be patched to.
        """
        return pulumi.get(self, "target_storage_server_version")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[str]:
        """
        The date and time the maintenance run was completed.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Output[str]:
        """
        (Updatable) The date and time that update should be scheduled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The date and time the maintenance run starts.
        """
        return pulumi.get(self, "time_started")

