# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPbfListingVersionResult',
    'AwaitableGetPbfListingVersionResult',
    'get_pbf_listing_version',
    'get_pbf_listing_version_output',
]

@pulumi.output_type
class GetPbfListingVersionResult:
    """
    A collection of values returned by getPbfListingVersion.
    """
    def __init__(__self__, change_summary=None, configs=None, defined_tags=None, freeform_tags=None, id=None, name=None, pbf_listing_id=None, pbf_listing_version_id=None, requirements=None, state=None, system_tags=None, time_created=None, time_updated=None, triggers=None):
        if change_summary and not isinstance(change_summary, str):
            raise TypeError("Expected argument 'change_summary' to be a str")
        pulumi.set(__self__, "change_summary", change_summary)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pbf_listing_id and not isinstance(pbf_listing_id, str):
            raise TypeError("Expected argument 'pbf_listing_id' to be a str")
        pulumi.set(__self__, "pbf_listing_id", pbf_listing_id)
        if pbf_listing_version_id and not isinstance(pbf_listing_version_id, str):
            raise TypeError("Expected argument 'pbf_listing_version_id' to be a str")
        pulumi.set(__self__, "pbf_listing_version_id", pbf_listing_version_id)
        if requirements and not isinstance(requirements, list):
            raise TypeError("Expected argument 'requirements' to be a list")
        pulumi.set(__self__, "requirements", requirements)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="changeSummary")
    def change_summary(self) -> str:
        """
        Details changes are included in this version.
        """
        return pulumi.get(self, "change_summary")

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetPbfListingVersionConfigResult']:
        """
        Details about the required and optional Function configurations needed for proper performance of the PBF.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        """
        The OCID of the PbfListing this resource version belongs to.
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="pbfListingVersionId")
    def pbf_listing_version_id(self) -> str:
        return pulumi.get(self, "pbf_listing_version_id")

    @property
    @pulumi.getter
    def requirements(self) -> Sequence['outputs.GetPbfListingVersionRequirementResult']:
        """
        Minimum memory required by this PBF. The user should use memory greater than or equal to this value  while configuring the Function.
        """
        return pulumi.get(self, "requirements")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the PBF resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the PbfListingVersion was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last time the PbfListingVersion was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetPbfListingVersionTriggerResult']:
        """
        An array of Trigger. A list of triggers that may activate the PBF.
        """
        return pulumi.get(self, "triggers")


class AwaitableGetPbfListingVersionResult(GetPbfListingVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbfListingVersionResult(
            change_summary=self.change_summary,
            configs=self.configs,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            name=self.name,
            pbf_listing_id=self.pbf_listing_id,
            pbf_listing_version_id=self.pbf_listing_version_id,
            requirements=self.requirements,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            triggers=self.triggers)


def get_pbf_listing_version(pbf_listing_version_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbfListingVersionResult:
    """
    This data source provides details about a specific Pbf Listing Version resource in Oracle Cloud Infrastructure Functions service.

    Gets a PbfListingVersion by identifier for a PbfListing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing_version = oci.Functions.get_pbf_listing_version(pbf_listing_version_id=test_pbf_listing_version_oci_functions_pbf_listing_version["id"])
    ```


    :param str pbf_listing_version_id: unique PbfListingVersion identifier
    """
    __args__ = dict()
    __args__['pbfListingVersionId'] = pbf_listing_version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getPbfListingVersion:getPbfListingVersion', __args__, opts=opts, typ=GetPbfListingVersionResult).value

    return AwaitableGetPbfListingVersionResult(
        change_summary=pulumi.get(__ret__, 'change_summary'),
        configs=pulumi.get(__ret__, 'configs'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pbf_listing_id=pulumi.get(__ret__, 'pbf_listing_id'),
        pbf_listing_version_id=pulumi.get(__ret__, 'pbf_listing_version_id'),
        requirements=pulumi.get(__ret__, 'requirements'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        triggers=pulumi.get(__ret__, 'triggers'))


@_utilities.lift_output_func(get_pbf_listing_version)
def get_pbf_listing_version_output(pbf_listing_version_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPbfListingVersionResult]:
    """
    This data source provides details about a specific Pbf Listing Version resource in Oracle Cloud Infrastructure Functions service.

    Gets a PbfListingVersion by identifier for a PbfListing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing_version = oci.Functions.get_pbf_listing_version(pbf_listing_version_id=test_pbf_listing_version_oci_functions_pbf_listing_version["id"])
    ```


    :param str pbf_listing_version_id: unique PbfListingVersion identifier
    """
    ...
