# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTagsResult',
    'AwaitableGetTagsResult',
    'get_tags',
    'get_tags_output',
]

@pulumi.output_type
class GetTagsResult:
    """
    A collection of values returned by getTags.
    """
    def __init__(__self__, filters=None, id=None, state=None, tag_namespace_id=None, tags=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tag_namespace_id and not isinstance(tag_namespace_id, str):
            raise TypeError("Expected argument 'tag_namespace_id' to be a str")
        pulumi.set(__self__, "tag_namespace_id", tag_namespace_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTagsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The tag's current state. After creating a tag, make sure its `lifecycleState` is ACTIVE before using it. After retiring a tag, make sure its `lifecycleState` is INACTIVE before using it. If you delete a tag, you cannot delete another tag until the deleted tag's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tagNamespaceId")
    def tag_namespace_id(self) -> str:
        """
        The OCID of the namespace that contains the tag definition.
        """
        return pulumi.get(self, "tag_namespace_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetTagsTagResult']:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetTagsResult(GetTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagsResult(
            filters=self.filters,
            id=self.id,
            state=self.state,
            tag_namespace_id=self.tag_namespace_id,
            tags=self.tags)


def get_tags(filters: Optional[Sequence[pulumi.InputType['GetTagsFilterArgs']]] = None,
             state: Optional[str] = None,
             tag_namespace_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagsResult:
    """
    This data source provides the list of Tags in Oracle Cloud Infrastructure Identity service.

    Lists the tag definitions in the specified tag namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tags = oci.Identity.get_tags(tag_namespace_id=test_tag_namespace["id"],
        state=tag_state)
    ```


    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str tag_namespace_id: The OCID of the tag namespace.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['tagNamespaceId'] = tag_namespace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getTags:getTags', __args__, opts=opts, typ=GetTagsResult).value

    return AwaitableGetTagsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        tag_namespace_id=pulumi.get(__ret__, 'tag_namespace_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_tags)
def get_tags_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetTagsFilterArgs']]]]] = None,
                    state: Optional[pulumi.Input[Optional[str]]] = None,
                    tag_namespace_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTagsResult]:
    """
    This data source provides the list of Tags in Oracle Cloud Infrastructure Identity service.

    Lists the tag definitions in the specified tag namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tags = oci.Identity.get_tags(tag_namespace_id=test_tag_namespace["id"],
        state=tag_state)
    ```


    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str tag_namespace_id: The OCID of the tag namespace.
    """
    ...
