# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJavaReleasesResult',
    'AwaitableGetJavaReleasesResult',
    'get_java_releases',
    'get_java_releases_output',
]

@pulumi.output_type
class GetJavaReleasesResult:
    """
    A collection of values returned by getJavaReleases.
    """
    def __init__(__self__, family_version=None, filters=None, id=None, java_release_collections=None, jre_security_status=None, license_type=None, release_type=None, release_version=None):
        if family_version and not isinstance(family_version, str):
            raise TypeError("Expected argument 'family_version' to be a str")
        pulumi.set(__self__, "family_version", family_version)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_release_collections and not isinstance(java_release_collections, list):
            raise TypeError("Expected argument 'java_release_collections' to be a list")
        pulumi.set(__self__, "java_release_collections", java_release_collections)
        if jre_security_status and not isinstance(jre_security_status, str):
            raise TypeError("Expected argument 'jre_security_status' to be a str")
        pulumi.set(__self__, "jre_security_status", jre_security_status)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if release_type and not isinstance(release_type, str):
            raise TypeError("Expected argument 'release_type' to be a str")
        pulumi.set(__self__, "release_type", release_type)
        if release_version and not isinstance(release_version, str):
            raise TypeError("Expected argument 'release_version' to be a str")
        pulumi.set(__self__, "release_version", release_version)

    @property
    @pulumi.getter(name="familyVersion")
    def family_version(self) -> Optional[str]:
        """
        Java release family identifier.
        """
        return pulumi.get(self, "family_version")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJavaReleasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaReleaseCollections")
    def java_release_collections(self) -> Sequence['outputs.GetJavaReleasesJavaReleaseCollectionResult']:
        """
        The list of java_release_collection.
        """
        return pulumi.get(self, "java_release_collections")

    @property
    @pulumi.getter(name="jreSecurityStatus")
    def jre_security_status(self) -> Optional[str]:
        return pulumi.get(self, "jre_security_status")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License type for the Java version.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="releaseType")
    def release_type(self) -> Optional[str]:
        """
        Release category of the Java version.
        """
        return pulumi.get(self, "release_type")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[str]:
        """
        Java release version identifier.
        """
        return pulumi.get(self, "release_version")


class AwaitableGetJavaReleasesResult(GetJavaReleasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaReleasesResult(
            family_version=self.family_version,
            filters=self.filters,
            id=self.id,
            java_release_collections=self.java_release_collections,
            jre_security_status=self.jre_security_status,
            license_type=self.license_type,
            release_type=self.release_type,
            release_version=self.release_version)


def get_java_releases(family_version: Optional[str] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetJavaReleasesFilterArgs']]] = None,
                      jre_security_status: Optional[str] = None,
                      license_type: Optional[str] = None,
                      release_type: Optional[str] = None,
                      release_version: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaReleasesResult:
    """
    This data source provides the list of Java Releases in Oracle Cloud Infrastructure Jms service.

    Returns a list of Java releases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_releases = oci.Jms.get_java_releases(family_version=java_release_family_version,
        jre_security_status=java_release_jre_security_status,
        license_type=java_release_license_type,
        release_type=java_release_release_type,
        release_version=java_release_release_version)
    ```


    :param str family_version: The version identifier for the Java family.
    :param str jre_security_status: The security status of the Java Runtime.
    :param str license_type: Java license type.
    :param str release_type: Java release type.
    :param str release_version: Unique Java release version identifier
    """
    __args__ = dict()
    __args__['familyVersion'] = family_version
    __args__['filters'] = filters
    __args__['jreSecurityStatus'] = jre_security_status
    __args__['licenseType'] = license_type
    __args__['releaseType'] = release_type
    __args__['releaseVersion'] = release_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaReleases:getJavaReleases', __args__, opts=opts, typ=GetJavaReleasesResult).value

    return AwaitableGetJavaReleasesResult(
        family_version=pulumi.get(__ret__, 'family_version'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        java_release_collections=pulumi.get(__ret__, 'java_release_collections'),
        jre_security_status=pulumi.get(__ret__, 'jre_security_status'),
        license_type=pulumi.get(__ret__, 'license_type'),
        release_type=pulumi.get(__ret__, 'release_type'),
        release_version=pulumi.get(__ret__, 'release_version'))


@_utilities.lift_output_func(get_java_releases)
def get_java_releases_output(family_version: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetJavaReleasesFilterArgs']]]]] = None,
                             jre_security_status: Optional[pulumi.Input[Optional[str]]] = None,
                             license_type: Optional[pulumi.Input[Optional[str]]] = None,
                             release_type: Optional[pulumi.Input[Optional[str]]] = None,
                             release_version: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJavaReleasesResult]:
    """
    This data source provides the list of Java Releases in Oracle Cloud Infrastructure Jms service.

    Returns a list of Java releases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_releases = oci.Jms.get_java_releases(family_version=java_release_family_version,
        jre_security_status=java_release_jre_security_status,
        license_type=java_release_license_type,
        release_type=java_release_release_type,
        release_version=java_release_release_version)
    ```


    :param str family_version: The version identifier for the Java family.
    :param str jre_security_status: The security status of the Java Runtime.
    :param str license_type: Java license type.
    :param str release_type: Java release type.
    :param str release_version: Unique Java release version identifier
    """
    ...
