# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEventResult',
    'AwaitableGetEventResult',
    'get_event',
    'get_event_output',
]

@pulumi.output_type
class GetEventResult:
    """
    A collection of values returned by getEvent.
    """
    def __init__(__self__, compartment_id=None, datas=None, defined_tags=None, event_details=None, event_id=None, event_summary=None, freeform_tags=None, id=None, is_managed_by_autonomous_linux=None, lifecycle_details=None, resource_id=None, state=None, system_details=None, system_tags=None, time_created=None, time_occurred=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if datas and not isinstance(datas, list):
            raise TypeError("Expected argument 'datas' to be a list")
        pulumi.set(__self__, "datas", datas)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if event_details and not isinstance(event_details, str):
            raise TypeError("Expected argument 'event_details' to be a str")
        pulumi.set(__self__, "event_details", event_details)
        if event_id and not isinstance(event_id, str):
            raise TypeError("Expected argument 'event_id' to be a str")
        pulumi.set(__self__, "event_id", event_id)
        if event_summary and not isinstance(event_summary, str):
            raise TypeError("Expected argument 'event_summary' to be a str")
        pulumi.set(__self__, "event_summary", event_summary)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_details and not isinstance(system_details, list):
            raise TypeError("Expected argument 'system_details' to be a list")
        pulumi.set(__self__, "system_details", system_details)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_occurred and not isinstance(time_occurred, str):
            raise TypeError("Expected argument 'time_occurred' to be a str")
        pulumi.set(__self__, "time_occurred", time_occurred)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetEventDataResult']:
        """
        Provides additional information for a management station event.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="eventDetails")
    def event_details(self) -> str:
        """
        Details of an event.
        """
        return pulumi.get(self, "event_details")

    @property
    @pulumi.getter(name="eventId")
    def event_id(self) -> str:
        return pulumi.get(self, "event_id")

    @property
    @pulumi.getter(name="eventSummary")
    def event_summary(self) -> str:
        """
        Summary of the event.
        """
        return pulumi.get(self, "event_summary")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> bool:
        """
        Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the current state of the event in more detail. For example, the  message can provide actionable information for a resource in the 'FAILED' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the event.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemDetails")
    def system_details(self) -> Sequence['outputs.GetEventSystemDetailResult']:
        """
        Provides information about the system architecture and operating system.
        """
        return pulumi.get(self, "system_details")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Event was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOccurred")
    def time_occurred(self) -> str:
        """
        The date and time that the event occurred.
        """
        return pulumi.get(self, "time_occurred")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time that the event was updated (in [RFC 3339](https://tools.ietf.org/html/rfc3339) format). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Event type:
        """
        return pulumi.get(self, "type")


class AwaitableGetEventResult(GetEventResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventResult(
            compartment_id=self.compartment_id,
            datas=self.datas,
            defined_tags=self.defined_tags,
            event_details=self.event_details,
            event_id=self.event_id,
            event_summary=self.event_summary,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            lifecycle_details=self.lifecycle_details,
            resource_id=self.resource_id,
            state=self.state,
            system_details=self.system_details,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_occurred=self.time_occurred,
            time_updated=self.time_updated,
            type=self.type)


def get_event(event_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventResult:
    """
    This data source provides details about a specific Event resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified event.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_event = oci.OsManagementHub.get_event(event_id=test_event_oci_os_management_hub_event["id"])
    ```


    :param str event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
    """
    __args__ = dict()
    __args__['eventId'] = event_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getEvent:getEvent', __args__, opts=opts, typ=GetEventResult).value

    return AwaitableGetEventResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        datas=pulumi.get(__ret__, 'datas'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        event_details=pulumi.get(__ret__, 'event_details'),
        event_id=pulumi.get(__ret__, 'event_id'),
        event_summary=pulumi.get(__ret__, 'event_summary'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        system_details=pulumi.get(__ret__, 'system_details'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_occurred=pulumi.get(__ret__, 'time_occurred'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_event)
def get_event_output(event_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventResult]:
    """
    This data source provides details about a specific Event resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified event.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_event = oci.OsManagementHub.get_event(event_id=test_event_oci_os_management_hub_event["id"])
    ```


    :param str event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
    """
    ...
