# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSoftwarePackagesResult',
    'AwaitableGetSoftwarePackagesResult',
    'get_software_packages',
    'get_software_packages_output',
]

@pulumi.output_type
class GetSoftwarePackagesResult:
    """
    A collection of values returned by getSoftwarePackages.
    """
    def __init__(__self__, architecture=None, display_name=None, display_name_contains=None, filters=None, id=None, is_latest=None, os_family=None, software_package_collections=None, version=None):
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if software_package_collections and not isinstance(software_package_collections, list):
            raise TypeError("Expected argument 'software_package_collections' to be a list")
        pulumi.set(__self__, "software_package_collections", software_package_collections)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        """
        The architecture for which this software was built
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSoftwarePackagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[bool]:
        """
        Indicates whether this package is the latest version.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="softwarePackageCollections")
    def software_package_collections(self) -> Sequence['outputs.GetSoftwarePackagesSoftwarePackageCollectionResult']:
        """
        The list of software_package_collection.
        """
        return pulumi.get(self, "software_package_collections")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the package.
        """
        return pulumi.get(self, "version")


class AwaitableGetSoftwarePackagesResult(GetSoftwarePackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwarePackagesResult(
            architecture=self.architecture,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            is_latest=self.is_latest,
            os_family=self.os_family,
            software_package_collections=self.software_package_collections,
            version=self.version)


def get_software_packages(architecture: Optional[str] = None,
                          display_name: Optional[str] = None,
                          display_name_contains: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetSoftwarePackagesFilterArgs']]] = None,
                          is_latest: Optional[bool] = None,
                          os_family: Optional[str] = None,
                          version: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwarePackagesResult:
    """
    This data source provides the list of Software Packages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software packages available through the OS Management Hub service.  Filter the list against a variety of criteria
    including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_packages = oci.OsManagementHub.get_software_packages(architecture=software_package_architecture,
        display_name=software_package_display_name,
        display_name_contains=software_package_display_name_contains,
        is_latest=software_package_is_latest,
        os_family=software_package_os_family,
        version=software_package_version)
    ```


    :param str architecture: A filter to return software packages that match the given architecture.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str version: A filter to return software packages that match the given version.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['isLatest'] = is_latest
    __args__['osFamily'] = os_family
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwarePackages:getSoftwarePackages', __args__, opts=opts, typ=GetSoftwarePackagesResult).value

    return AwaitableGetSoftwarePackagesResult(
        architecture=pulumi.get(__ret__, 'architecture'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        os_family=pulumi.get(__ret__, 'os_family'),
        software_package_collections=pulumi.get(__ret__, 'software_package_collections'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_software_packages)
def get_software_packages_output(architecture: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSoftwarePackagesFilterArgs']]]]] = None,
                                 is_latest: Optional[pulumi.Input[Optional[bool]]] = None,
                                 os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                 version: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwarePackagesResult]:
    """
    This data source provides the list of Software Packages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software packages available through the OS Management Hub service.  Filter the list against a variety of criteria
    including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_packages = oci.OsManagementHub.get_software_packages(architecture=software_package_architecture,
        display_name=software_package_display_name,
        display_name_contains=software_package_display_name_contains,
        is_latest=software_package_is_latest,
        os_family=software_package_os_family,
        version=software_package_version)
    ```


    :param str architecture: A filter to return software packages that match the given architecture.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str version: A filter to return software packages that match the given version.
    """
    ...
