# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostScanTargetErrorsResult',
    'AwaitableGetHostScanTargetErrorsResult',
    'get_host_scan_target_errors',
    'get_host_scan_target_errors_output',
]

@pulumi.output_type
class GetHostScanTargetErrorsResult:
    """
    A collection of values returned by getHostScanTargetErrors.
    """
    def __init__(__self__, compartment_id=None, filters=None, host_scan_target_error_summary_collections=None, host_scan_target_id=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_scan_target_error_summary_collections and not isinstance(host_scan_target_error_summary_collections, list):
            raise TypeError("Expected argument 'host_scan_target_error_summary_collections' to be a list")
        pulumi.set(__self__, "host_scan_target_error_summary_collections", host_scan_target_error_summary_collections)
        if host_scan_target_id and not isinstance(host_scan_target_id, str):
            raise TypeError("Expected argument 'host_scan_target_id' to be a str")
        pulumi.set(__self__, "host_scan_target_id", host_scan_target_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHostScanTargetErrorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="hostScanTargetErrorSummaryCollections")
    def host_scan_target_error_summary_collections(self) -> Sequence['outputs.GetHostScanTargetErrorsHostScanTargetErrorSummaryCollectionResult']:
        """
        The list of host_scan_target_error_summary_collection.
        """
        return pulumi.get(self, "host_scan_target_error_summary_collections")

    @property
    @pulumi.getter(name="hostScanTargetId")
    def host_scan_target_id(self) -> str:
        return pulumi.get(self, "host_scan_target_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")


class AwaitableGetHostScanTargetErrorsResult(GetHostScanTargetErrorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostScanTargetErrorsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            host_scan_target_error_summary_collections=self.host_scan_target_error_summary_collections,
            host_scan_target_id=self.host_scan_target_id,
            id=self.id,
            state=self.state)


def get_host_scan_target_errors(compartment_id: Optional[str] = None,
                                filters: Optional[Sequence[pulumi.InputType['GetHostScanTargetErrorsFilterArgs']]] = None,
                                host_scan_target_id: Optional[str] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostScanTargetErrorsResult:
    """
    This data source provides the list of Host Scan Target Errors in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves list of errors during scanning on instances associated with HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_target_errors = oci.VulnerabilityScanning.get_host_scan_target_errors(compartment_id=compartment_id,
        host_scan_target_id=test_host_scan_target["id"],
        state=host_scan_target_error_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str host_scan_target_id: unique HostScanTarget identifier
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['hostScanTargetId'] = host_scan_target_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getHostScanTargetErrors:getHostScanTargetErrors', __args__, opts=opts, typ=GetHostScanTargetErrorsResult).value

    return AwaitableGetHostScanTargetErrorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        host_scan_target_error_summary_collections=pulumi.get(__ret__, 'host_scan_target_error_summary_collections'),
        host_scan_target_id=pulumi.get(__ret__, 'host_scan_target_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_host_scan_target_errors)
def get_host_scan_target_errors_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetHostScanTargetErrorsFilterArgs']]]]] = None,
                                       host_scan_target_id: Optional[pulumi.Input[str]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostScanTargetErrorsResult]:
    """
    This data source provides the list of Host Scan Target Errors in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves list of errors during scanning on instances associated with HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_target_errors = oci.VulnerabilityScanning.get_host_scan_target_errors(compartment_id=compartment_id,
        host_scan_target_id=test_host_scan_target["id"],
        state=host_scan_target_error_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str host_scan_target_id: unique HostScanTarget identifier
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    ...
