"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-lambda-1');
const vpc = new ec2.Vpc(stack, 'Vpc', {
    maxAzs: 3,
    natGateways: 1,
});
const fileSystem = new efs.FileSystem(stack, 'Efs', {
    vpc,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
// create an access point and expose the root of the filesystem
const accessPoint = fileSystem.addAccessPoint('AccessPoint', {
    createAcl: {
        ownerGid: '1001',
        ownerUid: '1001',
        permissions: '750',
    },
    path: '/export/lambda',
    posixUser: {
        gid: '1001',
        uid: '1001',
    },
});
// this function will mount the access point to '/mnt/msg' and write content onto /mnt/msg/content
new lambda.Function(stack, 'MyLambda', {
    code: new lambda.InlineCode(`
import json
import os
import string
import random
import datetime

MSG_FILE_PATH = '/mnt/msg/content'

def randomString(stringLength=10):
  letters = string.ascii_lowercase
  return ''.join(random.choice(letters) for i in range(stringLength))

def lambda_handler(event, context):
  with open(MSG_FILE_PATH, 'a') as f:
      f.write(f"{datetime.datetime.utcnow():%Y-%m-%d-%H:%M:%S} " + randomString(5) + ' ')

  file = open(MSG_FILE_PATH, "r")
  file_content = file.read()
  file.close()

  return {
    'statusCode': 200,
    'body': str(file_content)
  }
  `),
    handler: 'index.lambda_handler',
    runtime: lambda.Runtime.PYTHON_3_7,
    vpc,
    filesystem: lambda.FileSystem.fromEfsAccessPoint(accessPoint, '/mnt/msg'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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