"use strict";
const nodeunit_1 = require("nodeunit");
const lambda = require("../lib");
module.exports = nodeunit_1.testCase({
    'runtimes are equal for different instances'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'runtimes are equal for same instance'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime.runtimeEquals(runtime);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'unequal when name changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.6', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when name changes');
        test.done();
    },
    'unequal when family changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.JAVA, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when family changes');
        test.done();
    },
    'unequal when supportsInlineCode changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: false });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when supportsInlineCode changes');
        test.done();
    },
    'bundlingDockerImage points to AWS SAM build image'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('my-runtime-name');
        // THEN
        test.equal(runtime.bundlingDockerImage.image, 'amazon/aws-sam-cli-build-image-my-runtime-name');
        test.done();
    },
    'overridde to bundlingDockerImage points to the correct image'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('my-runtime-name', undefined, {
            bundlingDockerImage: 'my-docker-image',
        });
        // THEN
        test.equal(runtime.bundlingDockerImage.image, 'my-docker-image');
        test.done();
    },
    'dotnetcore and go have overridden images'(test) {
        test.equal(lambda.Runtime.DOTNET_CORE_3_1.bundlingDockerImage.image, 'lambci/lambda:build-dotnetcore3.1');
        test.equal(lambda.Runtime.DOTNET_CORE_2_1.bundlingDockerImage.image, 'lambci/lambda:build-dotnetcore2.1');
        test.equal(lambda.Runtime.GO_1_X.bundlingDockerImage.image, 'lambci/lambda:build-go1.x');
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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