
"""Open XML helpers for the HWPX document format."""

from __future__ import annotations

from .body import (
    Paragraph,
    Run,
    Section,
    TextSpan,
    parse_paragraph_element,
    parse_run_element,
    parse_section_element,
    parse_text_span,
)
from .common import GenericElement, parse_generic_element

from .document import (
    DocumentNumbering,
    HwpxOxmlDocument,
    HwpxOxmlHeader,
    HwpxOxmlInlineObject,
    HwpxOxmlMemo,
    HwpxOxmlMemoGroup,
    HwpxOxmlParagraph,
    HwpxOxmlRun,
    HwpxOxmlSection,
    HwpxOxmlSectionHeaderFooter,
    HwpxOxmlSectionProperties,
    HwpxOxmlTable,
    HwpxOxmlTableCell,
    HwpxOxmlTableRow,
    PageMargins,
    PageSize,
    RunStyle,
    SectionStartNumbering,
)

from .header import (
    BeginNum,
    BorderFillList,
    CharProperty,
    CharPropertyList,
    DocOption,
    Font,
    FontFace,
    FontFaceList,
    FontSubstitution,
    FontTypeInfo,
    ForbiddenWordList,
    Header,
    KeyDerivation,
    KeyEncryption,
    LinkInfo,
    LicenseMark,
    MemoProperties,
    MemoShape,
    NumberingList,
    RefList,
    TabProperties,
    TrackChangeConfig,
    memo_shape_from_attributes,
    parse_begin_num,
    parse_doc_option,
    parse_header_element,
    parse_memo_properties,
    parse_memo_shape,
    parse_ref_list,
)
from .parser import element_to_model, parse_header_xml, parse_section_xml
from .schema import load_schema
from .utils import XmlSource

__all__ = [
    "BeginNum",
    "BorderFillList",
    "CharProperty",
    "CharPropertyList",
    "DocOption",
    "Font",
    "FontFace",
    "FontFaceList",
    "FontSubstitution",
    "FontTypeInfo",
    "ForbiddenWordList",
    "GenericElement",
    "Header",
    "DocumentNumbering",
    "HwpxOxmlDocument",
    "HwpxOxmlHeader",
    "HwpxOxmlInlineObject",
    "HwpxOxmlMemo",
    "HwpxOxmlMemoGroup",
    "HwpxOxmlParagraph",
    "HwpxOxmlRun",
    "HwpxOxmlSection",
    "HwpxOxmlSectionHeaderFooter",
    "HwpxOxmlSectionProperties",
    "HwpxOxmlTable",
    "HwpxOxmlTableCell",
    "HwpxOxmlTableRow",
    "KeyDerivation",
    "KeyEncryption",
    "LinkInfo",
    "LicenseMark",
    "MemoProperties",
    "MemoShape",
    "NumberingList",
    "Paragraph",
    "PageMargins",
    "PageSize",
    "RunStyle",
    "memo_shape_from_attributes",
    "RefList",
    "Run",
    "Section",
    "SectionStartNumbering",
    "TabProperties",
    "TextSpan",
    "TrackChangeConfig",
    "XmlSource",
    "element_to_model",
    "load_schema",
    "parse_begin_num",
    "parse_doc_option",
    "parse_generic_element",
    "parse_header_element",
    "parse_memo_properties",
    "parse_memo_shape",
    "parse_header_xml",
    "parse_paragraph_element",
    "parse_ref_list",
    "parse_run_element",
    "parse_section_element",
    "parse_section_xml",
    "parse_text_span",
]

