"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handler = exports.TidyUp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const sfn = require("@aws-cdk/aws-stepfunctions");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
const cdk = require("@aws-cdk/core");
/**
 * The primary consruct to tidy up ECR public images.
 *
 * @stability stable
 */
class TidyUp extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        this.repository = props.repository;
        const start = new sfn.Pass(this, 'prepare repos', {
            result: sfn.Result.fromObject({
                inputForMap: props.repository,
            }),
        });
        const map = new sfn.Map(this, 'Map State', {
            maxConcurrency: props.repository.length,
            itemsPath: sfn.JsonPath.stringAt('$.inputForMap'),
            outputPath: sfn.JsonPath.stringAt('$'),
        });
        map.iterator(new tasks.LambdaInvoke(this, 'LambdaInvoke', {
            lambdaFunction: (_c = props.function) !== null && _c !== void 0 ? _c : this._addHandler().function,
            payload: sfn.TaskInput.fromObject({
                REPO: sfn.JsonPath.stringAt('$'),
            }),
        }));
        const definition = sfn.Chain.start(start)
            .next(map);
        const machine = new sfn.StateMachine(this, 'StateMachine', {
            definition,
        });
        // schedule it with event bridge
        new events.Rule(this, 'ScheduleRule', {
            schedule: (_d = props.schedule) !== null && _d !== void 0 ? _d : events.Schedule.cron({ hour: '*/4', minute: '0' }),
            targets: [new targets.SfnStateMachine(machine)],
        });
    }
    _addHandler() {
        return new Handler(this, 'TidyUpHandler', {
            repository: this.repository,
        });
    }
}
exports.TidyUp = TidyUp;
_a = JSII_RTTI_SYMBOL_1;
TidyUp[_a] = { fqn: "cdk-ecrpublic-gc.TidyUp", version: "0.1.22" };
/**
 * The default handler.
 *
 * @stability stable
 */
class Handler extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const fn = new aws_lambda_nodejs_1.NodejsFunction(this, 'Function', {
            entry: path.join(__dirname, '../lambda/main.ts'),
            handler: 'handler',
            timeout: cdk.Duration.seconds(60),
        });
        this.function = fn;
        fn.addToRolePolicy(new iam.PolicyStatement({
            actions: ['ecr-public:DescribeImages'],
            resources: ['*'],
        }));
        props.repository.forEach(r => {
            fn.addToRolePolicy(new iam.PolicyStatement({
                actions: ['ecr-public:BatchDeleteImage'],
                resources: [stack.formatArn({
                        service: 'ecr-public',
                        region: '',
                        resource: 'repository',
                        resourceName: r,
                    })],
            }));
        });
    }
}
exports.Handler = Handler;
_b = JSII_RTTI_SYMBOL_1;
Handler[_b] = { fqn: "cdk-ecrpublic-gc.Handler", version: "0.1.22" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDhDQUE4QztBQUM5Qyx1REFBdUQ7QUFDdkQsd0NBQXdDO0FBRXhDLGtFQUE0RDtBQUM1RCxrREFBa0Q7QUFDbEQsMERBQTBEO0FBQzFELHFDQUFxQzs7Ozs7O0FBYXJDLE1BQWEsTUFBTyxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBRXZDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBa0I7O1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBRW5DLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFO1lBQ2hELE1BQU0sRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQztnQkFDNUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxVQUFVO2FBQzlCLENBQUM7U0FDSCxDQUFDLENBQUM7UUFFSCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRTtZQUN6QyxjQUFjLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNO1lBQ3ZDLFNBQVMsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUM7WUFDakQsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQztTQUN2QyxDQUFDLENBQUM7UUFFSCxHQUFHLENBQUMsUUFBUSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3hELGNBQWMsUUFBRSxLQUFLLENBQUMsUUFBUSxtQ0FBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsUUFBUTtZQUM3RCxPQUFPLEVBQUUsR0FBRyxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUM7Z0JBQ2hDLElBQUksRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUM7YUFDakMsQ0FBQztTQUNILENBQUMsQ0FBQyxDQUFDO1FBRUosTUFBTSxVQUFVLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO2FBQ3RDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUViLE1BQU0sT0FBTyxHQUFHLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3pELFVBQVU7U0FDWCxDQUFDLENBQUM7UUFFSCxnQ0FBZ0M7UUFDaEMsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUU7WUFDcEMsUUFBUSxRQUFFLEtBQUssQ0FBQyxRQUFRLG1DQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDOUUsT0FBTyxFQUFFLENBQUMsSUFBSSxPQUFPLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQ2hELENBQUMsQ0FBQztJQUNMLENBQUM7SUFDTyxXQUFXO1FBQ2pCLE9BQU8sSUFBSSxPQUFPLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFBRTtZQUN4QyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDNUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUEzQ0gsd0JBNENDOzs7Ozs7OztBQVFELE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBRXhDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVqQyxNQUFNLEVBQUUsR0FBRyxJQUFJLGtDQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM5QyxLQUFLLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsbUJBQW1CLENBQUM7WUFDaEQsT0FBTyxFQUFFLFNBQVM7WUFDbEIsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztTQUNsQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsUUFBUSxHQUFHLEVBQUUsQ0FBQztRQUNuQixFQUFFLENBQUMsZUFBZSxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN6QyxPQUFPLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQztZQUN0QyxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUFDLENBQUM7UUFFSixLQUFLLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUMzQixFQUFFLENBQUMsZUFBZSxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDekMsT0FBTyxFQUFFLENBQUMsNkJBQTZCLENBQUM7Z0JBQ3hDLFNBQVMsRUFBRSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUM7d0JBQzFCLE9BQU8sRUFBRSxZQUFZO3dCQUNyQixNQUFNLEVBQUUsRUFBRTt3QkFDVixRQUFRLEVBQUUsWUFBWTt3QkFDdEIsWUFBWSxFQUFFLENBQUM7cUJBQ2hCLENBQUMsQ0FBQzthQUNKLENBQUMsQ0FBQyxDQUFDO1FBQ04sQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQTdCSCwwQkE4QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMnO1xuaW1wb3J0ICogYXMgdGFyZ2V0cyBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzLXRhcmdldHMnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgTm9kZWpzRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLW5vZGVqcyc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0ICogYXMgdGFza3MgZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMtdGFza3MnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVGlkeVVwUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmdW5jdGlvbj86IGxhbWJkYS5JRnVuY3Rpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNjaGVkdWxlPzogZXZlbnRzLlNjaGVkdWxlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVwb3NpdG9yeTogc3RyaW5nW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFRpZHlVcCBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICByZWFkb25seSByZXBvc2l0b3J5OiBzdHJpbmdbXTtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUaWR5VXBQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnJlcG9zaXRvcnkgPSBwcm9wcy5yZXBvc2l0b3J5O1xuXG4gICAgY29uc3Qgc3RhcnQgPSBuZXcgc2ZuLlBhc3ModGhpcywgJ3ByZXBhcmUgcmVwb3MnLCB7XG4gICAgICByZXN1bHQ6IHNmbi5SZXN1bHQuZnJvbU9iamVjdCh7XG4gICAgICAgIGlucHV0Rm9yTWFwOiBwcm9wcy5yZXBvc2l0b3J5LFxuICAgICAgfSksXG4gICAgfSk7XG5cbiAgICBjb25zdCBtYXAgPSBuZXcgc2ZuLk1hcCh0aGlzLCAnTWFwIFN0YXRlJywge1xuICAgICAgbWF4Q29uY3VycmVuY3k6IHByb3BzLnJlcG9zaXRvcnkubGVuZ3RoLFxuICAgICAgaXRlbXNQYXRoOiBzZm4uSnNvblBhdGguc3RyaW5nQXQoJyQuaW5wdXRGb3JNYXAnKSxcbiAgICAgIG91dHB1dFBhdGg6IHNmbi5Kc29uUGF0aC5zdHJpbmdBdCgnJCcpLFxuICAgIH0pO1xuXG4gICAgbWFwLml0ZXJhdG9yKG5ldyB0YXNrcy5MYW1iZGFJbnZva2UodGhpcywgJ0xhbWJkYUludm9rZScsIHtcbiAgICAgIGxhbWJkYUZ1bmN0aW9uOiBwcm9wcy5mdW5jdGlvbiA/PyB0aGlzLl9hZGRIYW5kbGVyKCkuZnVuY3Rpb24sXG4gICAgICBwYXlsb2FkOiBzZm4uVGFza0lucHV0LmZyb21PYmplY3Qoe1xuICAgICAgICBSRVBPOiBzZm4uSnNvblBhdGguc3RyaW5nQXQoJyQnKSxcbiAgICAgIH0pLFxuICAgIH0pKTtcblxuICAgIGNvbnN0IGRlZmluaXRpb24gPSBzZm4uQ2hhaW4uc3RhcnQoc3RhcnQpXG4gICAgICAubmV4dChtYXApO1xuXG4gICAgY29uc3QgbWFjaGluZSA9IG5ldyBzZm4uU3RhdGVNYWNoaW5lKHRoaXMsICdTdGF0ZU1hY2hpbmUnLCB7XG4gICAgICBkZWZpbml0aW9uLFxuICAgIH0pO1xuXG4gICAgLy8gc2NoZWR1bGUgaXQgd2l0aCBldmVudCBicmlkZ2VcbiAgICBuZXcgZXZlbnRzLlJ1bGUodGhpcywgJ1NjaGVkdWxlUnVsZScsIHtcbiAgICAgIHNjaGVkdWxlOiBwcm9wcy5zY2hlZHVsZSA/PyBldmVudHMuU2NoZWR1bGUuY3Jvbih7IGhvdXI6ICcqLzQnLCBtaW51dGU6ICcwJyB9KSxcbiAgICAgIHRhcmdldHM6IFtuZXcgdGFyZ2V0cy5TZm5TdGF0ZU1hY2hpbmUobWFjaGluZSldLFxuICAgIH0pO1xuICB9XG4gIHByaXZhdGUgX2FkZEhhbmRsZXIoKTogSGFuZGxlciB7XG4gICAgcmV0dXJuIG5ldyBIYW5kbGVyKHRoaXMsICdUaWR5VXBIYW5kbGVyJywge1xuICAgICAgcmVwb3NpdG9yeTogdGhpcy5yZXBvc2l0b3J5LFxuICAgIH0pO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSGFuZGxlclByb3BzIHtcbiAgcmVhZG9ubHkgcmVwb3NpdG9yeTogc3RyaW5nW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEhhbmRsZXIgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgcmVhZG9ubHkgZnVuY3Rpb246IGxhbWJkYS5JRnVuY3Rpb247XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSGFuZGxlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHN0YWNrID0gY2RrLlN0YWNrLm9mKHRoaXMpO1xuXG4gICAgY29uc3QgZm4gPSBuZXcgTm9kZWpzRnVuY3Rpb24odGhpcywgJ0Z1bmN0aW9uJywge1xuICAgICAgZW50cnk6IHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9sYW1iZGEvbWFpbi50cycpLFxuICAgICAgaGFuZGxlcjogJ2hhbmRsZXInLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgIH0pO1xuICAgIHRoaXMuZnVuY3Rpb24gPSBmbjtcbiAgICBmbi5hZGRUb1JvbGVQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydlY3ItcHVibGljOkRlc2NyaWJlSW1hZ2VzJ10sXG4gICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgIH0pKTtcblxuICAgIHByb3BzLnJlcG9zaXRvcnkuZm9yRWFjaChyID0+IHtcbiAgICAgIGZuLmFkZFRvUm9sZVBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGFjdGlvbnM6IFsnZWNyLXB1YmxpYzpCYXRjaERlbGV0ZUltYWdlJ10sXG4gICAgICAgIHJlc291cmNlczogW3N0YWNrLmZvcm1hdEFybih7XG4gICAgICAgICAgc2VydmljZTogJ2Vjci1wdWJsaWMnLFxuICAgICAgICAgIHJlZ2lvbjogJycsXG4gICAgICAgICAgcmVzb3VyY2U6ICdyZXBvc2l0b3J5JyxcbiAgICAgICAgICByZXNvdXJjZU5hbWU6IHIsXG4gICAgICAgIH0pXSxcbiAgICAgIH0pKTtcbiAgICB9KTtcbiAgfVxufVxuIl19