/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.CommonTableExpression;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCTEQuery<ThisType extends BaseCTEQuery<ThisType>>
extends Query<ThisType> {
    private boolean _recursive;
    private SqlObjectList<SqlObject> _ctes = SqlObjectList.create();
    private int _nextCteAliasNum;

    protected BaseCTEQuery() {
    }

    public ThisType setRecursive(boolean recursive) {
        this._recursive = recursive;
        return (ThisType)((BaseCTEQuery)this.getThisType());
    }

    public ThisType addCommonTableExpression(Object cteObj) {
        CommonTableExpression cte;
        if (cteObj instanceof CommonTableExpression && !(cte = (CommonTableExpression)cteObj).hasTableAlias()) {
            String alias = "cte" + this._nextCteAliasNum++;
            cte.setTableAlias(alias);
        }
        this._ctes.addObject(Converter.toCustomSqlObject(cteObj));
        return (ThisType)((BaseCTEQuery)this.getThisType());
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._ctes.collectSchemaObjects(vContext);
    }

    @Override
    protected void prependTo(AppendableExt app) throws IOException {
        if (!this._ctes.isEmpty()) {
            app.append("WITH ");
            if (this._recursive) {
                app.append("RECURSIVE ");
            }
            app.append(this._ctes).append(" ");
        }
    }
}

