/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.database.Database;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.dcd.DCDReasoner;
import org.linqs.psl.reasoner.dcd.term.DCDStreamingTermStore;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDStreamingInference
extends InferenceApplication {
    private static final Logger log = LoggerFactory.getLogger(DCDStreamingInference.class);

    public DCDStreamingInference(Model model, Database db) {
        super(model, db);
    }

    @Override
    protected Reasoner createReasoner() {
        return new DCDReasoner();
    }

    @Override
    protected TermStore createTermStore() {
        return new DCDStreamingTermStore(this.model.getRules(), this.atomManager);
    }

    @Override
    protected GroundRuleStore createGroundRuleStore() {
        return null;
    }

    @Override
    protected TermGenerator createTermGenerator() {
        return null;
    }

    @Override
    public void close() {
        this.termStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
    }
}

