/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.linqs.psl.application.ModelApplication;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.grounding.MemoryGroundRuleStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.admm.ADMMReasoner;
import org.linqs.psl.reasoner.admm.term.ADMMTermGenerator;
import org.linqs.psl.reasoner.admm.term.ADMMTermStore;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InferenceApplication
implements ModelApplication {
    private static final Logger log = LoggerFactory.getLogger(InferenceApplication.class);
    public static final String CONFIG_PREFIX = "inference";
    public static final String REASONER_KEY = "inference.reasoner";
    public static final String REASONER_DEFAULT = ADMMReasoner.class.getName();
    public static final String GROUND_RULE_STORE_KEY = "inference.groundrulestore";
    public static final String GROUND_RULE_STORE_DEFAULT = MemoryGroundRuleStore.class.getName();
    public static final String TERM_STORE_KEY = "inference.termstore";
    public static final String TERM_STORE_DEFAULT = ADMMTermStore.class.getName();
    public static final String TERM_GENERATOR_KEY = "inference.termgenerator";
    public static final String TERM_GENERATOR_DEFAULT = ADMMTermGenerator.class.getName();
    protected Model model;
    protected Database db;
    protected Reasoner reasoner;
    protected GroundRuleStore groundRuleStore;
    protected TermStore termStore;
    protected TermGenerator termGenerator;
    protected PersistedAtomManager atomManager;

    public InferenceApplication(Model model, Database db) {
        this.model = model;
        this.db = db;
        this.initialize();
    }

    protected void initialize() {
        log.debug("Creating persisted atom mannager.");
        this.atomManager = this.createAtomManager(this.db);
        log.debug("Atom manager initialization complete.");
        this.reasoner = this.createReasoner();
        this.termStore = this.createTermStore();
        this.groundRuleStore = this.createGroundRuleStore();
        this.termGenerator = this.createTermGenerator();
        this.termStore.ensureVariableCapacity(this.atomManager.getCachedRVACount());
        this.completeInitialize();
    }

    protected PersistedAtomManager createAtomManager(Database db) {
        return new PersistedAtomManager(db);
    }

    protected GroundRuleStore createGroundRuleStore() {
        return (GroundRuleStore)Config.getNewObject(GROUND_RULE_STORE_KEY, GROUND_RULE_STORE_DEFAULT);
    }

    protected Reasoner createReasoner() {
        return (Reasoner)Config.getNewObject(REASONER_KEY, REASONER_DEFAULT);
    }

    protected TermGenerator createTermGenerator() {
        return (TermGenerator)Config.getNewObject(TERM_GENERATOR_KEY, TERM_GENERATOR_DEFAULT);
    }

    protected TermStore createTermStore() {
        return (TermStore)Config.getNewObject(TERM_STORE_KEY, TERM_STORE_DEFAULT);
    }

    protected void completeInitialize() {
    }

    public void inference() {
        this.inference(true);
    }

    public void inference(boolean commitAtoms) {
        log.info("Beginning inference.");
        this.internalInference();
        log.info("Inference complete.");
        if (commitAtoms) {
            log.info("Writing results to Database.");
            this.atomManager.commitPersistedAtoms();
            log.info("Results committed to database.");
        }
    }

    protected void internalInference() {
        this.reasoner.optimize(this.termStore);
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public TermStore getTermStore() {
        return this.termStore;
    }

    public PersistedAtomManager getAtomManager() {
        return this.atomManager;
    }

    @Override
    public void close() {
        this.termStore.close();
        this.groundRuleStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.groundRuleStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
    }

    public static InferenceApplication getInferenceApplication(String className, Model model, Database db) {
        className = Reflection.resolveClassName(className);
        Class<?> classObject = null;
        try {
            Class<?> uncheckedClassObject;
            classObject = uncheckedClassObject = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class: " + className, ex);
        }
        Constructor<?> constructor = null;
        try {
            constructor = classObject.getConstructor(Model.class, Database.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No sutible constructor found for inference application: " + className + ".", ex);
        }
        InferenceApplication inferenceApplication = null;
        try {
            inferenceApplication = (InferenceApplication)constructor.newInstance(model, db);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate inference application (" + className + ")", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Insufficient access to constructor for " + className, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error thrown while constructing " + className, ex);
        }
        return inferenceApplication;
    }
}

