/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.maxlikelihood;

import java.util.List;
import org.linqs.psl.application.inference.LazyMPEInference;
import org.linqs.psl.application.learning.weight.VotedPerceptron;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.LazyAtomManager;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyMaxLikelihoodMPE
extends VotedPerceptron {
    private static final Logger log = LoggerFactory.getLogger(LazyMaxLikelihoodMPE.class);
    public static final String CONFIG_PREFIX = "lazymaxlikelihoodmpe";
    public static final String MAX_ROUNDS_KEY = "lazymaxlikelihoodmpe.maxgrowrounds";
    public static final int MAX_ROUNDS_DEFAULT = 100;
    private int maxRounds = Config.getInt("lazymaxlikelihoodmpe.maxgrowrounds", 100);

    public LazyMaxLikelihoodMPE(Model model, Database rvDB, Database observedDB) {
        this(model.getRules(), rvDB, observedDB);
    }

    public LazyMaxLikelihoodMPE(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB, false);
    }

    @Override
    protected void computeObservedIncompatibility() {
        LazyMPEInference.inference(this.allRules, this.reasoner, this.groundRuleStore, this.termStore, this.termGenerator, (LazyAtomManager)this.atomManager, this.maxRounds);
        super.computeObservedIncompatibility();
    }

    @Override
    protected PersistedAtomManager createAtomManager() {
        return new LazyAtomManager(this.rvDB);
    }
}

