/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.ListUtils;

public class FormulaAnalysis {
    private final Formula f;
    private final List<DNFClause> clauses;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormulaAnalysis(Formula formula) {
        Formula[] rawClauses;
        this.f = formula;
        formula = formula.getDNF();
        if (formula instanceof Disjunction) {
            Disjunction disj = (Disjunction)formula.flatten();
            rawClauses = new Formula[disj.length()];
            for (int i = 0; i < rawClauses.length; ++i) {
                rawClauses[i] = disj.get(i);
            }
        } else {
            rawClauses = new Formula[]{formula};
        }
        this.clauses = new ArrayList<DNFClause>(rawClauses.length);
        ArrayList<Atom> posLiterals = new ArrayList<Atom>(4);
        ArrayList<Atom> negLiterals = new ArrayList<Atom>(4);
        for (int i = 0; i < rawClauses.length; ++i) {
            if (rawClauses[i] instanceof Conjunction) {
                Conjunction c = (Conjunction)rawClauses[i].flatten();
                for (int j = 0; j < c.length(); ++j) {
                    if (c.get(j) instanceof Atom) {
                        posLiterals.add((Atom)c.get(j));
                        continue;
                    }
                    if (!(c.get(j) instanceof Negation)) throw new IllegalStateException("Unexpected sub-Formula. Formula was not in flattened Disjunctive Normal Form.");
                    Negation n = (Negation)c.get(j);
                    if (!(n.getFormula() instanceof Atom)) throw new IllegalStateException("Unexpected sub-Formula. Formula was not in flattened Disjunctive Normal Form.");
                    negLiterals.add((Atom)n.getFormula());
                }
            } else if (rawClauses[i] instanceof Atom) {
                posLiterals.add((Atom)rawClauses[i]);
            } else {
                if (!(rawClauses[i] instanceof Negation)) throw new IllegalStateException("Unexpected sub-Formula. Formula was not in flattened Disjunctive Normal Form.");
                Negation n = (Negation)rawClauses[i];
                if (!(n.getFormula() instanceof Atom)) throw new IllegalStateException("Unexpected sub-Formula. Formula was not in flattened Disjunctive Normal Form.");
                negLiterals.add((Atom)n.getFormula());
            }
            this.clauses.add(new DNFClause(posLiterals, negLiterals));
            posLiterals.clear();
            negLiterals.clear();
        }
    }

    public Formula getFormula() {
        return this.f;
    }

    public int getNumDNFClauses() {
        return this.clauses.size();
    }

    public DNFClause getDNFClause(int index) {
        return this.clauses.get(index);
    }

    public class DNFClause {
        private List<Atom> posLiterals;
        private List<Atom> negLiterals;
        private Formula query;
        private Set<Variable> unboundVariables;
        private boolean isGround;

        public DNFClause(List<Atom> posLiterals, List<Atom> negLiterals) {
            this.posLiterals = Collections.unmodifiableList(new ArrayList<Atom>(posLiterals));
            this.negLiterals = Collections.unmodifiableList(new ArrayList<Atom>(negLiterals));
            this.unboundVariables = new HashSet<Variable>();
            HashSet allowedVariables = new HashSet();
            for (Atom atom : posLiterals) {
                Set<Object> setToAdd = atom.getPredicate() instanceof StandardPredicate ? allowedVariables : this.unboundVariables;
                for (Term term : atom.getArguments()) {
                    if (!(term instanceof Variable)) continue;
                    setToAdd.add((Variable)term);
                }
            }
            for (Atom atom : negLiterals) {
                for (Term term : atom.getArguments()) {
                    if (!(term instanceof Variable)) continue;
                    this.unboundVariables.add((Variable)term);
                }
            }
            this.isGround = allowedVariables.size() + this.unboundVariables.size() == 0;
            this.unboundVariables.removeAll(allowedVariables);
            this.unboundVariables = Collections.unmodifiableSet(this.unboundVariables);
            this.query = posLiterals.size() == 0 ? null : (posLiterals.size() == 1 ? (this.unboundVariables.isEmpty() ? (Formula)posLiterals.get(0) : null) : (this.unboundVariables.isEmpty() ? new Conjunction(posLiterals.toArray(new Formula[posLiterals.size()])) : null));
        }

        public List<Atom> getPosLiterals() {
            return this.posLiterals;
        }

        public List<Atom> getNegLiterals() {
            return this.negLiterals;
        }

        public Set<Variable> getUnboundVariables() {
            return this.unboundVariables;
        }

        public boolean isGround() {
            return this.isGround;
        }

        public boolean isQueriable() {
            return this.query != null;
        }

        public Formula getQueryFormula() {
            if (this.query != null) {
                return this.query;
            }
            throw new IllegalStateException("Clause is not queriable.");
        }

        public String toString() {
            ArrayList<String> allLiterals = new ArrayList<String>();
            for (Atom posLit : this.getPosLiterals()) {
                allLiterals.add(posLit.toString());
            }
            for (Atom negLit : this.getNegLiterals()) {
                allLiterals.add("~" + negLit.toString());
            }
            return ListUtils.join(" & ", allLiterals);
        }
    }
}

