/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.expression.ArithmeticRuleExpression;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.MathUtils;

public class WeightedArithmeticRule
extends AbstractArithmeticRule
implements WeightedRule {
    protected double weight;
    protected boolean squared;

    public WeightedArithmeticRule(ArithmeticRuleExpression expression, double weight, boolean squared) {
        this(expression, weight, squared, expression.toString());
    }

    public WeightedArithmeticRule(ArithmeticRuleExpression expression, double weight, boolean squared, String name) {
        this(expression, new HashMap<SummationVariable, Formula>(), weight, squared, name);
    }

    public WeightedArithmeticRule(ArithmeticRuleExpression expression, Map<SummationVariable, Formula> filterClauses, double weight, boolean squared) {
        this(expression, filterClauses, weight, squared, expression.toString());
    }

    public WeightedArithmeticRule(ArithmeticRuleExpression expression, Map<SummationVariable, Formula> filterClauses, double weight, boolean squared, String name) {
        super(expression, filterClauses, name);
        this.weight = weight;
        this.squared = squared;
    }

    @Override
    protected AbstractGroundArithmeticRule makeGroundRule(float[] coeffs, GroundAtom[] atoms, FunctionComparator comparator, float constant) {
        return new WeightedGroundArithmeticRule(this, coeffs, atoms, comparator, constant);
    }

    @Override
    protected AbstractGroundArithmeticRule makeGroundRule(List<Float> coeffs, List<GroundAtom> atoms, FunctionComparator comparator, float constant) {
        return new WeightedGroundArithmeticRule(this, coeffs, atoms, comparator, constant);
    }

    @Override
    public boolean isSquared() {
        return this.squared;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.weight);
        s.append(": ");
        s.append(this.expression);
        s.append(this.squared ? " ^2" : "");
        for (Map.Entry e : this.filters.entrySet()) {
            s.append("   {");
            s.append(((SummationVariable)e.getKey()).getVariable());
            s.append(" : ");
            s.append(e.getValue());
            s.append("}");
        }
        return s.toString();
    }

    @Override
    public boolean isWeighted() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WeightedArithmeticRule otherRule = (WeightedArithmeticRule)other;
        if (this.squared != otherRule.squared || !MathUtils.equals(this.weight, otherRule.weight)) {
            return false;
        }
        return super.equals(other);
    }
}

