/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.linqs.psl.reasoner.sgd.term.SGDObjectiveTerm;
import org.linqs.psl.reasoner.sgd.term.SGDStreamingTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingCacheIterator;
import org.linqs.psl.util.RuntimeStats;

public class SGDStreamingCacheIterator
extends StreamingCacheIterator<SGDObjectiveTerm> {
    public SGDStreamingCacheIterator(SGDStreamingTermStore parentStore, boolean readonly, List<SGDObjectiveTerm> termCache, List<SGDObjectiveTerm> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, boolean shufflePage, int[] shuffleMap, boolean randomizePageAccess, int numPages) {
        super(parentStore, readonly, termCache, termPool, termBuffer, volatileBuffer, shufflePage, shuffleMap, randomizePageAccess, numPages);
    }

    @Override
    protected void readPage(String termPagePath, String volatilePagePath) {
        int termsSize = 0;
        int numTerms = 0;
        int headerSize = 8;
        try (FileInputStream termStream = new FileInputStream(termPagePath);){
            termStream.read(this.termBuffer.array(), 0, headerSize);
            termsSize = this.termBuffer.getInt();
            numTerms = this.termBuffer.getInt();
            termStream.read(this.termBuffer.array(), headerSize, termsSize);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to read cache page: [%s].", termPagePath), ex);
        }
        RuntimeStats.logDiskRead(headerSize + termsSize);
        for (int i = 0; i < numTerms; ++i) {
            SGDObjectiveTerm term = (SGDObjectiveTerm)this.termPool.get(i);
            term.read(this.termBuffer, this.volatileBuffer);
            this.termCache.add(term);
        }
    }

    @Override
    protected void writeVolatilePage(String volatilePagePath) {
    }
}

