/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtils {
    private IteratorUtils() {
    }

    public static <T, S> Iterable<S> filterClass(Iterable<T> baseIterable, Class<S> targetClass) {
        final Class<S> finalTargetClass = targetClass;
        Iterable<S> classMatch = IteratorUtils.map(baseIterable, new MapFunction<T, S>(){

            @Override
            public S map(T obj) {
                if (finalTargetClass.isInstance(obj)) {
                    Object ignoreException = obj;
                    return ignoreException;
                }
                return null;
            }
        });
        return IteratorUtils.filter(classMatch, new FilterFunction<S>(){

            @Override
            public boolean keep(S obj) {
                return obj != null;
            }
        });
    }

    public static <T, S> Iterable<S> map(Iterable<T> baseIterable, MapFunction<T, S> mapFunction) {
        return new MapIterable<T, S>(baseIterable, mapFunction);
    }

    public static <T> Iterable<T> filter(Iterable<T> baseIterable, FilterFunction<T> filter) {
        return new FilterIterable<T>(baseIterable, filter);
    }

    public static <T> Iterable<T> newIterable(Iterator<T> items) {
        final Iterator<T> finalItems = items;
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return finalItems;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> join(Iterable<? extends T> ... collections) {
        return new ConcatenationIterable<T>(collections);
    }

    public static Iterator<int[]> permutations(int size) {
        return new PermutationIterator(size);
    }

    public static Iterable<boolean[]> powerset(int size) {
        final int finalSize = size;
        return new Iterable<boolean[]>(){

            @Override
            public Iterator<boolean[]> iterator() {
                return new PowerSetIterator(finalSize);
            }
        };
    }

    private static class PermutationIterator
    implements Iterator<int[]> {
        private final int size;
        private int[] next = null;
        private int[] permutations;
        private int[] directions;

        public PermutationIterator(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("Permutation size must be at least 1.");
            }
            this.size = size;
            this.permutations = new int[size];
            this.directions = new int[size];
            for (int i = 0; i < size; ++i) {
                this.permutations[i] = i;
                this.directions[i] = -1;
            }
            this.directions[0] = 0;
            this.next = this.permutations;
        }

        @Override
        public int[] next() {
            int[] rtn = this.makeNext();
            this.next = null;
            return rtn;
        }

        @Override
        public boolean hasNext() {
            return this.makeNext() != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int[] makeNext() {
            if (this.next != null) {
                return this.next;
            }
            if (this.permutations == null) {
                return null;
            }
            int i = -1;
            int e = -1;
            for (int j = 0; j < this.size; ++j) {
                if (this.directions[j] == 0 || this.permutations[j] <= e) continue;
                e = this.permutations[j];
                i = j;
            }
            if (i == -1) {
                this.next = null;
                this.permutations = null;
                this.directions = null;
                return this.next;
            }
            int k = i + this.directions[i];
            PermutationIterator.swap(i, k, this.directions);
            PermutationIterator.swap(i, k, this.permutations);
            if (k == 0 || k == this.size - 1 || this.permutations[k + this.directions[k]] > e) {
                this.directions[k] = 0;
            }
            for (int j = 0; j < this.size; ++j) {
                if (this.permutations[j] <= e) continue;
                this.directions[j] = j < k ? 1 : -1;
            }
            this.next = this.permutations;
            return this.next;
        }

        private static void swap(int i, int j, int[] data) {
            int temp = data[i];
            data[i] = data[j];
            data[j] = temp;
        }
    }

    private static class PowerSetIterator
    implements Iterator<boolean[]> {
        private final int size;
        private long count;
        private boolean[] currentSubset;

        public PowerSetIterator(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("Power sets require a positive int size, found: " + size);
            }
            if (size > 63) {
                throw new IllegalArgumentException("Powersets on sets larger than 63 (a long) are not supported, found: " + size);
            }
            this.size = size;
            this.count = 0L;
            this.currentSubset = new boolean[size];
        }

        @Override
        public boolean[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long mask = 1L;
            for (int i = 0; i < this.size; ++i) {
                this.currentSubset[i] = (this.count & mask) != 0L;
                mask <<= 1;
            }
            ++this.count;
            return this.currentSubset;
        }

        @Override
        public boolean hasNext() {
            return this.count < (long)((int)Math.pow(2.0, this.size));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConcatenationIterator<T>
    implements Iterator<T> {
        private Iterable<? extends T>[] collections;
        private int collectionIndex;
        private Iterator<? extends T> currentIterator;

        public ConcatenationIterator(Iterable<? extends T>[] collections) {
            this.collections = collections;
            this.collectionIndex = -1;
            this.currentIterator = null;
            this.primeNext();
        }

        private void primeNext() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return;
            }
            ++this.collectionIndex;
            if (this.collectionIndex >= this.collections.length) {
                this.currentIterator = null;
                return;
            }
            this.currentIterator = this.collections[this.collectionIndex].iterator();
            this.primeNext();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Called next() when hasNext() == false.");
            }
            T rtn = this.currentIterator.next();
            this.primeNext();
            return rtn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConcatenationIterable<T>
    implements Iterable<T> {
        private Iterable<? extends T>[] collections;

        public ConcatenationIterable(Iterable<? extends T>[] collections) {
            this.collections = collections;
        }

        @Override
        public Iterator<T> iterator() {
            return new ConcatenationIterator<T>(this.collections);
        }
    }

    public static interface FilterFunction<T> {
        public boolean keep(T var1);
    }

    private static class FilterIterator<T>
    implements Iterator<T> {
        private Iterator<T> baseIterator;
        private FilterFunction<T> filter;
        private T nextValue;

        public FilterIterator(Iterable<T> baseIterable, FilterFunction<T> filter) {
            this.baseIterator = baseIterable.iterator();
            this.filter = filter;
            this.primeNext();
        }

        private void primeNext() {
            while (this.baseIterator.hasNext()) {
                this.nextValue = this.baseIterator.next();
                if (!this.filter.keep(this.nextValue)) continue;
                return;
            }
            this.nextValue = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Called next() when hasNext() == false.");
            }
            T rtn = this.nextValue;
            this.primeNext();
            return rtn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FilterIterable<T>
    implements Iterable<T> {
        private Iterable<T> baseIterable;
        private FilterFunction<T> filter;

        public FilterIterable(Iterable<T> baseIterable, FilterFunction<T> filter) {
            this.baseIterable = baseIterable;
            this.filter = filter;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.baseIterable, this.filter);
        }
    }

    public static interface MapFunction<T, S> {
        public S map(T var1);
    }

    private static class MapIterator<T, S>
    implements Iterator<S> {
        private Iterator<T> baseIterator;
        private MapFunction<T, S> mapFunction;
        private S nextValue;
        private boolean hasNextValue;

        public MapIterator(Iterable<T> baseIterable, MapFunction<T, S> mapFunction) {
            this.baseIterator = baseIterable.iterator();
            this.mapFunction = mapFunction;
            this.primeNext();
        }

        private void primeNext() {
            if (this.baseIterator.hasNext()) {
                this.nextValue = this.mapFunction.map(this.baseIterator.next());
                this.hasNextValue = true;
                return;
            }
            this.hasNextValue = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNextValue;
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Called next() when hasNext() == false.");
            }
            S rtn = this.nextValue;
            this.primeNext();
            return rtn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MapIterable<T, S>
    implements Iterable<S> {
        private Iterable<T> baseIterable;
        private MapFunction<T, S> mapFunction;

        public MapIterable(Iterable<T> baseIterable, MapFunction<T, S> mapFunction) {
            this.baseIterable = baseIterable;
            this.mapFunction = mapFunction;
        }

        @Override
        public Iterator<S> iterator() {
            return new MapIterator<T, S>(this.baseIterable, this.mapFunction);
        }
    }
}

