/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.List;

public final class ListUtils {
    private ListUtils() {
    }

    public static int[] toPrimitiveIntArray(List<? extends Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static long[] toPrimitiveLongArray(List<? extends Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static float[] toPrimitiveFloatArray(List<? extends Float> list) {
        float[] result = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).floatValue();
        }
        return result;
    }

    public static double[] toPrimitiveDoubleArray(List<? extends Double> list) {
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String join(char delim, List<? extends Object> parts) {
        return ListUtils.join("" + delim, parts);
    }

    public static String join(String delim, List<? extends Object> parts) {
        StringBuilder builder = new StringBuilder(parts.size() * 2 - 1);
        for (int i = 0; i < parts.size(); ++i) {
            builder.append(parts.get(i));
            if (i == parts.size() - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }
}

