"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMapping = void 0;
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !token_1.Token.isUnresolved(key2) && !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping,
            },
        };
    }
}
exports.CfnMapping = CfnMapping;
//# sourceMappingURL=data:application/json;base64,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