"use strict";
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const lib_1 = require("../lib");
const construct_compat_1 = require("../lib/construct-compat");
class MyConstruct extends construct_compat_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
class MyAspect {
    visit(node) {
        node.node.addMetadata('foo', 'bar');
    }
}
module.exports = {
    'Aspects are invoked only once'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        root.node.applyAspect(new VisitOnce());
        app.synth();
        test.deepEqual(root.visitCounter, 1);
        app.synth();
        test.deepEqual(root.visitCounter, 1);
        test.done();
    },
    'Warn if an Aspect is added via another Aspect'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        const child = new MyConstruct(root, 'ChildConstruct');
        root.node.applyAspect({
            visit(construct) {
                construct.node.applyAspect({
                    visit(inner) {
                        inner.node.addMetadata('test', 'would-be-ignored');
                    },
                });
            },
        });
        app.synth();
        test.deepEqual(root.node.metadata[0].type, cxschema.ArtifactMetadataEntryType.WARN);
        test.deepEqual(root.node.metadata[0].data, 'We detected an Aspect was added via another Aspect, and will not be applied');
        // warning is not added to child construct
        test.equal(child.node.metadata.length, 0);
        test.done();
    },
    'Do not warn if an Aspect is added directly (not by another aspect)'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'Construct');
        const child = new MyConstruct(root, 'ChildConstruct');
        root.node.applyAspect(new MyAspect());
        app.synth();
        test.deepEqual(root.node.metadata[0].type, 'foo');
        test.deepEqual(root.node.metadata[0].data, 'bar');
        test.deepEqual(root.node.metadata[0].type, 'foo');
        test.deepEqual(child.node.metadata[0].data, 'bar');
        // no warning is added
        test.equal(root.node.metadata.length, 1);
        test.equal(child.node.metadata.length, 1);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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