"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.restoreStackTraceColection = exports.reEnableStackTraceCollection = exports.toCloudFormation = void 0;
const synthesis_1 = require("../lib/private/synthesis");
function toCloudFormation(stack) {
    return synthesis_1.synthesize(stack, { skipValidation: true }).getStackByName(stack.stackName).template;
}
exports.toCloudFormation = toCloudFormation;
function reEnableStackTraceCollection() {
    const previousValue = process.env.CDK_DISABLE_STACK_TRACE;
    process.env.CDK_DISABLE_STACK_TRACE = '';
    return previousValue;
}
exports.reEnableStackTraceCollection = reEnableStackTraceCollection;
function restoreStackTraceColection(previousValue) {
    process.env.CDK_DISABLE_STACK_TRACE = previousValue;
}
exports.restoreStackTraceColection = restoreStackTraceColection;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esd0RBQXNEO0FBRXRELFNBQWdCLGdCQUFnQixDQUFDLEtBQVk7SUFDM0MsT0FBTyxzQkFBVSxDQUFDLEtBQUssRUFBRSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsUUFBUSxDQUFDO0FBQzlGLENBQUM7QUFGRCw0Q0FFQztBQUVELFNBQWdCLDRCQUE0QjtJQUMxQyxNQUFNLGFBQWEsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLHVCQUF1QixDQUFDO0lBQzFELE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEdBQUcsRUFBRSxDQUFDO0lBQ3pDLE9BQU8sYUFBYSxDQUFDO0FBQ3ZCLENBQUM7QUFKRCxvRUFJQztBQUVELFNBQWdCLDBCQUEwQixDQUFDLGFBQWtCO0lBQzNELE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEdBQUcsYUFBYSxDQUFDO0FBQ3RELENBQUM7QUFGRCxnRUFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IHN5bnRoZXNpemUgfSBmcm9tICcuLi9saWIvcHJpdmF0ZS9zeW50aGVzaXMnO1xuXG5leHBvcnQgZnVuY3Rpb24gdG9DbG91ZEZvcm1hdGlvbihzdGFjazogU3RhY2spOiBhbnkge1xuICByZXR1cm4gc3ludGhlc2l6ZShzdGFjaywgeyBza2lwVmFsaWRhdGlvbjogdHJ1ZSB9KS5nZXRTdGFja0J5TmFtZShzdGFjay5zdGFja05hbWUpLnRlbXBsYXRlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVFbmFibGVTdGFja1RyYWNlQ29sbGVjdGlvbigpOiBhbnkge1xuICBjb25zdCBwcmV2aW91c1ZhbHVlID0gcHJvY2Vzcy5lbnYuQ0RLX0RJU0FCTEVfU1RBQ0tfVFJBQ0U7XG4gIHByb2Nlc3MuZW52LkNES19ESVNBQkxFX1NUQUNLX1RSQUNFID0gJyc7XG4gIHJldHVybiBwcmV2aW91c1ZhbHVlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVzdG9yZVN0YWNrVHJhY2VDb2xlY3Rpb24ocHJldmlvdXNWYWx1ZTogYW55KTogdm9pZCB7XG4gIHByb2Nlc3MuZW52LkNES19ESVNBQkxFX1NUQUNLX1RSQUNFID0gcHJldmlvdXNWYWx1ZTtcbn1cbiJdfQ==