"""
Copyright CNRS/Inria/UniCA
Contributor(s): Eric Debreuve (eric.debreuve@cnrs.fr) since 2018
SEE COPYRIGHT NOTICE BELOW
"""

import configparser as cfpr
import typing as h
from datetime import datetime as date_time_t
from pathlib import Path as path_t

from conf_ini_g.api.storage import INIConfig
from conf_ini_g.api.untyped import config_h
from obj_mpp.config.app import MAX_HISTORY_LENGTH
from obj_mpp.constant.app import CONFIG_PATH


def LoadedConfig() -> tuple[config_h, h.Sequence[str] | None]:
    """"""
    if CONFIG_PATH.exists():
        config = INIConfig(CONFIG_PATH)

        history = config.get("history")
        if history is not None:
            if history.__len__() == 0:
                history = None
            else:
                history = sorted(history.values())
            del config["history"]
    else:
        with open(CONFIG_PATH, "w") as accessor:
            print("[history]", file=accessor)
        config = {}
        history = None

    return config, history


def AddINIPathToHistory(path: path_t | str, /) -> None:
    """"""
    if isinstance(path, path_t):
        path = str(path)

    config = INIConfig(CONFIG_PATH)

    if (history := config.get("history")) is None:
        history = {}
    else:
        if path in history.values():
            return
        if history.__len__() >= MAX_HISTORY_LENGTH:
            oldest = min(history.keys())
            del history[oldest]
    history[str(date_time_t.now())] = path

    config["history"] = history
    parser = cfpr.ConfigParser()
    for key, value in config.items():
        parser[key] = value
    with open(CONFIG_PATH, "w") as accessor:
        parser.write(accessor)


"""
COPYRIGHT NOTICE

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

SEE LICENCE NOTICE: file README-LICENCE-utf8.txt at project source root.

This software is being developed by Eric Debreuve, a CNRS employee and
member of team Morpheme.
Team Morpheme is a joint team between Inria, CNRS, and UniCA.
It is hosted by the Centre Inria d'Université Côte d'Azur, Laboratory
I3S, and Laboratory iBV.

CNRS: https://www.cnrs.fr/index.php/en
Inria: https://www.inria.fr/en/
UniCA: https://univ-cotedazur.eu/
Centre Inria d'Université Côte d'Azur: https://www.inria.fr/en/centre/sophia/
I3S: https://www.i3s.unice.fr/en/
iBV: http://ibv.unice.fr/
Team Morpheme: https://team.inria.fr/morpheme/
"""
