# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppProbeClassPolicyObjectArgs', 'AppProbeClassPolicyObject']

@pulumi.input_type
class AppProbeClassPolicyObjectArgs:
    def __init__(__self__, *,
                 forwarding_class: pulumi.Input[builtins.str],
                 mappings: pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppProbeClassPolicyObject resource.
        :param pulumi.Input[builtins.str] forwarding_class: Forwarding class name
        :param pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]] mappings: Color mappings
        :param pulumi.Input[builtins.str] name: The name of the policy object
        """
        pulumi.set(__self__, "forwarding_class", forwarding_class)
        pulumi.set(__self__, "mappings", mappings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="forwardingClass")
    def forwarding_class(self) -> pulumi.Input[builtins.str]:
        """
        Forwarding class name
        """
        return pulumi.get(self, "forwarding_class")

    @forwarding_class.setter
    def forwarding_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "forwarding_class", value)

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]]:
        """
        Color mappings
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AppProbeClassPolicyObjectState:
    def __init__(__self__, *,
                 forwarding_class: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering AppProbeClassPolicyObject resources.
        :param pulumi.Input[builtins.str] forwarding_class: Forwarding class name
        :param pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]] mappings: Color mappings
        :param pulumi.Input[builtins.str] name: The name of the policy object
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if forwarding_class is not None:
            pulumi.set(__self__, "forwarding_class", forwarding_class)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="forwardingClass")
    def forwarding_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Forwarding class name
        """
        return pulumi.get(self, "forwarding_class")

    @forwarding_class.setter
    def forwarding_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forwarding_class", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]]]:
        """
        Color mappings
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppProbeClassPolicyObjectMappingArgs']]]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class AppProbeClassPolicyObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forwarding_class: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppProbeClassPolicyObjectMappingArgs', 'AppProbeClassPolicyObjectMappingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a App Probe Class Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.AppProbeClassPolicyObject("example",
            name="Example",
            forwarding_class="FC1",
            mappings=[{
                "color": "blue",
                "dscp": 8,
            }])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/appProbeClassPolicyObject:AppProbeClassPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] forwarding_class: Forwarding class name
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppProbeClassPolicyObjectMappingArgs', 'AppProbeClassPolicyObjectMappingArgsDict']]]] mappings: Color mappings
        :param pulumi.Input[builtins.str] name: The name of the policy object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppProbeClassPolicyObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a App Probe Class Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.AppProbeClassPolicyObject("example",
            name="Example",
            forwarding_class="FC1",
            mappings=[{
                "color": "blue",
                "dscp": 8,
            }])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/appProbeClassPolicyObject:AppProbeClassPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param AppProbeClassPolicyObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppProbeClassPolicyObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forwarding_class: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppProbeClassPolicyObjectMappingArgs', 'AppProbeClassPolicyObjectMappingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppProbeClassPolicyObjectArgs.__new__(AppProbeClassPolicyObjectArgs)

            if forwarding_class is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_class'")
            __props__.__dict__["forwarding_class"] = forwarding_class
            if mappings is None and not opts.urn:
                raise TypeError("Missing required property 'mappings'")
            __props__.__dict__["mappings"] = mappings
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(AppProbeClassPolicyObject, __self__).__init__(
            'sdwan:index/appProbeClassPolicyObject:AppProbeClassPolicyObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            forwarding_class: Optional[pulumi.Input[builtins.str]] = None,
            mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppProbeClassPolicyObjectMappingArgs', 'AppProbeClassPolicyObjectMappingArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'AppProbeClassPolicyObject':
        """
        Get an existing AppProbeClassPolicyObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] forwarding_class: Forwarding class name
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppProbeClassPolicyObjectMappingArgs', 'AppProbeClassPolicyObjectMappingArgsDict']]]] mappings: Color mappings
        :param pulumi.Input[builtins.str] name: The name of the policy object
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppProbeClassPolicyObjectState.__new__(_AppProbeClassPolicyObjectState)

        __props__.__dict__["forwarding_class"] = forwarding_class
        __props__.__dict__["mappings"] = mappings
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return AppProbeClassPolicyObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="forwardingClass")
    def forwarding_class(self) -> pulumi.Output[builtins.str]:
        """
        Forwarding class name
        """
        return pulumi.get(self, "forwarding_class")

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Output[Sequence['outputs.AppProbeClassPolicyObjectMapping']]:
        """
        Color mappings
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

