# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CflowdPolicyDefinitionArgs', 'CflowdPolicyDefinition']

@pulumi.input_type
class CflowdPolicyDefinitionArgs:
    def __init__(__self__, *,
                 collectors: pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]],
                 description: pulumi.Input[builtins.str],
                 active_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 flow_refresh: Optional[pulumi.Input[builtins.int]] = None,
                 inactive_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 remarked_dscp: Optional[pulumi.Input[builtins.bool]] = None,
                 sampling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 tos: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a CflowdPolicyDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]] collectors: List of collectors
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.int] active_flow_timeout: Active flow timeout in seconds - Range: `30`-`3600`
        :param pulumi.Input[builtins.int] flow_refresh: Flow refresh in seconds - Range: `60`-`86400`
        :param pulumi.Input[builtins.int] inactive_flow_timeout: Inactive flow timeout in seconds - Range: `1`-`3600`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[builtins.str] protocol: Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        :param pulumi.Input[builtins.bool] remarked_dscp: Collect remarked DSCP
        :param pulumi.Input[builtins.int] sampling_interval: Flow sampling interval - Range: `1`-`65536`
        :param pulumi.Input[builtins.bool] tos: Collect TOS record field
        """
        pulumi.set(__self__, "collectors", collectors)
        pulumi.set(__self__, "description", description)
        if active_flow_timeout is not None:
            pulumi.set(__self__, "active_flow_timeout", active_flow_timeout)
        if flow_refresh is not None:
            pulumi.set(__self__, "flow_refresh", flow_refresh)
        if inactive_flow_timeout is not None:
            pulumi.set(__self__, "inactive_flow_timeout", inactive_flow_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remarked_dscp is not None:
            pulumi.set(__self__, "remarked_dscp", remarked_dscp)
        if sampling_interval is not None:
            pulumi.set(__self__, "sampling_interval", sampling_interval)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @property
    @pulumi.getter
    def collectors(self) -> pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]]:
        """
        List of collectors
        """
        return pulumi.get(self, "collectors")

    @collectors.setter
    def collectors(self, value: pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]]):
        pulumi.set(self, "collectors", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="activeFlowTimeout")
    def active_flow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Active flow timeout in seconds - Range: `30`-`3600`
        """
        return pulumi.get(self, "active_flow_timeout")

    @active_flow_timeout.setter
    def active_flow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "active_flow_timeout", value)

    @property
    @pulumi.getter(name="flowRefresh")
    def flow_refresh(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Flow refresh in seconds - Range: `60`-`86400`
        """
        return pulumi.get(self, "flow_refresh")

    @flow_refresh.setter
    def flow_refresh(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "flow_refresh", value)

    @property
    @pulumi.getter(name="inactiveFlowTimeout")
    def inactive_flow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Inactive flow timeout in seconds - Range: `1`-`3600`
        """
        return pulumi.get(self, "inactive_flow_timeout")

    @inactive_flow_timeout.setter
    def inactive_flow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "inactive_flow_timeout", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="remarkedDscp")
    def remarked_dscp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Collect remarked DSCP
        """
        return pulumi.get(self, "remarked_dscp")

    @remarked_dscp.setter
    def remarked_dscp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remarked_dscp", value)

    @property
    @pulumi.getter(name="samplingInterval")
    def sampling_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Flow sampling interval - Range: `1`-`65536`
        """
        return pulumi.get(self, "sampling_interval")

    @sampling_interval.setter
    def sampling_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_interval", value)

    @property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Collect TOS record field
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tos", value)


@pulumi.input_type
class _CflowdPolicyDefinitionState:
    def __init__(__self__, *,
                 active_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 collectors: Optional[pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flow_refresh: Optional[pulumi.Input[builtins.int]] = None,
                 inactive_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 remarked_dscp: Optional[pulumi.Input[builtins.bool]] = None,
                 sampling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 tos: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CflowdPolicyDefinition resources.
        :param pulumi.Input[builtins.int] active_flow_timeout: Active flow timeout in seconds - Range: `30`-`3600`
        :param pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]] collectors: List of collectors
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.int] flow_refresh: Flow refresh in seconds - Range: `60`-`86400`
        :param pulumi.Input[builtins.int] inactive_flow_timeout: Inactive flow timeout in seconds - Range: `1`-`3600`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[builtins.str] protocol: Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        :param pulumi.Input[builtins.bool] remarked_dscp: Collect remarked DSCP
        :param pulumi.Input[builtins.int] sampling_interval: Flow sampling interval - Range: `1`-`65536`
        :param pulumi.Input[builtins.bool] tos: Collect TOS record field
        :param pulumi.Input[builtins.str] type: Type
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if active_flow_timeout is not None:
            pulumi.set(__self__, "active_flow_timeout", active_flow_timeout)
        if collectors is not None:
            pulumi.set(__self__, "collectors", collectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_refresh is not None:
            pulumi.set(__self__, "flow_refresh", flow_refresh)
        if inactive_flow_timeout is not None:
            pulumi.set(__self__, "inactive_flow_timeout", inactive_flow_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remarked_dscp is not None:
            pulumi.set(__self__, "remarked_dscp", remarked_dscp)
        if sampling_interval is not None:
            pulumi.set(__self__, "sampling_interval", sampling_interval)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activeFlowTimeout")
    def active_flow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Active flow timeout in seconds - Range: `30`-`3600`
        """
        return pulumi.get(self, "active_flow_timeout")

    @active_flow_timeout.setter
    def active_flow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "active_flow_timeout", value)

    @property
    @pulumi.getter
    def collectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]]]:
        """
        List of collectors
        """
        return pulumi.get(self, "collectors")

    @collectors.setter
    def collectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CflowdPolicyDefinitionCollectorArgs']]]]):
        pulumi.set(self, "collectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flowRefresh")
    def flow_refresh(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Flow refresh in seconds - Range: `60`-`86400`
        """
        return pulumi.get(self, "flow_refresh")

    @flow_refresh.setter
    def flow_refresh(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "flow_refresh", value)

    @property
    @pulumi.getter(name="inactiveFlowTimeout")
    def inactive_flow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Inactive flow timeout in seconds - Range: `1`-`3600`
        """
        return pulumi.get(self, "inactive_flow_timeout")

    @inactive_flow_timeout.setter
    def inactive_flow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "inactive_flow_timeout", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="remarkedDscp")
    def remarked_dscp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Collect remarked DSCP
        """
        return pulumi.get(self, "remarked_dscp")

    @remarked_dscp.setter
    def remarked_dscp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remarked_dscp", value)

    @property
    @pulumi.getter(name="samplingInterval")
    def sampling_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Flow sampling interval - Range: `1`-`65536`
        """
        return pulumi.get(self, "sampling_interval")

    @sampling_interval.setter
    def sampling_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_interval", value)

    @property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Collect TOS record field
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tos", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class CflowdPolicyDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CflowdPolicyDefinitionCollectorArgs', 'CflowdPolicyDefinitionCollectorArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flow_refresh: Optional[pulumi.Input[builtins.int]] = None,
                 inactive_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 remarked_dscp: Optional[pulumi.Input[builtins.bool]] = None,
                 sampling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 tos: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a Cflowd Policy Definition .

        ## Import

        ```sh
        $ pulumi import sdwan:index/cflowdPolicyDefinition:CflowdPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] active_flow_timeout: Active flow timeout in seconds - Range: `30`-`3600`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CflowdPolicyDefinitionCollectorArgs', 'CflowdPolicyDefinitionCollectorArgsDict']]]] collectors: List of collectors
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.int] flow_refresh: Flow refresh in seconds - Range: `60`-`86400`
        :param pulumi.Input[builtins.int] inactive_flow_timeout: Inactive flow timeout in seconds - Range: `1`-`3600`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[builtins.str] protocol: Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        :param pulumi.Input[builtins.bool] remarked_dscp: Collect remarked DSCP
        :param pulumi.Input[builtins.int] sampling_interval: Flow sampling interval - Range: `1`-`65536`
        :param pulumi.Input[builtins.bool] tos: Collect TOS record field
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CflowdPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cflowd Policy Definition .

        ## Import

        ```sh
        $ pulumi import sdwan:index/cflowdPolicyDefinition:CflowdPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CflowdPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CflowdPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CflowdPolicyDefinitionCollectorArgs', 'CflowdPolicyDefinitionCollectorArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flow_refresh: Optional[pulumi.Input[builtins.int]] = None,
                 inactive_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 remarked_dscp: Optional[pulumi.Input[builtins.bool]] = None,
                 sampling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 tos: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CflowdPolicyDefinitionArgs.__new__(CflowdPolicyDefinitionArgs)

            __props__.__dict__["active_flow_timeout"] = active_flow_timeout
            if collectors is None and not opts.urn:
                raise TypeError("Missing required property 'collectors'")
            __props__.__dict__["collectors"] = collectors
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["flow_refresh"] = flow_refresh
            __props__.__dict__["inactive_flow_timeout"] = inactive_flow_timeout
            __props__.__dict__["name"] = name
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["remarked_dscp"] = remarked_dscp
            __props__.__dict__["sampling_interval"] = sampling_interval
            __props__.__dict__["tos"] = tos
            __props__.__dict__["type"] = None
            __props__.__dict__["version"] = None
        super(CflowdPolicyDefinition, __self__).__init__(
            'sdwan:index/cflowdPolicyDefinition:CflowdPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
            collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CflowdPolicyDefinitionCollectorArgs', 'CflowdPolicyDefinitionCollectorArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            flow_refresh: Optional[pulumi.Input[builtins.int]] = None,
            inactive_flow_timeout: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            remarked_dscp: Optional[pulumi.Input[builtins.bool]] = None,
            sampling_interval: Optional[pulumi.Input[builtins.int]] = None,
            tos: Optional[pulumi.Input[builtins.bool]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CflowdPolicyDefinition':
        """
        Get an existing CflowdPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] active_flow_timeout: Active flow timeout in seconds - Range: `30`-`3600`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CflowdPolicyDefinitionCollectorArgs', 'CflowdPolicyDefinitionCollectorArgsDict']]]] collectors: List of collectors
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.int] flow_refresh: Flow refresh in seconds - Range: `60`-`86400`
        :param pulumi.Input[builtins.int] inactive_flow_timeout: Inactive flow timeout in seconds - Range: `1`-`3600`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[builtins.str] protocol: Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        :param pulumi.Input[builtins.bool] remarked_dscp: Collect remarked DSCP
        :param pulumi.Input[builtins.int] sampling_interval: Flow sampling interval - Range: `1`-`65536`
        :param pulumi.Input[builtins.bool] tos: Collect TOS record field
        :param pulumi.Input[builtins.str] type: Type
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CflowdPolicyDefinitionState.__new__(_CflowdPolicyDefinitionState)

        __props__.__dict__["active_flow_timeout"] = active_flow_timeout
        __props__.__dict__["collectors"] = collectors
        __props__.__dict__["description"] = description
        __props__.__dict__["flow_refresh"] = flow_refresh
        __props__.__dict__["inactive_flow_timeout"] = inactive_flow_timeout
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["remarked_dscp"] = remarked_dscp
        __props__.__dict__["sampling_interval"] = sampling_interval
        __props__.__dict__["tos"] = tos
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return CflowdPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeFlowTimeout")
    def active_flow_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Active flow timeout in seconds - Range: `30`-`3600`
        """
        return pulumi.get(self, "active_flow_timeout")

    @property
    @pulumi.getter
    def collectors(self) -> pulumi.Output[Sequence['outputs.CflowdPolicyDefinitionCollector']]:
        """
        List of collectors
        """
        return pulumi.get(self, "collectors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowRefresh")
    def flow_refresh(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Flow refresh in seconds - Range: `60`-`86400`
        """
        return pulumi.get(self, "flow_refresh")

    @property
    @pulumi.getter(name="inactiveFlowTimeout")
    def inactive_flow_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Inactive flow timeout in seconds - Range: `1`-`3600`
        """
        return pulumi.get(self, "inactive_flow_timeout")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Protocol, either `ipv4`, `ipv6` or `all` - Choices: `ipv4`, `ipv6`, `all`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remarkedDscp")
    def remarked_dscp(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Collect remarked DSCP
        """
        return pulumi.get(self, "remarked_dscp")

    @property
    @pulumi.getter(name="samplingInterval")
    def sampling_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Flow sampling interval - Range: `1`-`65536`
        """
        return pulumi.get(self, "sampling_interval")

    @property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Collect TOS record field
        """
        return pulumi.get(self, "tos")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

