# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoSnmpFeatureTemplateArgs', 'CiscoSnmpFeatureTemplate']

@pulumi.input_type
class CiscoSnmpFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]] = None,
                 contact: Optional[pulumi.Input[builtins.str]] = None,
                 contact_variable: Optional[pulumi.Input[builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 location_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]] = None):
        """
        The set of arguments for constructing a CiscoSnmpFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]] trap_targets: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]] users: Configure an SNMP user
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]] views: Configure a view record
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if communities is not None:
            pulumi.set(__self__, "communities", communities)
        if contact is not None:
            pulumi.set(__self__, "contact", contact)
        if contact_variable is not None:
            pulumi.set(__self__, "contact_variable", contact_variable)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_variable is not None:
            pulumi.set(__self__, "location_variable", location_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if trap_targets is not None:
            pulumi.set(__self__, "trap_targets", trap_targets)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if views is not None:
            pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def communities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter
    def contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact")

    @contact.setter
    def contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact", value)

    @property
    @pulumi.getter(name="contactVariable")
    def contact_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_variable")

    @contact_variable.setter
    def contact_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_variable", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @location_variable.setter
    def location_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="trapTargets")
    def trap_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_targets")

    @trap_targets.setter
    def trap_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]]):
        pulumi.set(self, "trap_targets", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]]):
        pulumi.set(self, "views", value)


@pulumi.input_type
class _CiscoSnmpFeatureTemplateState:
    def __init__(__self__, *,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]] = None,
                 contact: Optional[pulumi.Input[builtins.str]] = None,
                 contact_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 location_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 trap_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]] = None):
        """
        Input properties used for looking up and filtering CiscoSnmpFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]] trap_targets: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]] users: Configure an SNMP user
        :param pulumi.Input[builtins.int] version: The version of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]] views: Configure a view record
        """
        if communities is not None:
            pulumi.set(__self__, "communities", communities)
        if contact is not None:
            pulumi.set(__self__, "contact", contact)
        if contact_variable is not None:
            pulumi.set(__self__, "contact_variable", contact_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_variable is not None:
            pulumi.set(__self__, "location_variable", location_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if trap_targets is not None:
            pulumi.set(__self__, "trap_targets", trap_targets)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if views is not None:
            pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def communities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateCommunityArgs']]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter
    def contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact")

    @contact.setter
    def contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact", value)

    @property
    @pulumi.getter(name="contactVariable")
    def contact_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_variable")

    @contact_variable.setter
    def contact_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @location_variable.setter
    def location_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="trapTargets")
    def trap_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_targets")

    @trap_targets.setter
    def trap_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateTrapTargetArgs']]]]):
        pulumi.set(self, "trap_targets", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSnmpFeatureTemplateViewArgs']]]]):
        pulumi.set(self, "views", value)


class CiscoSnmpFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateCommunityArgs', 'CiscoSnmpFeatureTemplateCommunityArgsDict']]]]] = None,
                 contact: Optional[pulumi.Input[builtins.str]] = None,
                 contact_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateGroupArgs', 'CiscoSnmpFeatureTemplateGroupArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 location_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateTrapTargetArgs', 'CiscoSnmpFeatureTemplateTrapTargetArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateUserArgs', 'CiscoSnmpFeatureTemplateUserArgsDict']]]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateViewArgs', 'CiscoSnmpFeatureTemplateViewArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco SNMP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoSnmpFeatureTemplate:CiscoSnmpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateCommunityArgs', 'CiscoSnmpFeatureTemplateCommunityArgsDict']]]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateGroupArgs', 'CiscoSnmpFeatureTemplateGroupArgsDict']]]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateTrapTargetArgs', 'CiscoSnmpFeatureTemplateTrapTargetArgsDict']]]] trap_targets: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateUserArgs', 'CiscoSnmpFeatureTemplateUserArgsDict']]]] users: Configure an SNMP user
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateViewArgs', 'CiscoSnmpFeatureTemplateViewArgsDict']]]] views: Configure a view record
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoSnmpFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco SNMP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoSnmpFeatureTemplate:CiscoSnmpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoSnmpFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoSnmpFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateCommunityArgs', 'CiscoSnmpFeatureTemplateCommunityArgsDict']]]]] = None,
                 contact: Optional[pulumi.Input[builtins.str]] = None,
                 contact_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateGroupArgs', 'CiscoSnmpFeatureTemplateGroupArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 location_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateTrapTargetArgs', 'CiscoSnmpFeatureTemplateTrapTargetArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateUserArgs', 'CiscoSnmpFeatureTemplateUserArgsDict']]]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateViewArgs', 'CiscoSnmpFeatureTemplateViewArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoSnmpFeatureTemplateArgs.__new__(CiscoSnmpFeatureTemplateArgs)

            __props__.__dict__["communities"] = communities
            __props__.__dict__["contact"] = contact
            __props__.__dict__["contact_variable"] = contact_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["groups"] = groups
            __props__.__dict__["location"] = location
            __props__.__dict__["location_variable"] = location_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["trap_targets"] = trap_targets
            __props__.__dict__["users"] = users
            __props__.__dict__["views"] = views
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoSnmpFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoSnmpFeatureTemplate:CiscoSnmpFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateCommunityArgs', 'CiscoSnmpFeatureTemplateCommunityArgsDict']]]]] = None,
            contact: Optional[pulumi.Input[builtins.str]] = None,
            contact_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateGroupArgs', 'CiscoSnmpFeatureTemplateGroupArgsDict']]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            location_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            trap_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateTrapTargetArgs', 'CiscoSnmpFeatureTemplateTrapTargetArgsDict']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateUserArgs', 'CiscoSnmpFeatureTemplateUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateViewArgs', 'CiscoSnmpFeatureTemplateViewArgsDict']]]]] = None) -> 'CiscoSnmpFeatureTemplate':
        """
        Get an existing CiscoSnmpFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateCommunityArgs', 'CiscoSnmpFeatureTemplateCommunityArgsDict']]]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateGroupArgs', 'CiscoSnmpFeatureTemplateGroupArgsDict']]]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateTrapTargetArgs', 'CiscoSnmpFeatureTemplateTrapTargetArgsDict']]]] trap_targets: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateUserArgs', 'CiscoSnmpFeatureTemplateUserArgsDict']]]] users: Configure an SNMP user
        :param pulumi.Input[builtins.int] version: The version of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSnmpFeatureTemplateViewArgs', 'CiscoSnmpFeatureTemplateViewArgsDict']]]] views: Configure a view record
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoSnmpFeatureTemplateState.__new__(_CiscoSnmpFeatureTemplateState)

        __props__.__dict__["communities"] = communities
        __props__.__dict__["contact"] = contact
        __props__.__dict__["contact_variable"] = contact_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["groups"] = groups
        __props__.__dict__["location"] = location
        __props__.__dict__["location_variable"] = location_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["trap_targets"] = trap_targets
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        __props__.__dict__["views"] = views
        return CiscoSnmpFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def communities(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSnmpFeatureTemplateCommunity']]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter
    def contact(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact")

    @property
    @pulumi.getter(name="contactVariable")
    def contact_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSnmpFeatureTemplateGroup']]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trapTargets")
    def trap_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSnmpFeatureTemplateTrapTarget']]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_targets")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSnmpFeatureTemplateUser']]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def views(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSnmpFeatureTemplateView']]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

