# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CiscoVpnInterfaceIpsecFeatureTemplateArgs', 'CiscoVpnInterfaceIpsecFeatureTemplate']

@pulumi.input_type
class CiscoVpnInterfaceIpsecFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 application_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_interval: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_retries: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_retries_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ike_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ike_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[builtins.int]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoVpnInterfaceIpsecFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[builtins.str] application_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_interval: IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        :param pulumi.Input[builtins.str] dead_peer_detection_interval_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_retries: IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        :param pulumi.Input[builtins.str] dead_peer_detection_retries_variable: Variable name
        :param pulumi.Input[builtins.str] ike_ciphersuite: IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
               `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        :param pulumi.Input[builtins.str] ike_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ike_group: IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        :param pulumi.Input[builtins.str] ike_group_variable: Variable name
        :param pulumi.Input[builtins.str] ike_mode: IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        :param pulumi.Input[builtins.str] ike_mode_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key: Use preshared key to authenticate IKE peer
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id: IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id: IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_variable: Variable name
        :param pulumi.Input[builtins.int] ike_rekey_interval: IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        :param pulumi.Input[builtins.str] ike_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ike_version: IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: IPsec when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Assign IPv4 address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_ciphersuite: IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
               `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
               `aes256-gcm`
        :param pulumi.Input[builtins.str] ipsec_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy: IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
               `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_rekey_interval: IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        :param pulumi.Input[builtins.str] ipsec_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_replay_window: Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        :param pulumi.Input[builtins.str] ipsec_replay_window_variable: Variable name
        :param pulumi.Input[builtins.int] mtu: Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] mtu_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[builtins.str] tunnel_destination: Tunnel destination IP address
        :param pulumi.Input[builtins.str] tunnel_destination_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_variable is not None:
            pulumi.set(__self__, "application_variable", application_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if dead_peer_detection_interval is not None:
            pulumi.set(__self__, "dead_peer_detection_interval", dead_peer_detection_interval)
        if dead_peer_detection_interval_variable is not None:
            pulumi.set(__self__, "dead_peer_detection_interval_variable", dead_peer_detection_interval_variable)
        if dead_peer_detection_retries is not None:
            pulumi.set(__self__, "dead_peer_detection_retries", dead_peer_detection_retries)
        if dead_peer_detection_retries_variable is not None:
            pulumi.set(__self__, "dead_peer_detection_retries_variable", dead_peer_detection_retries_variable)
        if ike_ciphersuite is not None:
            pulumi.set(__self__, "ike_ciphersuite", ike_ciphersuite)
        if ike_ciphersuite_variable is not None:
            pulumi.set(__self__, "ike_ciphersuite_variable", ike_ciphersuite_variable)
        if ike_group is not None:
            pulumi.set(__self__, "ike_group", ike_group)
        if ike_group_variable is not None:
            pulumi.set(__self__, "ike_group_variable", ike_group_variable)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_mode_variable is not None:
            pulumi.set(__self__, "ike_mode_variable", ike_mode_variable)
        if ike_pre_shared_key is not None:
            pulumi.set(__self__, "ike_pre_shared_key", ike_pre_shared_key)
        if ike_pre_shared_key_local_id is not None:
            pulumi.set(__self__, "ike_pre_shared_key_local_id", ike_pre_shared_key_local_id)
        if ike_pre_shared_key_local_id_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_local_id_variable", ike_pre_shared_key_local_id_variable)
        if ike_pre_shared_key_remote_id is not None:
            pulumi.set(__self__, "ike_pre_shared_key_remote_id", ike_pre_shared_key_remote_id)
        if ike_pre_shared_key_remote_id_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_remote_id_variable", ike_pre_shared_key_remote_id_variable)
        if ike_pre_shared_key_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_variable", ike_pre_shared_key_variable)
        if ike_rekey_interval is not None:
            pulumi.set(__self__, "ike_rekey_interval", ike_rekey_interval)
        if ike_rekey_interval_variable is not None:
            pulumi.set(__self__, "ike_rekey_interval_variable", ike_rekey_interval_variable)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if ipsec_ciphersuite is not None:
            pulumi.set(__self__, "ipsec_ciphersuite", ipsec_ciphersuite)
        if ipsec_ciphersuite_variable is not None:
            pulumi.set(__self__, "ipsec_ciphersuite_variable", ipsec_ciphersuite_variable)
        if ipsec_perfect_forward_secrecy is not None:
            pulumi.set(__self__, "ipsec_perfect_forward_secrecy", ipsec_perfect_forward_secrecy)
        if ipsec_perfect_forward_secrecy_variable is not None:
            pulumi.set(__self__, "ipsec_perfect_forward_secrecy_variable", ipsec_perfect_forward_secrecy_variable)
        if ipsec_rekey_interval is not None:
            pulumi.set(__self__, "ipsec_rekey_interval", ipsec_rekey_interval)
        if ipsec_rekey_interval_variable is not None:
            pulumi.set(__self__, "ipsec_rekey_interval_variable", ipsec_rekey_interval_variable)
        if ipsec_replay_window is not None:
            pulumi.set(__self__, "ipsec_replay_window", ipsec_replay_window)
        if ipsec_replay_window_variable is not None:
            pulumi.set(__self__, "ipsec_replay_window_variable", ipsec_replay_window_variable)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if mtu_variable is not None:
            pulumi.set(__self__, "mtu_variable", mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)
        if tracker_variable is not None:
            pulumi.set(__self__, "tracker_variable", tracker_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if tunnel_destination is not None:
            pulumi.set(__self__, "tunnel_destination", tunnel_destination)
        if tunnel_destination_variable is not None:
            pulumi.set(__self__, "tunnel_destination_variable", tunnel_destination_variable)
        if tunnel_route_via is not None:
            pulumi.set(__self__, "tunnel_route_via", tunnel_route_via)
        if tunnel_route_via_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_variable", tunnel_route_via_variable)
        if tunnel_source is not None:
            pulumi.set(__self__, "tunnel_source", tunnel_source)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_variable is not None:
            pulumi.set(__self__, "tunnel_source_variable", tunnel_source_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @application_variable.setter
    def application_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter(name="deadPeerDetectionInterval")
    def dead_peer_detection_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        """
        return pulumi.get(self, "dead_peer_detection_interval")

    @dead_peer_detection_interval.setter
    def dead_peer_detection_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_peer_detection_interval", value)

    @property
    @pulumi.getter(name="deadPeerDetectionIntervalVariable")
    def dead_peer_detection_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_interval_variable")

    @dead_peer_detection_interval_variable.setter
    def dead_peer_detection_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dead_peer_detection_interval_variable", value)

    @property
    @pulumi.getter(name="deadPeerDetectionRetries")
    def dead_peer_detection_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        """
        return pulumi.get(self, "dead_peer_detection_retries")

    @dead_peer_detection_retries.setter
    def dead_peer_detection_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_peer_detection_retries", value)

    @property
    @pulumi.getter(name="deadPeerDetectionRetriesVariable")
    def dead_peer_detection_retries_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_retries_variable")

    @dead_peer_detection_retries_variable.setter
    def dead_peer_detection_retries_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dead_peer_detection_retries_variable", value)

    @property
    @pulumi.getter(name="ikeCiphersuite")
    def ike_ciphersuite(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
        `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        """
        return pulumi.get(self, "ike_ciphersuite")

    @ike_ciphersuite.setter
    def ike_ciphersuite(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_ciphersuite", value)

    @property
    @pulumi.getter(name="ikeCiphersuiteVariable")
    def ike_ciphersuite_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_ciphersuite_variable")

    @ike_ciphersuite_variable.setter
    def ike_ciphersuite_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_ciphersuite_variable", value)

    @property
    @pulumi.getter(name="ikeGroup")
    def ike_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        """
        return pulumi.get(self, "ike_group")

    @ike_group.setter
    def ike_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_group", value)

    @property
    @pulumi.getter(name="ikeGroupVariable")
    def ike_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_group_variable")

    @ike_group_variable.setter
    def ike_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_group_variable", value)

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        """
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @property
    @pulumi.getter(name="ikeModeVariable")
    def ike_mode_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_mode_variable")

    @ike_mode_variable.setter
    def ike_mode_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_mode_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKey")
    def ike_pre_shared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use preshared key to authenticate IKE peer
        """
        return pulumi.get(self, "ike_pre_shared_key")

    @ike_pre_shared_key.setter
    def ike_pre_shared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalId")
    def ike_pre_shared_key_local_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id")

    @ike_pre_shared_key_local_id.setter
    def ike_pre_shared_key_local_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_local_id", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalIdVariable")
    def ike_pre_shared_key_local_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id_variable")

    @ike_pre_shared_key_local_id_variable.setter
    def ike_pre_shared_key_local_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_local_id_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteId")
    def ike_pre_shared_key_remote_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id")

    @ike_pre_shared_key_remote_id.setter
    def ike_pre_shared_key_remote_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_remote_id", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteIdVariable")
    def ike_pre_shared_key_remote_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id_variable")

    @ike_pre_shared_key_remote_id_variable.setter
    def ike_pre_shared_key_remote_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_remote_id_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyVariable")
    def ike_pre_shared_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_variable")

    @ike_pre_shared_key_variable.setter
    def ike_pre_shared_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_variable", value)

    @property
    @pulumi.getter(name="ikeRekeyInterval")
    def ike_rekey_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        """
        return pulumi.get(self, "ike_rekey_interval")

    @ike_rekey_interval.setter
    def ike_rekey_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ike_rekey_interval", value)

    @property
    @pulumi.getter(name="ikeRekeyIntervalVariable")
    def ike_rekey_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_rekey_interval_variable")

    @ike_rekey_interval_variable.setter
    def ike_rekey_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_rekey_interval_variable", value)

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ike_version", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name: IPsec when present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter(name="ipsecCiphersuite")
    def ipsec_ciphersuite(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
        `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
        `aes256-gcm`
        """
        return pulumi.get(self, "ipsec_ciphersuite")

    @ipsec_ciphersuite.setter
    def ipsec_ciphersuite(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_ciphersuite", value)

    @property
    @pulumi.getter(name="ipsecCiphersuiteVariable")
    def ipsec_ciphersuite_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_ciphersuite_variable")

    @ipsec_ciphersuite_variable.setter
    def ipsec_ciphersuite_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_ciphersuite_variable", value)

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecy")
    def ipsec_perfect_forward_secrecy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
        `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy")

    @ipsec_perfect_forward_secrecy.setter
    def ipsec_perfect_forward_secrecy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_perfect_forward_secrecy", value)

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecyVariable")
    def ipsec_perfect_forward_secrecy_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy_variable")

    @ipsec_perfect_forward_secrecy_variable.setter
    def ipsec_perfect_forward_secrecy_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_perfect_forward_secrecy_variable", value)

    @property
    @pulumi.getter(name="ipsecRekeyInterval")
    def ipsec_rekey_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        """
        return pulumi.get(self, "ipsec_rekey_interval")

    @ipsec_rekey_interval.setter
    def ipsec_rekey_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipsec_rekey_interval", value)

    @property
    @pulumi.getter(name="ipsecRekeyIntervalVariable")
    def ipsec_rekey_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_rekey_interval_variable")

    @ipsec_rekey_interval_variable.setter
    def ipsec_rekey_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_rekey_interval_variable", value)

    @property
    @pulumi.getter(name="ipsecReplayWindow")
    def ipsec_replay_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        """
        return pulumi.get(self, "ipsec_replay_window")

    @ipsec_replay_window.setter
    def ipsec_replay_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipsec_replay_window", value)

    @property
    @pulumi.getter(name="ipsecReplayWindowVariable")
    def ipsec_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_replay_window_variable")

    @ipsec_replay_window_variable.setter
    def ipsec_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_replay_window_variable", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @mtu_variable.setter
    def mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtu_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @tracker_variable.setter
    def tracker_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel destination IP address
        """
        return pulumi.get(self, "tunnel_destination")

    @tunnel_destination.setter
    def tunnel_destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination", value)

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @tunnel_destination_variable.setter
    def tunnel_destination_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @tunnel_route_via.setter
    def tunnel_route_via(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via", value)

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @tunnel_route_via_variable.setter
    def tunnel_route_via_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_variable", value)

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @tunnel_source.setter
    def tunnel_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @tunnel_source_variable.setter
    def tunnel_source_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_variable", value)


@pulumi.input_type
class _CiscoVpnInterfaceIpsecFeatureTemplateState:
    def __init__(__self__, *,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 application_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_interval: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_retries: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_retries_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ike_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ike_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ike_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[builtins.int]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoVpnInterfaceIpsecFeatureTemplate resources.
        :param pulumi.Input[builtins.str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[builtins.str] application_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_interval: IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        :param pulumi.Input[builtins.str] dead_peer_detection_interval_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_retries: IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        :param pulumi.Input[builtins.str] dead_peer_detection_retries_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] ike_ciphersuite: IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
               `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        :param pulumi.Input[builtins.str] ike_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ike_group: IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        :param pulumi.Input[builtins.str] ike_group_variable: Variable name
        :param pulumi.Input[builtins.str] ike_mode: IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        :param pulumi.Input[builtins.str] ike_mode_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key: Use preshared key to authenticate IKE peer
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id: IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id: IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_variable: Variable name
        :param pulumi.Input[builtins.int] ike_rekey_interval: IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        :param pulumi.Input[builtins.str] ike_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ike_version: IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: IPsec when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Assign IPv4 address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_ciphersuite: IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
               `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
               `aes256-gcm`
        :param pulumi.Input[builtins.str] ipsec_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy: IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
               `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_rekey_interval: IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        :param pulumi.Input[builtins.str] ipsec_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_replay_window: Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        :param pulumi.Input[builtins.str] ipsec_replay_window_variable: Variable name
        :param pulumi.Input[builtins.int] mtu: Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] mtu_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[builtins.str] tunnel_destination: Tunnel destination IP address
        :param pulumi.Input[builtins.str] tunnel_destination_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_variable is not None:
            pulumi.set(__self__, "application_variable", application_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if dead_peer_detection_interval is not None:
            pulumi.set(__self__, "dead_peer_detection_interval", dead_peer_detection_interval)
        if dead_peer_detection_interval_variable is not None:
            pulumi.set(__self__, "dead_peer_detection_interval_variable", dead_peer_detection_interval_variable)
        if dead_peer_detection_retries is not None:
            pulumi.set(__self__, "dead_peer_detection_retries", dead_peer_detection_retries)
        if dead_peer_detection_retries_variable is not None:
            pulumi.set(__self__, "dead_peer_detection_retries_variable", dead_peer_detection_retries_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if ike_ciphersuite is not None:
            pulumi.set(__self__, "ike_ciphersuite", ike_ciphersuite)
        if ike_ciphersuite_variable is not None:
            pulumi.set(__self__, "ike_ciphersuite_variable", ike_ciphersuite_variable)
        if ike_group is not None:
            pulumi.set(__self__, "ike_group", ike_group)
        if ike_group_variable is not None:
            pulumi.set(__self__, "ike_group_variable", ike_group_variable)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_mode_variable is not None:
            pulumi.set(__self__, "ike_mode_variable", ike_mode_variable)
        if ike_pre_shared_key is not None:
            pulumi.set(__self__, "ike_pre_shared_key", ike_pre_shared_key)
        if ike_pre_shared_key_local_id is not None:
            pulumi.set(__self__, "ike_pre_shared_key_local_id", ike_pre_shared_key_local_id)
        if ike_pre_shared_key_local_id_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_local_id_variable", ike_pre_shared_key_local_id_variable)
        if ike_pre_shared_key_remote_id is not None:
            pulumi.set(__self__, "ike_pre_shared_key_remote_id", ike_pre_shared_key_remote_id)
        if ike_pre_shared_key_remote_id_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_remote_id_variable", ike_pre_shared_key_remote_id_variable)
        if ike_pre_shared_key_variable is not None:
            pulumi.set(__self__, "ike_pre_shared_key_variable", ike_pre_shared_key_variable)
        if ike_rekey_interval is not None:
            pulumi.set(__self__, "ike_rekey_interval", ike_rekey_interval)
        if ike_rekey_interval_variable is not None:
            pulumi.set(__self__, "ike_rekey_interval_variable", ike_rekey_interval_variable)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if ipsec_ciphersuite is not None:
            pulumi.set(__self__, "ipsec_ciphersuite", ipsec_ciphersuite)
        if ipsec_ciphersuite_variable is not None:
            pulumi.set(__self__, "ipsec_ciphersuite_variable", ipsec_ciphersuite_variable)
        if ipsec_perfect_forward_secrecy is not None:
            pulumi.set(__self__, "ipsec_perfect_forward_secrecy", ipsec_perfect_forward_secrecy)
        if ipsec_perfect_forward_secrecy_variable is not None:
            pulumi.set(__self__, "ipsec_perfect_forward_secrecy_variable", ipsec_perfect_forward_secrecy_variable)
        if ipsec_rekey_interval is not None:
            pulumi.set(__self__, "ipsec_rekey_interval", ipsec_rekey_interval)
        if ipsec_rekey_interval_variable is not None:
            pulumi.set(__self__, "ipsec_rekey_interval_variable", ipsec_rekey_interval_variable)
        if ipsec_replay_window is not None:
            pulumi.set(__self__, "ipsec_replay_window", ipsec_replay_window)
        if ipsec_replay_window_variable is not None:
            pulumi.set(__self__, "ipsec_replay_window_variable", ipsec_replay_window_variable)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if mtu_variable is not None:
            pulumi.set(__self__, "mtu_variable", mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if tracker_variable is not None:
            pulumi.set(__self__, "tracker_variable", tracker_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if tunnel_destination is not None:
            pulumi.set(__self__, "tunnel_destination", tunnel_destination)
        if tunnel_destination_variable is not None:
            pulumi.set(__self__, "tunnel_destination_variable", tunnel_destination_variable)
        if tunnel_route_via is not None:
            pulumi.set(__self__, "tunnel_route_via", tunnel_route_via)
        if tunnel_route_via_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_variable", tunnel_route_via_variable)
        if tunnel_source is not None:
            pulumi.set(__self__, "tunnel_source", tunnel_source)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_variable is not None:
            pulumi.set(__self__, "tunnel_source_variable", tunnel_source_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @application_variable.setter
    def application_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter(name="deadPeerDetectionInterval")
    def dead_peer_detection_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        """
        return pulumi.get(self, "dead_peer_detection_interval")

    @dead_peer_detection_interval.setter
    def dead_peer_detection_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_peer_detection_interval", value)

    @property
    @pulumi.getter(name="deadPeerDetectionIntervalVariable")
    def dead_peer_detection_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_interval_variable")

    @dead_peer_detection_interval_variable.setter
    def dead_peer_detection_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dead_peer_detection_interval_variable", value)

    @property
    @pulumi.getter(name="deadPeerDetectionRetries")
    def dead_peer_detection_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        """
        return pulumi.get(self, "dead_peer_detection_retries")

    @dead_peer_detection_retries.setter
    def dead_peer_detection_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_peer_detection_retries", value)

    @property
    @pulumi.getter(name="deadPeerDetectionRetriesVariable")
    def dead_peer_detection_retries_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_retries_variable")

    @dead_peer_detection_retries_variable.setter
    def dead_peer_detection_retries_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dead_peer_detection_retries_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ikeCiphersuite")
    def ike_ciphersuite(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
        `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        """
        return pulumi.get(self, "ike_ciphersuite")

    @ike_ciphersuite.setter
    def ike_ciphersuite(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_ciphersuite", value)

    @property
    @pulumi.getter(name="ikeCiphersuiteVariable")
    def ike_ciphersuite_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_ciphersuite_variable")

    @ike_ciphersuite_variable.setter
    def ike_ciphersuite_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_ciphersuite_variable", value)

    @property
    @pulumi.getter(name="ikeGroup")
    def ike_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        """
        return pulumi.get(self, "ike_group")

    @ike_group.setter
    def ike_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_group", value)

    @property
    @pulumi.getter(name="ikeGroupVariable")
    def ike_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_group_variable")

    @ike_group_variable.setter
    def ike_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_group_variable", value)

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        """
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @property
    @pulumi.getter(name="ikeModeVariable")
    def ike_mode_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_mode_variable")

    @ike_mode_variable.setter
    def ike_mode_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_mode_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKey")
    def ike_pre_shared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use preshared key to authenticate IKE peer
        """
        return pulumi.get(self, "ike_pre_shared_key")

    @ike_pre_shared_key.setter
    def ike_pre_shared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalId")
    def ike_pre_shared_key_local_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id")

    @ike_pre_shared_key_local_id.setter
    def ike_pre_shared_key_local_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_local_id", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalIdVariable")
    def ike_pre_shared_key_local_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id_variable")

    @ike_pre_shared_key_local_id_variable.setter
    def ike_pre_shared_key_local_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_local_id_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteId")
    def ike_pre_shared_key_remote_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id")

    @ike_pre_shared_key_remote_id.setter
    def ike_pre_shared_key_remote_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_remote_id", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteIdVariable")
    def ike_pre_shared_key_remote_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id_variable")

    @ike_pre_shared_key_remote_id_variable.setter
    def ike_pre_shared_key_remote_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_remote_id_variable", value)

    @property
    @pulumi.getter(name="ikePreSharedKeyVariable")
    def ike_pre_shared_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_variable")

    @ike_pre_shared_key_variable.setter
    def ike_pre_shared_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_pre_shared_key_variable", value)

    @property
    @pulumi.getter(name="ikeRekeyInterval")
    def ike_rekey_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        """
        return pulumi.get(self, "ike_rekey_interval")

    @ike_rekey_interval.setter
    def ike_rekey_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ike_rekey_interval", value)

    @property
    @pulumi.getter(name="ikeRekeyIntervalVariable")
    def ike_rekey_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_rekey_interval_variable")

    @ike_rekey_interval_variable.setter
    def ike_rekey_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ike_rekey_interval_variable", value)

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ike_version", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name: IPsec when present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter(name="ipsecCiphersuite")
    def ipsec_ciphersuite(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
        `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
        `aes256-gcm`
        """
        return pulumi.get(self, "ipsec_ciphersuite")

    @ipsec_ciphersuite.setter
    def ipsec_ciphersuite(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_ciphersuite", value)

    @property
    @pulumi.getter(name="ipsecCiphersuiteVariable")
    def ipsec_ciphersuite_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_ciphersuite_variable")

    @ipsec_ciphersuite_variable.setter
    def ipsec_ciphersuite_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_ciphersuite_variable", value)

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecy")
    def ipsec_perfect_forward_secrecy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
        `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy")

    @ipsec_perfect_forward_secrecy.setter
    def ipsec_perfect_forward_secrecy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_perfect_forward_secrecy", value)

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecyVariable")
    def ipsec_perfect_forward_secrecy_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy_variable")

    @ipsec_perfect_forward_secrecy_variable.setter
    def ipsec_perfect_forward_secrecy_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_perfect_forward_secrecy_variable", value)

    @property
    @pulumi.getter(name="ipsecRekeyInterval")
    def ipsec_rekey_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        """
        return pulumi.get(self, "ipsec_rekey_interval")

    @ipsec_rekey_interval.setter
    def ipsec_rekey_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipsec_rekey_interval", value)

    @property
    @pulumi.getter(name="ipsecRekeyIntervalVariable")
    def ipsec_rekey_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_rekey_interval_variable")

    @ipsec_rekey_interval_variable.setter
    def ipsec_rekey_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_rekey_interval_variable", value)

    @property
    @pulumi.getter(name="ipsecReplayWindow")
    def ipsec_replay_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        """
        return pulumi.get(self, "ipsec_replay_window")

    @ipsec_replay_window.setter
    def ipsec_replay_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipsec_replay_window", value)

    @property
    @pulumi.getter(name="ipsecReplayWindowVariable")
    def ipsec_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_replay_window_variable")

    @ipsec_replay_window_variable.setter
    def ipsec_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_replay_window_variable", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @mtu_variable.setter
    def mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtu_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @tracker_variable.setter
    def tracker_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel destination IP address
        """
        return pulumi.get(self, "tunnel_destination")

    @tunnel_destination.setter
    def tunnel_destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination", value)

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @tunnel_destination_variable.setter
    def tunnel_destination_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @tunnel_route_via.setter
    def tunnel_route_via(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via", value)

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @tunnel_route_via_variable.setter
    def tunnel_route_via_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_variable", value)

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @tunnel_source.setter
    def tunnel_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @tunnel_source_variable.setter
    def tunnel_source_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class CiscoVpnInterfaceIpsecFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 application_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_interval: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_retries: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_retries_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ike_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ike_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ike_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[builtins.int]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco VPN Interface IPSec feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CiscoVpnInterfaceIpsecFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            interface_name="ipsec1",
            shutdown=False,
            interface_description="My Description",
            ip_address="1.1.1.1/24",
            tunnel_source="1.2.3.4",
            tunnel_source_interface="e1",
            tunnel_destination="3.4.5.6",
            application="sig",
            tcp_mss_adjust=1400,
            clear_dont_fragment=True,
            mtu=1500,
            dead_peer_detection_interval=100,
            dead_peer_detection_retries=4,
            ike_version=2,
            ike_mode="main",
            ike_rekey_interval=20000,
            ike_ciphersuite="aes256-cbc-sha1",
            ike_group="20",
            ike_pre_shared_key="cisco123",
            ike_pre_shared_key_local_id="1",
            ike_pre_shared_key_remote_id="2",
            ipsec_rekey_interval=7200,
            ipsec_replay_window=128,
            ipsec_ciphersuite="aes256-cbc-sha256",
            ipsec_perfect_forward_secrecy="group-20",
            trackers=["TRACKER1"],
            tunnel_route_via="g0/0")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoVpnInterfaceIpsecFeatureTemplate:CiscoVpnInterfaceIpsecFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[builtins.str] application_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_interval: IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        :param pulumi.Input[builtins.str] dead_peer_detection_interval_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_retries: IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        :param pulumi.Input[builtins.str] dead_peer_detection_retries_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] ike_ciphersuite: IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
               `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        :param pulumi.Input[builtins.str] ike_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ike_group: IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        :param pulumi.Input[builtins.str] ike_group_variable: Variable name
        :param pulumi.Input[builtins.str] ike_mode: IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        :param pulumi.Input[builtins.str] ike_mode_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key: Use preshared key to authenticate IKE peer
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id: IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id: IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_variable: Variable name
        :param pulumi.Input[builtins.int] ike_rekey_interval: IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        :param pulumi.Input[builtins.str] ike_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ike_version: IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: IPsec when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Assign IPv4 address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_ciphersuite: IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
               `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
               `aes256-gcm`
        :param pulumi.Input[builtins.str] ipsec_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy: IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
               `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_rekey_interval: IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        :param pulumi.Input[builtins.str] ipsec_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_replay_window: Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        :param pulumi.Input[builtins.str] ipsec_replay_window_variable: Variable name
        :param pulumi.Input[builtins.int] mtu: Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] mtu_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[builtins.str] tunnel_destination: Tunnel destination IP address
        :param pulumi.Input[builtins.str] tunnel_destination_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoVpnInterfaceIpsecFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco VPN Interface IPSec feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CiscoVpnInterfaceIpsecFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            interface_name="ipsec1",
            shutdown=False,
            interface_description="My Description",
            ip_address="1.1.1.1/24",
            tunnel_source="1.2.3.4",
            tunnel_source_interface="e1",
            tunnel_destination="3.4.5.6",
            application="sig",
            tcp_mss_adjust=1400,
            clear_dont_fragment=True,
            mtu=1500,
            dead_peer_detection_interval=100,
            dead_peer_detection_retries=4,
            ike_version=2,
            ike_mode="main",
            ike_rekey_interval=20000,
            ike_ciphersuite="aes256-cbc-sha1",
            ike_group="20",
            ike_pre_shared_key="cisco123",
            ike_pre_shared_key_local_id="1",
            ike_pre_shared_key_remote_id="2",
            ipsec_rekey_interval=7200,
            ipsec_replay_window=128,
            ipsec_ciphersuite="aes256-cbc-sha256",
            ipsec_perfect_forward_secrecy="group-20",
            trackers=["TRACKER1"],
            tunnel_route_via="g0/0")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoVpnInterfaceIpsecFeatureTemplate:CiscoVpnInterfaceIpsecFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoVpnInterfaceIpsecFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoVpnInterfaceIpsecFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 application_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_interval: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dead_peer_detection_retries: Optional[pulumi.Input[builtins.int]] = None,
                 dead_peer_detection_retries_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ike_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ike_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group: Optional[pulumi.Input[builtins.str]] = None,
                 ike_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ike_mode_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_local_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_remote_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_pre_shared_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ike_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[builtins.int]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_perfect_forward_secrecy_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 ipsec_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoVpnInterfaceIpsecFeatureTemplateArgs.__new__(CiscoVpnInterfaceIpsecFeatureTemplateArgs)

            __props__.__dict__["application"] = application
            __props__.__dict__["application_variable"] = application_variable
            __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
            __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
            __props__.__dict__["dead_peer_detection_interval"] = dead_peer_detection_interval
            __props__.__dict__["dead_peer_detection_interval_variable"] = dead_peer_detection_interval_variable
            __props__.__dict__["dead_peer_detection_retries"] = dead_peer_detection_retries
            __props__.__dict__["dead_peer_detection_retries_variable"] = dead_peer_detection_retries_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["ike_ciphersuite"] = ike_ciphersuite
            __props__.__dict__["ike_ciphersuite_variable"] = ike_ciphersuite_variable
            __props__.__dict__["ike_group"] = ike_group
            __props__.__dict__["ike_group_variable"] = ike_group_variable
            __props__.__dict__["ike_mode"] = ike_mode
            __props__.__dict__["ike_mode_variable"] = ike_mode_variable
            __props__.__dict__["ike_pre_shared_key"] = ike_pre_shared_key
            __props__.__dict__["ike_pre_shared_key_local_id"] = ike_pre_shared_key_local_id
            __props__.__dict__["ike_pre_shared_key_local_id_variable"] = ike_pre_shared_key_local_id_variable
            __props__.__dict__["ike_pre_shared_key_remote_id"] = ike_pre_shared_key_remote_id
            __props__.__dict__["ike_pre_shared_key_remote_id_variable"] = ike_pre_shared_key_remote_id_variable
            __props__.__dict__["ike_pre_shared_key_variable"] = ike_pre_shared_key_variable
            __props__.__dict__["ike_rekey_interval"] = ike_rekey_interval
            __props__.__dict__["ike_rekey_interval_variable"] = ike_rekey_interval_variable
            __props__.__dict__["ike_version"] = ike_version
            __props__.__dict__["interface_description"] = interface_description
            __props__.__dict__["interface_description_variable"] = interface_description_variable
            __props__.__dict__["interface_name"] = interface_name
            __props__.__dict__["interface_name_variable"] = interface_name_variable
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_address_variable"] = ip_address_variable
            __props__.__dict__["ipsec_ciphersuite"] = ipsec_ciphersuite
            __props__.__dict__["ipsec_ciphersuite_variable"] = ipsec_ciphersuite_variable
            __props__.__dict__["ipsec_perfect_forward_secrecy"] = ipsec_perfect_forward_secrecy
            __props__.__dict__["ipsec_perfect_forward_secrecy_variable"] = ipsec_perfect_forward_secrecy_variable
            __props__.__dict__["ipsec_rekey_interval"] = ipsec_rekey_interval
            __props__.__dict__["ipsec_rekey_interval_variable"] = ipsec_rekey_interval_variable
            __props__.__dict__["ipsec_replay_window"] = ipsec_replay_window
            __props__.__dict__["ipsec_replay_window_variable"] = ipsec_replay_window_variable
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["mtu_variable"] = mtu_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
            __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
            __props__.__dict__["tracker_variable"] = tracker_variable
            __props__.__dict__["trackers"] = trackers
            __props__.__dict__["tunnel_destination"] = tunnel_destination
            __props__.__dict__["tunnel_destination_variable"] = tunnel_destination_variable
            __props__.__dict__["tunnel_route_via"] = tunnel_route_via
            __props__.__dict__["tunnel_route_via_variable"] = tunnel_route_via_variable
            __props__.__dict__["tunnel_source"] = tunnel_source
            __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
            __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
            __props__.__dict__["tunnel_source_variable"] = tunnel_source_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoVpnInterfaceIpsecFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoVpnInterfaceIpsecFeatureTemplate:CiscoVpnInterfaceIpsecFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application: Optional[pulumi.Input[builtins.str]] = None,
            application_variable: Optional[pulumi.Input[builtins.str]] = None,
            clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
            clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
            dead_peer_detection_interval: Optional[pulumi.Input[builtins.int]] = None,
            dead_peer_detection_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            dead_peer_detection_retries: Optional[pulumi.Input[builtins.int]] = None,
            dead_peer_detection_retries_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ike_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
            ike_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_group: Optional[pulumi.Input[builtins.str]] = None,
            ike_group_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_mode: Optional[pulumi.Input[builtins.str]] = None,
            ike_mode_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key_local_id: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key_local_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key_remote_id: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key_remote_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_pre_shared_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
            ike_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            ike_version: Optional[pulumi.Input[builtins.int]] = None,
            interface_description: Optional[pulumi.Input[builtins.str]] = None,
            interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_name: Optional[pulumi.Input[builtins.str]] = None,
            interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_ciphersuite: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_ciphersuite_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_perfect_forward_secrecy_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_rekey_interval: Optional[pulumi.Input[builtins.int]] = None,
            ipsec_rekey_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_replay_window: Optional[pulumi.Input[builtins.int]] = None,
            ipsec_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
            mtu: Optional[pulumi.Input[builtins.int]] = None,
            mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            tcp_mss_adjust: Optional[pulumi.Input[builtins.int]] = None,
            tcp_mss_adjust_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            tracker_variable: Optional[pulumi.Input[builtins.str]] = None,
            trackers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel_destination: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_destination_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_route_via: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_route_via_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CiscoVpnInterfaceIpsecFeatureTemplate':
        """
        Get an existing CiscoVpnInterfaceIpsecFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[builtins.str] application_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_interval: IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        :param pulumi.Input[builtins.str] dead_peer_detection_interval_variable: Variable name
        :param pulumi.Input[builtins.int] dead_peer_detection_retries: IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        :param pulumi.Input[builtins.str] dead_peer_detection_retries_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] ike_ciphersuite: IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
               `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        :param pulumi.Input[builtins.str] ike_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ike_group: IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        :param pulumi.Input[builtins.str] ike_group_variable: Variable name
        :param pulumi.Input[builtins.str] ike_mode: IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        :param pulumi.Input[builtins.str] ike_mode_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key: Use preshared key to authenticate IKE peer
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id: IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_local_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id: IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        :param pulumi.Input[builtins.str] ike_pre_shared_key_remote_id_variable: Variable name
        :param pulumi.Input[builtins.str] ike_pre_shared_key_variable: Variable name
        :param pulumi.Input[builtins.int] ike_rekey_interval: IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        :param pulumi.Input[builtins.str] ike_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ike_version: IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: IPsec when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Assign IPv4 address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_ciphersuite: IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
               `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
               `aes256-gcm`
        :param pulumi.Input[builtins.str] ipsec_ciphersuite_variable: Variable name
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy: IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
               `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        :param pulumi.Input[builtins.str] ipsec_perfect_forward_secrecy_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_rekey_interval: IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        :param pulumi.Input[builtins.str] ipsec_rekey_interval_variable: Variable name
        :param pulumi.Input[builtins.int] ipsec_replay_window: Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        :param pulumi.Input[builtins.str] ipsec_replay_window_variable: Variable name
        :param pulumi.Input[builtins.int] mtu: Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] mtu_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[builtins.str] tunnel_destination: Tunnel destination IP address
        :param pulumi.Input[builtins.str] tunnel_destination_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoVpnInterfaceIpsecFeatureTemplateState.__new__(_CiscoVpnInterfaceIpsecFeatureTemplateState)

        __props__.__dict__["application"] = application
        __props__.__dict__["application_variable"] = application_variable
        __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
        __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
        __props__.__dict__["dead_peer_detection_interval"] = dead_peer_detection_interval
        __props__.__dict__["dead_peer_detection_interval_variable"] = dead_peer_detection_interval_variable
        __props__.__dict__["dead_peer_detection_retries"] = dead_peer_detection_retries
        __props__.__dict__["dead_peer_detection_retries_variable"] = dead_peer_detection_retries_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["ike_ciphersuite"] = ike_ciphersuite
        __props__.__dict__["ike_ciphersuite_variable"] = ike_ciphersuite_variable
        __props__.__dict__["ike_group"] = ike_group
        __props__.__dict__["ike_group_variable"] = ike_group_variable
        __props__.__dict__["ike_mode"] = ike_mode
        __props__.__dict__["ike_mode_variable"] = ike_mode_variable
        __props__.__dict__["ike_pre_shared_key"] = ike_pre_shared_key
        __props__.__dict__["ike_pre_shared_key_local_id"] = ike_pre_shared_key_local_id
        __props__.__dict__["ike_pre_shared_key_local_id_variable"] = ike_pre_shared_key_local_id_variable
        __props__.__dict__["ike_pre_shared_key_remote_id"] = ike_pre_shared_key_remote_id
        __props__.__dict__["ike_pre_shared_key_remote_id_variable"] = ike_pre_shared_key_remote_id_variable
        __props__.__dict__["ike_pre_shared_key_variable"] = ike_pre_shared_key_variable
        __props__.__dict__["ike_rekey_interval"] = ike_rekey_interval
        __props__.__dict__["ike_rekey_interval_variable"] = ike_rekey_interval_variable
        __props__.__dict__["ike_version"] = ike_version
        __props__.__dict__["interface_description"] = interface_description
        __props__.__dict__["interface_description_variable"] = interface_description_variable
        __props__.__dict__["interface_name"] = interface_name
        __props__.__dict__["interface_name_variable"] = interface_name_variable
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_address_variable"] = ip_address_variable
        __props__.__dict__["ipsec_ciphersuite"] = ipsec_ciphersuite
        __props__.__dict__["ipsec_ciphersuite_variable"] = ipsec_ciphersuite_variable
        __props__.__dict__["ipsec_perfect_forward_secrecy"] = ipsec_perfect_forward_secrecy
        __props__.__dict__["ipsec_perfect_forward_secrecy_variable"] = ipsec_perfect_forward_secrecy_variable
        __props__.__dict__["ipsec_rekey_interval"] = ipsec_rekey_interval
        __props__.__dict__["ipsec_rekey_interval_variable"] = ipsec_rekey_interval_variable
        __props__.__dict__["ipsec_replay_window"] = ipsec_replay_window
        __props__.__dict__["ipsec_replay_window_variable"] = ipsec_replay_window_variable
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["mtu_variable"] = mtu_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
        __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["tracker_variable"] = tracker_variable
        __props__.__dict__["trackers"] = trackers
        __props__.__dict__["tunnel_destination"] = tunnel_destination
        __props__.__dict__["tunnel_destination_variable"] = tunnel_destination_variable
        __props__.__dict__["tunnel_route_via"] = tunnel_route_via
        __props__.__dict__["tunnel_route_via_variable"] = tunnel_route_via_variable
        __props__.__dict__["tunnel_source"] = tunnel_source
        __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
        __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
        __props__.__dict__["tunnel_source_variable"] = tunnel_source_variable
        __props__.__dict__["version"] = version
        return CiscoVpnInterfaceIpsecFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def application(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @property
    @pulumi.getter(name="deadPeerDetectionInterval")
    def dead_peer_detection_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IKE keepalive interval (seconds) - Range: `10`-`3600` - Default value: `10`
        """
        return pulumi.get(self, "dead_peer_detection_interval")

    @property
    @pulumi.getter(name="deadPeerDetectionIntervalVariable")
    def dead_peer_detection_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_interval_variable")

    @property
    @pulumi.getter(name="deadPeerDetectionRetries")
    def dead_peer_detection_retries(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IKE keepalive retries - Range: `2`-`60` - Default value: `3`
        """
        return pulumi.get(self, "dead_peer_detection_retries")

    @property
    @pulumi.getter(name="deadPeerDetectionRetriesVariable")
    def dead_peer_detection_retries_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dead_peer_detection_retries_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="ikeCiphersuite")
    def ike_ciphersuite(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IKE identity the IKE preshared secret belongs to - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha2`, `aes128-cbc-sha1`,
        `aes128-cbc-sha2` - Default value: `aes256-cbc-sha1`
        """
        return pulumi.get(self, "ike_ciphersuite")

    @property
    @pulumi.getter(name="ikeCiphersuiteVariable")
    def ike_ciphersuite_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_ciphersuite_variable")

    @property
    @pulumi.getter(name="ikeGroup")
    def ike_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IKE Diffie Hellman Groups - Choices: `2`, `14`, `15`, `16`, `19`, `20`, `21`, `24` - Default value: `16`
        """
        return pulumi.get(self, "ike_group")

    @property
    @pulumi.getter(name="ikeGroupVariable")
    def ike_group_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_group_variable")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IKE integrity protocol - Choices: `main`, `aggressive` - Default value: `main`
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikeModeVariable")
    def ike_mode_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_mode_variable")

    @property
    @pulumi.getter(name="ikePreSharedKey")
    def ike_pre_shared_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Use preshared key to authenticate IKE peer
        """
        return pulumi.get(self, "ike_pre_shared_key")

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalId")
    def ike_pre_shared_key_local_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IKE ID for the local endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id")

    @property
    @pulumi.getter(name="ikePreSharedKeyLocalIdVariable")
    def ike_pre_shared_key_local_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_local_id_variable")

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteId")
    def ike_pre_shared_key_remote_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IKE ID for the remote endpoint. Input IPv4 address, domain name, or email address
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id")

    @property
    @pulumi.getter(name="ikePreSharedKeyRemoteIdVariable")
    def ike_pre_shared_key_remote_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_remote_id_variable")

    @property
    @pulumi.getter(name="ikePreSharedKeyVariable")
    def ike_pre_shared_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_pre_shared_key_variable")

    @property
    @pulumi.getter(name="ikeRekeyInterval")
    def ike_rekey_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IKE rekey interval <60..86400> seconds - Range: `60`-`86400` - Default value: `14400`
        """
        return pulumi.get(self, "ike_rekey_interval")

    @property
    @pulumi.getter(name="ikeRekeyIntervalVariable")
    def ike_rekey_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ike_rekey_interval_variable")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IKE Version <1..2> - Range: `1`-`2` - Default value: `1`
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface name: IPsec when present
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @property
    @pulumi.getter(name="ipsecCiphersuite")
    def ipsec_ciphersuite(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IPsec(ESP) encryption and integrity protocol - Choices: `aes256-cbc-sha1`, `aes256-cbc-sha384`, `aes256-cbc-sha256`,
        `aes256-cbc-sha512`, `aes256-gcm`, `null-sha1`, `null-sha384`, `null-sha256`, `null-sha512` - Default value:
        `aes256-gcm`
        """
        return pulumi.get(self, "ipsec_ciphersuite")

    @property
    @pulumi.getter(name="ipsecCiphersuiteVariable")
    def ipsec_ciphersuite_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_ciphersuite_variable")

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecy")
    def ipsec_perfect_forward_secrecy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IPsec perfect forward secrecy settings - Choices: `group-1`, `group-2`, `group-5`, `group-14`, `group-15`, `group-16`,
        `group-19`, `group-20`, `group-21`, `group-24`, `none` - Default value: `group-16`
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy")

    @property
    @pulumi.getter(name="ipsecPerfectForwardSecrecyVariable")
    def ipsec_perfect_forward_secrecy_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_perfect_forward_secrecy_variable")

    @property
    @pulumi.getter(name="ipsecRekeyInterval")
    def ipsec_rekey_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IPsec rekey interval <300..1209600> seconds - Range: `120`-`2592000` - Default value: `3600`
        """
        return pulumi.get(self, "ipsec_rekey_interval")

    @property
    @pulumi.getter(name="ipsecRekeyIntervalVariable")
    def ipsec_rekey_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_rekey_interval_variable")

    @property
    @pulumi.getter(name="ipsecReplayWindow")
    def ipsec_replay_window(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Replay window size 32..8192 (must be a power of 2) - Range: `64`-`4096` - Default value: `512`
        """
        return pulumi.get(self, "ipsec_replay_window")

    @property
    @pulumi.getter(name="ipsecReplayWindowVariable")
    def ipsec_replay_window_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_replay_window_variable")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Interface MTU <68..9216>, in bytes - Range: `68`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @property
    @pulumi.getter
    def trackers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tunnel destination IP address
        """
        return pulumi.get(self, "tunnel_destination")

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

