# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EigrpFeatureTemplateArgs', 'EigrpFeatureTemplate']

@pulumi.input_type
class EigrpFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]] = None,
                 as_number: Optional[pulumi.Input[builtins.int]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EigrpFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]] address_families: Set EIGRP address family
        :param pulumi.Input[builtins.int] as_number: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]] keys: Set keychain name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] route_policy_name: Configure policy to apply to prefixes received from EIGRP neighbor
        :param pulumi.Input[builtins.str] route_policy_name_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if address_families is not None:
            pulumi.set(__self__, "address_families", address_families)
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if as_number_variable is not None:
            pulumi.set(__self__, "as_number_variable", as_number_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filter_variable is not None:
            pulumi.set(__self__, "filter_variable", filter_variable)
        if hello_interval is not None:
            pulumi.set(__self__, "hello_interval", hello_interval)
        if hello_interval_variable is not None:
            pulumi.set(__self__, "hello_interval_variable", hello_interval_variable)
        if hmac_authentication_key is not None:
            pulumi.set(__self__, "hmac_authentication_key", hmac_authentication_key)
        if hmac_authentication_key_variable is not None:
            pulumi.set(__self__, "hmac_authentication_key_variable", hmac_authentication_key_variable)
        if hold_time is not None:
            pulumi.set(__self__, "hold_time", hold_time)
        if hold_time_variable is not None:
            pulumi.set(__self__, "hold_time_variable", hold_time_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_policy_name is not None:
            pulumi.set(__self__, "route_policy_name", route_policy_name)
        if route_policy_name_variable is not None:
            pulumi.set(__self__, "route_policy_name_variable", route_policy_name_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]]:
        """
        Set EIGRP address family
        """
        return pulumi.get(self, "address_families")

    @address_families.setter
    def address_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]]):
        pulumi.set(self, "address_families", value)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "as_number", value)

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @as_number_variable.setter
    def as_number_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @filter_variable.setter
    def filter_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_variable", value)

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @hello_interval.setter
    def hello_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_interval", value)

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @hello_interval_variable.setter
    def hello_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hello_interval_variable", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set hmac-sha-256 authentication key
        """
        return pulumi.get(self, "hmac_authentication_key")

    @hmac_authentication_key.setter
    def hmac_authentication_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @hmac_authentication_key_variable.setter
    def hmac_authentication_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key_variable", value)

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @hold_time.setter
    def hold_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hold_time", value)

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @hold_time_variable.setter
    def hold_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hold_time_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]]:
        """
        Set keychain name
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routePolicyName")
    def route_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure policy to apply to prefixes received from EIGRP neighbor
        """
        return pulumi.get(self, "route_policy_name")

    @route_policy_name.setter
    def route_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_name", value)

    @property
    @pulumi.getter(name="routePolicyNameVariable")
    def route_policy_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_policy_name_variable")

    @route_policy_name_variable.setter
    def route_policy_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_name_variable", value)


@pulumi.input_type
class _EigrpFeatureTemplateState:
    def __init__(__self__, *,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]] = None,
                 as_number: Optional[pulumi.Input[builtins.int]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering EigrpFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]] address_families: Set EIGRP address family
        :param pulumi.Input[builtins.int] as_number: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]] keys: Set keychain name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] route_policy_name: Configure policy to apply to prefixes received from EIGRP neighbor
        :param pulumi.Input[builtins.str] route_policy_name_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if address_families is not None:
            pulumi.set(__self__, "address_families", address_families)
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if as_number_variable is not None:
            pulumi.set(__self__, "as_number_variable", as_number_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filter_variable is not None:
            pulumi.set(__self__, "filter_variable", filter_variable)
        if hello_interval is not None:
            pulumi.set(__self__, "hello_interval", hello_interval)
        if hello_interval_variable is not None:
            pulumi.set(__self__, "hello_interval_variable", hello_interval_variable)
        if hmac_authentication_key is not None:
            pulumi.set(__self__, "hmac_authentication_key", hmac_authentication_key)
        if hmac_authentication_key_variable is not None:
            pulumi.set(__self__, "hmac_authentication_key_variable", hmac_authentication_key_variable)
        if hold_time is not None:
            pulumi.set(__self__, "hold_time", hold_time)
        if hold_time_variable is not None:
            pulumi.set(__self__, "hold_time_variable", hold_time_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_policy_name is not None:
            pulumi.set(__self__, "route_policy_name", route_policy_name)
        if route_policy_name_variable is not None:
            pulumi.set(__self__, "route_policy_name_variable", route_policy_name_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]]:
        """
        Set EIGRP address family
        """
        return pulumi.get(self, "address_families")

    @address_families.setter
    def address_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateAddressFamilyArgs']]]]):
        pulumi.set(self, "address_families", value)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "as_number", value)

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @as_number_variable.setter
    def as_number_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @filter_variable.setter
    def filter_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_variable", value)

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @hello_interval.setter
    def hello_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_interval", value)

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @hello_interval_variable.setter
    def hello_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hello_interval_variable", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set hmac-sha-256 authentication key
        """
        return pulumi.get(self, "hmac_authentication_key")

    @hmac_authentication_key.setter
    def hmac_authentication_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @hmac_authentication_key_variable.setter
    def hmac_authentication_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key_variable", value)

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @hold_time.setter
    def hold_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hold_time", value)

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @hold_time_variable.setter
    def hold_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hold_time_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]]:
        """
        Set keychain name
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EigrpFeatureTemplateKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routePolicyName")
    def route_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure policy to apply to prefixes received from EIGRP neighbor
        """
        return pulumi.get(self, "route_policy_name")

    @route_policy_name.setter
    def route_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_name", value)

    @property
    @pulumi.getter(name="routePolicyNameVariable")
    def route_policy_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_policy_name_variable")

    @route_policy_name_variable.setter
    def route_policy_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_name_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class EigrpFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateAddressFamilyArgs', 'EigrpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
                 as_number: Optional[pulumi.Input[builtins.int]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateInterfaceArgs', 'EigrpFeatureTemplateInterfaceArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateKeyArgs', 'EigrpFeatureTemplateKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a eigrp feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/eigrpFeatureTemplate:EigrpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateAddressFamilyArgs', 'EigrpFeatureTemplateAddressFamilyArgsDict']]]] address_families: Set EIGRP address family
        :param pulumi.Input[builtins.int] as_number: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateInterfaceArgs', 'EigrpFeatureTemplateInterfaceArgsDict']]]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateKeyArgs', 'EigrpFeatureTemplateKeyArgsDict']]]] keys: Set keychain name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] route_policy_name: Configure policy to apply to prefixes received from EIGRP neighbor
        :param pulumi.Input[builtins.str] route_policy_name_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EigrpFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a eigrp feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/eigrpFeatureTemplate:EigrpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param EigrpFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EigrpFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateAddressFamilyArgs', 'EigrpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
                 as_number: Optional[pulumi.Input[builtins.int]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateInterfaceArgs', 'EigrpFeatureTemplateInterfaceArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateKeyArgs', 'EigrpFeatureTemplateKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 route_policy_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EigrpFeatureTemplateArgs.__new__(EigrpFeatureTemplateArgs)

            __props__.__dict__["address_families"] = address_families
            __props__.__dict__["as_number"] = as_number
            __props__.__dict__["as_number_variable"] = as_number_variable
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["filter"] = filter
            __props__.__dict__["filter_variable"] = filter_variable
            __props__.__dict__["hello_interval"] = hello_interval
            __props__.__dict__["hello_interval_variable"] = hello_interval_variable
            __props__.__dict__["hmac_authentication_key"] = hmac_authentication_key
            __props__.__dict__["hmac_authentication_key_variable"] = hmac_authentication_key_variable
            __props__.__dict__["hold_time"] = hold_time
            __props__.__dict__["hold_time_variable"] = hold_time_variable
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["keys"] = keys
            __props__.__dict__["name"] = name
            __props__.__dict__["route_policy_name"] = route_policy_name
            __props__.__dict__["route_policy_name_variable"] = route_policy_name_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(EigrpFeatureTemplate, __self__).__init__(
            'sdwan:index/eigrpFeatureTemplate:EigrpFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateAddressFamilyArgs', 'EigrpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
            as_number: Optional[pulumi.Input[builtins.int]] = None,
            as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            filter: Optional[pulumi.Input[builtins.bool]] = None,
            filter_variable: Optional[pulumi.Input[builtins.str]] = None,
            hello_interval: Optional[pulumi.Input[builtins.int]] = None,
            hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
            hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            hold_time: Optional[pulumi.Input[builtins.int]] = None,
            hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateInterfaceArgs', 'EigrpFeatureTemplateInterfaceArgsDict']]]]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateKeyArgs', 'EigrpFeatureTemplateKeyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            route_policy_name: Optional[pulumi.Input[builtins.str]] = None,
            route_policy_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'EigrpFeatureTemplate':
        """
        Get an existing EigrpFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateAddressFamilyArgs', 'EigrpFeatureTemplateAddressFamilyArgsDict']]]] address_families: Set EIGRP address family
        :param pulumi.Input[builtins.int] as_number: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateInterfaceArgs', 'EigrpFeatureTemplateInterfaceArgsDict']]]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['EigrpFeatureTemplateKeyArgs', 'EigrpFeatureTemplateKeyArgsDict']]]] keys: Set keychain name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] route_policy_name: Configure policy to apply to prefixes received from EIGRP neighbor
        :param pulumi.Input[builtins.str] route_policy_name_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EigrpFeatureTemplateState.__new__(_EigrpFeatureTemplateState)

        __props__.__dict__["address_families"] = address_families
        __props__.__dict__["as_number"] = as_number
        __props__.__dict__["as_number_variable"] = as_number_variable
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["filter"] = filter
        __props__.__dict__["filter_variable"] = filter_variable
        __props__.__dict__["hello_interval"] = hello_interval
        __props__.__dict__["hello_interval_variable"] = hello_interval_variable
        __props__.__dict__["hmac_authentication_key"] = hmac_authentication_key
        __props__.__dict__["hmac_authentication_key_variable"] = hmac_authentication_key_variable
        __props__.__dict__["hold_time"] = hold_time
        __props__.__dict__["hold_time_variable"] = hold_time_variable
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["keys"] = keys
        __props__.__dict__["name"] = name
        __props__.__dict__["route_policy_name"] = route_policy_name
        __props__.__dict__["route_policy_name_variable"] = route_policy_name_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return EigrpFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> pulumi.Output[Optional[Sequence['outputs.EigrpFeatureTemplateAddressFamily']]]:
        """
        Set EIGRP address family
        """
        return pulumi.get(self, "address_families")

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "as_number")

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set hmac-sha-256 authentication key
        """
        return pulumi.get(self, "hmac_authentication_key")

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.EigrpFeatureTemplateInterface']]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[Sequence['outputs.EigrpFeatureTemplateKey']]]:
        """
        Set keychain name
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routePolicyName")
    def route_policy_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Configure policy to apply to prefixes received from EIGRP neighbor
        """
        return pulumi.get(self, "route_policy_name")

    @property
    @pulumi.getter(name="routePolicyNameVariable")
    def route_policy_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_policy_name_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

