# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceMulticastFeatureArgs', 'ServiceMulticastFeature']

@pulumi.input_type
class ServiceMulticastFeatureArgs:
    def __init__(__self__, *,
                 pim_source_specific_multicast_enable: pulumi.Input[builtins.bool],
                 auto_rp_announces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]] = None,
                 auto_rp_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 igmp_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]] = None,
                 local_replicator: Optional[pulumi.Input[builtins.bool]] = None,
                 local_replicator_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_replicator_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 local_replicator_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_connection_retry_interval: Optional[pulumi.Input[builtins.int]] = None,
                 msdp_connection_retry_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]] = None,
                 msdp_originator_id: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_originator_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pim_bsr_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]] = None,
                 pim_bsr_rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]] = None,
                 pim_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]] = None,
                 pim_source_specific_multicast_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 pim_spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 pim_spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_only: Optional[pulumi.Input[builtins.bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[builtins.str]] = None,
                 static_rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceMulticastFeature resource.
        :param pulumi.Input[builtins.bool] pim_source_specific_multicast_enable: turn SSM on/off
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]] auto_rp_announces: Enable or disable RP Announce
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]] auto_rp_discoveries: Enable or disable RP Discovery
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] enable_auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]] igmp_interfaces: Set IGMP interface parameters
        :param pulumi.Input[builtins.bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[builtins.int] local_replicator_threshold: Set number of joins per group the router supports - Range: `0`-`131072`
        :param pulumi.Input[builtins.str] local_replicator_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] local_replicator_variable: Variable name
        :param pulumi.Input[builtins.int] msdp_connection_retry_interval: Set MSDP refresh timer - Range: `1`-`60`
        :param pulumi.Input[builtins.str] msdp_connection_retry_interval_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]] msdp_groups: multicast MSDP peer
        :param pulumi.Input[builtins.str] msdp_originator_id: Set MSDP originator ID
        :param pulumi.Input[builtins.str] msdp_originator_id_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]] pim_bsr_candidates: bsr candidate Attributes
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]] pim_bsr_rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]] pim_interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list_variable: Variable name
        :param pulumi.Input[builtins.str] pim_spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        :param pulumi.Input[builtins.str] pim_spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[builtins.str] spt_only_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]] static_rp_addresses: Set Static RP Address(es)
        """
        pulumi.set(__self__, "pim_source_specific_multicast_enable", pim_source_specific_multicast_enable)
        if auto_rp_announces is not None:
            pulumi.set(__self__, "auto_rp_announces", auto_rp_announces)
        if auto_rp_discoveries is not None:
            pulumi.set(__self__, "auto_rp_discoveries", auto_rp_discoveries)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_rp is not None:
            pulumi.set(__self__, "enable_auto_rp", enable_auto_rp)
        if enable_auto_rp_variable is not None:
            pulumi.set(__self__, "enable_auto_rp_variable", enable_auto_rp_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if igmp_interfaces is not None:
            pulumi.set(__self__, "igmp_interfaces", igmp_interfaces)
        if local_replicator is not None:
            pulumi.set(__self__, "local_replicator", local_replicator)
        if local_replicator_threshold is not None:
            pulumi.set(__self__, "local_replicator_threshold", local_replicator_threshold)
        if local_replicator_threshold_variable is not None:
            pulumi.set(__self__, "local_replicator_threshold_variable", local_replicator_threshold_variable)
        if local_replicator_variable is not None:
            pulumi.set(__self__, "local_replicator_variable", local_replicator_variable)
        if msdp_connection_retry_interval is not None:
            pulumi.set(__self__, "msdp_connection_retry_interval", msdp_connection_retry_interval)
        if msdp_connection_retry_interval_variable is not None:
            pulumi.set(__self__, "msdp_connection_retry_interval_variable", msdp_connection_retry_interval_variable)
        if msdp_groups is not None:
            pulumi.set(__self__, "msdp_groups", msdp_groups)
        if msdp_originator_id is not None:
            pulumi.set(__self__, "msdp_originator_id", msdp_originator_id)
        if msdp_originator_id_variable is not None:
            pulumi.set(__self__, "msdp_originator_id_variable", msdp_originator_id_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pim_bsr_candidates is not None:
            pulumi.set(__self__, "pim_bsr_candidates", pim_bsr_candidates)
        if pim_bsr_rp_candidates is not None:
            pulumi.set(__self__, "pim_bsr_rp_candidates", pim_bsr_rp_candidates)
        if pim_interfaces is not None:
            pulumi.set(__self__, "pim_interfaces", pim_interfaces)
        if pim_source_specific_multicast_access_list is not None:
            pulumi.set(__self__, "pim_source_specific_multicast_access_list", pim_source_specific_multicast_access_list)
        if pim_source_specific_multicast_access_list_variable is not None:
            pulumi.set(__self__, "pim_source_specific_multicast_access_list_variable", pim_source_specific_multicast_access_list_variable)
        if pim_spt_threshold is not None:
            pulumi.set(__self__, "pim_spt_threshold", pim_spt_threshold)
        if pim_spt_threshold_variable is not None:
            pulumi.set(__self__, "pim_spt_threshold_variable", pim_spt_threshold_variable)
        if spt_only is not None:
            pulumi.set(__self__, "spt_only", spt_only)
        if spt_only_variable is not None:
            pulumi.set(__self__, "spt_only_variable", spt_only_variable)
        if static_rp_addresses is not None:
            pulumi.set(__self__, "static_rp_addresses", static_rp_addresses)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastEnable")
    def pim_source_specific_multicast_enable(self) -> pulumi.Input[builtins.bool]:
        """
        turn SSM on/off
        """
        return pulumi.get(self, "pim_source_specific_multicast_enable")

    @pim_source_specific_multicast_enable.setter
    def pim_source_specific_multicast_enable(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "pim_source_specific_multicast_enable", value)

    @property
    @pulumi.getter(name="autoRpAnnounces")
    def auto_rp_announces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "auto_rp_announces")

    @auto_rp_announces.setter
    def auto_rp_announces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]]):
        pulumi.set(self, "auto_rp_announces", value)

    @property
    @pulumi.getter(name="autoRpDiscoveries")
    def auto_rp_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]]:
        """
        Enable or disable RP Discovery
        """
        return pulumi.get(self, "auto_rp_discoveries")

    @auto_rp_discoveries.setter
    def auto_rp_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]]):
        pulumi.set(self, "auto_rp_discoveries", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoRp")
    def enable_auto_rp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "enable_auto_rp")

    @enable_auto_rp.setter
    def enable_auto_rp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_auto_rp", value)

    @property
    @pulumi.getter(name="enableAutoRpVariable")
    def enable_auto_rp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_auto_rp_variable")

    @enable_auto_rp_variable.setter
    def enable_auto_rp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_auto_rp_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="igmpInterfaces")
    def igmp_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]]:
        """
        Set IGMP interface parameters
        """
        return pulumi.get(self, "igmp_interfaces")

    @igmp_interfaces.setter
    def igmp_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]]):
        pulumi.set(self, "igmp_interfaces", value)

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @local_replicator.setter
    def local_replicator(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_replicator", value)

    @property
    @pulumi.getter(name="localReplicatorThreshold")
    def local_replicator_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`131072`
        """
        return pulumi.get(self, "local_replicator_threshold")

    @local_replicator_threshold.setter
    def local_replicator_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_replicator_threshold", value)

    @property
    @pulumi.getter(name="localReplicatorThresholdVariable")
    def local_replicator_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_threshold_variable")

    @local_replicator_threshold_variable.setter
    def local_replicator_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_replicator_threshold_variable", value)

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @local_replicator_variable.setter
    def local_replicator_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_replicator_variable", value)

    @property
    @pulumi.getter(name="msdpConnectionRetryInterval")
    def msdp_connection_retry_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set MSDP refresh timer - Range: `1`-`60`
        """
        return pulumi.get(self, "msdp_connection_retry_interval")

    @msdp_connection_retry_interval.setter
    def msdp_connection_retry_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "msdp_connection_retry_interval", value)

    @property
    @pulumi.getter(name="msdpConnectionRetryIntervalVariable")
    def msdp_connection_retry_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_connection_retry_interval_variable")

    @msdp_connection_retry_interval_variable.setter
    def msdp_connection_retry_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_connection_retry_interval_variable", value)

    @property
    @pulumi.getter(name="msdpGroups")
    def msdp_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]]:
        """
        multicast MSDP peer
        """
        return pulumi.get(self, "msdp_groups")

    @msdp_groups.setter
    def msdp_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]]):
        pulumi.set(self, "msdp_groups", value)

    @property
    @pulumi.getter(name="msdpOriginatorId")
    def msdp_originator_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set MSDP originator ID
        """
        return pulumi.get(self, "msdp_originator_id")

    @msdp_originator_id.setter
    def msdp_originator_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_originator_id", value)

    @property
    @pulumi.getter(name="msdpOriginatorIdVariable")
    def msdp_originator_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_originator_id_variable")

    @msdp_originator_id_variable.setter
    def msdp_originator_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_originator_id_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pimBsrCandidates")
    def pim_bsr_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]]:
        """
        bsr candidate Attributes
        """
        return pulumi.get(self, "pim_bsr_candidates")

    @pim_bsr_candidates.setter
    def pim_bsr_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]]):
        pulumi.set(self, "pim_bsr_candidates", value)

    @property
    @pulumi.getter(name="pimBsrRpCandidates")
    def pim_bsr_rp_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "pim_bsr_rp_candidates")

    @pim_bsr_rp_candidates.setter
    def pim_bsr_rp_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]]):
        pulumi.set(self, "pim_bsr_rp_candidates", value)

    @property
    @pulumi.getter(name="pimInterfaces")
    def pim_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "pim_interfaces")

    @pim_interfaces.setter
    def pim_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]]):
        pulumi.set(self, "pim_interfaces", value)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessList")
    def pim_source_specific_multicast_access_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list")

    @pim_source_specific_multicast_access_list.setter
    def pim_source_specific_multicast_access_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_source_specific_multicast_access_list", value)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessListVariable")
    def pim_source_specific_multicast_access_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list_variable")

    @pim_source_specific_multicast_access_list_variable.setter
    def pim_source_specific_multicast_access_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_source_specific_multicast_access_list_variable", value)

    @property
    @pulumi.getter(name="pimSptThreshold")
    def pim_spt_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        """
        return pulumi.get(self, "pim_spt_threshold")

    @pim_spt_threshold.setter
    def pim_spt_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_spt_threshold", value)

    @property
    @pulumi.getter(name="pimSptThresholdVariable")
    def pim_spt_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_spt_threshold_variable")

    @pim_spt_threshold_variable.setter
    def pim_spt_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_spt_threshold_variable", value)

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @spt_only.setter
    def spt_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "spt_only", value)

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @spt_only_variable.setter
    def spt_only_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_only_variable", value)

    @property
    @pulumi.getter(name="staticRpAddresses")
    def static_rp_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "static_rp_addresses")

    @static_rp_addresses.setter
    def static_rp_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]]):
        pulumi.set(self, "static_rp_addresses", value)


@pulumi.input_type
class _ServiceMulticastFeatureState:
    def __init__(__self__, *,
                 auto_rp_announces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]] = None,
                 auto_rp_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 igmp_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]] = None,
                 local_replicator: Optional[pulumi.Input[builtins.bool]] = None,
                 local_replicator_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_replicator_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 local_replicator_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_connection_retry_interval: Optional[pulumi.Input[builtins.int]] = None,
                 msdp_connection_retry_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]] = None,
                 msdp_originator_id: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_originator_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pim_bsr_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]] = None,
                 pim_bsr_rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]] = None,
                 pim_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]] = None,
                 pim_source_specific_multicast_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_enable: Optional[pulumi.Input[builtins.bool]] = None,
                 pim_spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 pim_spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_only: Optional[pulumi.Input[builtins.bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[builtins.str]] = None,
                 static_rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceMulticastFeature resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]] auto_rp_announces: Enable or disable RP Announce
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]] auto_rp_discoveries: Enable or disable RP Discovery
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] enable_auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]] igmp_interfaces: Set IGMP interface parameters
        :param pulumi.Input[builtins.bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[builtins.int] local_replicator_threshold: Set number of joins per group the router supports - Range: `0`-`131072`
        :param pulumi.Input[builtins.str] local_replicator_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] local_replicator_variable: Variable name
        :param pulumi.Input[builtins.int] msdp_connection_retry_interval: Set MSDP refresh timer - Range: `1`-`60`
        :param pulumi.Input[builtins.str] msdp_connection_retry_interval_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]] msdp_groups: multicast MSDP peer
        :param pulumi.Input[builtins.str] msdp_originator_id: Set MSDP originator ID
        :param pulumi.Input[builtins.str] msdp_originator_id_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]] pim_bsr_candidates: bsr candidate Attributes
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]] pim_bsr_rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]] pim_interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list_variable: Variable name
        :param pulumi.Input[builtins.bool] pim_source_specific_multicast_enable: turn SSM on/off
        :param pulumi.Input[builtins.str] pim_spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        :param pulumi.Input[builtins.str] pim_spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[builtins.str] spt_only_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]] static_rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if auto_rp_announces is not None:
            pulumi.set(__self__, "auto_rp_announces", auto_rp_announces)
        if auto_rp_discoveries is not None:
            pulumi.set(__self__, "auto_rp_discoveries", auto_rp_discoveries)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_rp is not None:
            pulumi.set(__self__, "enable_auto_rp", enable_auto_rp)
        if enable_auto_rp_variable is not None:
            pulumi.set(__self__, "enable_auto_rp_variable", enable_auto_rp_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if igmp_interfaces is not None:
            pulumi.set(__self__, "igmp_interfaces", igmp_interfaces)
        if local_replicator is not None:
            pulumi.set(__self__, "local_replicator", local_replicator)
        if local_replicator_threshold is not None:
            pulumi.set(__self__, "local_replicator_threshold", local_replicator_threshold)
        if local_replicator_threshold_variable is not None:
            pulumi.set(__self__, "local_replicator_threshold_variable", local_replicator_threshold_variable)
        if local_replicator_variable is not None:
            pulumi.set(__self__, "local_replicator_variable", local_replicator_variable)
        if msdp_connection_retry_interval is not None:
            pulumi.set(__self__, "msdp_connection_retry_interval", msdp_connection_retry_interval)
        if msdp_connection_retry_interval_variable is not None:
            pulumi.set(__self__, "msdp_connection_retry_interval_variable", msdp_connection_retry_interval_variable)
        if msdp_groups is not None:
            pulumi.set(__self__, "msdp_groups", msdp_groups)
        if msdp_originator_id is not None:
            pulumi.set(__self__, "msdp_originator_id", msdp_originator_id)
        if msdp_originator_id_variable is not None:
            pulumi.set(__self__, "msdp_originator_id_variable", msdp_originator_id_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pim_bsr_candidates is not None:
            pulumi.set(__self__, "pim_bsr_candidates", pim_bsr_candidates)
        if pim_bsr_rp_candidates is not None:
            pulumi.set(__self__, "pim_bsr_rp_candidates", pim_bsr_rp_candidates)
        if pim_interfaces is not None:
            pulumi.set(__self__, "pim_interfaces", pim_interfaces)
        if pim_source_specific_multicast_access_list is not None:
            pulumi.set(__self__, "pim_source_specific_multicast_access_list", pim_source_specific_multicast_access_list)
        if pim_source_specific_multicast_access_list_variable is not None:
            pulumi.set(__self__, "pim_source_specific_multicast_access_list_variable", pim_source_specific_multicast_access_list_variable)
        if pim_source_specific_multicast_enable is not None:
            pulumi.set(__self__, "pim_source_specific_multicast_enable", pim_source_specific_multicast_enable)
        if pim_spt_threshold is not None:
            pulumi.set(__self__, "pim_spt_threshold", pim_spt_threshold)
        if pim_spt_threshold_variable is not None:
            pulumi.set(__self__, "pim_spt_threshold_variable", pim_spt_threshold_variable)
        if spt_only is not None:
            pulumi.set(__self__, "spt_only", spt_only)
        if spt_only_variable is not None:
            pulumi.set(__self__, "spt_only_variable", spt_only_variable)
        if static_rp_addresses is not None:
            pulumi.set(__self__, "static_rp_addresses", static_rp_addresses)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="autoRpAnnounces")
    def auto_rp_announces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "auto_rp_announces")

    @auto_rp_announces.setter
    def auto_rp_announces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpAnnounceArgs']]]]):
        pulumi.set(self, "auto_rp_announces", value)

    @property
    @pulumi.getter(name="autoRpDiscoveries")
    def auto_rp_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]]:
        """
        Enable or disable RP Discovery
        """
        return pulumi.get(self, "auto_rp_discoveries")

    @auto_rp_discoveries.setter
    def auto_rp_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureAutoRpDiscoveryArgs']]]]):
        pulumi.set(self, "auto_rp_discoveries", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoRp")
    def enable_auto_rp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "enable_auto_rp")

    @enable_auto_rp.setter
    def enable_auto_rp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_auto_rp", value)

    @property
    @pulumi.getter(name="enableAutoRpVariable")
    def enable_auto_rp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_auto_rp_variable")

    @enable_auto_rp_variable.setter
    def enable_auto_rp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_auto_rp_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="igmpInterfaces")
    def igmp_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]]:
        """
        Set IGMP interface parameters
        """
        return pulumi.get(self, "igmp_interfaces")

    @igmp_interfaces.setter
    def igmp_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureIgmpInterfaceArgs']]]]):
        pulumi.set(self, "igmp_interfaces", value)

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @local_replicator.setter
    def local_replicator(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_replicator", value)

    @property
    @pulumi.getter(name="localReplicatorThreshold")
    def local_replicator_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`131072`
        """
        return pulumi.get(self, "local_replicator_threshold")

    @local_replicator_threshold.setter
    def local_replicator_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_replicator_threshold", value)

    @property
    @pulumi.getter(name="localReplicatorThresholdVariable")
    def local_replicator_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_threshold_variable")

    @local_replicator_threshold_variable.setter
    def local_replicator_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_replicator_threshold_variable", value)

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @local_replicator_variable.setter
    def local_replicator_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_replicator_variable", value)

    @property
    @pulumi.getter(name="msdpConnectionRetryInterval")
    def msdp_connection_retry_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set MSDP refresh timer - Range: `1`-`60`
        """
        return pulumi.get(self, "msdp_connection_retry_interval")

    @msdp_connection_retry_interval.setter
    def msdp_connection_retry_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "msdp_connection_retry_interval", value)

    @property
    @pulumi.getter(name="msdpConnectionRetryIntervalVariable")
    def msdp_connection_retry_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_connection_retry_interval_variable")

    @msdp_connection_retry_interval_variable.setter
    def msdp_connection_retry_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_connection_retry_interval_variable", value)

    @property
    @pulumi.getter(name="msdpGroups")
    def msdp_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]]:
        """
        multicast MSDP peer
        """
        return pulumi.get(self, "msdp_groups")

    @msdp_groups.setter
    def msdp_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureMsdpGroupArgs']]]]):
        pulumi.set(self, "msdp_groups", value)

    @property
    @pulumi.getter(name="msdpOriginatorId")
    def msdp_originator_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set MSDP originator ID
        """
        return pulumi.get(self, "msdp_originator_id")

    @msdp_originator_id.setter
    def msdp_originator_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_originator_id", value)

    @property
    @pulumi.getter(name="msdpOriginatorIdVariable")
    def msdp_originator_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_originator_id_variable")

    @msdp_originator_id_variable.setter
    def msdp_originator_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "msdp_originator_id_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pimBsrCandidates")
    def pim_bsr_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]]:
        """
        bsr candidate Attributes
        """
        return pulumi.get(self, "pim_bsr_candidates")

    @pim_bsr_candidates.setter
    def pim_bsr_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrCandidateArgs']]]]):
        pulumi.set(self, "pim_bsr_candidates", value)

    @property
    @pulumi.getter(name="pimBsrRpCandidates")
    def pim_bsr_rp_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "pim_bsr_rp_candidates")

    @pim_bsr_rp_candidates.setter
    def pim_bsr_rp_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimBsrRpCandidateArgs']]]]):
        pulumi.set(self, "pim_bsr_rp_candidates", value)

    @property
    @pulumi.getter(name="pimInterfaces")
    def pim_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "pim_interfaces")

    @pim_interfaces.setter
    def pim_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeaturePimInterfaceArgs']]]]):
        pulumi.set(self, "pim_interfaces", value)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessList")
    def pim_source_specific_multicast_access_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list")

    @pim_source_specific_multicast_access_list.setter
    def pim_source_specific_multicast_access_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_source_specific_multicast_access_list", value)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessListVariable")
    def pim_source_specific_multicast_access_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list_variable")

    @pim_source_specific_multicast_access_list_variable.setter
    def pim_source_specific_multicast_access_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_source_specific_multicast_access_list_variable", value)

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastEnable")
    def pim_source_specific_multicast_enable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        turn SSM on/off
        """
        return pulumi.get(self, "pim_source_specific_multicast_enable")

    @pim_source_specific_multicast_enable.setter
    def pim_source_specific_multicast_enable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pim_source_specific_multicast_enable", value)

    @property
    @pulumi.getter(name="pimSptThreshold")
    def pim_spt_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        """
        return pulumi.get(self, "pim_spt_threshold")

    @pim_spt_threshold.setter
    def pim_spt_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_spt_threshold", value)

    @property
    @pulumi.getter(name="pimSptThresholdVariable")
    def pim_spt_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_spt_threshold_variable")

    @pim_spt_threshold_variable.setter
    def pim_spt_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pim_spt_threshold_variable", value)

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @spt_only.setter
    def spt_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "spt_only", value)

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @spt_only_variable.setter
    def spt_only_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_only_variable", value)

    @property
    @pulumi.getter(name="staticRpAddresses")
    def static_rp_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "static_rp_addresses")

    @static_rp_addresses.setter
    def static_rp_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMulticastFeatureStaticRpAddressArgs']]]]):
        pulumi.set(self, "static_rp_addresses", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class ServiceMulticastFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rp_announces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpAnnounceArgs', 'ServiceMulticastFeatureAutoRpAnnounceArgsDict']]]]] = None,
                 auto_rp_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpDiscoveryArgs', 'ServiceMulticastFeatureAutoRpDiscoveryArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 igmp_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureIgmpInterfaceArgs', 'ServiceMulticastFeatureIgmpInterfaceArgsDict']]]]] = None,
                 local_replicator: Optional[pulumi.Input[builtins.bool]] = None,
                 local_replicator_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_replicator_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 local_replicator_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_connection_retry_interval: Optional[pulumi.Input[builtins.int]] = None,
                 msdp_connection_retry_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureMsdpGroupArgs', 'ServiceMulticastFeatureMsdpGroupArgsDict']]]]] = None,
                 msdp_originator_id: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_originator_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pim_bsr_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrCandidateArgs', 'ServiceMulticastFeaturePimBsrCandidateArgsDict']]]]] = None,
                 pim_bsr_rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrRpCandidateArgs', 'ServiceMulticastFeaturePimBsrRpCandidateArgsDict']]]]] = None,
                 pim_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimInterfaceArgs', 'ServiceMulticastFeaturePimInterfaceArgsDict']]]]] = None,
                 pim_source_specific_multicast_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_enable: Optional[pulumi.Input[builtins.bool]] = None,
                 pim_spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 pim_spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_only: Optional[pulumi.Input[builtins.bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[builtins.str]] = None,
                 static_rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureStaticRpAddressArgs', 'ServiceMulticastFeatureStaticRpAddressArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Service Multicast Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_multicast_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceMulticastFeature:ServiceMulticastFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpAnnounceArgs', 'ServiceMulticastFeatureAutoRpAnnounceArgsDict']]]] auto_rp_announces: Enable or disable RP Announce
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpDiscoveryArgs', 'ServiceMulticastFeatureAutoRpDiscoveryArgsDict']]]] auto_rp_discoveries: Enable or disable RP Discovery
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] enable_auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureIgmpInterfaceArgs', 'ServiceMulticastFeatureIgmpInterfaceArgsDict']]]] igmp_interfaces: Set IGMP interface parameters
        :param pulumi.Input[builtins.bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[builtins.int] local_replicator_threshold: Set number of joins per group the router supports - Range: `0`-`131072`
        :param pulumi.Input[builtins.str] local_replicator_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] local_replicator_variable: Variable name
        :param pulumi.Input[builtins.int] msdp_connection_retry_interval: Set MSDP refresh timer - Range: `1`-`60`
        :param pulumi.Input[builtins.str] msdp_connection_retry_interval_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureMsdpGroupArgs', 'ServiceMulticastFeatureMsdpGroupArgsDict']]]] msdp_groups: multicast MSDP peer
        :param pulumi.Input[builtins.str] msdp_originator_id: Set MSDP originator ID
        :param pulumi.Input[builtins.str] msdp_originator_id_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrCandidateArgs', 'ServiceMulticastFeaturePimBsrCandidateArgsDict']]]] pim_bsr_candidates: bsr candidate Attributes
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrRpCandidateArgs', 'ServiceMulticastFeaturePimBsrRpCandidateArgsDict']]]] pim_bsr_rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimInterfaceArgs', 'ServiceMulticastFeaturePimInterfaceArgsDict']]]] pim_interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list_variable: Variable name
        :param pulumi.Input[builtins.bool] pim_source_specific_multicast_enable: turn SSM on/off
        :param pulumi.Input[builtins.str] pim_spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        :param pulumi.Input[builtins.str] pim_spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[builtins.str] spt_only_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureStaticRpAddressArgs', 'ServiceMulticastFeatureStaticRpAddressArgsDict']]]] static_rp_addresses: Set Static RP Address(es)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceMulticastFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Multicast Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_multicast_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceMulticastFeature:ServiceMulticastFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceMulticastFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceMulticastFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rp_announces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpAnnounceArgs', 'ServiceMulticastFeatureAutoRpAnnounceArgsDict']]]]] = None,
                 auto_rp_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpDiscoveryArgs', 'ServiceMulticastFeatureAutoRpDiscoveryArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 igmp_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureIgmpInterfaceArgs', 'ServiceMulticastFeatureIgmpInterfaceArgsDict']]]]] = None,
                 local_replicator: Optional[pulumi.Input[builtins.bool]] = None,
                 local_replicator_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_replicator_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 local_replicator_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_connection_retry_interval: Optional[pulumi.Input[builtins.int]] = None,
                 msdp_connection_retry_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureMsdpGroupArgs', 'ServiceMulticastFeatureMsdpGroupArgsDict']]]]] = None,
                 msdp_originator_id: Optional[pulumi.Input[builtins.str]] = None,
                 msdp_originator_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pim_bsr_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrCandidateArgs', 'ServiceMulticastFeaturePimBsrCandidateArgsDict']]]]] = None,
                 pim_bsr_rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrRpCandidateArgs', 'ServiceMulticastFeaturePimBsrRpCandidateArgsDict']]]]] = None,
                 pim_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimInterfaceArgs', 'ServiceMulticastFeaturePimInterfaceArgsDict']]]]] = None,
                 pim_source_specific_multicast_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 pim_source_specific_multicast_enable: Optional[pulumi.Input[builtins.bool]] = None,
                 pim_spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 pim_spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_only: Optional[pulumi.Input[builtins.bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[builtins.str]] = None,
                 static_rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureStaticRpAddressArgs', 'ServiceMulticastFeatureStaticRpAddressArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceMulticastFeatureArgs.__new__(ServiceMulticastFeatureArgs)

            __props__.__dict__["auto_rp_announces"] = auto_rp_announces
            __props__.__dict__["auto_rp_discoveries"] = auto_rp_discoveries
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_auto_rp"] = enable_auto_rp
            __props__.__dict__["enable_auto_rp_variable"] = enable_auto_rp_variable
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["igmp_interfaces"] = igmp_interfaces
            __props__.__dict__["local_replicator"] = local_replicator
            __props__.__dict__["local_replicator_threshold"] = local_replicator_threshold
            __props__.__dict__["local_replicator_threshold_variable"] = local_replicator_threshold_variable
            __props__.__dict__["local_replicator_variable"] = local_replicator_variable
            __props__.__dict__["msdp_connection_retry_interval"] = msdp_connection_retry_interval
            __props__.__dict__["msdp_connection_retry_interval_variable"] = msdp_connection_retry_interval_variable
            __props__.__dict__["msdp_groups"] = msdp_groups
            __props__.__dict__["msdp_originator_id"] = msdp_originator_id
            __props__.__dict__["msdp_originator_id_variable"] = msdp_originator_id_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["pim_bsr_candidates"] = pim_bsr_candidates
            __props__.__dict__["pim_bsr_rp_candidates"] = pim_bsr_rp_candidates
            __props__.__dict__["pim_interfaces"] = pim_interfaces
            __props__.__dict__["pim_source_specific_multicast_access_list"] = pim_source_specific_multicast_access_list
            __props__.__dict__["pim_source_specific_multicast_access_list_variable"] = pim_source_specific_multicast_access_list_variable
            if pim_source_specific_multicast_enable is None and not opts.urn:
                raise TypeError("Missing required property 'pim_source_specific_multicast_enable'")
            __props__.__dict__["pim_source_specific_multicast_enable"] = pim_source_specific_multicast_enable
            __props__.__dict__["pim_spt_threshold"] = pim_spt_threshold
            __props__.__dict__["pim_spt_threshold_variable"] = pim_spt_threshold_variable
            __props__.__dict__["spt_only"] = spt_only
            __props__.__dict__["spt_only_variable"] = spt_only_variable
            __props__.__dict__["static_rp_addresses"] = static_rp_addresses
            __props__.__dict__["version"] = None
        super(ServiceMulticastFeature, __self__).__init__(
            'sdwan:index/serviceMulticastFeature:ServiceMulticastFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_rp_announces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpAnnounceArgs', 'ServiceMulticastFeatureAutoRpAnnounceArgsDict']]]]] = None,
            auto_rp_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpDiscoveryArgs', 'ServiceMulticastFeatureAutoRpDiscoveryArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
            enable_auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            igmp_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureIgmpInterfaceArgs', 'ServiceMulticastFeatureIgmpInterfaceArgsDict']]]]] = None,
            local_replicator: Optional[pulumi.Input[builtins.bool]] = None,
            local_replicator_threshold: Optional[pulumi.Input[builtins.int]] = None,
            local_replicator_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
            local_replicator_variable: Optional[pulumi.Input[builtins.str]] = None,
            msdp_connection_retry_interval: Optional[pulumi.Input[builtins.int]] = None,
            msdp_connection_retry_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            msdp_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureMsdpGroupArgs', 'ServiceMulticastFeatureMsdpGroupArgsDict']]]]] = None,
            msdp_originator_id: Optional[pulumi.Input[builtins.str]] = None,
            msdp_originator_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pim_bsr_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrCandidateArgs', 'ServiceMulticastFeaturePimBsrCandidateArgsDict']]]]] = None,
            pim_bsr_rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrRpCandidateArgs', 'ServiceMulticastFeaturePimBsrRpCandidateArgsDict']]]]] = None,
            pim_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimInterfaceArgs', 'ServiceMulticastFeaturePimInterfaceArgsDict']]]]] = None,
            pim_source_specific_multicast_access_list: Optional[pulumi.Input[builtins.str]] = None,
            pim_source_specific_multicast_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
            pim_source_specific_multicast_enable: Optional[pulumi.Input[builtins.bool]] = None,
            pim_spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
            pim_spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
            spt_only: Optional[pulumi.Input[builtins.bool]] = None,
            spt_only_variable: Optional[pulumi.Input[builtins.str]] = None,
            static_rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureStaticRpAddressArgs', 'ServiceMulticastFeatureStaticRpAddressArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceMulticastFeature':
        """
        Get an existing ServiceMulticastFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpAnnounceArgs', 'ServiceMulticastFeatureAutoRpAnnounceArgsDict']]]] auto_rp_announces: Enable or disable RP Announce
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureAutoRpDiscoveryArgs', 'ServiceMulticastFeatureAutoRpDiscoveryArgsDict']]]] auto_rp_discoveries: Enable or disable RP Discovery
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] enable_auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureIgmpInterfaceArgs', 'ServiceMulticastFeatureIgmpInterfaceArgsDict']]]] igmp_interfaces: Set IGMP interface parameters
        :param pulumi.Input[builtins.bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[builtins.int] local_replicator_threshold: Set number of joins per group the router supports - Range: `0`-`131072`
        :param pulumi.Input[builtins.str] local_replicator_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] local_replicator_variable: Variable name
        :param pulumi.Input[builtins.int] msdp_connection_retry_interval: Set MSDP refresh timer - Range: `1`-`60`
        :param pulumi.Input[builtins.str] msdp_connection_retry_interval_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureMsdpGroupArgs', 'ServiceMulticastFeatureMsdpGroupArgsDict']]]] msdp_groups: multicast MSDP peer
        :param pulumi.Input[builtins.str] msdp_originator_id: Set MSDP originator ID
        :param pulumi.Input[builtins.str] msdp_originator_id_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrCandidateArgs', 'ServiceMulticastFeaturePimBsrCandidateArgsDict']]]] pim_bsr_candidates: bsr candidate Attributes
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimBsrRpCandidateArgs', 'ServiceMulticastFeaturePimBsrRpCandidateArgsDict']]]] pim_bsr_rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeaturePimInterfaceArgs', 'ServiceMulticastFeaturePimInterfaceArgsDict']]]] pim_interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] pim_source_specific_multicast_access_list_variable: Variable name
        :param pulumi.Input[builtins.bool] pim_source_specific_multicast_enable: turn SSM on/off
        :param pulumi.Input[builtins.str] pim_spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        :param pulumi.Input[builtins.str] pim_spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[builtins.str] spt_only_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceMulticastFeatureStaticRpAddressArgs', 'ServiceMulticastFeatureStaticRpAddressArgsDict']]]] static_rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceMulticastFeatureState.__new__(_ServiceMulticastFeatureState)

        __props__.__dict__["auto_rp_announces"] = auto_rp_announces
        __props__.__dict__["auto_rp_discoveries"] = auto_rp_discoveries
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_auto_rp"] = enable_auto_rp
        __props__.__dict__["enable_auto_rp_variable"] = enable_auto_rp_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["igmp_interfaces"] = igmp_interfaces
        __props__.__dict__["local_replicator"] = local_replicator
        __props__.__dict__["local_replicator_threshold"] = local_replicator_threshold
        __props__.__dict__["local_replicator_threshold_variable"] = local_replicator_threshold_variable
        __props__.__dict__["local_replicator_variable"] = local_replicator_variable
        __props__.__dict__["msdp_connection_retry_interval"] = msdp_connection_retry_interval
        __props__.__dict__["msdp_connection_retry_interval_variable"] = msdp_connection_retry_interval_variable
        __props__.__dict__["msdp_groups"] = msdp_groups
        __props__.__dict__["msdp_originator_id"] = msdp_originator_id
        __props__.__dict__["msdp_originator_id_variable"] = msdp_originator_id_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["pim_bsr_candidates"] = pim_bsr_candidates
        __props__.__dict__["pim_bsr_rp_candidates"] = pim_bsr_rp_candidates
        __props__.__dict__["pim_interfaces"] = pim_interfaces
        __props__.__dict__["pim_source_specific_multicast_access_list"] = pim_source_specific_multicast_access_list
        __props__.__dict__["pim_source_specific_multicast_access_list_variable"] = pim_source_specific_multicast_access_list_variable
        __props__.__dict__["pim_source_specific_multicast_enable"] = pim_source_specific_multicast_enable
        __props__.__dict__["pim_spt_threshold"] = pim_spt_threshold
        __props__.__dict__["pim_spt_threshold_variable"] = pim_spt_threshold_variable
        __props__.__dict__["spt_only"] = spt_only
        __props__.__dict__["spt_only_variable"] = spt_only_variable
        __props__.__dict__["static_rp_addresses"] = static_rp_addresses
        __props__.__dict__["version"] = version
        return ServiceMulticastFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRpAnnounces")
    def auto_rp_announces(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeatureAutoRpAnnounce']]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "auto_rp_announces")

    @property
    @pulumi.getter(name="autoRpDiscoveries")
    def auto_rp_discoveries(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeatureAutoRpDiscovery']]]:
        """
        Enable or disable RP Discovery
        """
        return pulumi.get(self, "auto_rp_discoveries")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableAutoRp")
    def enable_auto_rp(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "enable_auto_rp")

    @property
    @pulumi.getter(name="enableAutoRpVariable")
    def enable_auto_rp_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_auto_rp_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="igmpInterfaces")
    def igmp_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeatureIgmpInterface']]]:
        """
        Set IGMP interface parameters
        """
        return pulumi.get(self, "igmp_interfaces")

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @property
    @pulumi.getter(name="localReplicatorThreshold")
    def local_replicator_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`131072`
        """
        return pulumi.get(self, "local_replicator_threshold")

    @property
    @pulumi.getter(name="localReplicatorThresholdVariable")
    def local_replicator_threshold_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_threshold_variable")

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @property
    @pulumi.getter(name="msdpConnectionRetryInterval")
    def msdp_connection_retry_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set MSDP refresh timer - Range: `1`-`60`
        """
        return pulumi.get(self, "msdp_connection_retry_interval")

    @property
    @pulumi.getter(name="msdpConnectionRetryIntervalVariable")
    def msdp_connection_retry_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_connection_retry_interval_variable")

    @property
    @pulumi.getter(name="msdpGroups")
    def msdp_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeatureMsdpGroup']]]:
        """
        multicast MSDP peer
        """
        return pulumi.get(self, "msdp_groups")

    @property
    @pulumi.getter(name="msdpOriginatorId")
    def msdp_originator_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set MSDP originator ID
        """
        return pulumi.get(self, "msdp_originator_id")

    @property
    @pulumi.getter(name="msdpOriginatorIdVariable")
    def msdp_originator_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "msdp_originator_id_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pimBsrCandidates")
    def pim_bsr_candidates(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeaturePimBsrCandidate']]]:
        """
        bsr candidate Attributes
        """
        return pulumi.get(self, "pim_bsr_candidates")

    @property
    @pulumi.getter(name="pimBsrRpCandidates")
    def pim_bsr_rp_candidates(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeaturePimBsrRpCandidate']]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "pim_bsr_rp_candidates")

    @property
    @pulumi.getter(name="pimInterfaces")
    def pim_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeaturePimInterface']]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "pim_interfaces")

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessList")
    def pim_source_specific_multicast_access_list(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list")

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastAccessListVariable")
    def pim_source_specific_multicast_access_list_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_source_specific_multicast_access_list_variable")

    @property
    @pulumi.getter(name="pimSourceSpecificMulticastEnable")
    def pim_source_specific_multicast_enable(self) -> pulumi.Output[builtins.bool]:
        """
        turn SSM on/off
        """
        return pulumi.get(self, "pim_source_specific_multicast_enable")

    @property
    @pulumi.getter(name="pimSptThreshold")
    def pim_spt_threshold(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity` - Default value: `0`
        """
        return pulumi.get(self, "pim_spt_threshold")

    @property
    @pulumi.getter(name="pimSptThresholdVariable")
    def pim_spt_threshold_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pim_spt_threshold_variable")

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @property
    @pulumi.getter(name="staticRpAddresses")
    def static_rp_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceMulticastFeatureStaticRpAddress']]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "static_rp_addresses")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

