# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceRoutingEigrpFeatureArgs', 'ServiceRoutingEigrpFeature']

@pulumi.input_type
class ServiceRoutingEigrpFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 networks: pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]],
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_system_id: Optional[pulumi.Input[builtins.int]] = None,
                 autonomous_system_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]] = None,
                 md5_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]] = None,
                 route_policy_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceRoutingEigrpFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]] networks: Configure the networks for EIGRP to advertise
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.int] autonomous_system_id: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] autonomous_system_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]] md5_keys: Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]] redistributes: Redistribute routes into EIGRP
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "networks", networks)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if autonomous_system_id is not None:
            pulumi.set(__self__, "autonomous_system_id", autonomous_system_id)
        if autonomous_system_id_variable is not None:
            pulumi.set(__self__, "autonomous_system_id_variable", autonomous_system_id_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filter_variable is not None:
            pulumi.set(__self__, "filter_variable", filter_variable)
        if hello_interval is not None:
            pulumi.set(__self__, "hello_interval", hello_interval)
        if hello_interval_variable is not None:
            pulumi.set(__self__, "hello_interval_variable", hello_interval_variable)
        if hmac_authentication_key is not None:
            pulumi.set(__self__, "hmac_authentication_key", hmac_authentication_key)
        if hmac_authentication_key_variable is not None:
            pulumi.set(__self__, "hmac_authentication_key_variable", hmac_authentication_key_variable)
        if hold_time is not None:
            pulumi.set(__self__, "hold_time", hold_time)
        if hold_time_variable is not None:
            pulumi.set(__self__, "hold_time_variable", hold_time_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if md5_keys is not None:
            pulumi.set(__self__, "md5_keys", md5_keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redistributes is not None:
            pulumi.set(__self__, "redistributes", redistributes)
        if route_policy_id is not None:
            pulumi.set(__self__, "route_policy_id", route_policy_id)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]]:
        """
        Configure the networks for EIGRP to advertise
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter(name="autonomousSystemId")
    def autonomous_system_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "autonomous_system_id")

    @autonomous_system_id.setter
    def autonomous_system_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "autonomous_system_id", value)

    @property
    @pulumi.getter(name="autonomousSystemIdVariable")
    def autonomous_system_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "autonomous_system_id_variable")

    @autonomous_system_id_variable.setter
    def autonomous_system_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_system_id_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @filter_variable.setter
    def filter_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_variable", value)

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @hello_interval.setter
    def hello_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_interval", value)

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @hello_interval_variable.setter
    def hello_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hello_interval_variable", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        """
        return pulumi.get(self, "hmac_authentication_key")

    @hmac_authentication_key.setter
    def hmac_authentication_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @hmac_authentication_key_variable.setter
    def hmac_authentication_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key_variable", value)

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @hold_time.setter
    def hold_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hold_time", value)

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @hold_time_variable.setter
    def hold_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hold_time_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="md5Keys")
    def md5_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]]:
        """
        Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        """
        return pulumi.get(self, "md5_keys")

    @md5_keys.setter
    def md5_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]]):
        pulumi.set(self, "md5_keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]]:
        """
        Redistribute routes into EIGRP
        """
        return pulumi.get(self, "redistributes")

    @redistributes.setter
    def redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]]):
        pulumi.set(self, "redistributes", value)

    @property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "route_policy_id")

    @route_policy_id.setter
    def route_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_id", value)


@pulumi.input_type
class _ServiceRoutingEigrpFeatureState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_system_id: Optional[pulumi.Input[builtins.int]] = None,
                 autonomous_system_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]] = None,
                 md5_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]] = None,
                 route_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceRoutingEigrpFeature resources.
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.int] autonomous_system_id: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] autonomous_system_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]] md5_keys: Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]] networks: Configure the networks for EIGRP to advertise
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]] redistributes: Redistribute routes into EIGRP
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if autonomous_system_id is not None:
            pulumi.set(__self__, "autonomous_system_id", autonomous_system_id)
        if autonomous_system_id_variable is not None:
            pulumi.set(__self__, "autonomous_system_id_variable", autonomous_system_id_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filter_variable is not None:
            pulumi.set(__self__, "filter_variable", filter_variable)
        if hello_interval is not None:
            pulumi.set(__self__, "hello_interval", hello_interval)
        if hello_interval_variable is not None:
            pulumi.set(__self__, "hello_interval_variable", hello_interval_variable)
        if hmac_authentication_key is not None:
            pulumi.set(__self__, "hmac_authentication_key", hmac_authentication_key)
        if hmac_authentication_key_variable is not None:
            pulumi.set(__self__, "hmac_authentication_key_variable", hmac_authentication_key_variable)
        if hold_time is not None:
            pulumi.set(__self__, "hold_time", hold_time)
        if hold_time_variable is not None:
            pulumi.set(__self__, "hold_time_variable", hold_time_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if md5_keys is not None:
            pulumi.set(__self__, "md5_keys", md5_keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if redistributes is not None:
            pulumi.set(__self__, "redistributes", redistributes)
        if route_policy_id is not None:
            pulumi.set(__self__, "route_policy_id", route_policy_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter(name="autonomousSystemId")
    def autonomous_system_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "autonomous_system_id")

    @autonomous_system_id.setter
    def autonomous_system_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "autonomous_system_id", value)

    @property
    @pulumi.getter(name="autonomousSystemIdVariable")
    def autonomous_system_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "autonomous_system_id_variable")

    @autonomous_system_id_variable.setter
    def autonomous_system_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_system_id_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @filter_variable.setter
    def filter_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_variable", value)

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @hello_interval.setter
    def hello_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_interval", value)

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @hello_interval_variable.setter
    def hello_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hello_interval_variable", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        """
        return pulumi.get(self, "hmac_authentication_key")

    @hmac_authentication_key.setter
    def hmac_authentication_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key", value)

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @hmac_authentication_key_variable.setter
    def hmac_authentication_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hmac_authentication_key_variable", value)

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @hold_time.setter
    def hold_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hold_time", value)

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @hold_time_variable.setter
    def hold_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hold_time_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="md5Keys")
    def md5_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]]:
        """
        Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        """
        return pulumi.get(self, "md5_keys")

    @md5_keys.setter
    def md5_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureMd5KeyArgs']]]]):
        pulumi.set(self, "md5_keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]]]:
        """
        Configure the networks for EIGRP to advertise
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]]:
        """
        Redistribute routes into EIGRP
        """
        return pulumi.get(self, "redistributes")

    @redistributes.setter
    def redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutingEigrpFeatureRedistributeArgs']]]]):
        pulumi.set(self, "redistributes", value)

    @property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "route_policy_id")

    @route_policy_id.setter
    def route_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_policy_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class ServiceRoutingEigrpFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_system_id: Optional[pulumi.Input[builtins.int]] = None,
                 autonomous_system_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureInterfaceArgs', 'ServiceRoutingEigrpFeatureInterfaceArgsDict']]]]] = None,
                 md5_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureMd5KeyArgs', 'ServiceRoutingEigrpFeatureMd5KeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureNetworkArgs', 'ServiceRoutingEigrpFeatureNetworkArgsDict']]]]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureRedistributeArgs', 'ServiceRoutingEigrpFeatureRedistributeArgsDict']]]]] = None,
                 route_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service Routing EIGRP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_routing_eigrp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceRoutingEigrpFeature:ServiceRoutingEigrpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.int] autonomous_system_id: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] autonomous_system_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureInterfaceArgs', 'ServiceRoutingEigrpFeatureInterfaceArgsDict']]]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureMd5KeyArgs', 'ServiceRoutingEigrpFeatureMd5KeyArgsDict']]]] md5_keys: Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureNetworkArgs', 'ServiceRoutingEigrpFeatureNetworkArgsDict']]]] networks: Configure the networks for EIGRP to advertise
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureRedistributeArgs', 'ServiceRoutingEigrpFeatureRedistributeArgsDict']]]] redistributes: Redistribute routes into EIGRP
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceRoutingEigrpFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Routing EIGRP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_routing_eigrp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceRoutingEigrpFeature:ServiceRoutingEigrpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceRoutingEigrpFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceRoutingEigrpFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_system_id: Optional[pulumi.Input[builtins.int]] = None,
                 autonomous_system_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.bool]] = None,
                 filter_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hello_interval: Optional[pulumi.Input[builtins.int]] = None,
                 hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
                 hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hold_time: Optional[pulumi.Input[builtins.int]] = None,
                 hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureInterfaceArgs', 'ServiceRoutingEigrpFeatureInterfaceArgsDict']]]]] = None,
                 md5_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureMd5KeyArgs', 'ServiceRoutingEigrpFeatureMd5KeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureNetworkArgs', 'ServiceRoutingEigrpFeatureNetworkArgsDict']]]]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureRedistributeArgs', 'ServiceRoutingEigrpFeatureRedistributeArgsDict']]]]] = None,
                 route_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceRoutingEigrpFeatureArgs.__new__(ServiceRoutingEigrpFeatureArgs)

            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            __props__.__dict__["autonomous_system_id"] = autonomous_system_id
            __props__.__dict__["autonomous_system_id_variable"] = autonomous_system_id_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["filter"] = filter
            __props__.__dict__["filter_variable"] = filter_variable
            __props__.__dict__["hello_interval"] = hello_interval
            __props__.__dict__["hello_interval_variable"] = hello_interval_variable
            __props__.__dict__["hmac_authentication_key"] = hmac_authentication_key
            __props__.__dict__["hmac_authentication_key_variable"] = hmac_authentication_key_variable
            __props__.__dict__["hold_time"] = hold_time
            __props__.__dict__["hold_time_variable"] = hold_time_variable
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["md5_keys"] = md5_keys
            __props__.__dict__["name"] = name
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["redistributes"] = redistributes
            __props__.__dict__["route_policy_id"] = route_policy_id
            __props__.__dict__["version"] = None
        super(ServiceRoutingEigrpFeature, __self__).__init__(
            'sdwan:index/serviceRoutingEigrpFeature:ServiceRoutingEigrpFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_system_id: Optional[pulumi.Input[builtins.int]] = None,
            autonomous_system_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            filter: Optional[pulumi.Input[builtins.bool]] = None,
            filter_variable: Optional[pulumi.Input[builtins.str]] = None,
            hello_interval: Optional[pulumi.Input[builtins.int]] = None,
            hello_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            hmac_authentication_key: Optional[pulumi.Input[builtins.str]] = None,
            hmac_authentication_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            hold_time: Optional[pulumi.Input[builtins.int]] = None,
            hold_time_variable: Optional[pulumi.Input[builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureInterfaceArgs', 'ServiceRoutingEigrpFeatureInterfaceArgsDict']]]]] = None,
            md5_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureMd5KeyArgs', 'ServiceRoutingEigrpFeatureMd5KeyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureNetworkArgs', 'ServiceRoutingEigrpFeatureNetworkArgsDict']]]]] = None,
            redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureRedistributeArgs', 'ServiceRoutingEigrpFeatureRedistributeArgsDict']]]]] = None,
            route_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceRoutingEigrpFeature':
        """
        Get an existing ServiceRoutingEigrpFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_type: Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.int] autonomous_system_id: Set autonomous system ID <1..65535> - Range: `1`-`65535`
        :param pulumi.Input[builtins.str] autonomous_system_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] filter: Selective route download - Default value: `false`
        :param pulumi.Input[builtins.str] filter_variable: Variable name
        :param pulumi.Input[builtins.int] hello_interval: Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        :param pulumi.Input[builtins.str] hello_interval_variable: Variable name
        :param pulumi.Input[builtins.str] hmac_authentication_key: Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        :param pulumi.Input[builtins.str] hmac_authentication_key_variable: Variable name
        :param pulumi.Input[builtins.int] hold_time: Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        :param pulumi.Input[builtins.str] hold_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureInterfaceArgs', 'ServiceRoutingEigrpFeatureInterfaceArgsDict']]]] interfaces: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureMd5KeyArgs', 'ServiceRoutingEigrpFeatureMd5KeyArgsDict']]]] md5_keys: Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureNetworkArgs', 'ServiceRoutingEigrpFeatureNetworkArgsDict']]]] networks: Configure the networks for EIGRP to advertise
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutingEigrpFeatureRedistributeArgs', 'ServiceRoutingEigrpFeatureRedistributeArgsDict']]]] redistributes: Redistribute routes into EIGRP
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceRoutingEigrpFeatureState.__new__(_ServiceRoutingEigrpFeatureState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["autonomous_system_id"] = autonomous_system_id
        __props__.__dict__["autonomous_system_id_variable"] = autonomous_system_id_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["filter"] = filter
        __props__.__dict__["filter_variable"] = filter_variable
        __props__.__dict__["hello_interval"] = hello_interval
        __props__.__dict__["hello_interval_variable"] = hello_interval_variable
        __props__.__dict__["hmac_authentication_key"] = hmac_authentication_key
        __props__.__dict__["hmac_authentication_key_variable"] = hmac_authentication_key_variable
        __props__.__dict__["hold_time"] = hold_time
        __props__.__dict__["hold_time_variable"] = hold_time_variable
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["md5_keys"] = md5_keys
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["redistributes"] = redistributes
        __props__.__dict__["route_policy_id"] = route_policy_id
        __props__.__dict__["version"] = version
        return ServiceRoutingEigrpFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set EIGRP router authentication type - Choices: `md5`, `hmac-sha-256`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @property
    @pulumi.getter(name="autonomousSystemId")
    def autonomous_system_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set autonomous system ID <1..65535> - Range: `1`-`65535`
        """
        return pulumi.get(self, "autonomous_system_id")

    @property
    @pulumi.getter(name="autonomousSystemIdVariable")
    def autonomous_system_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "autonomous_system_id_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Selective route download - Default value: `false`
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterVariable")
    def filter_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "filter_variable")

    @property
    @pulumi.getter(name="helloInterval")
    def hello_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set EIGRP hello interval - Range: `0`-`65535` - Default value: `5`
        """
        return pulumi.get(self, "hello_interval")

    @property
    @pulumi.getter(name="helloIntervalVariable")
    def hello_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hello_interval_variable")

    @property
    @pulumi.getter(name="hmacAuthenticationKey")
    def hmac_authentication_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set hmac-sha-256 authentication key, Attribute conditional on `authentication_type` being equal to `hmac-sha-256`
        """
        return pulumi.get(self, "hmac_authentication_key")

    @property
    @pulumi.getter(name="hmacAuthenticationKeyVariable")
    def hmac_authentication_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hmac_authentication_key_variable")

    @property
    @pulumi.getter(name="holdTime")
    def hold_time(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set EIGRP hold time - Range: `0`-`65535` - Default value: `15`
        """
        return pulumi.get(self, "hold_time")

    @property
    @pulumi.getter(name="holdTimeVariable")
    def hold_time_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hold_time_variable")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceRoutingEigrpFeatureInterface']]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="md5Keys")
    def md5_keys(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceRoutingEigrpFeatureMd5Key']]]:
        """
        Set keychain details, Attribute conditional on `authentication_type` being equal to `md5`
        """
        return pulumi.get(self, "md5_keys")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.ServiceRoutingEigrpFeatureNetwork']]:
        """
        Configure the networks for EIGRP to advertise
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def redistributes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceRoutingEigrpFeatureRedistribute']]]:
        """
        Redistribute routes into EIGRP
        """
        return pulumi.get(self, "redistributes")

    @property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "route_policy_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

