# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TransportTrackerFeatureArgs', 'TransportTrackerFeature']

@pulumi.input_type
class TransportTrackerFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.int]] = None,
                 threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TransportTrackerFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] endpoint_api_url: API url of endpoint
        :param pulumi.Input[builtins.str] endpoint_api_url_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_dns_name: Endpoint DNS Name
        :param pulumi.Input[builtins.str] endpoint_dns_name_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_ip: Endpoint IP
        :param pulumi.Input[builtins.str] endpoint_ip_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_tracker_type: Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        :param pulumi.Input[builtins.str] endpoint_tracker_type_variable: Variable name
        :param pulumi.Input[builtins.int] interval: Interval - Range: `20`-`600` - Default value: `60`
        :param pulumi.Input[builtins.str] interval_variable: Variable name
        :param pulumi.Input[builtins.int] multiplier: Multiplier - Range: `1`-`10` - Default value: `3`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] threshold: Threshold - Range: `100`-`1000` - Default value: `300`
        :param pulumi.Input[builtins.str] threshold_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_name: Tracker Name
        :param pulumi.Input[builtins.str] tracker_name_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_type: Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        :param pulumi.Input[builtins.str] tracker_type_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_api_url is not None:
            pulumi.set(__self__, "endpoint_api_url", endpoint_api_url)
        if endpoint_api_url_variable is not None:
            pulumi.set(__self__, "endpoint_api_url_variable", endpoint_api_url_variable)
        if endpoint_dns_name is not None:
            pulumi.set(__self__, "endpoint_dns_name", endpoint_dns_name)
        if endpoint_dns_name_variable is not None:
            pulumi.set(__self__, "endpoint_dns_name_variable", endpoint_dns_name_variable)
        if endpoint_ip is not None:
            pulumi.set(__self__, "endpoint_ip", endpoint_ip)
        if endpoint_ip_variable is not None:
            pulumi.set(__self__, "endpoint_ip_variable", endpoint_ip_variable)
        if endpoint_tracker_type is not None:
            pulumi.set(__self__, "endpoint_tracker_type", endpoint_tracker_type)
        if endpoint_tracker_type_variable is not None:
            pulumi.set(__self__, "endpoint_tracker_type_variable", endpoint_tracker_type_variable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_variable is not None:
            pulumi.set(__self__, "interval_variable", interval_variable)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_variable is not None:
            pulumi.set(__self__, "threshold_variable", threshold_variable)
        if tracker_name is not None:
            pulumi.set(__self__, "tracker_name", tracker_name)
        if tracker_name_variable is not None:
            pulumi.set(__self__, "tracker_name_variable", tracker_name_variable)
        if tracker_type is not None:
            pulumi.set(__self__, "tracker_type", tracker_type)
        if tracker_type_variable is not None:
            pulumi.set(__self__, "tracker_type_variable", tracker_type_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointApiUrl")
    def endpoint_api_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API url of endpoint
        """
        return pulumi.get(self, "endpoint_api_url")

    @endpoint_api_url.setter
    def endpoint_api_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_api_url", value)

    @property
    @pulumi.getter(name="endpointApiUrlVariable")
    def endpoint_api_url_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_api_url_variable")

    @endpoint_api_url_variable.setter
    def endpoint_api_url_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_api_url_variable", value)

    @property
    @pulumi.getter(name="endpointDnsName")
    def endpoint_dns_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint DNS Name
        """
        return pulumi.get(self, "endpoint_dns_name")

    @endpoint_dns_name.setter
    def endpoint_dns_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_dns_name", value)

    @property
    @pulumi.getter(name="endpointDnsNameVariable")
    def endpoint_dns_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_dns_name_variable")

    @endpoint_dns_name_variable.setter
    def endpoint_dns_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_dns_name_variable", value)

    @property
    @pulumi.getter(name="endpointIp")
    def endpoint_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint IP
        """
        return pulumi.get(self, "endpoint_ip")

    @endpoint_ip.setter
    def endpoint_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_ip", value)

    @property
    @pulumi.getter(name="endpointIpVariable")
    def endpoint_ip_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_ip_variable")

    @endpoint_ip_variable.setter
    def endpoint_ip_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_ip_variable", value)

    @property
    @pulumi.getter(name="endpointTrackerType")
    def endpoint_tracker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        """
        return pulumi.get(self, "endpoint_tracker_type")

    @endpoint_tracker_type.setter
    def endpoint_tracker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_tracker_type", value)

    @property
    @pulumi.getter(name="endpointTrackerTypeVariable")
    def endpoint_tracker_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_tracker_type_variable")

    @endpoint_tracker_type_variable.setter
    def endpoint_tracker_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_tracker_type_variable", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval - Range: `20`-`600` - Default value: `60`
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="intervalVariable")
    def interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interval_variable")

    @interval_variable.setter
    def interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interval_variable", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Multiplier - Range: `1`-`10` - Default value: `3`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Threshold - Range: `100`-`1000` - Default value: `300`
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @threshold_variable.setter
    def threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold_variable", value)

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tracker Name
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_name", value)

    @property
    @pulumi.getter(name="trackerNameVariable")
    def tracker_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_name_variable")

    @tracker_name_variable.setter
    def tracker_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_name_variable", value)

    @property
    @pulumi.getter(name="trackerType")
    def tracker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        """
        return pulumi.get(self, "tracker_type")

    @tracker_type.setter
    def tracker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_type", value)

    @property
    @pulumi.getter(name="trackerTypeVariable")
    def tracker_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_type_variable")

    @tracker_type_variable.setter
    def tracker_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_type_variable", value)


@pulumi.input_type
class _TransportTrackerFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.int]] = None,
                 threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering TransportTrackerFeature resources.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] endpoint_api_url: API url of endpoint
        :param pulumi.Input[builtins.str] endpoint_api_url_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_dns_name: Endpoint DNS Name
        :param pulumi.Input[builtins.str] endpoint_dns_name_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_ip: Endpoint IP
        :param pulumi.Input[builtins.str] endpoint_ip_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_tracker_type: Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        :param pulumi.Input[builtins.str] endpoint_tracker_type_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] interval: Interval - Range: `20`-`600` - Default value: `60`
        :param pulumi.Input[builtins.str] interval_variable: Variable name
        :param pulumi.Input[builtins.int] multiplier: Multiplier - Range: `1`-`10` - Default value: `3`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] threshold: Threshold - Range: `100`-`1000` - Default value: `300`
        :param pulumi.Input[builtins.str] threshold_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_name: Tracker Name
        :param pulumi.Input[builtins.str] tracker_name_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_type: Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        :param pulumi.Input[builtins.str] tracker_type_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_api_url is not None:
            pulumi.set(__self__, "endpoint_api_url", endpoint_api_url)
        if endpoint_api_url_variable is not None:
            pulumi.set(__self__, "endpoint_api_url_variable", endpoint_api_url_variable)
        if endpoint_dns_name is not None:
            pulumi.set(__self__, "endpoint_dns_name", endpoint_dns_name)
        if endpoint_dns_name_variable is not None:
            pulumi.set(__self__, "endpoint_dns_name_variable", endpoint_dns_name_variable)
        if endpoint_ip is not None:
            pulumi.set(__self__, "endpoint_ip", endpoint_ip)
        if endpoint_ip_variable is not None:
            pulumi.set(__self__, "endpoint_ip_variable", endpoint_ip_variable)
        if endpoint_tracker_type is not None:
            pulumi.set(__self__, "endpoint_tracker_type", endpoint_tracker_type)
        if endpoint_tracker_type_variable is not None:
            pulumi.set(__self__, "endpoint_tracker_type_variable", endpoint_tracker_type_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_variable is not None:
            pulumi.set(__self__, "interval_variable", interval_variable)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_variable is not None:
            pulumi.set(__self__, "threshold_variable", threshold_variable)
        if tracker_name is not None:
            pulumi.set(__self__, "tracker_name", tracker_name)
        if tracker_name_variable is not None:
            pulumi.set(__self__, "tracker_name_variable", tracker_name_variable)
        if tracker_type is not None:
            pulumi.set(__self__, "tracker_type", tracker_type)
        if tracker_type_variable is not None:
            pulumi.set(__self__, "tracker_type_variable", tracker_type_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointApiUrl")
    def endpoint_api_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API url of endpoint
        """
        return pulumi.get(self, "endpoint_api_url")

    @endpoint_api_url.setter
    def endpoint_api_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_api_url", value)

    @property
    @pulumi.getter(name="endpointApiUrlVariable")
    def endpoint_api_url_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_api_url_variable")

    @endpoint_api_url_variable.setter
    def endpoint_api_url_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_api_url_variable", value)

    @property
    @pulumi.getter(name="endpointDnsName")
    def endpoint_dns_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint DNS Name
        """
        return pulumi.get(self, "endpoint_dns_name")

    @endpoint_dns_name.setter
    def endpoint_dns_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_dns_name", value)

    @property
    @pulumi.getter(name="endpointDnsNameVariable")
    def endpoint_dns_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_dns_name_variable")

    @endpoint_dns_name_variable.setter
    def endpoint_dns_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_dns_name_variable", value)

    @property
    @pulumi.getter(name="endpointIp")
    def endpoint_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint IP
        """
        return pulumi.get(self, "endpoint_ip")

    @endpoint_ip.setter
    def endpoint_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_ip", value)

    @property
    @pulumi.getter(name="endpointIpVariable")
    def endpoint_ip_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_ip_variable")

    @endpoint_ip_variable.setter
    def endpoint_ip_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_ip_variable", value)

    @property
    @pulumi.getter(name="endpointTrackerType")
    def endpoint_tracker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        """
        return pulumi.get(self, "endpoint_tracker_type")

    @endpoint_tracker_type.setter
    def endpoint_tracker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_tracker_type", value)

    @property
    @pulumi.getter(name="endpointTrackerTypeVariable")
    def endpoint_tracker_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_tracker_type_variable")

    @endpoint_tracker_type_variable.setter
    def endpoint_tracker_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_tracker_type_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval - Range: `20`-`600` - Default value: `60`
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="intervalVariable")
    def interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interval_variable")

    @interval_variable.setter
    def interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interval_variable", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Multiplier - Range: `1`-`10` - Default value: `3`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Threshold - Range: `100`-`1000` - Default value: `300`
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @threshold_variable.setter
    def threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold_variable", value)

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tracker Name
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_name", value)

    @property
    @pulumi.getter(name="trackerNameVariable")
    def tracker_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_name_variable")

    @tracker_name_variable.setter
    def tracker_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_name_variable", value)

    @property
    @pulumi.getter(name="trackerType")
    def tracker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        """
        return pulumi.get(self, "tracker_type")

    @tracker_type.setter
    def tracker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_type", value)

    @property
    @pulumi.getter(name="trackerTypeVariable")
    def tracker_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_type_variable")

    @tracker_type_variable.setter
    def tracker_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tracker_type_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class TransportTrackerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.int]] = None,
                 threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Transport Tracker Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportTrackerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            tracker_name="TRACKER_1",
            endpoint_api_url="google.com",
            endpoint_dns_name="google.com",
            endpoint_ip="1.2.3.4",
            interval=30,
            multiplier=3,
            threshold=300,
            endpoint_tracker_type="interface",
            tracker_type="endpoint")
        ```

        ## Import

        Expected import identifier with the format: "transport_tracker_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportTrackerFeature:TransportTrackerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] endpoint_api_url: API url of endpoint
        :param pulumi.Input[builtins.str] endpoint_api_url_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_dns_name: Endpoint DNS Name
        :param pulumi.Input[builtins.str] endpoint_dns_name_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_ip: Endpoint IP
        :param pulumi.Input[builtins.str] endpoint_ip_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_tracker_type: Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        :param pulumi.Input[builtins.str] endpoint_tracker_type_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] interval: Interval - Range: `20`-`600` - Default value: `60`
        :param pulumi.Input[builtins.str] interval_variable: Variable name
        :param pulumi.Input[builtins.int] multiplier: Multiplier - Range: `1`-`10` - Default value: `3`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] threshold: Threshold - Range: `100`-`1000` - Default value: `300`
        :param pulumi.Input[builtins.str] threshold_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_name: Tracker Name
        :param pulumi.Input[builtins.str] tracker_name_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_type: Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        :param pulumi.Input[builtins.str] tracker_type_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransportTrackerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Transport Tracker Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportTrackerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            tracker_name="TRACKER_1",
            endpoint_api_url="google.com",
            endpoint_dns_name="google.com",
            endpoint_ip="1.2.3.4",
            interval=30,
            multiplier=3,
            threshold=300,
            endpoint_tracker_type="interface",
            tracker_type="endpoint")
        ```

        ## Import

        Expected import identifier with the format: "transport_tracker_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportTrackerFeature:TransportTrackerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param TransportTrackerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportTrackerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_api_url_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_dns_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.int]] = None,
                 threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportTrackerFeatureArgs.__new__(TransportTrackerFeatureArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["endpoint_api_url"] = endpoint_api_url
            __props__.__dict__["endpoint_api_url_variable"] = endpoint_api_url_variable
            __props__.__dict__["endpoint_dns_name"] = endpoint_dns_name
            __props__.__dict__["endpoint_dns_name_variable"] = endpoint_dns_name_variable
            __props__.__dict__["endpoint_ip"] = endpoint_ip
            __props__.__dict__["endpoint_ip_variable"] = endpoint_ip_variable
            __props__.__dict__["endpoint_tracker_type"] = endpoint_tracker_type
            __props__.__dict__["endpoint_tracker_type_variable"] = endpoint_tracker_type_variable
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interval"] = interval
            __props__.__dict__["interval_variable"] = interval_variable
            __props__.__dict__["multiplier"] = multiplier
            __props__.__dict__["multiplier_variable"] = multiplier_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["threshold_variable"] = threshold_variable
            __props__.__dict__["tracker_name"] = tracker_name
            __props__.__dict__["tracker_name_variable"] = tracker_name_variable
            __props__.__dict__["tracker_type"] = tracker_type
            __props__.__dict__["tracker_type_variable"] = tracker_type_variable
            __props__.__dict__["version"] = None
        super(TransportTrackerFeature, __self__).__init__(
            'sdwan:index/transportTrackerFeature:TransportTrackerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_api_url: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_api_url_variable: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_dns_name: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_dns_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            multiplier: Optional[pulumi.Input[builtins.int]] = None,
            multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            threshold: Optional[pulumi.Input[builtins.int]] = None,
            threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
            tracker_name: Optional[pulumi.Input[builtins.str]] = None,
            tracker_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            tracker_type: Optional[pulumi.Input[builtins.str]] = None,
            tracker_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'TransportTrackerFeature':
        """
        Get an existing TransportTrackerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] endpoint_api_url: API url of endpoint
        :param pulumi.Input[builtins.str] endpoint_api_url_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_dns_name: Endpoint DNS Name
        :param pulumi.Input[builtins.str] endpoint_dns_name_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_ip: Endpoint IP
        :param pulumi.Input[builtins.str] endpoint_ip_variable: Variable name
        :param pulumi.Input[builtins.str] endpoint_tracker_type: Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        :param pulumi.Input[builtins.str] endpoint_tracker_type_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] interval: Interval - Range: `20`-`600` - Default value: `60`
        :param pulumi.Input[builtins.str] interval_variable: Variable name
        :param pulumi.Input[builtins.int] multiplier: Multiplier - Range: `1`-`10` - Default value: `3`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] threshold: Threshold - Range: `100`-`1000` - Default value: `300`
        :param pulumi.Input[builtins.str] threshold_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_name: Tracker Name
        :param pulumi.Input[builtins.str] tracker_name_variable: Variable name
        :param pulumi.Input[builtins.str] tracker_type: Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        :param pulumi.Input[builtins.str] tracker_type_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportTrackerFeatureState.__new__(_TransportTrackerFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_api_url"] = endpoint_api_url
        __props__.__dict__["endpoint_api_url_variable"] = endpoint_api_url_variable
        __props__.__dict__["endpoint_dns_name"] = endpoint_dns_name
        __props__.__dict__["endpoint_dns_name_variable"] = endpoint_dns_name_variable
        __props__.__dict__["endpoint_ip"] = endpoint_ip
        __props__.__dict__["endpoint_ip_variable"] = endpoint_ip_variable
        __props__.__dict__["endpoint_tracker_type"] = endpoint_tracker_type
        __props__.__dict__["endpoint_tracker_type_variable"] = endpoint_tracker_type_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interval"] = interval
        __props__.__dict__["interval_variable"] = interval_variable
        __props__.__dict__["multiplier"] = multiplier
        __props__.__dict__["multiplier_variable"] = multiplier_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["threshold_variable"] = threshold_variable
        __props__.__dict__["tracker_name"] = tracker_name
        __props__.__dict__["tracker_name_variable"] = tracker_name_variable
        __props__.__dict__["tracker_type"] = tracker_type
        __props__.__dict__["tracker_type_variable"] = tracker_type_variable
        __props__.__dict__["version"] = version
        return TransportTrackerFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointApiUrl")
    def endpoint_api_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        API url of endpoint
        """
        return pulumi.get(self, "endpoint_api_url")

    @property
    @pulumi.getter(name="endpointApiUrlVariable")
    def endpoint_api_url_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_api_url_variable")

    @property
    @pulumi.getter(name="endpointDnsName")
    def endpoint_dns_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Endpoint DNS Name
        """
        return pulumi.get(self, "endpoint_dns_name")

    @property
    @pulumi.getter(name="endpointDnsNameVariable")
    def endpoint_dns_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_dns_name_variable")

    @property
    @pulumi.getter(name="endpointIp")
    def endpoint_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Endpoint IP
        """
        return pulumi.get(self, "endpoint_ip")

    @property
    @pulumi.getter(name="endpointIpVariable")
    def endpoint_ip_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_ip_variable")

    @property
    @pulumi.getter(name="endpointTrackerType")
    def endpoint_tracker_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Endpoint Tracker Type - Choices: `interface` - Default value: `interface`
        """
        return pulumi.get(self, "endpoint_tracker_type")

    @property
    @pulumi.getter(name="endpointTrackerTypeVariable")
    def endpoint_tracker_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "endpoint_tracker_type_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Interval - Range: `20`-`600` - Default value: `60`
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalVariable")
    def interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interval_variable")

    @property
    @pulumi.getter
    def multiplier(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Multiplier - Range: `1`-`10` - Default value: `3`
        """
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Threshold - Range: `100`-`1000` - Default value: `300`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tracker Name
        """
        return pulumi.get(self, "tracker_name")

    @property
    @pulumi.getter(name="trackerNameVariable")
    def tracker_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_name_variable")

    @property
    @pulumi.getter(name="trackerType")
    def tracker_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tracker Type - Choices: `endpoint`, `object` - Default value: `endpoint`
        """
        return pulumi.get(self, "tracker_type")

    @property
    @pulumi.getter(name="trackerTypeVariable")
    def tracker_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_type_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

