# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransportWanVpnFeatureArgs', 'TransportWanVpnFeature']

@pulumi.input_type
class TransportWanVpnFeatureArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]] = None,
                 new_host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a TransportWanVpnFeature resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enhance_ecmp_keying: Enhance ECMP Keying - Default value: `false`
        :param pulumi.Input[builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]] services: Service
        :param pulumi.Input[builtins.int] vpn: VPN - Default value: `0`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enhance_ecmp_keying is not None:
            pulumi.set(__self__, "enhance_ecmp_keying", enhance_ecmp_keying)
        if enhance_ecmp_keying_variable is not None:
            pulumi.set(__self__, "enhance_ecmp_keying_variable", enhance_ecmp_keying_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_v4_pools is not None:
            pulumi.set(__self__, "nat64_v4_pools", nat64_v4_pools)
        if new_host_mappings is not None:
            pulumi.set(__self__, "new_host_mappings", new_host_mappings)
        if primary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4", primary_dns_address_ipv4)
        if primary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4_variable", primary_dns_address_ipv4_variable)
        if primary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6", primary_dns_address_ipv6)
        if primary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6_variable", primary_dns_address_ipv6_variable)
        if secondary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4", secondary_dns_address_ipv4)
        if secondary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4_variable", secondary_dns_address_ipv4_variable)
        if secondary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6", secondary_dns_address_ipv6)
        if secondary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6_variable", secondary_dns_address_ipv6_variable)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enhance ECMP Keying - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @enhance_ecmp_keying.setter
    def enhance_ecmp_keying(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enhance_ecmp_keying", value)

    @property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @enhance_ecmp_keying_variable.setter
    def enhance_ecmp_keying_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enhance_ecmp_keying_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @nat64_v4_pools.setter
    def nat64_v4_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]]):
        pulumi.set(self, "nat64_v4_pools", value)

    @property
    @pulumi.getter(name="newHostMappings")
    def new_host_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]]:
        return pulumi.get(self, "new_host_mappings")

    @new_host_mappings.setter
    def new_host_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]]):
        pulumi.set(self, "new_host_mappings", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @primary_dns_address_ipv4.setter
    def primary_dns_address_ipv4(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @primary_dns_address_ipv4_variable.setter
    def primary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @primary_dns_address_ipv6.setter
    def primary_dns_address_ipv6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @primary_dns_address_ipv6_variable.setter
    def primary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @secondary_dns_address_ipv4.setter
    def secondary_dns_address_ipv4(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @secondary_dns_address_ipv4_variable.setter
    def secondary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @secondary_dns_address_ipv6.setter
    def secondary_dns_address_ipv6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @secondary_dns_address_ipv6_variable.setter
    def secondary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VPN - Default value: `0`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vpn", value)


@pulumi.input_type
class _TransportWanVpnFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]] = None,
                 new_host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering TransportWanVpnFeature resources.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enhance_ecmp_keying: Enhance ECMP Keying - Default value: `false`
        :param pulumi.Input[builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]] services: Service
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[builtins.int] vpn: VPN - Default value: `0`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enhance_ecmp_keying is not None:
            pulumi.set(__self__, "enhance_ecmp_keying", enhance_ecmp_keying)
        if enhance_ecmp_keying_variable is not None:
            pulumi.set(__self__, "enhance_ecmp_keying_variable", enhance_ecmp_keying_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_v4_pools is not None:
            pulumi.set(__self__, "nat64_v4_pools", nat64_v4_pools)
        if new_host_mappings is not None:
            pulumi.set(__self__, "new_host_mappings", new_host_mappings)
        if primary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4", primary_dns_address_ipv4)
        if primary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4_variable", primary_dns_address_ipv4_variable)
        if primary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6", primary_dns_address_ipv6)
        if primary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6_variable", primary_dns_address_ipv6_variable)
        if secondary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4", secondary_dns_address_ipv4)
        if secondary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4_variable", secondary_dns_address_ipv4_variable)
        if secondary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6", secondary_dns_address_ipv6)
        if secondary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6_variable", secondary_dns_address_ipv6_variable)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enhance ECMP Keying - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @enhance_ecmp_keying.setter
    def enhance_ecmp_keying(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enhance_ecmp_keying", value)

    @property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @enhance_ecmp_keying_variable.setter
    def enhance_ecmp_keying_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enhance_ecmp_keying_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @nat64_v4_pools.setter
    def nat64_v4_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNat64V4PoolArgs']]]]):
        pulumi.set(self, "nat64_v4_pools", value)

    @property
    @pulumi.getter(name="newHostMappings")
    def new_host_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]]:
        return pulumi.get(self, "new_host_mappings")

    @new_host_mappings.setter
    def new_host_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureNewHostMappingArgs']]]]):
        pulumi.set(self, "new_host_mappings", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @primary_dns_address_ipv4.setter
    def primary_dns_address_ipv4(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @primary_dns_address_ipv4_variable.setter
    def primary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @primary_dns_address_ipv6.setter
    def primary_dns_address_ipv6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @primary_dns_address_ipv6_variable.setter
    def primary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @secondary_dns_address_ipv4.setter
    def secondary_dns_address_ipv4(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @secondary_dns_address_ipv4_variable.setter
    def secondary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @secondary_dns_address_ipv6.setter
    def secondary_dns_address_ipv6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @secondary_dns_address_ipv6_variable.setter
    def secondary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportWanVpnFeatureServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VPN - Default value: `0`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vpn", value)


class TransportWanVpnFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv4StaticRouteArgs', 'TransportWanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv6StaticRouteArgs', 'TransportWanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNat64V4PoolArgs', 'TransportWanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
                 new_host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNewHostMappingArgs', 'TransportWanVpnFeatureNewHostMappingArgsDict']]]]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureServiceArgs', 'TransportWanVpnFeatureServiceArgsDict']]]]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource can manage a Transport WAN VPN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "transport_wan_vpn_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportWanVpnFeature:TransportWanVpnFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enhance_ecmp_keying: Enhance ECMP Keying - Default value: `false`
        :param pulumi.Input[builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv4StaticRouteArgs', 'TransportWanVpnFeatureIpv4StaticRouteArgsDict']]]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv6StaticRouteArgs', 'TransportWanVpnFeatureIpv6StaticRouteArgsDict']]]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNat64V4PoolArgs', 'TransportWanVpnFeatureNat64V4PoolArgsDict']]]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureServiceArgs', 'TransportWanVpnFeatureServiceArgsDict']]]] services: Service
        :param pulumi.Input[builtins.int] vpn: VPN - Default value: `0`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TransportWanVpnFeatureArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Transport WAN VPN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "transport_wan_vpn_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportWanVpnFeature:TransportWanVpnFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param TransportWanVpnFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportWanVpnFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv4StaticRouteArgs', 'TransportWanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv6StaticRouteArgs', 'TransportWanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNat64V4PoolArgs', 'TransportWanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
                 new_host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNewHostMappingArgs', 'TransportWanVpnFeatureNewHostMappingArgsDict']]]]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureServiceArgs', 'TransportWanVpnFeatureServiceArgsDict']]]]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportWanVpnFeatureArgs.__new__(TransportWanVpnFeatureArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enhance_ecmp_keying"] = enhance_ecmp_keying
            __props__.__dict__["enhance_ecmp_keying_variable"] = enhance_ecmp_keying_variable
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
            __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
            __props__.__dict__["name"] = name
            __props__.__dict__["nat64_v4_pools"] = nat64_v4_pools
            __props__.__dict__["new_host_mappings"] = new_host_mappings
            __props__.__dict__["primary_dns_address_ipv4"] = primary_dns_address_ipv4
            __props__.__dict__["primary_dns_address_ipv4_variable"] = primary_dns_address_ipv4_variable
            __props__.__dict__["primary_dns_address_ipv6"] = primary_dns_address_ipv6
            __props__.__dict__["primary_dns_address_ipv6_variable"] = primary_dns_address_ipv6_variable
            __props__.__dict__["secondary_dns_address_ipv4"] = secondary_dns_address_ipv4
            __props__.__dict__["secondary_dns_address_ipv4_variable"] = secondary_dns_address_ipv4_variable
            __props__.__dict__["secondary_dns_address_ipv6"] = secondary_dns_address_ipv6
            __props__.__dict__["secondary_dns_address_ipv6_variable"] = secondary_dns_address_ipv6_variable
            __props__.__dict__["services"] = services
            __props__.__dict__["vpn"] = vpn
            __props__.__dict__["version"] = None
        super(TransportWanVpnFeature, __self__).__init__(
            'sdwan:index/transportWanVpnFeature:TransportWanVpnFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enhance_ecmp_keying: Optional[pulumi.Input[builtins.bool]] = None,
            enhance_ecmp_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv4StaticRouteArgs', 'TransportWanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
            ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv6StaticRouteArgs', 'TransportWanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNat64V4PoolArgs', 'TransportWanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
            new_host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNewHostMappingArgs', 'TransportWanVpnFeatureNewHostMappingArgsDict']]]]] = None,
            primary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
            primary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
            primary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
            primary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address_ipv4: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address_ipv4_variable: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address_ipv6: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address_ipv6_variable: Optional[pulumi.Input[builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureServiceArgs', 'TransportWanVpnFeatureServiceArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            vpn: Optional[pulumi.Input[builtins.int]] = None) -> 'TransportWanVpnFeature':
        """
        Get an existing TransportWanVpnFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enhance_ecmp_keying: Enhance ECMP Keying - Default value: `false`
        :param pulumi.Input[builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv4StaticRouteArgs', 'TransportWanVpnFeatureIpv4StaticRouteArgsDict']]]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureIpv6StaticRouteArgs', 'TransportWanVpnFeatureIpv6StaticRouteArgsDict']]]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureNat64V4PoolArgs', 'TransportWanVpnFeatureNat64V4PoolArgsDict']]]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[builtins.str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportWanVpnFeatureServiceArgs', 'TransportWanVpnFeatureServiceArgsDict']]]] services: Service
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[builtins.int] vpn: VPN - Default value: `0`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportWanVpnFeatureState.__new__(_TransportWanVpnFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enhance_ecmp_keying"] = enhance_ecmp_keying
        __props__.__dict__["enhance_ecmp_keying_variable"] = enhance_ecmp_keying_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
        __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
        __props__.__dict__["name"] = name
        __props__.__dict__["nat64_v4_pools"] = nat64_v4_pools
        __props__.__dict__["new_host_mappings"] = new_host_mappings
        __props__.__dict__["primary_dns_address_ipv4"] = primary_dns_address_ipv4
        __props__.__dict__["primary_dns_address_ipv4_variable"] = primary_dns_address_ipv4_variable
        __props__.__dict__["primary_dns_address_ipv6"] = primary_dns_address_ipv6
        __props__.__dict__["primary_dns_address_ipv6_variable"] = primary_dns_address_ipv6_variable
        __props__.__dict__["secondary_dns_address_ipv4"] = secondary_dns_address_ipv4
        __props__.__dict__["secondary_dns_address_ipv4_variable"] = secondary_dns_address_ipv4_variable
        __props__.__dict__["secondary_dns_address_ipv6"] = secondary_dns_address_ipv6
        __props__.__dict__["secondary_dns_address_ipv6_variable"] = secondary_dns_address_ipv6_variable
        __props__.__dict__["services"] = services
        __props__.__dict__["version"] = version
        __props__.__dict__["vpn"] = vpn
        return TransportWanVpnFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enhance ECMP Keying - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.TransportWanVpnFeatureIpv4StaticRoute']]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.TransportWanVpnFeatureIpv6StaticRoute']]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> pulumi.Output[Optional[Sequence['outputs.TransportWanVpnFeatureNat64V4Pool']]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @property
    @pulumi.getter(name="newHostMappings")
    def new_host_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.TransportWanVpnFeatureNewHostMapping']]]:
        return pulumi.get(self, "new_host_mappings")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.TransportWanVpnFeatureService']]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vpn(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        VPN - Default value: `0`
        """
        return pulumi.get(self, "vpn")

