# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BdsInstanceMetastoreConfigArgs', 'BdsInstanceMetastoreConfig']

@pulumi.input_type
class BdsInstanceMetastoreConfigArgs:
    def __init__(__self__, *,
                 bds_api_key_id: pulumi.Input[str],
                 bds_api_key_passphrase: pulumi.Input[str],
                 bds_instance_id: pulumi.Input[str],
                 cluster_admin_password: pulumi.Input[str],
                 metastore_id: pulumi.Input[str],
                 activate_trigger: Optional[pulumi.Input[int]] = None,
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BdsInstanceMetastoreConfig resource.
        :param pulumi.Input[str] bds_api_key_id: (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        :param pulumi.Input[str] bds_api_key_passphrase: (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[str] metastore_id: The OCID of the Data Catalog metastore.
        :param pulumi.Input[int] activate_trigger: (Updatable) An optional integer, when flipped triggers activation of metastore config.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] display_name: (Updatable) The display name of the metastore configuration
        """
        pulumi.set(__self__, "bds_api_key_id", bds_api_key_id)
        pulumi.set(__self__, "bds_api_key_passphrase", bds_api_key_passphrase)
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "metastore_id", metastore_id)
        if activate_trigger is not None:
            pulumi.set(__self__, "activate_trigger", activate_trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="bdsApiKeyId")
    def bds_api_key_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        """
        return pulumi.get(self, "bds_api_key_id")

    @bds_api_key_id.setter
    def bds_api_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bds_api_key_id", value)

    @property
    @pulumi.getter(name="bdsApiKeyPassphrase")
    def bds_api_key_passphrase(self) -> pulumi.Input[str]:
        """
        (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        """
        return pulumi.get(self, "bds_api_key_passphrase")

    @bds_api_key_passphrase.setter
    def bds_api_key_passphrase(self, value: pulumi.Input[str]):
        pulumi.set(self, "bds_api_key_passphrase", value)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[str]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Input[str]:
        """
        The OCID of the Data Catalog metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="activateTrigger")
    def activate_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional integer, when flipped triggers activation of metastore config.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "activate_trigger")

    @activate_trigger.setter
    def activate_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activate_trigger", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the metastore configuration
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _BdsInstanceMetastoreConfigState:
    def __init__(__self__, *,
                 activate_trigger: Optional[pulumi.Input[int]] = None,
                 bds_api_key_id: Optional[pulumi.Input[str]] = None,
                 bds_api_key_passphrase: Optional[pulumi.Input[str]] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 metastore_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceMetastoreConfig resources.
        :param pulumi.Input[int] activate_trigger: (Updatable) An optional integer, when flipped triggers activation of metastore config.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] bds_api_key_id: (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        :param pulumi.Input[str] bds_api_key_passphrase: (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the metastore configuration
        :param pulumi.Input[str] metastore_id: The OCID of the Data Catalog metastore.
        :param pulumi.Input[str] metastore_type: The type of the metastore in the metastore configuration.
        :param pulumi.Input[str] state: the lifecycle state of the metastore configuration.
        :param pulumi.Input[str] time_created: The time when the configuration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        if activate_trigger is not None:
            pulumi.set(__self__, "activate_trigger", activate_trigger)
        if bds_api_key_id is not None:
            pulumi.set(__self__, "bds_api_key_id", bds_api_key_id)
        if bds_api_key_passphrase is not None:
            pulumi.set(__self__, "bds_api_key_passphrase", bds_api_key_passphrase)
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if metastore_type is not None:
            pulumi.set(__self__, "metastore_type", metastore_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="activateTrigger")
    def activate_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional integer, when flipped triggers activation of metastore config.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "activate_trigger")

    @activate_trigger.setter
    def activate_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activate_trigger", value)

    @property
    @pulumi.getter(name="bdsApiKeyId")
    def bds_api_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        """
        return pulumi.get(self, "bds_api_key_id")

    @bds_api_key_id.setter
    def bds_api_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bds_api_key_id", value)

    @property
    @pulumi.getter(name="bdsApiKeyPassphrase")
    def bds_api_key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        """
        return pulumi.get(self, "bds_api_key_passphrase")

    @bds_api_key_passphrase.setter
    def bds_api_key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bds_api_key_passphrase", value)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the metastore configuration
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Catalog metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="metastoreType")
    def metastore_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the metastore in the metastore configuration.
        """
        return pulumi.get(self, "metastore_type")

    @metastore_type.setter
    def metastore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metastore_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        the lifecycle state of the metastore configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the configuration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class BdsInstanceMetastoreConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_trigger: Optional[pulumi.Input[int]] = None,
                 bds_api_key_id: Optional[pulumi.Input[str]] = None,
                 bds_api_key_passphrase: Optional[pulumi.Input[str]] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance Metastore Config resource in Oracle Cloud Infrastructure Big Data Service service.

        Create and activate external metastore configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_metastore_config = oci.big_data_service.BdsInstanceMetastoreConfig("test_bds_instance_metastore_config",
            bds_api_key_id=test_api_key["id"],
            bds_api_key_passphrase=bds_instance_metastore_config_bds_api_key_passphrase,
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_metastore_config_cluster_admin_password,
            metastore_id=test_metastore["id"],
            display_name=bds_instance_metastore_config_display_name)
        ```

        ## Import

        BdsInstanceMetastoreConfigs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceMetastoreConfig:BdsInstanceMetastoreConfig test_bds_instance_metastore_config "bdsInstances/{bdsInstanceId}/metastoreConfigs/{metastoreConfigId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activate_trigger: (Updatable) An optional integer, when flipped triggers activation of metastore config.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] bds_api_key_id: (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        :param pulumi.Input[str] bds_api_key_passphrase: (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the metastore configuration
        :param pulumi.Input[str] metastore_id: The OCID of the Data Catalog metastore.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceMetastoreConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance Metastore Config resource in Oracle Cloud Infrastructure Big Data Service service.

        Create and activate external metastore configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_metastore_config = oci.big_data_service.BdsInstanceMetastoreConfig("test_bds_instance_metastore_config",
            bds_api_key_id=test_api_key["id"],
            bds_api_key_passphrase=bds_instance_metastore_config_bds_api_key_passphrase,
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_metastore_config_cluster_admin_password,
            metastore_id=test_metastore["id"],
            display_name=bds_instance_metastore_config_display_name)
        ```

        ## Import

        BdsInstanceMetastoreConfigs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceMetastoreConfig:BdsInstanceMetastoreConfig test_bds_instance_metastore_config "bdsInstances/{bdsInstanceId}/metastoreConfigs/{metastoreConfigId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceMetastoreConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceMetastoreConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_trigger: Optional[pulumi.Input[int]] = None,
                 bds_api_key_id: Optional[pulumi.Input[str]] = None,
                 bds_api_key_passphrase: Optional[pulumi.Input[str]] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceMetastoreConfigArgs.__new__(BdsInstanceMetastoreConfigArgs)

            __props__.__dict__["activate_trigger"] = activate_trigger
            if bds_api_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_api_key_id'")
            __props__.__dict__["bds_api_key_id"] = bds_api_key_id
            if bds_api_key_passphrase is None and not opts.urn:
                raise TypeError("Missing required property 'bds_api_key_passphrase'")
            __props__.__dict__["bds_api_key_passphrase"] = None if bds_api_key_passphrase is None else pulumi.Output.secret(bds_api_key_passphrase)
            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["display_name"] = display_name
            if metastore_id is None and not opts.urn:
                raise TypeError("Missing required property 'metastore_id'")
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["metastore_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bdsApiKeyPassphrase", "clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceMetastoreConfig, __self__).__init__(
            'oci:BigDataService/bdsInstanceMetastoreConfig:BdsInstanceMetastoreConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activate_trigger: Optional[pulumi.Input[int]] = None,
            bds_api_key_id: Optional[pulumi.Input[str]] = None,
            bds_api_key_passphrase: Optional[pulumi.Input[str]] = None,
            bds_instance_id: Optional[pulumi.Input[str]] = None,
            cluster_admin_password: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            metastore_id: Optional[pulumi.Input[str]] = None,
            metastore_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'BdsInstanceMetastoreConfig':
        """
        Get an existing BdsInstanceMetastoreConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activate_trigger: (Updatable) An optional integer, when flipped triggers activation of metastore config.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] bds_api_key_id: (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        :param pulumi.Input[str] bds_api_key_passphrase: (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the metastore configuration
        :param pulumi.Input[str] metastore_id: The OCID of the Data Catalog metastore.
        :param pulumi.Input[str] metastore_type: The type of the metastore in the metastore configuration.
        :param pulumi.Input[str] state: the lifecycle state of the metastore configuration.
        :param pulumi.Input[str] time_created: The time when the configuration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceMetastoreConfigState.__new__(_BdsInstanceMetastoreConfigState)

        __props__.__dict__["activate_trigger"] = activate_trigger
        __props__.__dict__["bds_api_key_id"] = bds_api_key_id
        __props__.__dict__["bds_api_key_passphrase"] = bds_api_key_passphrase
        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["metastore_type"] = metastore_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return BdsInstanceMetastoreConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activateTrigger")
    def activate_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional integer, when flipped triggers activation of metastore config.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "activate_trigger")

    @property
    @pulumi.getter(name="bdsApiKeyId")
    def bds_api_key_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The ID of BDS Api Key used for Data Catalog metastore integration.
        """
        return pulumi.get(self, "bds_api_key_id")

    @property
    @pulumi.getter(name="bdsApiKeyPassphrase")
    def bds_api_key_passphrase(self) -> pulumi.Output[str]:
        """
        (Updatable) Base-64 encoded passphrase of the BDS Api Key.
        """
        return pulumi.get(self, "bds_api_key_passphrase")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[str]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the metastore configuration
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Data Catalog metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="metastoreType")
    def metastore_type(self) -> pulumi.Output[str]:
        """
        The type of the metastore in the metastore configuration.
        """
        return pulumi.get(self, "metastore_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        the lifecycle state of the metastore configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the configuration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

