# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOsnsResult',
    'AwaitableGetOsnsResult',
    'get_osns',
    'get_osns_output',
]

@pulumi.output_type
class GetOsnsResult:
    """
    A collection of values returned by getOsns.
    """
    def __init__(__self__, blockchain_platform_id=None, display_name=None, filters=None, id=None, osn_collections=None):
        if blockchain_platform_id and not isinstance(blockchain_platform_id, str):
            raise TypeError("Expected argument 'blockchain_platform_id' to be a str")
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if osn_collections and not isinstance(osn_collections, list):
            raise TypeError("Expected argument 'osn_collections' to be a list")
        pulumi.set(__self__, "osn_collections", osn_collections)

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOsnsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osnCollections")
    def osn_collections(self) -> Sequence['outputs.GetOsnsOsnCollectionResult']:
        """
        The list of osn_collection.
        """
        return pulumi.get(self, "osn_collections")


class AwaitableGetOsnsResult(GetOsnsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOsnsResult(
            blockchain_platform_id=self.blockchain_platform_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            osn_collections=self.osn_collections)


def get_osns(blockchain_platform_id: Optional[str] = None,
             display_name: Optional[str] = None,
             filters: Optional[Sequence[Union['GetOsnsFilterArgs', 'GetOsnsFilterArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOsnsResult:
    """
    This data source provides the list of Osns in Oracle Cloud Infrastructure Blockchain service.

    List Blockchain Platform OSNs

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_osns = oci.Blockchain.get_osns(blockchain_platform_id=test_blockchain_platform["id"],
        display_name=osn_display_name)
    ```


    :param str blockchain_platform_id: Unique service identifier.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Blockchain/getOsns:getOsns', __args__, opts=opts, typ=GetOsnsResult).value

    return AwaitableGetOsnsResult(
        blockchain_platform_id=pulumi.get(__ret__, 'blockchain_platform_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        osn_collections=pulumi.get(__ret__, 'osn_collections'))


@_utilities.lift_output_func(get_osns)
def get_osns_output(blockchain_platform_id: Optional[pulumi.Input[str]] = None,
                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOsnsFilterArgs', 'GetOsnsFilterArgsDict']]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOsnsResult]:
    """
    This data source provides the list of Osns in Oracle Cloud Infrastructure Blockchain service.

    List Blockchain Platform OSNs

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_osns = oci.Blockchain.get_osns(blockchain_platform_id=test_blockchain_platform["id"],
        display_name=osn_display_name)
    ```


    :param str blockchain_platform_id: Unique service identifier.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
    """
    ...
