# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetResponderRecipeResult',
    'AwaitableGetResponderRecipeResult',
    'get_responder_recipe',
    'get_responder_recipe_output',
]

@pulumi.output_type
class GetResponderRecipeResult:
    """
    A collection of values returned by getResponderRecipe.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, effective_responder_rules=None, freeform_tags=None, id=None, lifecycle_details=None, owner=None, responder_recipe_id=None, responder_rules=None, source_responder_recipe_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_responder_rules and not isinstance(effective_responder_rules, list):
            raise TypeError("Expected argument 'effective_responder_rules' to be a list")
        pulumi.set(__self__, "effective_responder_rules", effective_responder_rules)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if responder_recipe_id and not isinstance(responder_recipe_id, str):
            raise TypeError("Expected argument 'responder_recipe_id' to be a str")
        pulumi.set(__self__, "responder_recipe_id", responder_recipe_id)
        if responder_rules and not isinstance(responder_rules, list):
            raise TypeError("Expected argument 'responder_rules' to be a list")
        pulumi.set(__self__, "responder_rules", responder_rules)
        if source_responder_recipe_id and not isinstance(source_responder_recipe_id, str):
            raise TypeError("Expected argument 'source_responder_recipe_id' to be a str")
        pulumi.set(__self__, "source_responder_recipe_id", source_responder_recipe_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Responder rule description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Responder rule display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveResponderRules")
    def effective_responder_rules(self) -> Sequence['outputs.GetResponderRecipeEffectiveResponderRuleResult']:
        """
        List of currently enabled responder rules for the responder type, for recipe after applying defaults
        """
        return pulumi.get(self, "effective_responder_rules")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the responder recip
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of responder recipe
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="responderRecipeId")
    def responder_recipe_id(self) -> str:
        return pulumi.get(self, "responder_recipe_id")

    @property
    @pulumi.getter(name="responderRules")
    def responder_rules(self) -> Sequence['outputs.GetResponderRecipeResponderRuleResult']:
        """
        List of responder rules associated with the recipe
        """
        return pulumi.get(self, "responder_rules")

    @property
    @pulumi.getter(name="sourceResponderRecipeId")
    def source_responder_recipe_id(self) -> str:
        """
        The unique identifier of the source responder recipe
        """
        return pulumi.get(self, "source_responder_recipe_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the example
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the responder recipe was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the responder recipe was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetResponderRecipeResult(GetResponderRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResponderRecipeResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            effective_responder_rules=self.effective_responder_rules,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            owner=self.owner,
            responder_recipe_id=self.responder_recipe_id,
            responder_rules=self.responder_rules,
            source_responder_recipe_id=self.source_responder_recipe_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_responder_recipe(responder_recipe_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResponderRecipeResult:
    """
    This data source provides details about a specific Responder Recipe resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a responder recipe (ResponderRecipe resource) identified by responderRecipeId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_responder_recipe = oci.CloudGuard.get_responder_recipe(responder_recipe_id=test_responder_recipe_oci_cloud_guard_responder_recipe["id"])
    ```


    :param str responder_recipe_id: OCID of the responder recipe.
    """
    __args__ = dict()
    __args__['responderRecipeId'] = responder_recipe_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getResponderRecipe:getResponderRecipe', __args__, opts=opts, typ=GetResponderRecipeResult).value

    return AwaitableGetResponderRecipeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_responder_rules=pulumi.get(__ret__, 'effective_responder_rules'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        owner=pulumi.get(__ret__, 'owner'),
        responder_recipe_id=pulumi.get(__ret__, 'responder_recipe_id'),
        responder_rules=pulumi.get(__ret__, 'responder_rules'),
        source_responder_recipe_id=pulumi.get(__ret__, 'source_responder_recipe_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_responder_recipe)
def get_responder_recipe_output(responder_recipe_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResponderRecipeResult]:
    """
    This data source provides details about a specific Responder Recipe resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a responder recipe (ResponderRecipe resource) identified by responderRecipeId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_responder_recipe = oci.CloudGuard.get_responder_recipe(responder_recipe_id=test_responder_recipe_oci_cloud_guard_responder_recipe["id"])
    ```


    :param str responder_recipe_id: OCID of the responder recipe.
    """
    ...
