# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDedicatedVmHostResult',
    'AwaitableGetDedicatedVmHostResult',
    'get_dedicated_vm_host',
    'get_dedicated_vm_host_output',
]

@pulumi.output_type
class GetDedicatedVmHostResult:
    """
    A collection of values returned by getDedicatedVmHost.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, dedicated_vm_host_id=None, dedicated_vm_host_shape=None, defined_tags=None, display_name=None, fault_domain=None, freeform_tags=None, id=None, remaining_memory_in_gbs=None, remaining_ocpus=None, state=None, time_created=None, total_memory_in_gbs=None, total_ocpus=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dedicated_vm_host_id and not isinstance(dedicated_vm_host_id, str):
            raise TypeError("Expected argument 'dedicated_vm_host_id' to be a str")
        pulumi.set(__self__, "dedicated_vm_host_id", dedicated_vm_host_id)
        if dedicated_vm_host_shape and not isinstance(dedicated_vm_host_shape, str):
            raise TypeError("Expected argument 'dedicated_vm_host_shape' to be a str")
        pulumi.set(__self__, "dedicated_vm_host_shape", dedicated_vm_host_shape)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fault_domain and not isinstance(fault_domain, str):
            raise TypeError("Expected argument 'fault_domain' to be a str")
        pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if remaining_memory_in_gbs and not isinstance(remaining_memory_in_gbs, float):
            raise TypeError("Expected argument 'remaining_memory_in_gbs' to be a float")
        pulumi.set(__self__, "remaining_memory_in_gbs", remaining_memory_in_gbs)
        if remaining_ocpus and not isinstance(remaining_ocpus, float):
            raise TypeError("Expected argument 'remaining_ocpus' to be a float")
        pulumi.set(__self__, "remaining_ocpus", remaining_ocpus)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if total_memory_in_gbs and not isinstance(total_memory_in_gbs, float):
            raise TypeError("Expected argument 'total_memory_in_gbs' to be a float")
        pulumi.set(__self__, "total_memory_in_gbs", total_memory_in_gbs)
        if total_ocpus and not isinstance(total_ocpus, float):
            raise TypeError("Expected argument 'total_ocpus' to be a float")
        pulumi.set(__self__, "total_ocpus", total_ocpus)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain the dedicated virtual machine host is running in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the dedicated virtual machine host.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dedicatedVmHostId")
    def dedicated_vm_host_id(self) -> str:
        return pulumi.get(self, "dedicated_vm_host_id")

    @property
    @pulumi.getter(name="dedicatedVmHostShape")
    def dedicated_vm_host_shape(self) -> str:
        """
        The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VMs.
        """
        return pulumi.get(self, "dedicated_vm_host_shape")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> str:
        """
        The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault).
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated VM host.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="remainingMemoryInGbs")
    def remaining_memory_in_gbs(self) -> float:
        """
        The current available memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "remaining_memory_in_gbs")

    @property
    @pulumi.getter(name="remainingOcpus")
    def remaining_ocpus(self) -> float:
        """
        The current available OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "remaining_ocpus")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the dedicated VM host.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the dedicated VM host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="totalMemoryInGbs")
    def total_memory_in_gbs(self) -> float:
        """
        The current total memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "total_memory_in_gbs")

    @property
    @pulumi.getter(name="totalOcpus")
    def total_ocpus(self) -> float:
        """
        The current total OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "total_ocpus")


class AwaitableGetDedicatedVmHostResult(GetDedicatedVmHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedVmHostResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            dedicated_vm_host_id=self.dedicated_vm_host_id,
            dedicated_vm_host_shape=self.dedicated_vm_host_shape,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            fault_domain=self.fault_domain,
            freeform_tags=self.freeform_tags,
            id=self.id,
            remaining_memory_in_gbs=self.remaining_memory_in_gbs,
            remaining_ocpus=self.remaining_ocpus,
            state=self.state,
            time_created=self.time_created,
            total_memory_in_gbs=self.total_memory_in_gbs,
            total_ocpus=self.total_ocpus)


def get_dedicated_vm_host(dedicated_vm_host_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedVmHostResult:
    """
    This data source provides details about a specific Dedicated Vm Host resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified dedicated virtual machine host.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_vm_host = oci.Core.get_dedicated_vm_host(dedicated_vm_host_id=test_dedicated_vm_host_oci_core_dedicated_vm_host["id"])
    ```


    :param str dedicated_vm_host_id: The OCID of the dedicated VM host.
    """
    __args__ = dict()
    __args__['dedicatedVmHostId'] = dedicated_vm_host_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDedicatedVmHost:getDedicatedVmHost', __args__, opts=opts, typ=GetDedicatedVmHostResult).value

    return AwaitableGetDedicatedVmHostResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dedicated_vm_host_id=pulumi.get(__ret__, 'dedicated_vm_host_id'),
        dedicated_vm_host_shape=pulumi.get(__ret__, 'dedicated_vm_host_shape'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fault_domain=pulumi.get(__ret__, 'fault_domain'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        remaining_memory_in_gbs=pulumi.get(__ret__, 'remaining_memory_in_gbs'),
        remaining_ocpus=pulumi.get(__ret__, 'remaining_ocpus'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        total_memory_in_gbs=pulumi.get(__ret__, 'total_memory_in_gbs'),
        total_ocpus=pulumi.get(__ret__, 'total_ocpus'))


@_utilities.lift_output_func(get_dedicated_vm_host)
def get_dedicated_vm_host_output(dedicated_vm_host_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDedicatedVmHostResult]:
    """
    This data source provides details about a specific Dedicated Vm Host resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified dedicated virtual machine host.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_vm_host = oci.Core.get_dedicated_vm_host(dedicated_vm_host_id=test_dedicated_vm_host_oci_core_dedicated_vm_host["id"])
    ```


    :param str dedicated_vm_host_id: The OCID of the dedicated VM host.
    """
    ...
