# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityListArgs', 'SecurityList']

@pulumi.input_type
class SecurityListArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 egress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityList resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]] egress_security_rules: (Updatable) Rules for allowing egress IP packets.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]] ingress_security_rules: (Updatable) Rules for allowing ingress IP packets.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if egress_security_rules is not None:
            pulumi.set(__self__, "egress_security_rules", egress_security_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ingress_security_rules is not None:
            pulumi.set(__self__, "ingress_security_rules", ingress_security_rules)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="egressSecurityRules")
    def egress_security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]]:
        """
        (Updatable) Rules for allowing egress IP packets.
        """
        return pulumi.get(self, "egress_security_rules")

    @egress_security_rules.setter
    def egress_security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]]):
        pulumi.set(self, "egress_security_rules", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ingressSecurityRules")
    def ingress_security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]]:
        """
        (Updatable) Rules for allowing ingress IP packets.
        """
        return pulumi.get(self, "ingress_security_rules")

    @ingress_security_rules.setter
    def ingress_security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]]):
        pulumi.set(self, "ingress_security_rules", value)


@pulumi.input_type
class _SecurityListState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 egress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityList resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]] egress_security_rules: (Updatable) Rules for allowing egress IP packets.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]] ingress_security_rules: (Updatable) Rules for allowing ingress IP packets.
        :param pulumi.Input[str] state: The security list's current state.
        :param pulumi.Input[str] time_created: The date and time the security list was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if egress_security_rules is not None:
            pulumi.set(__self__, "egress_security_rules", egress_security_rules)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ingress_security_rules is not None:
            pulumi.set(__self__, "ingress_security_rules", ingress_security_rules)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="egressSecurityRules")
    def egress_security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]]:
        """
        (Updatable) Rules for allowing egress IP packets.
        """
        return pulumi.get(self, "egress_security_rules")

    @egress_security_rules.setter
    def egress_security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListEgressSecurityRuleArgs']]]]):
        pulumi.set(self, "egress_security_rules", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ingressSecurityRules")
    def ingress_security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]]:
        """
        (Updatable) Rules for allowing ingress IP packets.
        """
        return pulumi.get(self, "ingress_security_rules")

    @ingress_security_rules.setter
    def ingress_security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityListIngressSecurityRuleArgs']]]]):
        pulumi.set(self, "ingress_security_rules", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The security list's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the security list was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


class SecurityList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 egress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListEgressSecurityRuleArgs', 'SecurityListEgressSecurityRuleArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListIngressSecurityRuleArgs', 'SecurityListIngressSecurityRuleArgsDict']]]]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Security List resource in Oracle Cloud Infrastructure Core service.

        Creates a new security list for the specified VCN. For more information
        about security lists, see [Security Lists](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm).
        For information on the number of rules you can have in a security list, see
        [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the security
        list to reside. Notice that the security list doesn't have to be in the same compartment as the VCN, subnets,
        or other Networking Service components. If you're not sure which compartment to use, put the security
        list in the same compartment as the VCN. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the security list, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        For more information on configuring a VCN's default security list, see [Managing Default VCN Resources](https://www.terraform.io/docs/providers/oci/guides/managing_default_resources.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_list = oci.core.SecurityList("test_security_list",
            compartment_id=compartment_id,
            vcn_id=test_vcn["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=security_list_display_name,
            egress_security_rules=[{
                "destination": security_list_egress_security_rules_destination,
                "protocol": security_list_egress_security_rules_protocol,
                "description": security_list_egress_security_rules_description,
                "destination_type": security_list_egress_security_rules_destination_type,
                "icmp_options": {
                    "type": security_list_egress_security_rules_icmp_options_type,
                    "code": security_list_egress_security_rules_icmp_options_code,
                },
                "stateless": security_list_egress_security_rules_stateless,
                "tcp_options": {
                    "max": security_list_egress_security_rules_tcp_options_destination_port_range_max,
                    "min": security_list_egress_security_rules_tcp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_egress_security_rules_tcp_options_source_port_range_max,
                        "min": security_list_egress_security_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "max": security_list_egress_security_rules_udp_options_destination_port_range_max,
                    "min": security_list_egress_security_rules_udp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_egress_security_rules_udp_options_source_port_range_max,
                        "min": security_list_egress_security_rules_udp_options_source_port_range_min,
                    },
                },
            }],
            freeform_tags={
                "Department": "Finance",
            },
            ingress_security_rules=[{
                "protocol": security_list_ingress_security_rules_protocol,
                "source": security_list_ingress_security_rules_source,
                "description": security_list_ingress_security_rules_description,
                "icmp_options": {
                    "type": security_list_ingress_security_rules_icmp_options_type,
                    "code": security_list_ingress_security_rules_icmp_options_code,
                },
                "source_type": security_list_ingress_security_rules_source_type,
                "stateless": security_list_ingress_security_rules_stateless,
                "tcp_options": {
                    "max": security_list_ingress_security_rules_tcp_options_destination_port_range_max,
                    "min": security_list_ingress_security_rules_tcp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_ingress_security_rules_tcp_options_source_port_range_max,
                        "min": security_list_ingress_security_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "max": security_list_ingress_security_rules_udp_options_destination_port_range_max,
                    "min": security_list_ingress_security_rules_udp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_ingress_security_rules_udp_options_source_port_range_max,
                        "min": security_list_ingress_security_rules_udp_options_source_port_range_min,
                    },
                },
            }])
        ```

        ## Import

        SecurityLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/securityList:SecurityList test_security_list "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityListEgressSecurityRuleArgs', 'SecurityListEgressSecurityRuleArgsDict']]]] egress_security_rules: (Updatable) Rules for allowing egress IP packets.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityListIngressSecurityRuleArgs', 'SecurityListIngressSecurityRuleArgsDict']]]] ingress_security_rules: (Updatable) Rules for allowing ingress IP packets.
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Security List resource in Oracle Cloud Infrastructure Core service.

        Creates a new security list for the specified VCN. For more information
        about security lists, see [Security Lists](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm).
        For information on the number of rules you can have in a security list, see
        [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the security
        list to reside. Notice that the security list doesn't have to be in the same compartment as the VCN, subnets,
        or other Networking Service components. If you're not sure which compartment to use, put the security
        list in the same compartment as the VCN. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the security list, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        For more information on configuring a VCN's default security list, see [Managing Default VCN Resources](https://www.terraform.io/docs/providers/oci/guides/managing_default_resources.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_list = oci.core.SecurityList("test_security_list",
            compartment_id=compartment_id,
            vcn_id=test_vcn["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=security_list_display_name,
            egress_security_rules=[{
                "destination": security_list_egress_security_rules_destination,
                "protocol": security_list_egress_security_rules_protocol,
                "description": security_list_egress_security_rules_description,
                "destination_type": security_list_egress_security_rules_destination_type,
                "icmp_options": {
                    "type": security_list_egress_security_rules_icmp_options_type,
                    "code": security_list_egress_security_rules_icmp_options_code,
                },
                "stateless": security_list_egress_security_rules_stateless,
                "tcp_options": {
                    "max": security_list_egress_security_rules_tcp_options_destination_port_range_max,
                    "min": security_list_egress_security_rules_tcp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_egress_security_rules_tcp_options_source_port_range_max,
                        "min": security_list_egress_security_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "max": security_list_egress_security_rules_udp_options_destination_port_range_max,
                    "min": security_list_egress_security_rules_udp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_egress_security_rules_udp_options_source_port_range_max,
                        "min": security_list_egress_security_rules_udp_options_source_port_range_min,
                    },
                },
            }],
            freeform_tags={
                "Department": "Finance",
            },
            ingress_security_rules=[{
                "protocol": security_list_ingress_security_rules_protocol,
                "source": security_list_ingress_security_rules_source,
                "description": security_list_ingress_security_rules_description,
                "icmp_options": {
                    "type": security_list_ingress_security_rules_icmp_options_type,
                    "code": security_list_ingress_security_rules_icmp_options_code,
                },
                "source_type": security_list_ingress_security_rules_source_type,
                "stateless": security_list_ingress_security_rules_stateless,
                "tcp_options": {
                    "max": security_list_ingress_security_rules_tcp_options_destination_port_range_max,
                    "min": security_list_ingress_security_rules_tcp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_ingress_security_rules_tcp_options_source_port_range_max,
                        "min": security_list_ingress_security_rules_tcp_options_source_port_range_min,
                    },
                },
                "udp_options": {
                    "max": security_list_ingress_security_rules_udp_options_destination_port_range_max,
                    "min": security_list_ingress_security_rules_udp_options_destination_port_range_min,
                    "source_port_range": {
                        "max": security_list_ingress_security_rules_udp_options_source_port_range_max,
                        "min": security_list_ingress_security_rules_udp_options_source_port_range_min,
                    },
                },
            }])
        ```

        ## Import

        SecurityLists can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/securityList:SecurityList test_security_list "id"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 egress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListEgressSecurityRuleArgs', 'SecurityListEgressSecurityRuleArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListIngressSecurityRuleArgs', 'SecurityListIngressSecurityRuleArgsDict']]]]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityListArgs.__new__(SecurityListArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["egress_security_rules"] = egress_security_rules
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ingress_security_rules"] = ingress_security_rules
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(SecurityList, __self__).__init__(
            'oci:Core/securityList:SecurityList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            egress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListEgressSecurityRuleArgs', 'SecurityListEgressSecurityRuleArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ingress_security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityListIngressSecurityRuleArgs', 'SecurityListIngressSecurityRuleArgsDict']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None) -> 'SecurityList':
        """
        Get an existing SecurityList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityListEgressSecurityRuleArgs', 'SecurityListEgressSecurityRuleArgsDict']]]] egress_security_rules: (Updatable) Rules for allowing egress IP packets.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityListIngressSecurityRuleArgs', 'SecurityListIngressSecurityRuleArgsDict']]]] ingress_security_rules: (Updatable) Rules for allowing ingress IP packets.
        :param pulumi.Input[str] state: The security list's current state.
        :param pulumi.Input[str] time_created: The date and time the security list was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityListState.__new__(_SecurityListState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["egress_security_rules"] = egress_security_rules
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ingress_security_rules"] = ingress_security_rules
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vcn_id"] = vcn_id
        return SecurityList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the security list.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="egressSecurityRules")
    def egress_security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityListEgressSecurityRule']]]:
        """
        (Updatable) Rules for allowing egress IP packets.
        """
        return pulumi.get(self, "egress_security_rules")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ingressSecurityRules")
    def ingress_security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityListIngressSecurityRule']]]:
        """
        (Updatable) Rules for allowing ingress IP packets.
        """
        return pulumi.get(self, "ingress_security_rules")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The security list's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the security list was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the security list belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

