# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupDestinationArgs', 'BackupDestination']

@pulumi.input_type
class BackupDestinationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 connection_string: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 local_mount_point_path: Optional[pulumi.Input[str]] = None,
                 mount_type_details: Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']] = None,
                 vpc_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a BackupDestination resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: The user-provided name of the backup destination.
        :param pulumi.Input[str] type: Type of the backup destination.
        :param pulumi.Input[str] connection_string: (Updatable) The connection string for connecting to the Recovery Appliance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] local_mount_point_path: (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        :param pulumi.Input['BackupDestinationMountTypeDetailsArgs'] mount_type_details: Mount type details for backup destination.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_users: (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "type", type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if local_mount_point_path is not None:
            warnings.warn("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""local_mount_point_path is deprecated: The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
        if local_mount_point_path is not None:
            pulumi.set(__self__, "local_mount_point_path", local_mount_point_path)
        if mount_type_details is not None:
            pulumi.set(__self__, "mount_type_details", mount_type_details)
        if vpc_users is not None:
            pulumi.set(__self__, "vpc_users", vpc_users)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-provided name of the backup destination.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the backup destination.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The connection string for connecting to the Recovery Appliance.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="localMountPointPath")
    @_utilities.deprecated("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
    def local_mount_point_path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        """
        return pulumi.get(self, "local_mount_point_path")

    @local_mount_point_path.setter
    def local_mount_point_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_mount_point_path", value)

    @property
    @pulumi.getter(name="mountTypeDetails")
    def mount_type_details(self) -> Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']]:
        """
        Mount type details for backup destination.
        """
        return pulumi.get(self, "mount_type_details")

    @mount_type_details.setter
    def mount_type_details(self, value: Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']]):
        pulumi.set(self, "mount_type_details", value)

    @property
    @pulumi.getter(name="vpcUsers")
    def vpc_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vpc_users")

    @vpc_users.setter
    def vpc_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_users", value)


@pulumi.input_type
class _BackupDestinationState:
    def __init__(__self__, *,
                 associated_databases: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDestinationAssociatedDatabaseArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 local_mount_point_path: Optional[pulumi.Input[str]] = None,
                 mount_type_details: Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']] = None,
                 nfs_mount_type: Optional[pulumi.Input[str]] = None,
                 nfs_server_export: Optional[pulumi.Input[str]] = None,
                 nfs_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering BackupDestination resources.
        :param pulumi.Input[Sequence[pulumi.Input['BackupDestinationAssociatedDatabaseArgs']]] associated_databases: List of databases associated with the backup destination.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] connection_string: (Updatable) The connection string for connecting to the Recovery Appliance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-provided name of the backup destination.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: A descriptive text associated with the lifecycleState. Typically contains additional displayable text
        :param pulumi.Input[str] local_mount_point_path: (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        :param pulumi.Input['BackupDestinationMountTypeDetailsArgs'] mount_type_details: Mount type details for backup destination.
        :param pulumi.Input[str] nfs_mount_type: NFS Mount type for backup destination.
        :param pulumi.Input[str] nfs_server_export: Specifies the directory on which to mount the file system
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nfs_servers: Host names or IP addresses for NFS Auto mount.
        :param pulumi.Input[str] state: The current lifecycle state of the backup destination.
        :param pulumi.Input[str] time_created: The date and time the backup destination was created.
        :param pulumi.Input[str] type: Type of the backup destination.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_users: (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if associated_databases is not None:
            pulumi.set(__self__, "associated_databases", associated_databases)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if local_mount_point_path is not None:
            warnings.warn("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""local_mount_point_path is deprecated: The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
        if local_mount_point_path is not None:
            pulumi.set(__self__, "local_mount_point_path", local_mount_point_path)
        if mount_type_details is not None:
            pulumi.set(__self__, "mount_type_details", mount_type_details)
        if nfs_mount_type is not None:
            pulumi.set(__self__, "nfs_mount_type", nfs_mount_type)
        if nfs_server_export is not None:
            pulumi.set(__self__, "nfs_server_export", nfs_server_export)
        if nfs_servers is not None:
            pulumi.set(__self__, "nfs_servers", nfs_servers)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_users is not None:
            pulumi.set(__self__, "vpc_users", vpc_users)

    @property
    @pulumi.getter(name="associatedDatabases")
    def associated_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupDestinationAssociatedDatabaseArgs']]]]:
        """
        List of databases associated with the backup destination.
        """
        return pulumi.get(self, "associated_databases")

    @associated_databases.setter
    def associated_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDestinationAssociatedDatabaseArgs']]]]):
        pulumi.set(self, "associated_databases", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The connection string for connecting to the Recovery Appliance.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-provided name of the backup destination.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive text associated with the lifecycleState. Typically contains additional displayable text
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="localMountPointPath")
    @_utilities.deprecated("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
    def local_mount_point_path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        """
        return pulumi.get(self, "local_mount_point_path")

    @local_mount_point_path.setter
    def local_mount_point_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_mount_point_path", value)

    @property
    @pulumi.getter(name="mountTypeDetails")
    def mount_type_details(self) -> Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']]:
        """
        Mount type details for backup destination.
        """
        return pulumi.get(self, "mount_type_details")

    @mount_type_details.setter
    def mount_type_details(self, value: Optional[pulumi.Input['BackupDestinationMountTypeDetailsArgs']]):
        pulumi.set(self, "mount_type_details", value)

    @property
    @pulumi.getter(name="nfsMountType")
    def nfs_mount_type(self) -> Optional[pulumi.Input[str]]:
        """
        NFS Mount type for backup destination.
        """
        return pulumi.get(self, "nfs_mount_type")

    @nfs_mount_type.setter
    def nfs_mount_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_mount_type", value)

    @property
    @pulumi.getter(name="nfsServerExport")
    def nfs_server_export(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the directory on which to mount the file system
        """
        return pulumi.get(self, "nfs_server_export")

    @nfs_server_export.setter
    def nfs_server_export(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_server_export", value)

    @property
    @pulumi.getter(name="nfsServers")
    def nfs_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Host names or IP addresses for NFS Auto mount.
        """
        return pulumi.get(self, "nfs_servers")

    @nfs_servers.setter
    def nfs_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nfs_servers", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the backup destination.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the backup destination was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the backup destination.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcUsers")
    def vpc_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vpc_users")

    @vpc_users.setter
    def vpc_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_users", value)


class BackupDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 local_mount_point_path: Optional[pulumi.Input[str]] = None,
                 mount_type_details: Optional[pulumi.Input[Union['BackupDestinationMountTypeDetailsArgs', 'BackupDestinationMountTypeDetailsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Backup Destination resource in Oracle Cloud Infrastructure Database service.

        Creates a backup destination in an Exadata Cloud@Customer system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backup_destination = oci.database.BackupDestination("test_backup_destination",
            compartment_id=compartment_id,
            display_name=backup_destination_display_name,
            type=backup_destination_type,
            connection_string=backup_destination_connection_string,
            defined_tags=backup_destination_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            local_mount_point_path=backup_destination_local_mount_point_path,
            mount_type_details={
                "mount_type": backup_destination_mount_type_details_mount_type,
                "local_mount_point_path": backup_destination_mount_type_details_local_mount_point_path,
                "nfs_servers": backup_destination_mount_type_details_nfs_server,
                "nfs_server_export": backup_destination_mount_type_details_nfs_server_export,
            },
            vpc_users=backup_destination_vpc_users)
        ```

        ## Import

        BackupDestinations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/backupDestination:BackupDestination test_backup_destination "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] connection_string: (Updatable) The connection string for connecting to the Recovery Appliance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-provided name of the backup destination.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] local_mount_point_path: (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        :param pulumi.Input[Union['BackupDestinationMountTypeDetailsArgs', 'BackupDestinationMountTypeDetailsArgsDict']] mount_type_details: Mount type details for backup destination.
        :param pulumi.Input[str] type: Type of the backup destination.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_users: (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Backup Destination resource in Oracle Cloud Infrastructure Database service.

        Creates a backup destination in an Exadata Cloud@Customer system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backup_destination = oci.database.BackupDestination("test_backup_destination",
            compartment_id=compartment_id,
            display_name=backup_destination_display_name,
            type=backup_destination_type,
            connection_string=backup_destination_connection_string,
            defined_tags=backup_destination_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            local_mount_point_path=backup_destination_local_mount_point_path,
            mount_type_details={
                "mount_type": backup_destination_mount_type_details_mount_type,
                "local_mount_point_path": backup_destination_mount_type_details_local_mount_point_path,
                "nfs_servers": backup_destination_mount_type_details_nfs_server,
                "nfs_server_export": backup_destination_mount_type_details_nfs_server_export,
            },
            vpc_users=backup_destination_vpc_users)
        ```

        ## Import

        BackupDestinations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/backupDestination:BackupDestination test_backup_destination "id"
        ```

        :param str resource_name: The name of the resource.
        :param BackupDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 local_mount_point_path: Optional[pulumi.Input[str]] = None,
                 mount_type_details: Optional[pulumi.Input[Union['BackupDestinationMountTypeDetailsArgs', 'BackupDestinationMountTypeDetailsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupDestinationArgs.__new__(BackupDestinationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["local_mount_point_path"] = local_mount_point_path
            __props__.__dict__["mount_type_details"] = mount_type_details
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_users"] = vpc_users
            __props__.__dict__["associated_databases"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["nfs_mount_type"] = None
            __props__.__dict__["nfs_server_export"] = None
            __props__.__dict__["nfs_servers"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(BackupDestination, __self__).__init__(
            'oci:Database/backupDestination:BackupDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupDestinationAssociatedDatabaseArgs', 'BackupDestinationAssociatedDatabaseArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            local_mount_point_path: Optional[pulumi.Input[str]] = None,
            mount_type_details: Optional[pulumi.Input[Union['BackupDestinationMountTypeDetailsArgs', 'BackupDestinationMountTypeDetailsArgsDict']]] = None,
            nfs_mount_type: Optional[pulumi.Input[str]] = None,
            nfs_server_export: Optional[pulumi.Input[str]] = None,
            nfs_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vpc_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'BackupDestination':
        """
        Get an existing BackupDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupDestinationAssociatedDatabaseArgs', 'BackupDestinationAssociatedDatabaseArgsDict']]]] associated_databases: List of databases associated with the backup destination.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] connection_string: (Updatable) The connection string for connecting to the Recovery Appliance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-provided name of the backup destination.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: A descriptive text associated with the lifecycleState. Typically contains additional displayable text
        :param pulumi.Input[str] local_mount_point_path: (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        :param pulumi.Input[Union['BackupDestinationMountTypeDetailsArgs', 'BackupDestinationMountTypeDetailsArgsDict']] mount_type_details: Mount type details for backup destination.
        :param pulumi.Input[str] nfs_mount_type: NFS Mount type for backup destination.
        :param pulumi.Input[str] nfs_server_export: Specifies the directory on which to mount the file system
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nfs_servers: Host names or IP addresses for NFS Auto mount.
        :param pulumi.Input[str] state: The current lifecycle state of the backup destination.
        :param pulumi.Input[str] time_created: The date and time the backup destination was created.
        :param pulumi.Input[str] type: Type of the backup destination.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_users: (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupDestinationState.__new__(_BackupDestinationState)

        __props__.__dict__["associated_databases"] = associated_databases
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["local_mount_point_path"] = local_mount_point_path
        __props__.__dict__["mount_type_details"] = mount_type_details
        __props__.__dict__["nfs_mount_type"] = nfs_mount_type
        __props__.__dict__["nfs_server_export"] = nfs_server_export
        __props__.__dict__["nfs_servers"] = nfs_servers
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_users"] = vpc_users
        return BackupDestination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedDatabases")
    def associated_databases(self) -> pulumi.Output[Sequence['outputs.BackupDestinationAssociatedDatabase']]:
        """
        List of databases associated with the backup destination.
        """
        return pulumi.get(self, "associated_databases")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The connection string for connecting to the Recovery Appliance.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-provided name of the backup destination.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A descriptive text associated with the lifecycleState. Typically contains additional displayable text
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="localMountPointPath")
    @_utilities.deprecated("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
    def local_mount_point_path(self) -> pulumi.Output[str]:
        """
        (Updatable) **Deprecated.** The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes. This field is deprecated. Use the mountTypeDetails field instead to specify the mount type for NFS.
        """
        return pulumi.get(self, "local_mount_point_path")

    @property
    @pulumi.getter(name="mountTypeDetails")
    def mount_type_details(self) -> pulumi.Output['outputs.BackupDestinationMountTypeDetails']:
        """
        Mount type details for backup destination.
        """
        return pulumi.get(self, "mount_type_details")

    @property
    @pulumi.getter(name="nfsMountType")
    def nfs_mount_type(self) -> pulumi.Output[str]:
        """
        NFS Mount type for backup destination.
        """
        return pulumi.get(self, "nfs_mount_type")

    @property
    @pulumi.getter(name="nfsServerExport")
    def nfs_server_export(self) -> pulumi.Output[str]:
        """
        Specifies the directory on which to mount the file system
        """
        return pulumi.get(self, "nfs_server_export")

    @property
    @pulumi.getter(name="nfsServers")
    def nfs_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        Host names or IP addresses for NFS Auto mount.
        """
        return pulumi.get(self, "nfs_servers")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the backup destination.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the backup destination was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the backup destination.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcUsers")
    def vpc_users(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vpc_users")

