# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ExternalContainerDatabasesStackMonitoringArgs', 'ExternalContainerDatabasesStackMonitoring']

@pulumi.input_type
class ExternalContainerDatabasesStackMonitoringArgs:
    def __init__(__self__, *,
                 enable_stack_monitoring: pulumi.Input[bool],
                 external_container_database_id: pulumi.Input[str],
                 external_database_connector_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ExternalContainerDatabasesStackMonitoring resource.
        :param pulumi.Input[bool] enable_stack_monitoring: (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        pulumi.set(__self__, "enable_stack_monitoring", enable_stack_monitoring)
        pulumi.set(__self__, "external_container_database_id", external_container_database_id)
        pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)

    @property
    @pulumi.getter(name="enableStackMonitoring")
    def enable_stack_monitoring(self) -> pulumi.Input[bool]:
        """
        (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_stack_monitoring")

    @enable_stack_monitoring.setter
    def enable_stack_monitoring(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_stack_monitoring", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Input[str]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_database_connector_id", value)


@pulumi.input_type
class _ExternalContainerDatabasesStackMonitoringState:
    def __init__(__self__, *,
                 enable_stack_monitoring: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalContainerDatabasesStackMonitoring resources.
        :param pulumi.Input[bool] enable_stack_monitoring: (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        if enable_stack_monitoring is not None:
            pulumi.set(__self__, "enable_stack_monitoring", enable_stack_monitoring)
        if external_container_database_id is not None:
            pulumi.set(__self__, "external_container_database_id", external_container_database_id)
        if external_database_connector_id is not None:
            pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)

    @property
    @pulumi.getter(name="enableStackMonitoring")
    def enable_stack_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_stack_monitoring")

    @enable_stack_monitoring.setter
    def enable_stack_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stack_monitoring", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_database_connector_id", value)


class ExternalContainerDatabasesStackMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_stack_monitoring: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Externalcontainerdatabases Stack Monitoring resource in Oracle Cloud Infrastructure Database service.

        Enable Stack Monitoring for the external container database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_externalcontainerdatabases_stack_monitoring = oci.database.ExternalContainerDatabasesStackMonitoring("test_externalcontainerdatabases_stack_monitoring",
            external_container_database_id=test_external_container_database["id"],
            external_database_connector_id=test_external_database_connector["id"],
            enable_stack_monitoring=True)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_stack_monitoring: (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalContainerDatabasesStackMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Externalcontainerdatabases Stack Monitoring resource in Oracle Cloud Infrastructure Database service.

        Enable Stack Monitoring for the external container database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_externalcontainerdatabases_stack_monitoring = oci.database.ExternalContainerDatabasesStackMonitoring("test_externalcontainerdatabases_stack_monitoring",
            external_container_database_id=test_external_container_database["id"],
            external_database_connector_id=test_external_database_connector["id"],
            enable_stack_monitoring=True)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ExternalContainerDatabasesStackMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalContainerDatabasesStackMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_stack_monitoring: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalContainerDatabasesStackMonitoringArgs.__new__(ExternalContainerDatabasesStackMonitoringArgs)

            if enable_stack_monitoring is None and not opts.urn:
                raise TypeError("Missing required property 'enable_stack_monitoring'")
            __props__.__dict__["enable_stack_monitoring"] = enable_stack_monitoring
            if external_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_container_database_id'")
            __props__.__dict__["external_container_database_id"] = external_container_database_id
            if external_database_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_database_connector_id'")
            __props__.__dict__["external_database_connector_id"] = external_database_connector_id
        super(ExternalContainerDatabasesStackMonitoring, __self__).__init__(
            'oci:Database/externalContainerDatabasesStackMonitoring:ExternalContainerDatabasesStackMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_stack_monitoring: Optional[pulumi.Input[bool]] = None,
            external_container_database_id: Optional[pulumi.Input[str]] = None,
            external_database_connector_id: Optional[pulumi.Input[str]] = None) -> 'ExternalContainerDatabasesStackMonitoring':
        """
        Get an existing ExternalContainerDatabasesStackMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_stack_monitoring: (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalContainerDatabasesStackMonitoringState.__new__(_ExternalContainerDatabasesStackMonitoringState)

        __props__.__dict__["enable_stack_monitoring"] = enable_stack_monitoring
        __props__.__dict__["external_container_database_id"] = external_container_database_id
        __props__.__dict__["external_database_connector_id"] = external_database_connector_id
        return ExternalContainerDatabasesStackMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableStackMonitoring")
    def enable_stack_monitoring(self) -> pulumi.Output[bool]:
        """
        (Updatable) Enabling Stack Monitoring on External Container Databases . Requires boolean value "true" or "false".


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_stack_monitoring")

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Output[str]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

