# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousContainerDatabaseDataguardAssociationResult',
    'AwaitableGetAutonomousContainerDatabaseDataguardAssociationResult',
    'get_autonomous_container_database_dataguard_association',
    'get_autonomous_container_database_dataguard_association_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseDataguardAssociationResult:
    """
    A collection of values returned by getAutonomousContainerDatabaseDataguardAssociation.
    """
    def __init__(__self__, apply_lag=None, apply_rate=None, autonomous_container_database_dataguard_association_id=None, autonomous_container_database_id=None, fast_start_fail_over_lag_limit_in_seconds=None, id=None, is_automatic_failover_enabled=None, lifecycle_details=None, peer_autonomous_container_database_backup_configs=None, peer_autonomous_container_database_compartment_id=None, peer_autonomous_container_database_dataguard_association_id=None, peer_autonomous_container_database_display_name=None, peer_autonomous_container_database_id=None, peer_autonomous_vm_cluster_id=None, peer_cloud_autonomous_vm_cluster_id=None, peer_db_unique_name=None, peer_lifecycle_state=None, peer_role=None, protection_mode=None, role=None, standby_maintenance_buffer_in_days=None, state=None, time_created=None, time_last_role_changed=None, time_last_synced=None, transport_lag=None):
        if apply_lag and not isinstance(apply_lag, str):
            raise TypeError("Expected argument 'apply_lag' to be a str")
        pulumi.set(__self__, "apply_lag", apply_lag)
        if apply_rate and not isinstance(apply_rate, str):
            raise TypeError("Expected argument 'apply_rate' to be a str")
        pulumi.set(__self__, "apply_rate", apply_rate)
        if autonomous_container_database_dataguard_association_id and not isinstance(autonomous_container_database_dataguard_association_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_dataguard_association_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_dataguard_association_id", autonomous_container_database_dataguard_association_id)
        if autonomous_container_database_id and not isinstance(autonomous_container_database_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if fast_start_fail_over_lag_limit_in_seconds and not isinstance(fast_start_fail_over_lag_limit_in_seconds, int):
            raise TypeError("Expected argument 'fast_start_fail_over_lag_limit_in_seconds' to be a int")
        pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_automatic_failover_enabled and not isinstance(is_automatic_failover_enabled, bool):
            raise TypeError("Expected argument 'is_automatic_failover_enabled' to be a bool")
        pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if peer_autonomous_container_database_backup_configs and not isinstance(peer_autonomous_container_database_backup_configs, list):
            raise TypeError("Expected argument 'peer_autonomous_container_database_backup_configs' to be a list")
        pulumi.set(__self__, "peer_autonomous_container_database_backup_configs", peer_autonomous_container_database_backup_configs)
        if peer_autonomous_container_database_compartment_id and not isinstance(peer_autonomous_container_database_compartment_id, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_compartment_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_container_database_dataguard_association_id and not isinstance(peer_autonomous_container_database_dataguard_association_id, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_dataguard_association_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_dataguard_association_id", peer_autonomous_container_database_dataguard_association_id)
        if peer_autonomous_container_database_display_name and not isinstance(peer_autonomous_container_database_display_name, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_display_name' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        if peer_autonomous_container_database_id and not isinstance(peer_autonomous_container_database_id, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_id", peer_autonomous_container_database_id)
        if peer_autonomous_vm_cluster_id and not isinstance(peer_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'peer_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id and not isinstance(peer_cloud_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'peer_cloud_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name and not isinstance(peer_db_unique_name, str):
            raise TypeError("Expected argument 'peer_db_unique_name' to be a str")
        pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if peer_lifecycle_state and not isinstance(peer_lifecycle_state, str):
            raise TypeError("Expected argument 'peer_lifecycle_state' to be a str")
        pulumi.set(__self__, "peer_lifecycle_state", peer_lifecycle_state)
        if peer_role and not isinstance(peer_role, str):
            raise TypeError("Expected argument 'peer_role' to be a str")
        pulumi.set(__self__, "peer_role", peer_role)
        if protection_mode and not isinstance(protection_mode, str):
            raise TypeError("Expected argument 'protection_mode' to be a str")
        pulumi.set(__self__, "protection_mode", protection_mode)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if standby_maintenance_buffer_in_days and not isinstance(standby_maintenance_buffer_in_days, int):
            raise TypeError("Expected argument 'standby_maintenance_buffer_in_days' to be a int")
        pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_role_changed and not isinstance(time_last_role_changed, str):
            raise TypeError("Expected argument 'time_last_role_changed' to be a str")
        pulumi.set(__self__, "time_last_role_changed", time_last_role_changed)
        if time_last_synced and not isinstance(time_last_synced, str):
            raise TypeError("Expected argument 'time_last_synced' to be a str")
        pulumi.set(__self__, "time_last_synced", time_last_synced)
        if transport_lag and not isinstance(transport_lag, str):
            raise TypeError("Expected argument 'transport_lag' to be a str")
        pulumi.set(__self__, "transport_lag", transport_lag)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> str:
        """
        The lag time between updates to the primary Autonomous Container Database and application of the redo data on the standby Autonomous Container Database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> str:
        """
        The rate at which redo logs are synchronized between the associated Autonomous Container Databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @property
    @pulumi.getter(name="autonomousContainerDatabaseDataguardAssociationId")
    def autonomous_container_database_dataguard_association_id(self) -> str:
        return pulumi.get(self, "autonomous_container_database_dataguard_association_id")

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Container Database that has a relationship with the peer Autonomous Container Database. Used only by Autonomous Database on Dedicated Exadata Infrastructure.
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> int:
        """
        The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Autonomous Data Guard created for a given Autonomous Container Database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> bool:
        """
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Output DataType: boolean. Example : is_automatic_failover_enabled = true.
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfigs")
    def peer_autonomous_container_database_backup_configs(self) -> Sequence['outputs.GetAutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigResult']:
        return pulumi.get(self, "peer_autonomous_container_database_backup_configs")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> str:
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDataguardAssociationId")
    def peer_autonomous_container_database_dataguard_association_id(self) -> str:
        """
        The OCID of the peer Autonomous Container Database-Autonomous Data Guard association.
        """
        return pulumi.get(self, "peer_autonomous_container_database_dataguard_association_id")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> str:
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseId")
    def peer_autonomous_container_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_id")

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> str:
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> str:
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> str:
        return pulumi.get(self, "peer_db_unique_name")

    @property
    @pulumi.getter(name="peerLifecycleState")
    def peer_lifecycle_state(self) -> str:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "peer_lifecycle_state")

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> str:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "peer_role")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> int:
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of Autonomous Data Guard.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Autonomous DataGuard association was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastRoleChanged")
    def time_last_role_changed(self) -> str:
        """
        The date and time when the last role change action happened.
        """
        return pulumi.get(self, "time_last_role_changed")

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> str:
        """
        The date and time of the last update to the apply lag, apply rate, and transport lag values.
        """
        return pulumi.get(self, "time_last_synced")

    @property
    @pulumi.getter(name="transportLag")
    def transport_lag(self) -> str:
        """
        The approximate number of seconds of redo data not yet available on the standby Autonomous Container Database, as computed by the reporting database.  Example: `7 seconds`
        """
        return pulumi.get(self, "transport_lag")


class AwaitableGetAutonomousContainerDatabaseDataguardAssociationResult(GetAutonomousContainerDatabaseDataguardAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseDataguardAssociationResult(
            apply_lag=self.apply_lag,
            apply_rate=self.apply_rate,
            autonomous_container_database_dataguard_association_id=self.autonomous_container_database_dataguard_association_id,
            autonomous_container_database_id=self.autonomous_container_database_id,
            fast_start_fail_over_lag_limit_in_seconds=self.fast_start_fail_over_lag_limit_in_seconds,
            id=self.id,
            is_automatic_failover_enabled=self.is_automatic_failover_enabled,
            lifecycle_details=self.lifecycle_details,
            peer_autonomous_container_database_backup_configs=self.peer_autonomous_container_database_backup_configs,
            peer_autonomous_container_database_compartment_id=self.peer_autonomous_container_database_compartment_id,
            peer_autonomous_container_database_dataguard_association_id=self.peer_autonomous_container_database_dataguard_association_id,
            peer_autonomous_container_database_display_name=self.peer_autonomous_container_database_display_name,
            peer_autonomous_container_database_id=self.peer_autonomous_container_database_id,
            peer_autonomous_vm_cluster_id=self.peer_autonomous_vm_cluster_id,
            peer_cloud_autonomous_vm_cluster_id=self.peer_cloud_autonomous_vm_cluster_id,
            peer_db_unique_name=self.peer_db_unique_name,
            peer_lifecycle_state=self.peer_lifecycle_state,
            peer_role=self.peer_role,
            protection_mode=self.protection_mode,
            role=self.role,
            standby_maintenance_buffer_in_days=self.standby_maintenance_buffer_in_days,
            state=self.state,
            time_created=self.time_created,
            time_last_role_changed=self.time_last_role_changed,
            time_last_synced=self.time_last_synced,
            transport_lag=self.transport_lag)


def get_autonomous_container_database_dataguard_association(autonomous_container_database_dataguard_association_id: Optional[str] = None,
                                                            autonomous_container_database_id: Optional[str] = None,
                                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseDataguardAssociationResult:
    """
    This data source provides details about a specific Autonomous Container Database Dataguard Association resource in Oracle Cloud Infrastructure Database service.

    Gets an Autonomous Container Database enabled with Autonomous Data Guard associated with the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_dataguard_association = oci.Database.get_autonomous_container_database_dataguard_association(autonomous_container_database_dataguard_association_id=test_autonomous_container_database_dataguard_association_oci_database_autonomous_container_database_dataguard_association["id"],
        autonomous_container_database_id=test_autonomous_container_database["id"])
    ```


    :param str autonomous_container_database_dataguard_association_id: The Autonomous Container Database-Autonomous Data Guard association [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseDataguardAssociationId'] = autonomous_container_database_dataguard_association_id
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabaseDataguardAssociation:getAutonomousContainerDatabaseDataguardAssociation', __args__, opts=opts, typ=GetAutonomousContainerDatabaseDataguardAssociationResult).value

    return AwaitableGetAutonomousContainerDatabaseDataguardAssociationResult(
        apply_lag=pulumi.get(__ret__, 'apply_lag'),
        apply_rate=pulumi.get(__ret__, 'apply_rate'),
        autonomous_container_database_dataguard_association_id=pulumi.get(__ret__, 'autonomous_container_database_dataguard_association_id'),
        autonomous_container_database_id=pulumi.get(__ret__, 'autonomous_container_database_id'),
        fast_start_fail_over_lag_limit_in_seconds=pulumi.get(__ret__, 'fast_start_fail_over_lag_limit_in_seconds'),
        id=pulumi.get(__ret__, 'id'),
        is_automatic_failover_enabled=pulumi.get(__ret__, 'is_automatic_failover_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        peer_autonomous_container_database_backup_configs=pulumi.get(__ret__, 'peer_autonomous_container_database_backup_configs'),
        peer_autonomous_container_database_compartment_id=pulumi.get(__ret__, 'peer_autonomous_container_database_compartment_id'),
        peer_autonomous_container_database_dataguard_association_id=pulumi.get(__ret__, 'peer_autonomous_container_database_dataguard_association_id'),
        peer_autonomous_container_database_display_name=pulumi.get(__ret__, 'peer_autonomous_container_database_display_name'),
        peer_autonomous_container_database_id=pulumi.get(__ret__, 'peer_autonomous_container_database_id'),
        peer_autonomous_vm_cluster_id=pulumi.get(__ret__, 'peer_autonomous_vm_cluster_id'),
        peer_cloud_autonomous_vm_cluster_id=pulumi.get(__ret__, 'peer_cloud_autonomous_vm_cluster_id'),
        peer_db_unique_name=pulumi.get(__ret__, 'peer_db_unique_name'),
        peer_lifecycle_state=pulumi.get(__ret__, 'peer_lifecycle_state'),
        peer_role=pulumi.get(__ret__, 'peer_role'),
        protection_mode=pulumi.get(__ret__, 'protection_mode'),
        role=pulumi.get(__ret__, 'role'),
        standby_maintenance_buffer_in_days=pulumi.get(__ret__, 'standby_maintenance_buffer_in_days'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_role_changed=pulumi.get(__ret__, 'time_last_role_changed'),
        time_last_synced=pulumi.get(__ret__, 'time_last_synced'),
        transport_lag=pulumi.get(__ret__, 'transport_lag'))


@_utilities.lift_output_func(get_autonomous_container_database_dataguard_association)
def get_autonomous_container_database_dataguard_association_output(autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[str]] = None,
                                                                   autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
                                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousContainerDatabaseDataguardAssociationResult]:
    """
    This data source provides details about a specific Autonomous Container Database Dataguard Association resource in Oracle Cloud Infrastructure Database service.

    Gets an Autonomous Container Database enabled with Autonomous Data Guard associated with the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_dataguard_association = oci.Database.get_autonomous_container_database_dataguard_association(autonomous_container_database_dataguard_association_id=test_autonomous_container_database_dataguard_association_oci_database_autonomous_container_database_dataguard_association["id"],
        autonomous_container_database_id=test_autonomous_container_database["id"])
    ```


    :param str autonomous_container_database_dataguard_association_id: The Autonomous Container Database-Autonomous Data Guard association [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
