# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDbVersionsResult',
    'AwaitableGetAutonomousDbVersionsResult',
    'get_autonomous_db_versions',
    'get_autonomous_db_versions_output',
]

@pulumi.output_type
class GetAutonomousDbVersionsResult:
    """
    A collection of values returned by getAutonomousDbVersions.
    """
    def __init__(__self__, autonomous_db_versions=None, compartment_id=None, db_workload=None, filters=None, id=None):
        if autonomous_db_versions and not isinstance(autonomous_db_versions, list):
            raise TypeError("Expected argument 'autonomous_db_versions' to be a list")
        pulumi.set(__self__, "autonomous_db_versions", autonomous_db_versions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_workload and not isinstance(db_workload, str):
            raise TypeError("Expected argument 'db_workload' to be a str")
        pulumi.set(__self__, "db_workload", db_workload)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="autonomousDbVersions")
    def autonomous_db_versions(self) -> Sequence['outputs.GetAutonomousDbVersionsAutonomousDbVersionResult']:
        """
        The list of autonomous_db_versions.
        """
        return pulumi.get(self, "autonomous_db_versions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[str]:
        """
        The Autonomous Database workload type. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDbVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAutonomousDbVersionsResult(GetAutonomousDbVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDbVersionsResult(
            autonomous_db_versions=self.autonomous_db_versions,
            compartment_id=self.compartment_id,
            db_workload=self.db_workload,
            filters=self.filters,
            id=self.id)


def get_autonomous_db_versions(compartment_id: Optional[str] = None,
                               db_workload: Optional[str] = None,
                               filters: Optional[Sequence[Union['GetAutonomousDbVersionsFilterArgs', 'GetAutonomousDbVersionsFilterArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDbVersionsResult:
    """
    This data source provides the list of Autonomous Db Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_db_versions = oci.Database.get_autonomous_db_versions(compartment_id=compartment_id,
        db_workload=autonomous_db_version_db_workload)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_workload: A filter to return only autonomous database resources that match the specified workload type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbWorkload'] = db_workload
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDbVersions:getAutonomousDbVersions', __args__, opts=opts, typ=GetAutonomousDbVersionsResult).value

    return AwaitableGetAutonomousDbVersionsResult(
        autonomous_db_versions=pulumi.get(__ret__, 'autonomous_db_versions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_workload=pulumi.get(__ret__, 'db_workload'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_autonomous_db_versions)
def get_autonomous_db_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      db_workload: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDbVersionsFilterArgs', 'GetAutonomousDbVersionsFilterArgsDict']]]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDbVersionsResult]:
    """
    This data source provides the list of Autonomous Db Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_db_versions = oci.Database.get_autonomous_db_versions(compartment_id=compartment_id,
        db_workload=autonomous_db_version_db_workload)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_workload: A filter to return only autonomous database resources that match the specified workload type.
    """
    ...
